/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.CompositeWhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.LanguageWhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.StaticSymbolWhiteSpaceDefinitionStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.reference.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public final class WhiteSpaceFormattingStrategyFactory {
    public static final WhiteSpaceFormattingStrategy DEFAULT_STRATEGY = new StaticSymbolWhiteSpaceDefinitionStrategy(' ', '\t', '\n');
    private static final AtomicReference<WeakReference<Collection<WhiteSpaceFormattingStrategy>>> myCachedStrategies = new AtomicReference();

    private WhiteSpaceFormattingStrategyFactory() {
    }

    public static WhiteSpaceFormattingStrategy getStrategy() {
        return DEFAULT_STRATEGY;
    }

    @NotNull
    public static WhiteSpaceFormattingStrategy getStrategy(@NotNull Language language) {
        WhiteSpaceFormattingStrategy strategy;
        if (language == null) {
            WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(0);
        }
        if ((strategy = (WhiteSpaceFormattingStrategy)LanguageWhiteSpaceFormattingStrategy.INSTANCE.forLanguage(language)) != null) {
            if (strategy.replaceDefaultStrategy()) {
                WhiteSpaceFormattingStrategy whiteSpaceFormattingStrategy = strategy;
                if (whiteSpaceFormattingStrategy == null) {
                    WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(1);
                }
                return whiteSpaceFormattingStrategy;
            }
            return new CompositeWhiteSpaceFormattingStrategy(List.of(DEFAULT_STRATEGY, strategy));
        }
        WhiteSpaceFormattingStrategy whiteSpaceFormattingStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy();
        if (whiteSpaceFormattingStrategy == null) {
            WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(2);
        }
        return whiteSpaceFormattingStrategy;
    }

    @NotNull
    public static Collection<WhiteSpaceFormattingStrategy> getAllStrategies() {
        WeakReference<Collection<WhiteSpaceFormattingStrategy>> reference = myCachedStrategies.get();
        Collection strategies = (Collection)SoftReference.dereference(reference);
        if (strategies != null) {
            Collection collection = strategies;
            if (collection == null) {
                WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(3);
            }
            return collection;
        }
        Collection languages = Language.getRegisteredLanguages();
        HashSet<WhiteSpaceFormattingStrategy> result = new HashSet<WhiteSpaceFormattingStrategy>();
        result.add(DEFAULT_STRATEGY);
        LanguageWhiteSpaceFormattingStrategy languageStrategy = LanguageWhiteSpaceFormattingStrategy.INSTANCE;
        for (Language language : languages) {
            WhiteSpaceFormattingStrategy strategy = (WhiteSpaceFormattingStrategy)languageStrategy.forLanguage(language);
            if (strategy == null) continue;
            result.add(strategy);
        }
        myCachedStrategies.set(new WeakReference(result));
        HashSet<WhiteSpaceFormattingStrategy> hashSet = result;
        if (hashSet == null) {
            WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    public static WhiteSpaceFormattingStrategy getStrategy(@NotNull Editor editor) {
        PsiFile psiFile;
        Project project;
        if (editor == null) {
            WhiteSpaceFormattingStrategyFactory.$$$reportNull$$$0(5);
        }
        if ((project = editor.getProject()) != null && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
            return WhiteSpaceFormattingStrategyFactory.getStrategy(psiFile.getLanguage());
        }
        return WhiteSpaceFormattingStrategyFactory.getStrategy();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/WhiteSpaceFormattingStrategyFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/WhiteSpaceFormattingStrategyFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrategy";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllStrategies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStrategy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

