/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.comments;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class CommentLineData {
    protected String line;
    int commentOffset;
    int textStartOffset;
    boolean startsWithLetter;
    private final List<TextRange> unbreakableRanges;

    public CommentLineData(@NotNull String line) {
        if (line == null) {
            CommentLineData.$$$reportNull$$$0(0);
        }
        this.commentOffset = -1;
        this.textStartOffset = -1;
        this.startsWithLetter = false;
        this.unbreakableRanges = new ArrayList<TextRange>();
        this.line = line;
    }

    public void addUnbreakableRange(@NotNull TextRange range) {
        if (range == null) {
            CommentLineData.$$$reportNull$$$0(1);
        }
        this.unbreakableRanges.add(range);
    }

    protected int calcWrapPos(int rightMargin) {
        if (!this.hasText()) {
            return -1;
        }
        int indexBeforeRightMargin = this.getLastIndexBeforeRightMargin(rightMargin);
        String cutLine = this.line.substring(0, indexBeforeRightMargin);
        int wrapPos = cutLine.lastIndexOf(32);
        if (wrapPos < this.textStartOffset && (wrapPos = this.line.indexOf(32, this.textStartOffset)) != this.beforeUnbreakableRange(wrapPos)) {
            return -1;
        }
        return wrapPos;
    }

    public boolean hasText() {
        return this.textStartOffset > this.commentOffset;
    }

    public boolean canBeMergedWithPrevious() {
        return this.hasText() && this.startsWithLetter;
    }

    @NotNull
    public String getText() {
        if (this.hasText()) {
            String string = this.line.substring(this.textStartOffset);
            if (string == null) {
                CommentLineData.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "";
    }

    public void merge(@NotNull CommentLineData lineData) {
        if (lineData == null) {
            CommentLineData.$$$reportNull$$$0(3);
        }
        for (TextRange range : lineData.unbreakableRanges) {
            this.unbreakableRanges.add(range.shiftRight(this.line.length() + 1));
        }
        this.line = this.line + " " + lineData.getText();
    }

    public int getLineLength() {
        int len = 0;
        for (int i = 0; i < this.line.length(); ++i) {
            char c = this.line.charAt(i);
            len = this.getNextCol(len, c);
        }
        return len;
    }

    @Nullable
    public Pair<String, String> splitLine(int rightMargin) {
        int wrapPos = this.calcWrapPos(rightMargin);
        if (wrapPos >= 0) {
            return new Pair((Object)this.line.substring(0, wrapPos), (Object)this.line.substring(wrapPos));
        }
        return null;
    }

    @NotNull
    public String getLine() {
        String string = this.line;
        if (string == null) {
            CommentLineData.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isTagLine() {
        return false;
    }

    public void setTagLine(boolean isTagLine) {
    }

    @NotNull
    public String getLinePrefix() {
        return "";
    }

    public int getCommentOffset() {
        return this.commentOffset;
    }

    public void setCommentOffset(int commentOffset) {
        this.commentOffset = commentOffset;
    }

    public int getTextStartOffset() {
        return this.textStartOffset;
    }

    public void setTextStartOffset(int textStartOffset) {
        this.textStartOffset = textStartOffset;
    }

    protected abstract int getTabSize();

    private int getLastIndexBeforeRightMargin(int rightMargin) {
        int col = 0;
        int i = 0;
        while (col < rightMargin) {
            if (i < this.line.length()) {
                char c = this.line.charAt(i);
                if ((col = this.getNextCol(col, c)) > rightMargin) break;
                ++i;
                continue;
            }
            --i;
            break;
        }
        return this.beforeUnbreakableRange(i);
    }

    private int beforeUnbreakableRange(int i) {
        for (TextRange range : this.unbreakableRanges) {
            if (!range.contains(i)) continue;
            return range.getStartOffset();
        }
        return i;
    }

    private int getNextCol(int currCol, char c) {
        return currCol + (c == '\t' ? this.getTabSize() : 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/comments/CommentLineData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/comments/CommentLineData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addUnbreakableRange";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

