/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/psi/formatter/IndentRangesCalculator;", "", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;)V", "startOffset", "", "endOffset", "calcIndentRanges", "", "intellij.platform.codeStyle.impl"})
public final class IndentRangesCalculator {
    @NotNull
    private final Document document;
    @NotNull
    private final TextRange textRange;
    private final int startOffset;
    private final int endOffset;

    public IndentRangesCalculator(@NotNull Document document, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        this.document = document;
        this.textRange = textRange;
        this.startOffset = this.textRange.getStartOffset();
        this.endOffset = this.textRange.getEndOffset();
    }

    @NotNull
    public final List<TextRange> calcIndentRanges() {
        int startLine = this.document.getLineNumber(this.startOffset);
        int endLine = this.document.getLineNumber(this.endOffset);
        CharSequence charSequence = this.document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        List indentRanges = new ArrayList();
        int line = startLine;
        if (line <= endLine) {
            while (true) {
                int lineStartOffset = this.document.getLineStartOffset(line);
                int lineEndOffset = this.document.getLineEndOffset(line);
                int firstNonWsChar = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (int)(lineEndOffset + 1), (String)" \t");
                indentRanges.add(new TextRange(lineStartOffset, firstNonWsChar));
                if (line == endLine) break;
                ++line;
            }
        }
        return indentRanges;
    }
}

