/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.CodeStyleBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.cache.CodeStyleCachingService;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ChangedRangesUtil;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.CodeFormattingData;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerRunnable;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import com.intellij.psi.impl.source.codeStyle.FormatterBasedIndentAdjuster;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.codeStyle.IndentImpl;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CodeStyleManagerImpl
extends CodeStyleManager
implements FormattingModeAwareIndentAdjuster {
    private static final Logger LOG = Logger.getInstance(CodeStyleManagerImpl.class);
    private final ThreadLocal<FormattingMode> myCurrentFormattingMode = ThreadLocal.withInitial(() -> FormattingMode.REFORMAT);
    private final Project myProject;

    public CodeStyleManagerImpl(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(0);
        }
        return project;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = this.reformat(element, false);
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement reformat(@NotNull PsiElement element, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(3);
        }
        CheckUtil.checkWritable((PsiElement)element);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)element)) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        PsiElement psiElement = FormattingServiceUtil.formatElement(element, canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public void reformatText(@NotNull PsiFile file, @NotNull Collection<? extends TextRange> ranges, boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(7);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(8);
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        ranges.forEach(range -> formatRanges.add((TextRange)range, true));
        this.reformatText(file, formatRanges, (myRanges, psiFile) -> CodeStyleManagerImpl.isFullRange(myRanges, psiFile) && !processChangedTextOnly);
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(9);
        }
        return CodeStyleManagerImpl.reformatRangeImpl(element, startOffset, endOffset, canChangeWhiteSpacesOnly);
    }

    public PsiElement reformatRange(@NotNull PsiElement element, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(10);
        }
        return CodeStyleManagerImpl.reformatRangeImpl(element, startOffset, endOffset, false);
    }

    private static void transformAllChildren(ASTNode file) {
        ((TreeElement)file).acceptTree((TreeElementVisitor)new RecursiveTreeElementWalkingVisitor(){});
    }

    public void reformatText(@NotNull PsiFile file, int startOffset, int endOffset) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(11);
        }
        this.reformatText(file, Collections.singleton(new TextRange(startOffset, endOffset)));
    }

    public void reformatText(@NotNull PsiFile file, @NotNull Collection<? extends TextRange> ranges) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(12);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(13);
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        ranges.forEach(range -> formatRanges.add((TextRange)range, true));
        this.reformatText(file, formatRanges, (myRanges, psiFile) -> CodeStyleManagerImpl.isFullRange(myRanges, psiFile));
    }

    public void reformatChanges(@NotNull PsiFile file, @NotNull ChangedRangesInfo info) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(14);
        }
        if (info == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(15);
        }
        this.ensureDocumentCommitted(file);
        FormatTextRanges formatRanges = new FormatTextRanges(info, ChangedRangesUtil.processChangedRanges(file, info));
        this.reformatText(file, formatRanges, (ranges, psiFile) -> CodeStyleManagerImpl.isFullRange(ranges, psiFile));
    }

    private static boolean isFullRange(FormatTextRanges ranges, PsiFile psiFile) {
        return ranges.getRanges().size() == 1 && ranges.getRanges().get(0).getTextRange().equals((Object)psiFile.getTextRange());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformatText(@NotNull PsiFile file, @NotNull FormatTextRanges ranges, BiFunction<FormatTextRanges, PsiFile, Boolean> isFullRange) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(16);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(17);
        }
        if (ranges.isEmpty()) {
            return;
        }
        this.ensureDocumentCommitted(file);
        CheckUtil.checkWritable((PsiElement)file);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file)) {
            return;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)file);
        CodeStyleManagerImpl.transformAllChildren(treeElement);
        LOG.assertTrue(file.isValid(), (Object)("File name: " + file.getName() + " , class: " + file.getClass().getSimpleName()));
        ((CodeStyleManager.Listener)this.myProject.getMessageBus().syncPublisher(CodeStyleManager.Listener.TOPIC)).beforeReformatText(file);
        try {
            if (FormatterUtil.isFormatterCalledExplicitly()) {
                CodeStyleManagerImpl.removeEndingWhiteSpaceFromEachRange(file, ranges);
            }
            FormattingServiceUtil.formatRanges(file, ranges, false, isFullRange.apply(ranges, file));
        }
        finally {
            ((CodeStyleManager.Listener)this.myProject.getMessageBus().syncPublisher(CodeStyleManager.Listener.TOPIC)).afterReformatText(file);
        }
    }

    private void ensureDocumentCommitted(@NotNull PsiFile file) {
        PsiDocumentManager documentManager;
        Document document;
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(18);
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)this.myProject)).getDocument(file)) != null) {
            documentManager.commitDocument(document);
        }
    }

    private static void removeEndingWhiteSpaceFromEachRange(@NotNull PsiFile file, @NotNull FormatTextRanges ranges) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(19);
        }
        if (ranges == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(20);
        }
        for (FormatTextRange formatRange : ranges.getRanges()) {
            PsiElement prev;
            TextRange range = formatRange.getTextRange();
            int rangeStart = range.getStartOffset();
            int rangeEnd = range.getEndOffset();
            PsiElement lastElementInRange = CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file, rangeEnd);
            if (!(lastElementInRange instanceof PsiWhiteSpace) || rangeStart >= lastElementInRange.getTextRange().getStartOffset() || (prev = lastElementInRange.getPrevSibling()) == null) continue;
            int newEnd = prev.getTextRange().getEndOffset();
            formatRange.setTextRange(new TextRange(rangeStart, newEnd));
        }
    }

    private static PsiElement reformatRangeImpl(@NotNull PsiElement element, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(21);
        }
        LOG.assertTrue(element.isValid());
        CheckUtil.checkWritable((PsiElement)element);
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)element)) {
            return element;
        }
        return FormattingServiceUtil.formatElement(element, TextRange.create((int)startOffset, (int)endOffset), canChangeWhiteSpacesOnly);
    }

    public void reformatNewlyAddedElement(@NotNull ASTNode parent, @NotNull ASTNode addedElement) throws IncorrectOperationException {
        FormattingModelBuilder builder;
        if (parent == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(22);
        }
        if (addedElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(23);
        }
        LOG.assertTrue(addedElement.getTreeParent() == parent, (Object)"addedElement must be added to parent");
        PsiElement psiElement = parent.getPsi();
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            containingFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        }
        assert (containingFile != null);
        TextRange textRange = addedElement.getTextRange();
        Document document = fileViewProvider.getDocument();
        if (document instanceof DocumentWindow) {
            DocumentWindow documentWindow = (DocumentWindow)document;
            if (CodeFormatterFacade.shouldDelegateToTopLevel(containingFile)) {
                containingFile = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getTopLevelFile((PsiElement)containingFile);
                textRange = documentWindow.injectedToHost(textRange);
            }
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)containingFile)) != null) {
            FormattingModel model = CoreFormatterUtil.buildModel(builder, (PsiElement)containingFile, CodeStyleManagerImpl.getSettings(containingFile), FormattingMode.REFORMAT);
            FormatterEx.getInstanceEx().formatAroundRange(model, CodeStyleManagerImpl.getSettings(containingFile), containingFile, textRange);
        }
        this.adjustLineIndent(containingFile, textRange);
    }

    public int adjustLineIndent(@NotNull PsiFile file, int offset) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(24);
        }
        return (Integer)PostprocessReformattingAspect.getInstance((Project)file.getProject()).disablePostprocessFormattingInside(() -> this.doAdjustLineIndentByOffset(file, offset, FormattingMode.ADJUST_INDENT));
    }

    public int adjustLineIndent(@NotNull Document document, int offset, FormattingMode mode) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(25);
        }
        return (Integer)PostprocessReformattingAspect.getInstance((Project)this.getProject()).disablePostprocessFormattingInside(() -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(document);
            PsiFile file = documentManager.getPsiFile(document);
            if (file == null) {
                return offset;
            }
            return this.doAdjustLineIndentByOffset(file, offset, mode);
        });
    }

    public int adjustLineIndent(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(26);
        }
        return this.adjustLineIndent(document, offset, FormattingMode.ADJUST_INDENT);
    }

    private int doAdjustLineIndentByOffset(@NotNull PsiFile file, int offset, FormattingMode mode) {
        Integer result;
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(27);
        }
        return (result = (Integer)new CodeStyleManagerRunnable<Integer>(this, this, mode){

            @Override
            protected Integer doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().adjustLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }

            @Override
            protected Integer computeValueInsidePlainComment(PsiFile file, int offset, Integer defaultValue) {
                return CharArrayUtil.shiftForward((CharSequence)file.getViewProvider().getContents(), (int)offset, (String)" \t");
            }

            @Override
            protected Integer adjustResultForInjected(Integer result, DocumentWindow documentWindow) {
                return result != null ? Integer.valueOf(documentWindow.hostToInjected(result.intValue())) : null;
            }
        }.perform(file, offset, null, null)) != null ? result : offset;
    }

    public void adjustLineIndent(@NotNull PsiFile file, TextRange rangeToAdjust) throws IncorrectOperationException {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(28);
        }
        new CodeStyleManagerRunnable<Object>(this, this, FormattingMode.ADJUST_INDENT){

            @Override
            protected Object doPerform(int offset, TextRange range) {
                FormatterEx.getInstanceEx().adjustLineIndentsForRange(this.myModel, this.mySettings, this.myIndentOptions, range);
                return null;
            }
        }.perform(file, -1, rangeToAdjust, null);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file, int offset) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(29);
        }
        return this.getLineIndent(file, offset, FormattingMode.ADJUST_INDENT);
    }

    @Nullable
    public String getLineIndent(@NotNull PsiFile file, int offset, FormattingMode mode) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(30);
        }
        return new CodeStyleManagerRunnable<String>(this, this, mode){

            @Override
            protected boolean useDocumentBaseFormattingModel() {
                return false;
            }

            @Override
            protected String doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().getLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }
        }.perform(file, offset, null, null);
    }

    @Nullable
    public List<String> getLineIndents(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(31);
        }
        return new CodeStyleManagerRunnable<List<String>>(this, this, FormattingMode.ADJUST_INDENT){

            @Override
            protected boolean useDocumentBaseFormattingModel() {
                return false;
            }

            @Override
            protected List<String> doPerform(int offset, TextRange range) {
                return FormatterEx.getInstanceEx().getLineIndents(this.myModel, this.mySettings, this.myIndentOptions);
            }
        }.perform(file, 0, null, null);
    }

    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        PsiFile file;
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(32);
        }
        if ((file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document)) == null) {
            return "";
        }
        return this.getLineIndent(file, offset);
    }

    @Deprecated
    public boolean isLineToBeIndented(@NotNull PsiFile file, int offset) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(33);
        }
        if (!SourceTreeToPsiMap.hasTreeElement((PsiElement)file)) {
            return false;
        }
        CharSequence chars = file.getViewProvider().getContents();
        int start2 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (start2 > 0 && chars.charAt(start2) != '\n' && chars.charAt(start2) != '\r') {
            return false;
        }
        int end = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)" \t");
        if (end >= chars.length()) {
            return false;
        }
        ASTNode element = SourceTreeToPsiMap.psiElementToTree((PsiElement)CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file, end));
        if (element == null) {
            return false;
        }
        if (element.getElementType() == TokenType.WHITE_SPACE) {
            return false;
        }
        if (element.getElementType() == PlainTextTokenTypes.PLAIN_TEXT) {
            return false;
        }
        return !CodeStyleManagerImpl.getSettings((PsiFile)file).getCommonSettings((Language)file.getLanguage()).KEEP_FIRST_COLUMN_COMMENT || !CodeStyleManagerImpl.isCommentToken(element) || IndentHelper.getInstance().getIndent(this.myProject, file.getFileType(), element, true) != 0;
    }

    private static boolean isCommentToken(ASTNode element) {
        Language language = element.getElementType().getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter documentationAwareCommenter = (CodeDocumentationAwareCommenter)commenter;
            return element.getElementType() == documentationAwareCommenter.getBlockCommentTokenType() || element.getElementType() == documentationAwareCommenter.getLineCommentTokenType();
        }
        return false;
    }

    public Indent getIndent(String text, FileType fileType) {
        int indent = IndentHelperImpl.getIndent(CodeStyle.getSettings((Project)this.myProject).getIndentOptions(fileType), text, true);
        int indentLevel = indent / 10000;
        int spaceCount = indent - indentLevel * 10000;
        return new IndentImpl(CodeStyle.getSettings((Project)this.myProject), indentLevel, spaceCount, fileType);
    }

    public String fillIndent(Indent indent, FileType fileType) {
        IndentImpl indent1 = (IndentImpl)indent;
        int indentLevel = indent1.getIndentLevel();
        int spaceCount = indent1.getSpaceCount();
        CodeStyleSettings settings = CodeStyle.getSettings((Project)this.myProject);
        if (indentLevel < 0) {
            spaceCount += indentLevel * settings.getIndentSize(fileType);
            indentLevel = 0;
            if (spaceCount < 0) {
                spaceCount = 0;
            }
        } else if (spaceCount < 0) {
            int v = (-spaceCount + settings.getIndentSize(fileType) - 1) / settings.getIndentSize(fileType);
            spaceCount += v * settings.getIndentSize(fileType);
            if ((indentLevel -= v) < 0) {
                indentLevel = 0;
            }
        }
        return IndentHelperImpl.fillIndent(this.myProject, fileType, indentLevel * 10000 + spaceCount);
    }

    public Indent zeroIndent() {
        return new IndentImpl(CodeStyle.getSettings((Project)this.myProject), 0, 0, null);
    }

    @NotNull
    private static CodeStyleSettings getSettings(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(34);
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file);
        if (codeStyleSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(35);
        }
        return codeStyleSettings;
    }

    public boolean isSequentialProcessingAllowed() {
        return CoreCodeStyleUtil.isSequentialProcessingAllowed();
    }

    public void performActionWithFormatterDisabled(Runnable r) {
        this.performActionWithFormatterDisabled(() -> {
            r.run();
            return null;
        });
    }

    public <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> r) throws T {
        Throwable[] throwable = new Throwable[1];
        this.performActionWithFormatterDisabled(() -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
            return null;
        });
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    public <T> T performActionWithFormatterDisabled(Computable<T> r) {
        PostprocessReformattingAspect component = PostprocessReformattingAspect.getInstance((Project)this.getProject());
        return (T)component.disablePostprocessFormattingInside(r);
    }

    public FormattingMode getCurrentFormattingMode() {
        return this.myCurrentFormattingMode.get();
    }

    void setCurrentFormattingMode(@NotNull FormattingMode mode) {
        if (mode == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(36);
        }
        this.myCurrentFormattingMode.set(mode);
    }

    public int getSpacing(@NotNull PsiFile file, int offset) {
        FormattingModel model;
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(37);
        }
        return (model = CodeStyleManagerImpl.createFormattingModel(file, offset)) == null ? -1 : FormatterEx.getInstance().getSpacingForBlockAtOffset(model, offset);
    }

    public int getMinLineFeeds(@NotNull PsiFile file, int offset) {
        FormattingModel model;
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(38);
        }
        return (model = CodeStyleManagerImpl.createFormattingModel(file, offset)) == null ? -1 : FormatterEx.getInstance().getMinLineFeedsBeforeBlockAtOffset(model, offset);
    }

    @Nullable
    private static FormattingModel createFormattingModel(@NotNull PsiFile file, int offset) {
        FormattingModelBuilder builder;
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(39);
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file)) == null) {
            return null;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)file);
        return builder.createModel(FormattingContext.create((PsiElement)file, (TextRange)TextRange.create((int)offset, (int)offset), (CodeStyleSettings)settings, (FormattingMode)FormattingMode.REFORMAT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file, @NotNull Runnable runnable) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(40);
        }
        if (runnable == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(41);
        }
        DocCommentSettings docSettings = this.getDocCommentSettings(file);
        boolean currDocFormattingEnabled = docSettings.isDocFormattingEnabled();
        docSettings.setDocFormattingEnabled(false);
        try {
            runnable.run();
        }
        finally {
            docSettings.setDocFormattingEnabled(currDocFormattingEnabled);
        }
    }

    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file) {
        Language language;
        LanguageCodeStyleProvider settingsProvider;
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(42);
        }
        if ((settingsProvider = LanguageCodeStyleProvider.forLanguage((Language)(language = file.getLanguage()))) != null) {
            DocCommentSettings docCommentSettings = settingsProvider.getDocCommentSettings(CodeStyle.getSettings((PsiFile)file));
            if (docCommentSettings == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(43);
            }
            return docCommentSettings;
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(44);
        }
        return docCommentSettings;
    }

    public void scheduleIndentAdjustment(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(45);
        }
        FormatterBasedIndentAdjuster.scheduleIndentAdjustment(this.myProject, document, offset);
    }

    public void scheduleReformatWhenSettingsComputed(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(46);
        }
        if (LightVirtualFile.shouldSkipEventSystem((VirtualFile)file.getViewProvider().getVirtualFile())) {
            this.ensureDocumentCommitted(file);
            this.formatBlockingPostprocess(file);
            return;
        }
        Runnable commandRunnable = () -> {
            if (file.isValid()) {
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)CodeStyleBundle.message((String)"command.name.reformat", (Object[])new Object[0]), null, () -> this.formatBlockingPostprocess(file), (PsiFile[])new PsiFile[]{file});
            }
        };
        CodeStyleCachingService.getInstance((Project)this.myProject).scheduleWhenSettingsComputed(file, () -> {
            NonBlockingReadAction prepareDataAction = ReadAction.nonBlocking(() -> CodeFormattingData.prepare(file, Collections.singletonList(file.getTextRange()))).expireWhen(() -> this.myProject.isDisposed()).withDocumentsCommitted(this.myProject);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.ensureDocumentCommitted(file);
                commandRunnable.run();
            } else if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                prepareDataAction.executeSynchronously();
                commandRunnable.run();
            } else {
                prepareDataAction.finishOnUiThread(ModalityState.nonModal(), data -> commandRunnable.run()).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }
        });
    }

    private void formatBlockingPostprocess(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(47);
        }
        PostprocessReformattingAspect.getInstance((Project)this.myProject).disablePostprocessFormattingInside(() -> this.reformat((PsiElement)this.ensureValid(file)));
    }

    @NotNull
    private PsiFile ensureValid(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(48);
        }
        if (!file.isValid()) {
            PsiFile fileToUse = PsiUtilCore.getPsiFile((Project)this.myProject, (VirtualFile)file.getViewProvider().getVirtualFile());
            CodeFormattingData.copy(file, fileToUse);
            PsiFile psiFile = fileToUse;
            if (psiFile == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(49);
            }
            return psiFile;
        }
        PsiFile psiFile = file;
        if (psiFile == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(50);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 45, 46, 47, 48 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedElement";
                break;
            }
            case 25: 
            case 26: 
            case 32: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reformat";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureValid";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reformatText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reformatRange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reformatChanges";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "ensureDocumentCommitted";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeEndingWhiteSpaceFromEachRange";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reformatRangeImpl";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reformatNewlyAddedElement";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "adjustLineIndent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doAdjustLineIndentByOffset";
                break;
            }
            case 29: 
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndents";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isLineToBeIndented";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentFormattingMode";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getMinLineFeeds";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingModel";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "runWithDocCommentFormattingDisabled";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIndentAdjustment";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "scheduleReformatWhenSettingsComputed";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "formatBlockingPostprocess";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 45, 46, 47, 48 -> new IllegalArgumentException(string);
        };
    }
}

