/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.AsyncFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class CoreFormattingService
implements FormattingService {
    private static final Set<FormattingService.Feature> FEATURES = EnumSet.of(FormattingService.Feature.AD_HOC_FORMATTING, FormattingService.Feature.FORMAT_FRAGMENTS, FormattingService.Feature.OPTIMIZE_IMPORTS);

    public boolean canFormat(@NotNull PsiFile file) {
        if (file == null) {
            CoreFormattingService.$$$reportNull$$$0(0);
        }
        return true;
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Set<FormattingService.Feature> set = FEATURES;
        if (set == null) {
            CoreFormattingService.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElement formatElement(@NotNull PsiElement element, boolean canChangeWhiteSpacesOnly) {
        if (element == null) {
            CoreFormattingService.$$$reportNull$$$0(2);
        }
        ASTNode treeElement = element.getNode();
        PsiFile file = element.getContainingFile();
        PsiElement formatted = new CodeFormatterFacade(CoreFormattingService.getSettings(file), element.getLanguage(), canChangeWhiteSpacesOnly).processElement(treeElement).getPsi();
        PsiElement psiElement = CoreCodeStyleUtil.postProcessElement(file, formatted, canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            CoreFormattingService.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement formatElement(@NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly) {
        if (element == null) {
            CoreFormattingService.$$$reportNull$$$0(4);
        }
        if (range == null) {
            CoreFormattingService.$$$reportNull$$$0(5);
        }
        ASTNode treeElement = element.getNode();
        PsiFile file = element.getContainingFile();
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CoreFormattingService.getSettings(file), element.getLanguage());
        PsiElement formatted = codeFormatter.processRange(treeElement, range.getStartOffset(), range.getEndOffset()).getPsi();
        PsiElement psiElement = CoreCodeStyleUtil.postProcessElement(file, formatted, canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            CoreFormattingService.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public void asyncFormatElement(@NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhitespaceOnly) {
        if (element == null) {
            CoreFormattingService.$$$reportNull$$$0(7);
        }
        if (range == null) {
            CoreFormattingService.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.formatElement(element, range, canChangeWhitespaceOnly);
            return;
        }
        AsyncFormattingService.getInstance().asyncFormatElement(this, element, range, canChangeWhitespaceOnly);
    }

    public void formatRanges(@NotNull PsiFile file, FormattingRangesInfo rangesInfo, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        if (file == null) {
            CoreFormattingService.$$$reportNull$$$0(9);
        }
        List<CoreCodeStyleUtil.RangeFormatInfo> infos = CoreCodeStyleUtil.getRangeFormatInfoList(file, rangesInfo);
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CoreFormattingService.getSettings(file), file.getLanguage());
        codeFormatter.processText(file, (FormatTextRanges)rangesInfo, !canChangeWhiteSpaceOnly);
        CoreCodeStyleUtil.postProcessRanges(infos, range -> CoreCodeStyleUtil.postProcessText(file, range, canChangeWhiteSpaceOnly));
    }

    @NotNull
    public Set<ImportOptimizer> getImportOptimizers(@NotNull PsiFile file) {
        if (file == null) {
            CoreFormattingService.$$$reportNull$$$0(10);
        }
        Set<ImportOptimizer> set = LanguageImportStatements.INSTANCE.forFile(file);
        if (set == null) {
            CoreFormattingService.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static CodeStyleSettings getSettings(@NotNull PsiFile file) {
        if (file == null) {
            CoreFormattingService.$$$reportNull$$$0(12);
        }
        return CodeStyle.getSettings((PsiFile)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/service/CoreFormattingService";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/service/CoreFormattingService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportOptimizers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFormat";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "asyncFormatElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getImportOptimizers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 11 -> new IllegalStateException(string);
        };
    }
}

