/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CodeStyleManagerRunnable<T> {
    protected CodeStyleSettings mySettings;
    protected CommonCodeStyleSettings.IndentOptions myIndentOptions;
    protected FormattingModel myModel;
    protected TextRange mySignificantRange;
    private final CodeStyleManagerImpl myCodeStyleManager;
    @NotNull
    private final FormattingMode myMode;

    CodeStyleManagerRunnable(CodeStyleManagerImpl codeStyleManager, @NotNull FormattingMode mode) {
        if (mode == null) {
            CodeStyleManagerRunnable.$$$reportNull$$$0(0);
        }
        this.myCodeStyleManager = codeStyleManager;
        this.myMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T perform(PsiFile file, int offset, @Nullable TextRange range, T defaultValue) {
        FormattingModelBuilder elementBuilder;
        PsiFile templateFile;
        PsiDocumentManager documentManager;
        Document document;
        if (file instanceof PsiCompiledFile) {
            file = ((PsiCompiledFile)file).getDecompiledPsiFile();
        }
        if ((document = (documentManager = PsiDocumentManager.getInstance((Project)this.myCodeStyleManager.getProject())).getDocument(file)) instanceof DocumentWindow) {
            PsiFile topLevelFile;
            DocumentWindow documentWindow = (DocumentWindow)document;
            if (CodeFormatterFacade.shouldDelegateToTopLevel(file) && !file.equals((Object)(topLevelFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file)))) {
                if (range != null) {
                    range = documentWindow.injectedToHost(range);
                }
                if (offset != -1) {
                    offset = documentWindow.injectedToHost(offset);
                }
                return this.adjustResultForInjected(this.perform(topLevelFile, offset, range, defaultValue), documentWindow);
            }
        }
        if ((templateFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)file)) != null) {
            file = templateFile;
            document = documentManager.getDocument(templateFile);
        }
        PsiElement element = null;
        if (offset != -1) {
            element = CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file, offset);
            if (element == null && offset != file.getTextLength()) {
                return defaultValue;
            }
            if (CodeStyleManagerRunnable.isInsidePlainComment(offset, element)) {
                return this.computeValueInsidePlainComment(file, offset, defaultValue);
            }
        }
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        FormattingModelBuilder formattingModelBuilder = elementBuilder = element != null ? LanguageFormatting.INSTANCE.forContext(element) : builder;
        if (builder != null && elementBuilder != null) {
            this.mySettings = CodeStyle.getSettings((PsiFile)file);
            this.mySignificantRange = offset != -1 ? CodeStyleManagerRunnable.getSignificantRange(file, offset) : null;
            this.myIndentOptions = CodeFormatterFacade.getIndentOptions(this.mySettings, this.myCodeStyleManager.getProject(), file, document, this.mySignificantRange);
            FormattingMode currentMode = this.myCodeStyleManager.getCurrentFormattingMode();
            this.myCodeStyleManager.setCurrentFormattingMode(this.myMode);
            try {
                TextRange modelRange = range != null ? range : (offset != -1 ? TextRange.create((int)offset, (int)offset) : file.getTextRange());
                this.myModel = this.buildModel(builder, file, modelRange, document);
                T result = this.doPerform(offset, range);
                if (result != null) {
                    T t = result;
                    return t;
                }
            }
            finally {
                this.myCodeStyleManager.setCurrentFormattingMode(currentMode);
            }
        }
        return defaultValue;
    }

    @NotNull
    private FormattingModel buildModel(@NotNull FormattingModelBuilder builder, @NotNull PsiFile file, @NotNull TextRange range, @Nullable Document document) {
        if (builder == null) {
            CodeStyleManagerRunnable.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CodeStyleManagerRunnable.$$$reportNull$$$0(2);
        }
        if (range == null) {
            CodeStyleManagerRunnable.$$$reportNull$$$0(3);
        }
        Object model = CoreFormatterUtil.buildModel(builder, (PsiElement)file, range, this.mySettings, this.myMode);
        if (document != null && this.useDocumentBaseFormattingModel()) {
            model = new DocumentBasedFormattingModel((FormattingModel)model, document, this.myCodeStyleManager.getProject(), this.mySettings, file.getFileType(), file);
        }
        FormattingModel formattingModel = model;
        if (formattingModel == null) {
            CodeStyleManagerRunnable.$$$reportNull$$$0(4);
        }
        return formattingModel;
    }

    protected boolean useDocumentBaseFormattingModel() {
        return true;
    }

    protected T adjustResultForInjected(T result, DocumentWindow documentWindow) {
        return result;
    }

    protected T computeValueInsidePlainComment(PsiFile file, int offset, T defaultValue) {
        return defaultValue;
    }

    @Nullable
    protected abstract T doPerform(int var1, TextRange var2);

    private static boolean isInsidePlainComment(int offset, @Nullable PsiElement element) {
        if (!(element instanceof PsiComment) || element instanceof PsiDocCommentBase || !element.getTextRange().contains(offset - 1)) {
            return false;
        }
        return !(element instanceof PsiLanguageInjectionHost) || !InjectedLanguageUtilBase.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element));
    }

    private static TextRange getSignificantRange(PsiFile file, int offset) {
        TextRange textRange;
        ASTNode elementAtOffset = SourceTreeToPsiMap.psiElementToTree((PsiElement)CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file, offset));
        if (elementAtOffset == null) {
            int significantRangeStart = CharArrayUtil.shiftBackward((CharSequence)file.getText(), (int)(offset - 1), (String)"\n\r\t ");
            return new TextRange(Math.max(significantRangeStart, 0), offset);
        }
        FormattingModelBuilder builder = LanguageFormatting.INSTANCE.forContext((PsiElement)file);
        if (builder != null && (textRange = builder.getRangeAffectingIndent(file, offset, elementAtOffset)) != null) {
            return textRange;
        }
        TextRange elementRange = elementAtOffset.getTextRange();
        if (CodeStyleManagerRunnable.isWhiteSpace(elementAtOffset)) {
            return CodeStyleManagerRunnable.extendRangeAtStartOffset(file, elementRange);
        }
        return elementRange;
    }

    private static boolean isWhiteSpace(ASTNode elementAtOffset) {
        return elementAtOffset instanceof PsiWhiteSpace || CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)elementAtOffset.getChars());
    }

    @NotNull
    private static TextRange extendRangeAtStartOffset(@NotNull PsiFile file, @NotNull TextRange range) {
        int startOffset;
        if (file == null) {
            CodeStyleManagerRunnable.$$$reportNull$$$0(5);
        }
        if (range == null) {
            CodeStyleManagerRunnable.$$$reportNull$$$0(6);
        }
        if ((startOffset = range.getStartOffset()) > 0) {
            String text = file.getText();
            startOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)startOffset, (String)"\n\r\t ");
        }
        return new TextRange(startOffset + 1, range.getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerRunnable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildModel";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extendRangeAtStartOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

