/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.formatting.FormattingMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class FormatterBasedIndentAdjuster {
    private static final int MAX_SYNCHRONOUS_ADJUSTMENT_DOC_SIZE = 100000;

    private FormatterBasedIndentAdjuster() {
    }

    static void scheduleIndentAdjustment(@NotNull Project project, @NotNull Document document, int offset) {
        PsiFile file;
        if (project == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(0);
        }
        if (document == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(1);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document)) != null) {
            IndentAdjusterRunnable fixer = new IndentAdjusterRunnable(project, document, file, offset);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            if (FormatterBasedIndentAdjuster.isSynchronousAdjustment(document, file)) {
                documentManager.commitDocument(document);
            }
            fixer.run();
        }
    }

    private static boolean isSynchronousAdjustment(@NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(2);
        }
        if (file == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(3);
        }
        return ApplicationManager.getApplication().isUnitTestMode() || document.getTextLength() <= 100000 && !BlockSupport.isTooDeep((UserDataHolder)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/FormatterBasedIndentAdjuster";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleIndentAdjustment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSynchronousAdjustment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class IndentAdjusterRunnable
    implements Runnable {
        private final Project myProject;
        private final int myLine;
        private final Document myDocument;
        private final PsiFile myPsiFile;

        IndentAdjusterRunnable(@NotNull Project project, @NotNull Document document, @NotNull PsiFile psiFile, int offset) {
            if (project == null) {
                IndentAdjusterRunnable.$$$reportNull$$$0(0);
            }
            if (document == null) {
                IndentAdjusterRunnable.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                IndentAdjusterRunnable.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myDocument = document;
            this.myLine = this.myDocument.getLineNumber(offset);
            this.myPsiFile = psiFile;
        }

        @Override
        public void run() {
            int lineStart = this.myDocument.getLineStartOffset(this.myLine);
            int indentEnd = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)lineStart, (String)" \t");
            RangeMarker indentMarker = this.myDocument.createRangeMarker(lineStart, indentEnd);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
            if (FormatterBasedIndentAdjuster.isSynchronousAdjustment(this.myDocument, this.myPsiFile)) {
                this.updateIndent(indentMarker, codeStyleManager.getLineIndent(this.myPsiFile, lineStart, FormattingMode.ADJUST_INDENT_ON_ENTER));
            } else {
                ReadAction.nonBlocking(() -> codeStyleManager.getLineIndent(this.myPsiFile, lineStart, FormattingMode.ADJUST_INDENT_ON_ENTER)).withDocumentsCommitted(this.myProject).finishOnUiThread(ModalityState.nonModal(), indentString -> this.updateIndent(indentMarker, (String)indentString)).submit((Executor)AppExecutorUtil.getAppExecutorService());
            }
        }

        private void updateIndent(@NotNull RangeMarker indentMarker, @Nullable String newIndent) {
            if (indentMarker == null) {
                IndentAdjusterRunnable.$$$reportNull$$$0(3);
            }
            if (newIndent != null) {
                CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    this.myDocument.replaceString(indentMarker.getStartOffset(), indentMarker.getEndOffset(), (CharSequence)newIndent);
                    indentMarker.dispose();
                }));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indentMarker";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/FormatterBasedIndentAdjuster$IndentAdjusterRunnable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateIndent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

