/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.CodeStyleBundle;
import com.intellij.concurrency.ThreadContext;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncDocumentFormattingSupport;
import com.intellij.formatting.service.AsyncDocumentFormattingSupportImpl;
import com.intellij.formatting.service.AsyncDocumentFormattingSupportImplKt;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.DocumentMerger;
import com.intellij.formatting.service.FormattingNotificationService;
import com.intellij.formatting.service.StructuredAsyncDocumentFormatting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.SystemProperties;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002()B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J6\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0014\u0010\u0017\u001a\u00020\r2\n\u0010\u0018\u001a\u00060\u000bR\u00020\u0000H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0014\u0010\u001b\u001a\u00020\r2\n\u0010\u001c\u001a\u00060\u000bR\u00020\u0000H\u0002J\u001a\u0010\u001d\u001a\u00020\r2\n\u0010\u0018\u001a\u00060\u000bR\u00020\u0000H\u0082@\u00a2\u0006\u0002\u0010\u001eJ<\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u001c\u0010#\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0%\u0012\u0006\u0012\u0004\u0018\u00010&0$H\u0082@\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/formatting/service/AsyncDocumentFormattingSupportImpl;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingSupport;", "service", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/formatting/service/AsyncDocumentFormattingService;Lkotlinx/coroutines/CoroutineScope;)V", "pendingRequests", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/editor/Document;", "Lcom/intellij/formatting/service/AsyncDocumentFormattingSupportImpl$FormattingRequestImpl;", "formatDocument", "", "document", "formattingRanges", "", "Lcom/intellij/openapi/util/TextRange;", "formattingContext", "Lcom/intellij/formatting/FormattingContext;", "canChangeWhiteSpaceOnly", "", "quickFormat", "launchAsyncFormat", "formattingRequest", "isSyncFormat", "isForceSyncFormat", "runAsyncFormatBlocking", "request", "runAsyncFormat", "(Lcom/intellij/formatting/service/AsyncDocumentFormattingSupportImpl$FormattingRequestImpl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "underProgressIfNeeded", "isNeeded", "project", "Lcom/intellij/openapi/project/Project;", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(ZLcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "FormattingRequestImpl", "Companion", "intellij.platform.codeStyle.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAsyncDocumentFormattingSupportImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncDocumentFormattingSupportImpl.kt\ncom/intellij/formatting/service/AsyncDocumentFormattingSupportImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,361:1\n23#2:362\n*S KotlinDebug\n*F\n+ 1 AsyncDocumentFormattingSupportImpl.kt\ncom/intellij/formatting/service/AsyncDocumentFormattingSupportImpl\n*L\n346#1:362\n*E\n"})
public final class AsyncDocumentFormattingSupportImpl
implements AsyncDocumentFormattingSupport {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final AsyncDocumentFormattingService service;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<Document, FormattingRequestImpl> pendingRequests;
    @NotNull
    private static final Logger LOG;

    public AsyncDocumentFormattingSupportImpl(@NotNull AsyncDocumentFormattingService service, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.service = service;
        this.coroutineScope = coroutineScope;
        this.pendingRequests = new ConcurrentHashMap();
    }

    public synchronized void formatDocument(@NotNull Document document, @NotNull List<? extends TextRange> formattingRanges, @NotNull FormattingContext formattingContext, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(formattingRanges, (String)"formattingRanges");
        Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
        FormattingRequestImpl currRequest = this.pendingRequests.get(document);
        boolean isSync = this.isSyncFormat(document);
        if (currRequest != null && !currRequest.cancel()) {
            LOG.warn("Pending request can't be cancelled");
            return;
        }
        AsyncDocumentFormattingService.prepareForFormatting((AsyncDocumentFormattingService)this.service, (Document)document, (FormattingContext)formattingContext);
        FormattingRequestImpl formattingRequest = new FormattingRequestImpl(formattingContext, document, formattingRanges, canChangeWhiteSpaceOnly, quickFormat, isSync);
        AsyncDocumentFormattingService.FormattingTask formattingTask = AsyncDocumentFormattingService.createFormattingTask((AsyncDocumentFormattingService)this.service, (AsyncFormattingRequest)formattingRequest);
        if (formattingTask != null) {
            formattingRequest.setTask(formattingTask);
            ((Map)this.pendingRequests).put(document, formattingRequest);
            if (isSync) {
                this.runAsyncFormatBlocking(formattingRequest);
            } else {
                this.launchAsyncFormat(formattingRequest);
            }
        }
    }

    private final void launchAsyncFormat(FormattingRequestImpl formattingRequest) {
        CoroutineScope coroutineScope;
        CoroutineStart coroutineStart = CoroutineStart.UNDISPATCHED;
        if (StructuredAsyncDocumentFormatting.isStructuredAsyncDocumentFormatting((CoroutineContext)ThreadContext.currentThreadContext())) {
            coroutineScope = CoroutinesKt.currentThreadCoroutineScope();
        } else {
            String string = "Non-structured async document formatting: " + AsyncDocumentFormattingService.getName((AsyncDocumentFormattingService)this.service);
            CoroutineDispatcher coroutineDispatcher = Dispatchers.getDefault();
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
            coroutineScope = CoroutineScopeKt.childScope((CoroutineScope)this.coroutineScope, (String)string, (CoroutineContext)coroutineDispatcher.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (boolean)false);
        }
        CoroutineScope coroutineScope2 = coroutineScope;
        BuildersKt.launch$default((CoroutineScope)coroutineScope2, null, (CoroutineStart)coroutineStart, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, formattingRequest, null){
            int label;
            final /* synthetic */ AsyncDocumentFormattingSupportImpl this$0;
            final /* synthetic */ FormattingRequestImpl $formattingRequest;
            {
                this.this$0 = $receiver;
                this.$formattingRequest = $formattingRequest;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = AsyncDocumentFormattingSupportImpl.access$runAsyncFormat(this.this$0, this.$formattingRequest, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final boolean isSyncFormat(Document document) {
        boolean forceSync = this.isForceSyncFormat(document);
        boolean isHeadless = ApplicationManager.getApplication().isHeadlessEnvironment();
        boolean isIgnoreHeadless = SystemProperties.getBooleanProperty((String)"intellij.async.formatting.ignoreHeadless", (boolean)false);
        return forceSync || isHeadless && !isIgnoreHeadless;
    }

    private final boolean isForceSyncFormat(Document document) {
        return Intrinsics.areEqual((Object)document.getUserData(AsyncDocumentFormattingService.FORMAT_DOCUMENT_SYNCHRONOUSLY), (Object)true);
    }

    private final void runAsyncFormatBlocking(FormattingRequestImpl request) {
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
                int label;
                final /* synthetic */ AsyncDocumentFormattingSupportImpl this$0;
                final /* synthetic */ FormattingRequestImpl $request;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = AsyncDocumentFormattingSupportImpl.access$runAsyncFormat(this.this$0, this.$request, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        } else {
            CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
                int label;
                final /* synthetic */ AsyncDocumentFormattingSupportImpl this$0;
                final /* synthetic */ FormattingRequestImpl $request;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = AsyncDocumentFormattingSupportImpl.access$runAsyncFormat(this.this$0, this.$request, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object runAsyncFormat(FormattingRequestImpl formattingRequest, Continuation<? super Unit> $completion) {
        if (!($completion instanceof runAsyncFormat.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AsyncDocumentFormattingSupportImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AsyncDocumentFormattingSupportImpl.access$runAsyncFormat(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = formattingRequest.getTask();
                if (v0 == null) {
                    var4_6 = "Required value was null.";
                    throw new IllegalStateException(var4_6.toString());
                }
                v1 = v0.isRunUnderProgress();
                v2 = formattingRequest.getContext().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getProject(...)");
                $continuation.L$0 = formattingRequest;
                $continuation.label = 1;
                v3 = this.underProgressIfNeeded(v1, v2, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(formattingRequest, null){
                    int label;
                    final /* synthetic */ FormattingRequestImpl $formattingRequest;
                    {
                        this.$formattingRequest = $formattingRequest;
                        super(1, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$formattingRequest.runAndAwaitTask((Continuation<? super Job>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Unit>)$continuation);
                ** if (v3 != var7_5) goto lbl26
lbl25:
                // 1 sources

                return var7_5;
lbl26:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                formattingRequest = (FormattingRequestImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                }
                catch (Throwable var3_7) {
                    throw var3_7;
                }
                finally {
                    this.pendingRequests.remove(formattingRequest.getDocument(), formattingRequest);
                }
lbl40:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object underProgressIfNeeded(boolean isNeeded, Project project, Function1<? super Continuation<? super Unit>, ? extends Object> block, Continuation<? super Unit> $completion) {
        if (isNeeded) {
            Object[] objectArray = new Object[]{AsyncDocumentFormattingService.getName((AsyncDocumentFormattingService)this.service)};
            String string = CodeStyleBundle.message((String)"async.formatting.service.running", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            TaskCancellation.Cancellable cancellable = TaskCancellation.Companion.cancellable();
            objectArray = new Object[]{AsyncDocumentFormattingService.getName((AsyncDocumentFormattingService)this.service)};
            String string2 = CodeStyleBundle.message((String)"async.formatting.service.cancel", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            Object object = TasksKt.withBackgroundProgress((Project)project, (String)string, (TaskCancellation)((TaskCancellation)cancellable.withButtonText(string2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(block, null){
                int label;
                final /* synthetic */ Function1<Continuation<? super Unit>, Object> $block;
                {
                    this.$block = $block;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.$block.invoke((Object)((Object)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Object object = block.invoke($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$runAsyncFormat(AsyncDocumentFormattingSupportImpl $this, FormattingRequestImpl formattingRequest, Continuation $completion) {
        return $this.runAsyncFormat(formattingRequest, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$underProgressIfNeeded(AsyncDocumentFormattingSupportImpl $this, boolean isNeeded, Project project, Function1 block, Continuation $completion) {
        return $this.underProgressIfNeeded(isNeeded, project, (Function1<? super Continuation<? super Unit>, ? extends Object>)block, (Continuation<? super Unit>)$completion);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/formatting/service/AsyncDocumentFormattingSupportImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.codeStyle.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001e\u001a\u00020\nJ\b\u0010\u001f\u001a\u00020\u001bH\u0002J\u000e\u0010 \u001a\u00020!H\u0086@\u00a2\u0006\u0002\u0010\"J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001dJ\u0012\u0010'\u001a\u00020\u001b2\b\u0010(\u001a\u0004\u0018\u00010\u001dH\u0016J\"\u0010)\u001a\u00020\u001b2\u000b\u0010*\u001a\u00070\u001d\u00a2\u0006\u0002\b+2\u000b\u0010,\u001a\u00070\u001d\u00a2\u0006\u0002\b-H\u0016J0\u0010)\u001a\u00020\u001b2\r\b\u0001\u0010*\u001a\u00070\u001d\u00a2\u0006\u0002\b+2\r\b\u0001\u0010,\u001a\u00070\u001d\u00a2\u0006\u0002\b-2\b\u0010.\u001a\u0004\u0018\u00010\u001dH\u0016J*\u0010)\u001a\u00020\u001b2\u000b\u0010*\u001a\u00070\u001d\u00a2\u0006\u0002\b+2\u000b\u0010,\u001a\u00070\u001d\u00a2\u0006\u0002\b-2\u0006\u0010/\u001a\u000200H\u0016J8\u0010)\u001a\u00020\u001b2\r\b\u0001\u0010*\u001a\u00070\u001d\u00a2\u0006\u0002\b+2\r\b\u0001\u0010,\u001a\u00070\u001d\u00a2\u0006\u0002\b-2\b\u0010.\u001a\u0004\u0018\u00010\u001d2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u001dH\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u00103\u001a\u00020\nH\u0016J\b\u00104\u001a\u00020\u0003H\u0016J\b\u00105\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/formatting/service/AsyncDocumentFormattingSupportImpl$FormattingRequestImpl;", "Lcom/intellij/formatting/service/AsyncFormattingRequest;", "_context", "Lcom/intellij/formatting/FormattingContext;", "document", "Lcom/intellij/openapi/editor/Document;", "_ranges", "", "Lcom/intellij/openapi/util/TextRange;", "_canChangeWhitespaceOnly", "", "_quickFormat", "isSync", "<init>", "(Lcom/intellij/formatting/service/AsyncDocumentFormattingSupportImpl;Lcom/intellij/formatting/FormattingContext;Lcom/intellij/openapi/editor/Document;Ljava/util/List;ZZZ)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "initialModificationStamp", "", "task", "Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "getTask", "()Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;", "setTask", "(Lcom/intellij/formatting/service/AsyncDocumentFormattingService$FormattingTask;)V", "taskStarted", "Lkotlinx/coroutines/CompletableDeferred;", "", "taskResult", "", "cancel", "notifyExpired", "runAndAwaitTask", "Lkotlinx/coroutines/Job;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIOFile", "Ljava/io/File;", "updateDocument", "newText", "onTextReady", "updatedText", "onError", "title", "Lcom/intellij/openapi/util/NlsContexts$NotificationTitle;", "message", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "displayId", "offset", "", "getDocumentText", "getFormattingRanges", "canChangeWhitespaceOnly", "getContext", "isQuickFormat", "intellij.platform.codeStyle.impl"})
    private final class FormattingRequestImpl
    implements AsyncFormattingRequest {
        @NotNull
        private final FormattingContext _context;
        @NotNull
        private final Document document;
        @NotNull
        private final List<TextRange> _ranges;
        private final boolean _canChangeWhitespaceOnly;
        private final boolean _quickFormat;
        private final boolean isSync;
        private final long initialModificationStamp;
        @Nullable
        private volatile AsyncDocumentFormattingService.FormattingTask task;
        @NotNull
        private final CompletableDeferred<Unit> taskStarted;
        @NotNull
        private final CompletableDeferred<String> taskResult;

        public FormattingRequestImpl(@NotNull FormattingContext _context, @NotNull Document document, List<? extends TextRange> _ranges, boolean _canChangeWhitespaceOnly, boolean _quickFormat, boolean isSync) {
            Intrinsics.checkNotNullParameter((Object)_context, (String)"_context");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(_ranges, (String)"_ranges");
            this._context = _context;
            this.document = document;
            this._ranges = _ranges;
            this._canChangeWhitespaceOnly = _canChangeWhitespaceOnly;
            this._quickFormat = _quickFormat;
            this.isSync = isSync;
            this.initialModificationStamp = this.document.getModificationStamp();
            this.taskStarted = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            this.taskResult = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @Nullable
        public final AsyncDocumentFormattingService.FormattingTask getTask() {
            return this.task;
        }

        public final void setTask(@Nullable AsyncDocumentFormattingService.FormattingTask formattingTask) {
            this.task = formattingTask;
        }

        public final boolean cancel() {
            if (!this.taskStarted.isCompleted()) {
                return false;
            }
            if (this.taskResult.completeExceptionally((Throwable)new CancellationException())) {
                AsyncDocumentFormattingService.FormattingTask formattingTask = this.task;
                if (formattingTask == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                AsyncDocumentFormattingService.FormattingTask formattingTask2 = formattingTask;
                return formattingTask2.cancel();
            }
            return false;
        }

        private final void notifyExpired() {
            Object[] objectArray = new Object[]{AsyncDocumentFormattingService.getName((AsyncDocumentFormattingService)AsyncDocumentFormattingSupportImpl.this.service), String.valueOf(AsyncDocumentFormattingService.getTimeout((AsyncDocumentFormattingService)AsyncDocumentFormattingSupportImpl.this.service).getSeconds())};
            String string = CodeStyleBundle.message((String)"async.formatting.service.timeout", (Object[])objectArray);
            objectArray = AsyncDocumentFormattingService.getTimeoutActions((AsyncDocumentFormattingService)AsyncDocumentFormattingSupportImpl.this.service, (FormattingContext)this._context);
            FormattingNotificationService.getInstance((Project)this._context.getProject()).reportError(AsyncDocumentFormattingService.getNotificationGroupId((AsyncDocumentFormattingService)AsyncDocumentFormattingSupportImpl.this.service), AsyncDocumentFormattingService.getTimeoutNotificationDisplayId((AsyncDocumentFormattingService)AsyncDocumentFormattingSupportImpl.this.service), AsyncDocumentFormattingService.getName((AsyncDocumentFormattingService)AsyncDocumentFormattingSupportImpl.this.service), string, (AnAction[])Arrays.copyOf(objectArray, objectArray.length));
        }

        @Nullable
        public final Object runAndAwaitTask(@NotNull Continuation<? super Job> $completion) {
            return kotlinx.coroutines.CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(this, AsyncDocumentFormattingSupportImpl.this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ FormattingRequestImpl this$0;
                final /* synthetic */ AsyncDocumentFormattingSupportImpl this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            CoroutineDispatcher coroutineDispatcher;
                            void $this$coroutineScope;
                            ResultKt.throwOnFailure((Object)$result);
                            AsyncDocumentFormattingService.FormattingTask formattingTask = this.this$0.getTask();
                            if (formattingTask == null) {
                                String string = "Required value was null.";
                                throw new IllegalStateException(string.toString());
                            }
                            AsyncDocumentFormattingService.FormattingTask task = formattingTask;
                            if (FormattingRequestImpl.access$isSync$p(this.this$0)) {
                                CoroutineContext.Element element = $this$coroutineScope.getCoroutineContext().get((CoroutineContext.Key)CoroutineDispatcher.Key);
                                if (element == null) {
                                    String string = "Required value was null.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                coroutineDispatcher = (CoroutineDispatcher)element;
                            } else {
                                coroutineDispatcher = Dispatchers.getIO();
                            }
                            CoroutineDispatcher taskDispatcher = coroutineDispatcher;
                            Job taskJob2 = BuildersKt.launch$default((CoroutineScope)kotlinx.coroutines.CoroutineScopeKt.CoroutineScope((CoroutineContext)$this$coroutineScope.getCoroutineContext().minusKey((CoroutineContext.Key)Job.Key).plus((CoroutineContext)taskDispatcher)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(task, this.this$0, null){
                                int label;
                                final /* synthetic */ AsyncDocumentFormattingService.FormattingTask $task;
                                final /* synthetic */ FormattingRequestImpl this$0;
                                {
                                    this.$task = $task;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = AsyncDocumentFormattingSupportImplKt.access$coroutineToIndicatorIfNeeded(this.$task.isRunUnderProgress(), () -> runAndAwaitTask.taskJob.1.invokeSuspend$lambda$0(this.this$0, this.$task), (Continuation)this);
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            Object object2;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                            catch (Throwable t) {
                                                FormattingRequestImpl.access$getTaskStarted$p(this.this$0).completeExceptionally(t);
                                                throw t;
                                            }
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final Unit invokeSuspend$lambda$0(FormattingRequestImpl this$0, AsyncDocumentFormattingService.FormattingTask $task) {
                                    FormattingRequestImpl.access$getTaskStarted$p(this$0).complete((Object)Unit.INSTANCE);
                                    $task.run();
                                    return Unit.INSTANCE;
                                }
                            }), (int)3, null);
                            return BuildersKt.launch((CoroutineScope)$this$coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (CoroutineStart)CoroutineStart.ATOMIC, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.this$0, taskDispatcher, taskJob2, null){
                                long J$0;
                                long J$1;
                                long J$2;
                                long J$3;
                                Object L$0;
                                int label;
                                final /* synthetic */ AsyncDocumentFormattingSupportImpl this$0;
                                final /* synthetic */ FormattingRequestImpl this$1;
                                final /* synthetic */ CoroutineDispatcher $taskDispatcher;
                                final /* synthetic */ Job $taskJob;
                                {
                                    this.this$0 = $receiver;
                                    this.this$1 = $receiver2;
                                    this.$taskDispatcher = $taskDispatcher;
                                    this.$taskJob = $taskJob;
                                    super(2, $completion);
                                }

                                /*
                                 * Exception decompiling
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    /*
                                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                     * 
                                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[SWITCH], 12[CASE]], but top level block is 4[TRYBLOCK]
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCase.dump(StructuredCase.java:94)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredSwitch.dump(StructuredSwitch.java:59)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                                     *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                     */
                                    throw new IllegalStateException("Decompilation failed");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public File getIOFile() {
            VirtualFile originalFile = this._context.getVirtualFile();
            String ext = null;
            Charset charset = null;
            if (originalFile != null) {
                Path localPath;
                if (originalFile.isInLocalFileSystem() && (localPath = originalFile.getFileSystem().getNioPath(originalFile)) != null) {
                    return localPath.toFile();
                }
                ext = originalFile.getExtension();
                charset = originalFile.getCharset();
            } else {
                ext = this._context.getContainingFile().getFileType().getDefaultExtension();
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            try {
                File file = FileUtilRt.createTempFile((String)"ij-format-temp", (String)("." + ext), (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
                File tempFile = file;
                Closeable closeable = new FileWriter(tempFile, charset);
                Throwable throwable = null;
                try {
                    FileWriter writer = (FileWriter)closeable;
                    boolean bl = false;
                    writer.write(this.getDocumentText());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return tempFile;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }

        public final void updateDocument(@NotNull String newText) {
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            if (!AsyncDocumentFormattingService.needToUpdate((AsyncDocumentFormattingService)AsyncDocumentFormattingSupportImpl.this.service)) {
                return;
            }
            if (this.document.getModificationStamp() > this.initialModificationStamp) {
                DocumentMerger merger;
                Iterator iterator = DocumentMerger.EP_NAME.getExtensionList().iterator();
                while (iterator.hasNext() && !(merger = (DocumentMerger)iterator.next()).updateDocument(this.document, newText)) {
                }
            } else {
                this.document.setText((CharSequence)newText);
            }
        }

        public void onTextReady(@Nullable String updatedText) {
            this.taskResult.complete((Object)updatedText);
        }

        public void onError(@NotNull String title, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.onError(title, message, null);
        }

        public void onError(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @Nullable String displayId) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (this.taskResult.complete(null)) {
                FormattingNotificationService.getInstance((Project)this._context.getProject()).reportError(AsyncDocumentFormattingService.getNotificationGroupId((AsyncDocumentFormattingService)AsyncDocumentFormattingSupportImpl.this.service), displayId, title, message);
            }
        }

        public void onError(@NotNull String title, @NotNull String message, int offset) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.onError(title, message, null, offset);
        }

        public void onError(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @Nullable String displayId, int offset) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (this.taskResult.complete(null)) {
                FormattingNotificationService.getInstance((Project)this._context.getProject()).reportErrorAndNavigate(AsyncDocumentFormattingService.getNotificationGroupId((AsyncDocumentFormattingService)AsyncDocumentFormattingSupportImpl.this.service), displayId, title, message, this._context, offset);
            }
        }

        @NotNull
        public String getDocumentText() {
            String string = this.document.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        @NotNull
        public List<TextRange> getFormattingRanges() {
            return this._ranges;
        }

        public boolean canChangeWhitespaceOnly() {
            return this._canChangeWhitespaceOnly;
        }

        @NotNull
        public FormattingContext getContext() {
            return this._context;
        }

        public boolean isQuickFormat() {
            return this._quickFormat;
        }

        public static final /* synthetic */ boolean access$isSync$p(FormattingRequestImpl $this) {
            return $this.isSync;
        }

        public static final /* synthetic */ CompletableDeferred access$getTaskStarted$p(FormattingRequestImpl $this) {
            return $this.taskStarted;
        }

        public static final /* synthetic */ CompletableDeferred access$getTaskResult$p(FormattingRequestImpl $this) {
            return $this.taskResult;
        }

        public static final /* synthetic */ void access$notifyExpired(FormattingRequestImpl $this) {
            $this.notifyExpired();
        }
    }
}

