/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.FormattingService;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.CoreCodeStyleUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ExternalFormatProcessorAdapter
implements FormattingService {
    private static final Set<FormattingService.Feature> FEATURES = EnumSet.of(FormattingService.Feature.AD_HOC_FORMATTING, FormattingService.Feature.FORMAT_FRAGMENTS);

    public boolean canFormat(@NotNull PsiFile file) {
        if (file == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(0);
        }
        return ExternalFormatProcessor.useExternalFormatter((PsiFile)file);
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Set<FormattingService.Feature> set = FEATURES;
        if (set == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public PsiElement formatElement(@NotNull PsiElement element, boolean canChangeWhiteSpacesOnly) {
        if (element == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = ExternalFormatProcessor.formatElement((PsiElement)element, (TextRange)element.getTextRange(), (boolean)canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement formatElement(@NotNull PsiElement element, @NotNull TextRange range, boolean canChangeWhiteSpacesOnly) {
        if (element == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(4);
        }
        if (range == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = ExternalFormatProcessor.formatElement((PsiElement)element, (TextRange)range, (boolean)canChangeWhiteSpacesOnly);
        if (psiElement == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public void formatRanges(@NotNull PsiFile file, FormattingRangesInfo rangesInfo, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        if (file == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(7);
        }
        List<CoreCodeStyleUtil.RangeFormatInfo> infos = CoreCodeStyleUtil.getRangeFormatInfoList(file, rangesInfo);
        CoreCodeStyleUtil.postProcessRanges(infos, range -> ExternalFormatProcessor.formatRangeInFile((PsiFile)file, (TextRange)range, (boolean)false, (boolean)false));
    }

    @NotNull
    public Set<ImportOptimizer> getImportOptimizers(@NotNull PsiFile file) {
        if (file == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(8);
        }
        Set<ImportOptimizer> set = Collections.emptySet();
        if (set == null) {
            ExternalFormatProcessorAdapter.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/service/ExternalFormatProcessorAdapter";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/service/ExternalFormatProcessorAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportOptimizers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFormat";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getImportOptimizers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 9 -> new IllegalStateException(string);
        };
    }
}

