/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.DefaultLineWrapPositionStrategy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SlowOperations;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class LanguageLineWrapPositionStrategy
extends LanguageExtension<LineWrapPositionStrategy> {
    public static final ExtensionPointName<? extends KeyedLazyInstance<LineWrapPositionStrategy>> EP_NAME = new ExtensionPointName("com.intellij.lang.lineWrapStrategy");
    public static final LanguageLineWrapPositionStrategy INSTANCE = new LanguageLineWrapPositionStrategy();

    private LanguageLineWrapPositionStrategy() {
        super(EP_NAME, (Object)new DefaultLineWrapPositionStrategy());
    }

    @NotNull
    public LineWrapPositionStrategy forEditor(@NotNull Editor editor) {
        if (editor == null) {
            LanguageLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        LineWrapPositionStrategy result = this.getDefaultImplementation();
        Project project = editor.getProject();
        if (project != null && !project.isDisposed()) {
            try (AccessToken ignore = SlowOperations.knownIssue((String)"IJPL-162826");){
                LineWrapPositionStrategy strategy = (LineWrapPositionStrategy)ReadAction.compute(() -> {
                    PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                    if (file == null) {
                        return null;
                    }
                    return (LineWrapPositionStrategy)INSTANCE.forLanguage(file.getLanguage());
                });
                if (strategy != null) {
                    result = strategy;
                }
            }
        }
        LineWrapPositionStrategy lineWrapPositionStrategy = result;
        if (lineWrapPositionStrategy == null) {
            LanguageLineWrapPositionStrategy.$$$reportNull$$$0(1);
        }
        return lineWrapPositionStrategy;
    }

    @NotNull
    public LineWrapPositionStrategy getDefaultImplementation() {
        LineWrapPositionStrategy lineWrapPositionStrategy = Objects.requireNonNull((LineWrapPositionStrategy)super.getDefaultImplementation(), "com.intellij.openapi.editor.DefaultLineWrapPositionStrategy must be registered");
        if (lineWrapPositionStrategy == null) {
            LanguageLineWrapPositionStrategy.$$$reportNull$$$0(2);
        }
        return lineWrapPositionStrategy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/LanguageLineWrapPositionStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/LanguageLineWrapPositionStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forEditor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

