/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.util;

import com.intellij.collaboration.ui.util.VolatileImageBufferingPainterKt;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.VolatileImage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J9\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\t0\u000fJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/collaboration/ui/util/VolatileImageBufferingPainter;", "", "bufferTransparency", "", "<init>", "(I)V", "buffer", "Ljava/awt/image/VolatileImage;", "paintBuffered", "", "targetG", "Ljava/awt/Graphics;", "bufferSize", "Ljava/awt/Dimension;", "painter", "Lkotlin/Function1;", "Ljava/awt/Graphics2D;", "Lkotlin/ParameterName;", "name", "bufferG2", "validateAndRecreateBuffer", "g2", "createVolatileImage", "dc", "Ljava/awt/GraphicsConfiguration;", "width", "height", "intellij.platform.collaborationTools"})
public final class VolatileImageBufferingPainter {
    private final int bufferTransparency;
    @Nullable
    private VolatileImage buffer;

    public VolatileImageBufferingPainter(int bufferTransparency) {
        this.bufferTransparency = bufferTransparency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paintBuffered(@NotNull Graphics targetG, @NotNull Dimension bufferSize, @NotNull Function1<? super Graphics2D, Unit> painter) {
        Intrinsics.checkNotNullParameter((Object)targetG, (String)"targetG");
        Intrinsics.checkNotNullParameter((Object)bufferSize, (String)"bufferSize");
        Intrinsics.checkNotNullParameter(painter, (String)"painter");
        Graphics graphics = targetG.create();
        Graphics2D graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g2 = graphics2D;
        try {
            VolatileImage volatileImage;
            if (this.validateAndRecreateBuffer(g2, bufferSize) == null) {
                return;
            }
            VolatileImage buffer = volatileImage;
            boolean painted = VolatileImageBufferingPainterKt.access$paintToVolatileImage(buffer, painter);
            if (!painted) {
                return;
            }
            GraphicsUtil.disableAAPainting((Graphics)g2);
            PaintUtil.alignTxToInt((Graphics2D)g2, null, (boolean)true, (boolean)true, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND_FLOOR_BIAS);
            g2.drawImage(buffer, 0, 0, null);
        }
        finally {
            g2.dispose();
        }
    }

    private final VolatileImage validateAndRecreateBuffer(Graphics2D g2, Dimension bufferSize) {
        VolatileImage volatileImage;
        block5: {
            VolatileImage it;
            VolatileImage volatileImage2;
            GraphicsConfiguration dc;
            int heightAligned;
            int widthAligned;
            block4: {
                ScaleContext ctx = ScaleContext.Companion.create(g2);
                widthAligned = PaintUtil.alignIntToInt((int)bufferSize.width, (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
                heightAligned = PaintUtil.alignIntToInt((int)bufferSize.height, (ScaleContext)ctx, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL, null);
                if (widthAligned <= 0 || heightAligned <= 0) {
                    return null;
                }
                dc = g2.getDeviceConfiguration();
                volatileImage = this.buffer;
                if (volatileImage == null) break block4;
                it = volatileImage2 = volatileImage;
                boolean bl = false;
                volatileImage = it.getWidth() == widthAligned && it.getHeight() == heightAligned && it.validate(dc) != 2 ? volatileImage2 : null;
                if (volatileImage != null) break block5;
            }
            Intrinsics.checkNotNull((Object)dc);
            it = volatileImage2 = this.createVolatileImage(dc, widthAligned, heightAligned);
            boolean bl = false;
            this.buffer = it;
            volatileImage = volatileImage2;
        }
        return volatileImage;
    }

    private final VolatileImage createVolatileImage(GraphicsConfiguration dc, int width, int height) {
        VolatileImage volatileImage;
        VolatileImage volatileImage2;
        try {
            int transparency = this.bufferTransparency != 1 ? 3 : this.bufferTransparency;
            volatileImage2 = dc.createCompatibleVolatileImage(width, height, new ImageCapabilities(true), transparency);
        }
        catch (AWTException aWTException) {
            volatileImage2 = dc.createCompatibleVolatileImage(width, height, this.bufferTransparency);
        }
        VolatileImage volatileImage3 = volatileImage2;
        if (volatileImage3 != null) {
            VolatileImage it = volatileImage2 = volatileImage3;
            boolean bl = false;
            volatileImage = it.validate(dc) != 2 ? volatileImage2 : null;
        } else {
            volatileImage = null;
        }
        return volatileImage;
    }
}

