/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.commercial.dependencies;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesDownloader;
import org.jetbrains.intellij.build.dependencies.DependenciesProperties;
import org.jetbrains.intellij.build.dependencies.JdkDownloader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/commercial/dependencies/StationDependenciesDownloader;", "", "<init>", "()V", "getToolboxBuildNumber", "", "communityRoot", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "getDownloadLink", "fileName", "getDownloadFileName", "version", "intellij.platform.commercial.dependencies"})
@ApiStatus.Internal
public final class StationDependenciesDownloader {
    @NotNull
    public static final StationDependenciesDownloader INSTANCE = new StationDependenciesDownloader();

    private StationDependenciesDownloader() {
    }

    @NotNull
    public final String getToolboxBuildNumber(@NotNull BuildDependenciesCommunityRoot communityRoot) {
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        DependenciesProperties properties = BuildDependenciesDownloader.INSTANCE.getDependencyProperties(communityRoot);
        String version = properties.property("toolboxBuild");
        return version;
    }

    @NotNull
    public final String getDownloadLink(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return "https://cache-redirector.jetbrains.com/download.jetbrains.com/toolbox/ide-bundle/" + fileName;
    }

    @NotNull
    public final String getDownloadFileName(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        JdkDownloader.OS os = JdkDownloader.OS.Companion.getCurrent();
        JdkDownloader.Arch arch = JdkDownloader.Arch.Companion.getCurrent();
        String archSuffix = arch == JdkDownloader.Arch.X86_64 ? "" : "-arm64";
        String extension = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1 -> "exe";
            case 2 -> "dmg";
            case 3 -> "tar.gz";
            default -> throw new NoWhenBranchMatchedException();
        };
        return "jetbrains-toolbox-" + version + archSuffix + "." + extension;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JdkDownloader.OS.values().length];
            try {
                nArray[JdkDownloader.OS.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JdkDownloader.OS.MACOSX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JdkDownloader.OS.LINUX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

