/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.ReflectionUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;

public final class AtomicFieldUpdater<ContainingClass, FieldType> {
    private final VarHandle myHandle;

    @NotNull
    public static <T, V> AtomicFieldUpdater<T, V> forFieldOfType(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(0);
        }
        if (fieldType == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(1);
        }
        return new AtomicFieldUpdater<T, V>(ownerClass, fieldType);
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Long> forLongFieldIn(@NotNull Class<T> ownerClass) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(2);
        }
        return new AtomicFieldUpdater<T, Long>(ownerClass, Long.TYPE);
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Integer> forIntFieldIn(@NotNull Class<T> ownerClass) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(3);
        }
        return new AtomicFieldUpdater<T, Integer>(ownerClass, Integer.TYPE);
    }

    @NotNull
    public static <O, E> AtomicFieldUpdater<O, E> forField(@NotNull Field field) {
        if (field == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(4);
        }
        return new AtomicFieldUpdater(field);
    }

    private AtomicFieldUpdater(@NotNull Class<ContainingClass> ownerClass, @NotNull Class<FieldType> fieldType) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(5);
        }
        if (fieldType == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(6);
        }
        this(ReflectionUtil.getTheOnlyVolatileInstanceFieldOfClass(ownerClass, fieldType));
    }

    private AtomicFieldUpdater(@NotNull Field field) {
        if (field == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(7);
        }
        field.setAccessible(true);
        if (!Modifier.isVolatile(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException(String.valueOf(field) + " must be volatile instance");
        }
        try {
            this.myHandle = MethodHandles.privateLookupIn(field.getDeclaringClass(), MethodHandles.lookup()).findVarHandle(field.getDeclaringClass(), field.getName(), field.getType());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public boolean compareAndSet(@NotNull ContainingClass owner, FieldType expected, FieldType newValue) {
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(8);
        }
        return this.myHandle.compareAndSet(owner, expected, newValue);
    }

    /*
     * WARNING - void declaration
     */
    public boolean compareAndSetLong(@NotNull ContainingClass owner, long expected, long l) {
        void newValue;
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(9);
        }
        return this.myHandle.compareAndSet(owner, expected, (long)newValue);
    }

    public boolean compareAndSetInt(@NotNull ContainingClass owner, int expected, int newValue) {
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(10);
        }
        return this.myHandle.compareAndSet(owner, expected, newValue);
    }

    public void setVolatile(@NotNull ContainingClass owner, FieldType newValue) {
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(11);
        }
        this.myHandle.setVolatile(owner, newValue);
    }

    public FieldType getVolatile(@NotNull ContainingClass owner) {
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(12);
        }
        return (FieldType)this.myHandle.getVolatile(owner);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/concurrency/AtomicFieldUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forFieldOfType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "forLongFieldIn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "forIntFieldIn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "forField";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAndSet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAndSetLong";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "compareAndSetInt";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "setVolatile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getVolatile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

