/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/concurrency/CountDownConsumer;", "T", "", "Ljava/util/function/Consumer;", "countDown", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "totalResult", "<init>", "(ILorg/jetbrains/concurrency/AsyncPromise;Ljava/lang/Object;)V", "Ljava/lang/Object;", "Ljava/util/concurrent/atomic/AtomicInteger;", "accept", "", "t", "intellij.platform.concurrency"})
final class CountDownConsumer<T>
implements Consumer<Object> {
    @NotNull
    private final AsyncPromise<T> promise;
    private final T totalResult;
    @NotNull
    private final AtomicInteger countDown;

    public CountDownConsumer(int countDown, @NotNull AsyncPromise<T> promise, T totalResult) {
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        this.promise = promise;
        this.totalResult = totalResult;
        this.countDown = new AtomicInteger(countDown);
    }

    @Override
    public void accept(@Nullable Object t) {
        if (this.countDown.decrementAndGet() == 0) {
            this.promise.setResult(this.totalResult);
        }
    }
}

