/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.util.PathUtilRt;
import com.intellij.workspaceModel.ide.impl.JpsMetricsKt;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/configurationStore/AppStorageContentReader;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "<init>", "()V", "loadComponent", "Lorg/jdom/Element;", "fileUrl", "", "componentName", "customModuleFilePath", "getExpandMacroMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "isApplicationLevelFile", "", "filePath", "Companion", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nApplicationStoreBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationStoreBridge.kt\ncom/intellij/configurationStore/AppStorageContentReader\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,107:1\n44#2,2:108\n46#2:113\n29#3,3:110\n*S KotlinDebug\n*F\n+ 1 ApplicationStoreBridge.kt\ncom/intellij/configurationStore/AppStorageContentReader\n*L\n28#1:108,2\n28#1:113\n28#1:110,3\n*E\n"})
public final class AppStorageContentReader
implements JpsFileContentReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final AtomicLong loadComponentTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);

    @Nullable
    public Element loadComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable String customModuleFilePath) {
        Element element;
        Element element2;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        AtomicLong atomicLong = loadComponentTimeMs;
        boolean bl = false;
        Element value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        String filePath = JpsPathUtil.urlToPath((String)fileUrl);
        Intrinsics.checkNotNull((Object)filePath);
        if (this.isApplicationLevelFile(filePath)) {
            FileStorageAnnotation storageSpec = new FileStorageAnnotation(PathUtilRt.getFileName((String)filePath), false, StateSplitterEx.class);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            StateStorage stateStorage = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager().getStateStorage((Storage)storageSpec);
            Intrinsics.checkNotNull((Object)stateStorage, (String)"null cannot be cast to non-null type com.intellij.configurationStore.StateStorageBase<com.intellij.configurationStore.StateMap>");
            element2 = StateMap.getElement$default((StateMap)((StateStorageBase)stateStorage).getStorageData(), componentName, null, 2, null);
        } else {
            element2 = null;
        }
        value$iv = element = element2;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        ExpandMacroToPathMap expandMacroToPathMap = PathMacroManager.getInstance((ComponentManager)((ComponentManager)ApplicationManager.getApplication())).getExpandMacroMap();
        Intrinsics.checkNotNullExpressionValue((Object)expandMacroToPathMap, (String)"getExpandMacroMap(...)");
        return expandMacroToPathMap;
    }

    private final boolean isApplicationLevelFile(String filePath) {
        return Path.of(filePath, new String[0]).startsWith(PathManager.getOptionsDir());
    }

    static {
        Meter meter = JpsMetricsKt.getJpsMetrics().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        AppStorageContentReader.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/configurationStore/AppStorageContentReader$Companion;", "", "<init>", "()V", "loadComponentTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.configurationStore.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement loadComponentTimeCounter = meter.counterBuilder("jps.app.storage.content.reader.load.component.ms").buildObserver();
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(loadComponentTimeCounter), (ObservableMeasurement)loadComponentTimeCounter, new ObservableMeasurement[0]);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $loadComponentTimeCounter) {
            $loadComponentTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)loadComponentTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

