/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.SaveResult;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.SaveSessionProducerManager;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsAppFileContentWriter;
import com.intellij.util.PathUtilRt;
import com.intellij.workspaceModel.ide.impl.JpsMetricsKt;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u000f\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/configurationStore/AppStorageContentWriter;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsAppFileContentWriter;", "session", "Lcom/intellij/configurationStore/SaveSessionProducerManager;", "<init>", "(Lcom/intellij/configurationStore/SaveSessionProducerManager;)V", "saveComponent", "", "fileUrl", "", "componentName", "componentTag", "Lorg/jdom/Element;", "getReplacePathMacroMap", "Lcom/intellij/openapi/components/PathMacroMap;", "saveSession", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isApplicationLevelFile", "", "filePath", "Companion", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nApplicationStoreBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationStoreBridge.kt\ncom/intellij/configurationStore/AppStorageContentWriter\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,107:1\n44#2,2:108\n46#2:113\n29#3,3:110\n*S KotlinDebug\n*F\n+ 1 ApplicationStoreBridge.kt\ncom/intellij/configurationStore/AppStorageContentWriter\n*L\n79#1:108,2\n79#1:113\n79#1:110,3\n*E\n"})
public final class AppStorageContentWriter
implements JpsAppFileContentWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SaveSessionProducerManager session;
    @NotNull
    private static final AtomicLong saveComponentTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);

    public AppStorageContentWriter(@NotNull SaveSessionProducerManager session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    public void saveComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable Element componentTag) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        AtomicLong atomicLong = saveComponentTimeMs;
        boolean bl = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        String filePath = JpsPathUtil.urlToPath((String)fileUrl);
        Intrinsics.checkNotNull((Object)filePath);
        if (this.isApplicationLevelFile(filePath)) {
            FileStorageAnnotation storageSpec = new FileStorageAnnotation(PathUtilRt.getFileName((String)filePath), false, StateSplitterEx.class);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            StateStorage stateStorage = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager().getStateStorage((Storage)storageSpec);
            Intrinsics.checkNotNull((Object)stateStorage, (String)"null cannot be cast to non-null type com.intellij.configurationStore.StateStorageBase<com.intellij.configurationStore.StateMap>");
            StateStorageBase storage = (StateStorageBase)stateStorage;
            SaveSessionProducer saveSessionProducer = this.session.getProducer(storage);
            if (saveSessionProducer != null) {
                saveSessionProducer.setState(null, componentName, PluginManagerCore.CORE_ID, (Object)componentTag);
            }
        }
        value$iv = Unit.INSTANCE;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    @NotNull
    public PathMacroMap getReplacePathMacroMap(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        ReplacePathToMacroMap replacePathToMacroMap = PathMacroManager.getInstance((ComponentManager)((ComponentManager)ApplicationManager.getApplication())).getReplacePathMap();
        Intrinsics.checkNotNullExpressionValue((Object)replacePathToMacroMap, (String)"getReplacePathMap(...)");
        return (PathMacroMap)replacePathToMacroMap;
    }

    @Nullable
    public Object saveSession(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.session.save(new SaveResult(), false, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final boolean isApplicationLevelFile(String filePath) {
        return Path.of(filePath, new String[0]).startsWith(PathManager.getOptionsDir());
    }

    static {
        Meter meter = JpsMetricsKt.getJpsMetrics().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        AppStorageContentWriter.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/configurationStore/AppStorageContentWriter$Companion;", "", "<init>", "()V", "saveComponentTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.configurationStore.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement saveComponentTimeCounter = meter.counterBuilder("jps.app.storage.content.writer.save.component.ms").buildObserver();
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(saveComponentTimeCounter), (ObservableMeasurement)saveComponentTimeCounter, new ObservableMeasurement[0]);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $saveComponentTimeCounter) {
            $saveComponentTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)saveComponentTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

