/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.RenameableStateStorageManager;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u001a\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0010J\u0014\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "", "<init>", "()V", "filePathToStorage", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "hasDirectoryBasedStorages", "", "put", "", "path", "storage", "remove", "filter", "Lkotlin/Function1;", "schedule", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "TrackedStorage", "intellij.platform.configurationStore.impl"})
public final class StorageVirtualFileTracker {
    @NotNull
    private final ConcurrentHashMap<String, TrackedStorage> filePathToStorage = new ConcurrentHashMap();
    private volatile boolean hasDirectoryBasedStorages;

    public final void put(@NotNull String path, @NotNull TrackedStorage storage) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.filePathToStorage.put(path, storage);
        if (storage instanceof DirectoryBasedStorage) {
            this.hasDirectoryBasedStorages = true;
        }
    }

    public final void remove(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.filePathToStorage.remove(path);
    }

    public final void remove(@NotNull Function1<? super TrackedStorage, Boolean> filter2) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        this.filePathToStorage.values().removeIf(arg_0 -> StorageVirtualFileTracker.remove$lambda$0(filter2, arg_0));
    }

    public final void schedule(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Map projectToChanges = null;
        for (VFileEvent entry : events) {
            Project project;
            ComponentManager componentManager;
            ComponentManager componentManager2;
            String path;
            StateStorage storage = null;
            if (entry instanceof VFilePropertyChangeEvent && Intrinsics.areEqual((Object)"name", (Object)((VFilePropertyChangeEvent)entry).getPropertyName())) {
                String oldPath;
                Intrinsics.checkNotNullExpressionValue((Object)((VFilePropertyChangeEvent)entry).getOldPath(), (String)"getOldPath(...)");
                storage = this.filePathToStorage.remove(oldPath);
                if (storage != null) {
                    StateStorageManagerImpl stateStorageManagerImpl;
                    String newPath;
                    Intrinsics.checkNotNullExpressionValue((Object)((VFilePropertyChangeEvent)entry).getNewPath(), (String)"getNewPath(...)");
                    Path newFile = Path.of(newPath, new String[0]);
                    this.filePathToStorage.put(newPath, (TrackedStorage)storage);
                    if (storage instanceof FileBasedStorage) {
                        ((FileBasedStorage)storage).setFile(null, newFile);
                    }
                    RenameableStateStorageManager renameableStateStorageManager = (stateStorageManagerImpl = ((TrackedStorage)storage).getStorageManager()) instanceof RenameableStateStorageManager ? (RenameableStateStorageManager)stateStorageManagerImpl : null;
                    if (renameableStateStorageManager != null) {
                        Intrinsics.checkNotNull((Object)newFile);
                        renameableStateStorageManager.pathRenamed(newFile, entry);
                    }
                }
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)entry.getPath(), (String)"getPath(...)");
                storage = this.filePathToStorage.get(path);
                if (storage == null && this.hasDirectoryBasedStorages && StringsKt.endsWith((String)path, (String)".xml", (boolean)true)) {
                    storage = (StateStorage)((Map)this.filePathToStorage).get(VfsUtil.getParentDir((String)path));
                }
            }
            if (storage == null) continue;
            path = entry;
            if (path instanceof VFileMoveEvent) {
                if (storage instanceof FileBasedStorage) {
                    ((FileBasedStorage)storage).setFile(null, Path.of(((VFileMoveEvent)entry).getNewPath(), new String[0]));
                }
            } else if (path instanceof VFileCreateEvent) {
                if (storage instanceof FileBasedStorage && !(((VFileCreateEvent)entry).getRequestor() instanceof SaveSession)) {
                    ((FileBasedStorage)storage).setFile(((VFileCreateEvent)entry).getFile(), null);
                }
            } else if (path instanceof VFileDeleteEvent) {
                if (storage instanceof FileBasedStorage) {
                    ((FileBasedStorage)storage).setFile(null, null);
                } else {
                    ((DirectoryBasedStorage)storage).setVirtualDir$intellij_platform_configurationStore_impl(null);
                }
            } else if (path instanceof VFileCopyEvent) continue;
            if (!StateStorageManagerKt.isFireStorageFileChangedEvent((VFileEvent)entry)) continue;
            Intrinsics.checkNotNull((Object)((TrackedStorage)storage).getStorageManager().getComponentManager());
            if (projectToChanges == null) {
                projectToChanges = new LinkedHashMap();
            }
            if ((componentManager2 = componentManager) instanceof Project) {
                project = (Project)componentManager;
            } else {
                if (!(componentManager2 instanceof Module)) continue;
                Project project2 = ((Module)componentManager).getProject();
                project = project2;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            }
            Project project3 = project;
            projectToChanges.computeIfAbsent(project3, arg_0 -> StorageVirtualFileTracker.schedule$lambda$1(StorageVirtualFileTracker::schedule$lambda$0, arg_0)).computeIfAbsent(IComponentStoreKt.getStateStore((ComponentManager)componentManager), arg_0 -> StorageVirtualFileTracker.schedule$lambda$3(StorageVirtualFileTracker::schedule$lambda$2, arg_0)).add(storage);
        }
        if (projectToChanges == null) {
            return;
        }
        for (Map.Entry entry : projectToChanges.entrySet()) {
            Project project = (Project)entry.getKey();
            Map batchStorageEvents = (Map)entry.getValue();
            StoreReloadManager.Companion.getInstance(project).storageFilesBatchProcessing(batchStorageEvents);
        }
    }

    private static final boolean remove$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Map schedule$lambda$0(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    private static final Map schedule$lambda$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Set schedule$lambda$2(IComponentStore it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set schedule$lambda$3(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "Lcom/intellij/openapi/components/StateStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "intellij.platform.configurationStore.impl"})
    public static interface TrackedStorage
    extends StateStorage {
        @NotNull
        public StateStorageManagerImpl getStorageManager();
    }
}

