/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.JpsStorageContentWriter;
import com.intellij.configurationStore.ProjectStoreBridgeKt;
import com.intellij.configurationStore.ProjectStoreImpl;
import com.intellij.configurationStore.ProjectWithModulesSaveSessionProducerManager;
import com.intellij.configurationStore.XmlDataWriter;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.platform.workspace.jps.serialization.impl.WritableJpsFileContent;
import com.intellij.util.LineSeparator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0002\u001f B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J'\u0010\u0017\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J$\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000e2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00110\u001bH\u0016J\u000e\u0010\u001d\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/configurationStore/DirectJpsStorageContentWriter;", "Lcom/intellij/configurationStore/JpsStorageContentWriter;", "session", "Lcom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager;", "store", "Lcom/intellij/configurationStore/ProjectStoreImpl;", "project", "Lcom/intellij/openapi/project/Project;", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "<init>", "(Lcom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager;Lcom/intellij/configurationStore/ProjectStoreImpl;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/ModuleManager;)V", "filesWithComponents", "", "", "Lcom/intellij/configurationStore/DirectJpsStorageContentWriter$WritableImlFileContent;", "saveInternalFileModuleComponent", "", "filePath", "Lcom/intellij/openapi/util/NlsSafe;", "componentName", "componentTag", "Lorg/jdom/Element;", "saveExternalFileModuleComponent", "saveFile", "fileUrl", "writer", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/jps/serialization/impl/WritableJpsFileContent;", "writeFilesToDisk", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "WritableImlFileContent", "ImmediateJpsStorageContentWriter", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nProjectStoreBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStoreBridge.kt\ncom/intellij/configurationStore/DirectJpsStorageContentWriter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,483:1\n382#2,7:484\n382#2,7:491\n1869#3,2:498\n*S KotlinDebug\n*F\n+ 1 ProjectStoreBridge.kt\ncom/intellij/configurationStore/DirectJpsStorageContentWriter\n*L\n149#1:484,7\n157#1:491,7\n192#1:498,2\n*E\n"})
final class DirectJpsStorageContentWriter
extends JpsStorageContentWriter {
    @NotNull
    private final ModuleManager moduleManager;
    @NotNull
    private final Map<String, WritableImlFileContent> filesWithComponents;

    public DirectJpsStorageContentWriter(@NotNull ProjectWithModulesSaveSessionProducerManager session, @NotNull ProjectStoreImpl store, @NotNull Project project, @NotNull ModuleManager moduleManager) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleManager, (String)"moduleManager");
        super(session, store, project);
        this.moduleManager = moduleManager;
        this.filesWithComponents = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveInternalFileModuleComponent(@NotNull String filePath, @NotNull String componentName, @Nullable Element componentTag) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        if (componentTag != null) {
            Object object;
            void $this$getOrPut$iv;
            Map<String, WritableImlFileContent> map2 = this.filesWithComponents;
            String key$iv = filePath;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                WritableImlFileContent answer$iv = new WritableImlFileContent(filePath);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            WritableImlFileContent fileComponents = (WritableImlFileContent)object;
            fileComponents.saveComponent(componentName, componentTag);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveExternalFileModuleComponent(@NotNull String filePath, @NotNull String componentName, @Nullable Element componentTag) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        if (componentTag != null) {
            Object object;
            void $this$getOrPut$iv;
            Map<String, WritableImlFileContent> map2 = this.filesWithComponents;
            String key$iv = filePath;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                WritableImlFileContent answer$iv = new WritableImlFileContent(filePath);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            WritableImlFileContent fileComponents = (WritableImlFileContent)object;
            fileComponents.saveComponent(componentName, componentTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(@NotNull String fileUrl, @NotNull Function1<? super WritableJpsFileContent, Unit> writer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        String filePath = JpsPathUtil.urlToPath((String)fileUrl);
        if (ProjectStoreBridgeKt.access$shouldWriteExternalFilesImmediately()) {
            Intrinsics.checkNotNull((Object)filePath);
            WritableImlFileContent fileComponents = new WritableImlFileContent(filePath);
            Closeable closeable = new ImmediateJpsStorageContentWriter(fileComponents, this.moduleManager);
            Throwable throwable = null;
            try {
                Object object = writer.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            super.saveFile(fileUrl, writer);
        }
    }

    @Override
    @Nullable
    public Object writeFilesToDisk(@NotNull Continuation<? super Unit> $completion) {
        if (this.filesWithComponents.isEmpty()) {
            return Unit.INSTANCE;
        }
        CopyOnWriteArrayList<IOException> exceptions = new CopyOnWriteArrayList<IOException>();
        PathMacros globalPathMacros = PathMacros.getInstance();
        Object object = this.filesWithComponents.values().iterator();
        while (object.hasNext()) {
            WritableImlFileContent components = object.next();
            try {
                Intrinsics.checkNotNull((Object)globalPathMacros);
                components.flush(this.moduleManager, globalPathMacros);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!((Collection)exceptions).isEmpty()) {
            Object e = object = new IOException();
            boolean bl = false;
            Iterable $this$forEach$iv = exceptions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable p0 = (Throwable)element$iv;
                boolean bl2 = false;
                ((Throwable)e).addSuppressed(p0);
            }
            throw (Throwable)object;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/configurationStore/DirectJpsStorageContentWriter$ImmediateJpsStorageContentWriter;", "Lcom/intellij/platform/workspace/jps/serialization/impl/WritableJpsFileContent;", "Ljava/io/Closeable;", "delegate", "Lcom/intellij/configurationStore/DirectJpsStorageContentWriter$WritableImlFileContent;", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "<init>", "(Lcom/intellij/configurationStore/DirectJpsStorageContentWriter$WritableImlFileContent;Lcom/intellij/openapi/module/ModuleManager;)V", "saveComponent", "", "componentName", "", "componentTag", "Lorg/jdom/Element;", "close", "intellij.platform.configurationStore.impl"})
    private static final class ImmediateJpsStorageContentWriter
    implements WritableJpsFileContent,
    Closeable {
        @NotNull
        private final WritableImlFileContent delegate;
        @NotNull
        private final ModuleManager moduleManager;

        public ImmediateJpsStorageContentWriter(@NotNull WritableImlFileContent delegate, @NotNull ModuleManager moduleManager) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)moduleManager, (String)"moduleManager");
            this.delegate = delegate;
            this.moduleManager = moduleManager;
        }

        public void saveComponent(@NotNull String componentName, @Nullable Element componentTag) {
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            this.delegate.saveComponent(componentName, componentTag);
        }

        @Override
        public void close() {
            PathMacros pathMacros = PathMacros.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)pathMacros, (String)"getInstance(...)");
            this.delegate.flush(this.moduleManager, pathMacros);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/DirectJpsStorageContentWriter$WritableImlFileContent;", "", "filePath", "", "<init>", "(Ljava/lang/String;)V", "components", "Ljava/util/TreeMap;", "Lorg/jdom/Element;", "saveComponent", "", "componentName", "componentTag", "flush", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "globalPathMacros", "Lcom/intellij/openapi/application/PathMacros;", "intellij.platform.configurationStore.impl"})
    private static final class WritableImlFileContent {
        @NotNull
        private final String filePath;
        @NotNull
        private final TreeMap<String, Element> components;

        public WritableImlFileContent(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.filePath = filePath;
            this.components = new TreeMap();
        }

        public final void saveComponent(@NotNull String componentName, @Nullable Element componentTag) {
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            if (componentTag != null) {
                if (!Intrinsics.areEqual((Object)componentTag.getName(), (Object)"component")) {
                    componentTag.getAttributes().add(0, new Attribute("name", componentTag.getName()));
                    componentTag.setName("component");
                }
                this.components.put(componentName, componentTag);
            }
        }

        public final void flush(@NotNull ModuleManager moduleManager, @NotNull PathMacros globalPathMacros) {
            ModulePathMacroManager modulePathMacroManager;
            Intrinsics.checkNotNullParameter((Object)moduleManager, (String)"moduleManager");
            Intrinsics.checkNotNullParameter((Object)globalPathMacros, (String)"globalPathMacros");
            Path path = Path.of(this.filePath, new String[0]);
            Intrinsics.checkNotNull((Object)path);
            String moduleName = PathsKt.getNameWithoutExtension((Path)path);
            Module module = moduleManager.findModuleByName(moduleName);
            if (module == null) {
                ComponentStoreImplKt.LOG.error("Could not find module with name " + moduleName + ". Paths will not be substituted.");
                modulePathMacroManager = null;
            } else {
                modulePathMacroManager = new ModulePathMacroManager(module, globalPathMacros);
            }
            ModulePathMacroManager pathMacroManager = modulePathMacroManager;
            Collection<Element> collection = this.components.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            XmlDataWriter writer = new XmlDataWriter("module", CollectionsKt.toList((Iterable)collection), MapsKt.emptyMap(), (PathMacroManager)pathMacroManager, this.filePath);
            LineSeparator lineSeparator = LineSeparator.getSystemLineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)lineSeparator, (String)"getSystemLineSeparator(...)");
            writer.writeTo(path, null, lineSeparator, false);
        }
    }
}

