/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialog;
import com.intellij.configurationStore.ChooseComponentsToExportDialogKt;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.configurationStore.ImportSettingsActionKt;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ImportSettingsFilenameFilter;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0014J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0003J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/configurationStore/ImportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "getExportableComponents", "", "Lcom/intellij/configurationStore/FileSpec;", "", "Lcom/intellij/configurationStore/ExportableItem;", "relativePaths", "", "", "getMarkedComponents", "components", "doImport", "saveFile", "Ljava/nio/file/Path;", "restart", "confirmRestart", "", "message", "getRestartActionName", "doImportFromDirectory", "getRelativeNamesToExtract", "chosenComponents", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nImportSettingsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportSettingsAction.kt\ncom/intellij/configurationStore/ImportSettingsAction\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,188:1\n488#2,7:189\n*S KotlinDebug\n*F\n+ 1 ImportSettingsAction.kt\ncom/intellij/configurationStore/ImportSettingsAction\n*L\n82#1:189,7\n*E\n"})
public class ImportSettingsAction
extends AnAction
implements ActionRemoteBehaviorSpecification.Frontend,
DumbAware {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        FileChooserDescriptor fileChooserDescriptor;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Component component = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2);
        FileChooserDescriptor $this$actionPerformed_u24lambda_u240 = fileChooserDescriptor = new FileChooserDescriptor(){

            public boolean isFileSelectable(VirtualFile file) {
                boolean bl;
                if (file == null) {
                    bl = false;
                } else if (file.isDirectory()) {
                    Path path = file.getFileSystem().getNioPath(file);
                    if (path != null) {
                        Path path2 = path;
                        boolean bl2 = false;
                        bl = ConfigImportHelper.isConfigDirectory((Path)path2);
                    } else {
                        bl = false;
                    }
                } else {
                    bl = super.isFileSelectable(file);
                }
                return bl;
            }
        };
        boolean bl = false;
        $this$actionPerformed_u24lambda_u240.setTitle(ConfigurationStoreBundle.message("title.import.file.location", new Object[0]));
        $this$actionPerformed_u24lambda_u240.setDescription(ConfigurationStoreBundle.message("prompt.choose.import.file.path", new Object[0]));
        $this$actionPerformed_u24lambda_u240.setHideIgnored(false);
        ConfigImportHelper.setSettingsFilter((FileChooserDescriptor)$this$actionPerformed_u24lambda_u240);
        FileChooserDescriptor descriptor2 = fileChooserDescriptor;
        FileChooserDescriptor fileChooserDescriptor2 = descriptor2;
        Path path = PathManager.getOriginalConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getOriginalConfigDir(...)");
        ChooseComponentsToExportDialogKt.chooseSettingsFile(fileChooserDescriptor2, ((Object)path).toString(), component, (Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> ImportSettingsAction.actionPerformed$lambda$1(this, arg_0)));
    }

    @NotNull
    protected Map<FileSpec, List<ExportableItem>> getExportableComponents(@NotNull Set<String> relativePaths) {
        Intrinsics.checkNotNullParameter(relativePaths, (String)"relativePaths");
        Map $this$filterKeys$iv = ExportSettingsActionKt.getExportableComponentsMap$default(true, null, true, false, 10, null);
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            FileSpec it = (FileSpec)entry$iv.getKey();
            boolean bl = false;
            if (!relativePaths.contains(it.relativePath)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @NotNull
    protected Set<ExportableItem> getMarkedComponents(@NotNull Set<ExportableItem> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        return components;
    }

    protected void doImport(@NotNull Path saveFile) {
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(saveFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Object[] objectArray = new Object[]{saveFile};
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.cannot.find.file", objectArray), (String)ConfigurationStoreBundle.message("title.file.not.found", new Object[0]));
            return;
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.isDirectory(saveFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            this.doImportFromDirectory(saveFile);
            return;
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(saveFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Set<String> relativePaths = ImportSettingsActionKt.getPaths(inputStream);
        if (!relativePaths.contains("IntelliJ IDEA Global Settings")) {
            Object[] objectArray = new Object[]{saveFile};
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.no.settings.to.import", objectArray), (String)ConfigurationStoreBundle.message("title.invalid.file", new Object[0]));
            return;
        }
        Path path = PathManager.getOriginalConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getOriginalConfigDir(...)");
        Path configPath = path;
        Map<FileSpec, List<ExportableItem>> map2 = this.getExportableComponents(relativePaths);
        String string = ConfigurationStoreBundle.message("title.select.components.to.import", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = ConfigurationStoreBundle.message("prompt.check.components.to.import", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(map2, false, string, string2);
        if (!dialog.showAndGet()) {
            return;
        }
        Path tempFile = PathManager.getStartupScriptDir().resolve(saveFile.getFileName());
        Intrinsics.checkNotNull((Object)tempFile);
        PathKt.copy((Path)saveFile, (Path)tempFile);
        ImportSettingsFilenameFilter filenameFilter = new ImportSettingsFilenameFilter(this.getRelativeNamesToExtract(this.getMarkedComponents(dialog.getExportableComponents$intellij_platform_configurationStore_impl())));
        Object[] objectArray = new Object[]{new StartupActionScriptManager.UnzipCommand(tempFile, configPath, (Predicate)filenameFilter), new StartupActionScriptManager.DeleteCommand(tempFile)};
        StartupActionScriptManager.addActionCommands((List)CollectionsKt.listOf((Object[])objectArray));
        UpdateSettings.getInstance().forceCheckForUpdateAfterRestart();
        Object[] objectArray2 = new Object[]{this.getRestartActionName(), ApplicationNamesInfo.getInstance().getFullProductName()};
        String string3 = ConfigurationStoreBundle.message("message.settings.imported.successfully", objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        if (this.confirmRestart(string3)) {
            this.restart();
        }
    }

    private final void restart() {
        ActionsKt.invokeLater$default(null, ImportSettingsAction::restart$lambda$0, (int)1, null);
    }

    private final boolean confirmRestart(@NlsContexts.DialogMessage String message) {
        String string = ConfigurationStoreBundle.message("import.settings.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return MessageUtil.showOkCancelDialog$default((String)string, (String)message, (String)this.getRestartActionName(), null, (Icon)Messages.getQuestionIcon(), null, null, (int)104, null) == 0;
    }

    @NlsContexts.Button
    private final String getRestartActionName() {
        String string;
        if (ApplicationManager.getApplication().isRestartCapable()) {
            String string2 = ConfigurationStoreBundle.message("import.settings.confirmation.button.restart", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = ConfigurationStoreBundle.message("import.default.settings.confirmation.button.shutdown", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private final void doImportFromDirectory(Path saveFile) {
        Object[] objectArray = new Object[1];
        Path path = PathManager.getOriginalConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getOriginalConfigDir(...)");
        objectArray[0] = ConfigBackup.Companion.getNextBackupPath$default((ConfigBackup.Companion)ConfigBackup.Companion, (Path)path, null, (int)2, null);
        String string = ConfigurationStoreBundle.message("restore.default.settings.confirmation.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String confirmationMessage = string;
        if (this.confirmRestart(confirmationMessage)) {
            CustomConfigMigrationOption.writeConfigMarkerFile$default((CustomConfigMigrationOption)((CustomConfigMigrationOption)new CustomConfigMigrationOption.MigrateFromCustomPlace(saveFile)), null, (int)1, null);
            this.restart();
        }
    }

    private final Set<String> getRelativeNamesToExtract(Set<ExportableItem> chosenComponents) {
        HashSet<String> result = new HashSet<String>();
        for (ExportableItem item : chosenComponents) {
            result.add(item.fileSpec.relativePath);
        }
        result.add("installed.txt");
        return result;
    }

    private static final Unit actionPerformed$lambda$1(ImportSettingsAction this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path saveFile = Paths.get(it.getPath(), new String[0]);
        try {
            Intrinsics.checkNotNull((Object)saveFile);
            this$0.doImport(saveFile);
        }
        catch (ZipException e1) {
            Object[] objectArray = new Object[]{saveFile, e1.getMessage()};
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.reading.settings.file", objectArray), (String)ConfigurationStoreBundle.message("title.invalid.file", new Object[0]));
        }
        catch (IOException e1) {
            Object[] objectArray = new Object[]{saveFile, e1.getMessage()};
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.reading.settings.file.2", objectArray), (String)IdeBundle.message((String)"title.error.reading.file", (Object[])new Object[0]));
        }
        return Unit.INSTANCE;
    }

    private static final Unit restart$lambda$0() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        ((ApplicationEx)application).restart(true);
        return Unit.INSTANCE;
    }
}

