/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DotIdeaProjectStoreDescriptor;
import com.intellij.configurationStore.IprProjectStoreDescriptor;
import com.intellij.configurationStore.NestedProjectStorePathManagerKt;
import com.intellij.configurationStore.ProjectStoreDescriptor;
import com.intellij.configurationStore.ProjectStorePathCustomizer;
import com.intellij.configurationStore.ProjectStorePathManager;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/configurationStore/NestedProjectStorePathManager;", "Lcom/intellij/configurationStore/ProjectStorePathManager;", "<init>", "()V", "getStoreDescriptor", "Lcom/intellij/configurationStore/ProjectStoreDescriptor;", "projectRoot", "Ljava/nio/file/Path;", "getStoreDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.configurationStore.impl"})
final class NestedProjectStorePathManager
implements ProjectStorePathManager {
    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public ProjectStoreDescriptor getStoreDescriptor(@NotNull Path projectRoot) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        suitableDescriptors = new ArrayList<ProjectStoreDescriptor>();
        for (LazyExtension descriptor : NestedProjectStorePathManagerKt.access$getEP_NAME$p().filterableLazySequence()) {
            Intrinsics.checkNotNullExpressionValue((Object)descriptor.getPluginDescriptor().getPluginId(), (String)"getPluginId(...)");
            if (!descriptor.getPluginDescriptor().isBundled() && !Intrinsics.areEqual((Object)pluginId.getIdString(), (Object)"org.jetbrains.bazel")) {
                ComponentStoreImplKt.LOG.warn((Throwable)new PluginException("ProjectStorePathCustomizer from '" + descriptor.getPluginDescriptor() + "' is not allowed (not in a whitelist)", pluginId));
                continue;
            }
            v0 = (ProjectStorePathCustomizer)descriptor.getInstance();
            descriptor /* !! */  = v0 != null ? v0.getStoreDirectoryPath(projectRoot) : null;
            if (descriptor /* !! */  == null) continue;
            suitableDescriptors.add(descriptor /* !! */ );
        }
        if (((Collection)suitableDescriptors).isEmpty() == false) {
            if (!(suitableDescriptors.size() == 1)) {
                $i$a$-require-NestedProjectStorePathManager$getStoreDescriptor$1 = false;
                var4_7 = "More than one suitable ProjectStorePathCustomizer found: " + CollectionsKt.joinToString$default((Iterable)suitableDescriptors, null, null, null, (int)0, null, null, (int)63, null) + ". We cannot determine which one is suitable for " + projectRoot;
                throw new IllegalArgumentException(var4_7.toString());
            }
            return (ProjectStoreDescriptor)CollectionsKt.single((List)suitableDescriptors);
        }
        if (StringsKt.endsWith$default((String)projectRoot.toString(), (String)".ipr", (boolean)false, (int)2, null)) {
            v1 = projectRoot.getParent();
            if (v1 == null) {
                v2 = projectRoot.getFileSystem().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"getRootDirectories(...)");
                v1 = (Path)CollectionsKt.first(v2);
            }
            userBaseDir = v1;
            Intrinsics.checkNotNull((Object)userBaseDir);
            return new IprProjectStoreDescriptor(userBaseDir, projectRoot);
        }
        if (!Boolean.parseBoolean(System.getProperty("store.basedir.parent.detection", "true"))) ** GOTO lbl-1000
        v3 = projectRoot.getFileName();
        v4 = v3 != null && (v3 = v3.toString()) != null ? StringsKt.startsWith$default((String)v3, (String)".idea.", (boolean)false, (int)2, null) : false;
        if (v4) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = false;
        }
        useParent = v5;
        var4_5 = useParent != false ? projectRoot.getParent().getParent() : projectRoot;
        Intrinsics.checkNotNull((Object)var4_5);
        return new DotIdeaProjectStoreDescriptor(projectRoot, var4_5);
    }

    @Nullable
    public VirtualFile getStoreDirectory(@NotNull VirtualFile projectRoot) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        return projectRoot.isDirectory() ? projectRoot.findChild(".idea") : null;
    }
}

