/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FakeDirectoryBasedStateSplitter;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.ProjectStorePathCustomizer;
import com.intellij.configurationStore.StateAnnotation;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectNameProvider;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0001\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/configurationStore/ProjectStorePathCustomizer;", "DEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION", "Lcom/intellij/configurationStore/FileStorageAnnotation;", "doGetJpsBridgeAwareStorageSpec", "Lcom/intellij/openapi/components/Storage;", "filePath", "", "project", "Lcom/intellij/openapi/project/Project;", "getNameFileForDotIdeaProject", "Ljava/nio/file/Path;", "dotIdea", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nNestedProjectStorePathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestedProjectStorePathManager.kt\ncom/intellij/configurationStore/NestedProjectStorePathManagerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1#2:280\n*E\n"})
public final class NestedProjectStorePathManagerKt {
    @NotNull
    private static final ExtensionPointName<ProjectStorePathCustomizer> EP_NAME = new ExtensionPointName("com.intellij.projectStorePathCustomizer");
    @NotNull
    private static final FileStorageAnnotation DEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION = new FileStorageAnnotation("$PROJECT_FILE$", true);

    @NotNull
    public static final Storage doGetJpsBridgeAwareStorageSpec(@NotNull String filePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String collapsedPath = null;
        Class<StateSplitterEx> splitterClass = null;
        String string = PathUtilRt.getFileName((String)filePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String fileName = string;
        String string2 = PathUtilRt.getParentPath((String)filePath);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParentPath(...)");
        String parentPath = string2;
        String string3 = PathUtilRt.getFileName((String)parentPath);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFileName(...)");
        String parentFileName = string3;
        if (StringsKt.endsWith$default((String)filePath, (String)".ipr", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)fileName, (Object)"misc.xml") && Intrinsics.areEqual((Object)parentFileName, (Object)".idea")) {
            collapsedPath = "$PROJECT_FILE$";
            splitterClass = StateSplitterEx.class;
        } else if (Intrinsics.areEqual((Object)parentFileName, (Object)".idea")) {
            collapsedPath = fileName;
            splitterClass = StateSplitterEx.class;
        } else {
            String string4 = PathUtilRt.getParentPath((String)parentPath);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getParentPath(...)");
            String grandParentPath = string4;
            collapsedPath = parentFileName;
            splitterClass = FakeDirectoryBasedStateSplitter.class;
            if (!Intrinsics.areEqual((Object)PathUtil.getFileName((String)grandParentPath), (Object)".idea")) {
                if (Intrinsics.areEqual((Object)parentFileName, (Object)"project")) {
                    Storage storage;
                    if (Intrinsics.areEqual((Object)fileName, (Object)"libraries.xml") || Intrinsics.areEqual((Object)fileName, (Object)"artifacts.xml")) {
                        FileStorageAnnotation inProjectStorage = new FileStorageAnnotation(FileUtilRt.getNameWithoutExtension((String)fileName), false, splitterClass);
                        String componentName = Intrinsics.areEqual((Object)fileName, (Object)"libraries.xml") ? "libraryTable" : "ArtifactManager";
                        Storage storage2 = (Storage)StreamProviderFactory.EP_NAME.computeSafeIfAny((AreaInstance)project, arg_0 -> NestedProjectStorePathManagerKt.doGetJpsBridgeAwareStorageSpec$lambda$0(fileName, componentName, inProjectStorage, arg_0));
                        if (storage2 != null) {
                            Storage it = storage2;
                            boolean bl = false;
                            return it;
                        }
                    }
                    if (Intrinsics.areEqual((Object)fileName, (Object)"modules.xml") && (storage = (Storage)StreamProviderFactory.EP_NAME.computeSafeIfAny((AreaInstance)project, arg_0 -> NestedProjectStorePathManagerKt.doGetJpsBridgeAwareStorageSpec$lambda$2(fileName, arg_0))) != null) {
                        Storage it = storage;
                        boolean bl = false;
                        return it;
                    }
                }
                if (StreamProviderFactory.EP_NAME.hasAnyExtensions((AreaInstance)project)) {
                    throw new IllegalStateException((filePath + " is not under .idea directory and not under external system cache").toString());
                }
            }
        }
        return (Storage)new FileStorageAnnotation(collapsedPath, false, splitterClass);
    }

    @VisibleForTesting
    @NotNull
    public static final Path getNameFileForDotIdeaProject(@NotNull Project project, @NotNull Path dotIdea) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dotIdea, (String)"dotIdea");
        for (ProjectNameProvider projectNameProvider : ProjectNameProvider.EP_NAME.lazySequence()) {
            Path path;
            Object object;
            try {
                boolean bl = false;
                object = Result.constructor-impl((Object)projectNameProvider.getNameFile(project));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if ((path = (Path)LoggerKt.getOrLogException((Object)object, (Logger)ComponentStoreImplKt.LOG)) == null) continue;
            Path it = path;
            boolean bl = false;
            return it;
        }
        Path path = dotIdea.resolve(".name");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final Storage doGetJpsBridgeAwareStorageSpec$lambda$0(String $fileName, String $componentName, FileStorageAnnotation $inProjectStorage, StreamProviderFactory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getOrCreateStorageSpec($fileName, (State)new StateAnnotation($componentName, (Storage)$inProjectStorage));
    }

    private static final Storage doGetJpsBridgeAwareStorageSpec$lambda$2(String $fileName, StreamProviderFactory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StreamProviderFactory.getOrCreateStorageSpec$default((StreamProviderFactory)it, (String)$fileName, null, (int)2, null);
    }

    public static final /* synthetic */ ExtensionPointName access$getEP_NAME$p() {
        return EP_NAME;
    }

    public static final /* synthetic */ FileStorageAnnotation access$getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION$p() {
        return DEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION;
    }
}

