/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ApplicationStoreImplKt;
import com.intellij.configurationStore.Macro;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.platform.settings.SettingsController;
import com.intellij.serviceContainer.ComponentManagerImpl;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0014J\u001a\u0010\u000f\u001a\u00020\u00102\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J*\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0014J \u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/intellij/configurationStore/ProjectStateStorageManager;", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "isExternalStorageSupported", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "customMacros", "", "", "Ljava/nio/file/Path;", "normalizeFileSpec", "fileSpec", "setCustomMacros", "", "expandMacro", "collapsedPath", "beforeElementSaved", "elements", "", "Lorg/jdom/Element;", "rootAttributes", "", "getOldStorageSpec", "component", "", "componentName", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "isExternalSystemStorageEnabled", "()Z", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nProjectStoreImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStoreImpl.kt\ncom/intellij/configurationStore/ProjectStateStorageManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,329:1\n30#2,2:330\n*S KotlinDebug\n*F\n+ 1 ProjectStoreImpl.kt\ncom/intellij/configurationStore/ProjectStateStorageManager\n*L\n287#1:330,2\n*E\n"})
final class ProjectStateStorageManager
extends StateStorageManagerImpl {
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<Boolean> isExternalStorageSupported;
    @NotNull
    private Map<String, ? extends Path> customMacros;

    public ProjectStateStorageManager(@NotNull Project project, @NotNull Function0<Boolean> isExternalStorageSupported) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(isExternalStorageSupported, (String)"isExternalStorageSupported");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<PathMacroManager> serviceClass$iv = PathMacroManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        SettingsController settingsController = (SettingsController)ApplicationManager.getApplication().getService(SettingsController.class);
        super("project", new TrackingPathMacroSubstitutorImpl((PathMacroManager)object), (ComponentManager)project, settingsController != null ? settingsController.createChild((ComponentManager)project) : null);
        this.project = project;
        this.isExternalStorageSupported = isExternalStorageSupported;
        this.customMacros = MapsKt.emptyMap();
    }

    @Override
    @NotNull
    protected String normalizeFileSpec(@NotNull String fileSpec) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        return ApplicationStoreImplKt.removeMacroIfStartsWith(super.normalizeFileSpec(fileSpec), "$PROJECT_CONFIG_DIR$");
    }

    public final void setCustomMacros(@NotNull Map<String, ? extends Path> customMacros) {
        Intrinsics.checkNotNullParameter(customMacros, (String)"customMacros");
        this.customMacros = customMacros;
    }

    @Override
    @NotNull
    public Path expandMacro(@NotNull String collapsedPath) {
        Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
        if (collapsedPath.charAt(0) == '$') {
            return super.expandMacro(collapsedPath);
        }
        Path path = this.customMacros.get(collapsedPath);
        if (path != null) {
            Path it = path;
            boolean bl = false;
            return it;
        }
        Path path2 = ((Macro)this.macros.get((int)0)).value.resolve(collapsedPath);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @Override
    protected void beforeElementSaved(@NotNull List<Element> elements, @NotNull Map<String, String> rootAttributes) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(rootAttributes, (String)"rootAttributes");
        rootAttributes.put("version", "4");
    }

    @Override
    @NotNull
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return ComponentManagerImpl.badWorkspaceComponents.contains(componentName) ? "$WORKSPACE_FILE$" : "$PROJECT_FILE$";
    }

    public boolean isExternalSystemStorageEnabled() {
        return (Boolean)this.isExternalStorageSupported.invoke() != false && ProjectUtilCore.isExternalStorageEnabled((Project)this.project);
    }
}

