/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.SaveResult;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.SaveSessionProducerManagerKt;
import com.intellij.openapi.components.StateStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u0006J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u00a2\u0006\u0002\b\u0011J\u001e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0017RN\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/configurationStore/SaveSessionProducerManager;", "", "<init>", "()V", "producers", "", "Lcom/intellij/openapi/components/StateStorage;", "kotlin.jvm.PlatformType", "Lcom/intellij/configurationStore/SaveSessionProducer;", "", "getProducer", "storage", "collectSaveSessions", "", "result", "", "Lcom/intellij/configurationStore/SaveSession;", "collectSaveSessions$intellij_platform_configurationStore_impl", "save", "saveResult", "Lcom/intellij/configurationStore/SaveResult;", "collectVfsEvents", "", "(Lcom/intellij/configurationStore/SaveResult;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.configurationStore.impl"})
public class SaveSessionProducerManager {
    private final Map<StateStorage, SaveSessionProducer> producers = Collections.synchronizedMap(new LinkedHashMap());

    @Nullable
    public final SaveSessionProducer getProducer(@NotNull StateStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        SaveSessionProducer producer = this.producers.get(storage);
        if (producer == null) {
            SaveSessionProducer saveSessionProducer = storage.createSaveSessionProducer();
            if (saveSessionProducer == null) {
                return null;
            }
            producer = saveSessionProducer;
            SaveSessionProducer prev = this.producers.put(storage, producer);
            if (!(prev == null)) {
                throw new IllegalStateException("Check failed.");
            }
        }
        return producer;
    }

    public final void collectSaveSessions$intellij_platform_configurationStore_impl(@NotNull Collection<SaveSession> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        for (SaveSessionProducer session : this.producers.values()) {
            SaveSession saveSession = session.createSaveSession();
            if (saveSession == null) continue;
            result.add(saveSession);
        }
    }

    @Nullable
    public final Object save(@NotNull SaveResult saveResult, boolean collectVfsEvents, @NotNull Continuation<? super Unit> $completion) {
        Map<StateStorage, SaveSessionProducer> map2 = this.producers;
        Intrinsics.checkNotNullExpressionValue(map2, (String)"producers");
        if (!map2.isEmpty()) {
            ArrayList saveSessions2 = new ArrayList();
            this.collectSaveSessions$intellij_platform_configurationStore_impl(saveSessions2);
            if (!((Collection)saveSessions2).isEmpty()) {
                Object object = SaveSessionProducerManagerKt.saveSessions(saveSessions2, saveResult, collectVfsEvents, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }
}

