/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.ComponentInfoKt;
import com.intellij.configurationStore.CompoundStreamProvider;
import com.intellij.configurationStore.DataStateChanged;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.Macro;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StorageCreator;
import com.intellij.configurationStore.StorageVirtualFileTracker;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.TrackedDirectoryStorage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.platform.settings.SettingsController;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001qB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\"2\u000e\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0(H\u0016J!\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u00a2\u0006\u0002\b/J\u000e\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0014Ju\u00105\u001a\u00020\u00192\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u0002082\u0010\b\u0002\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190(2\u0010\b\u0002\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020;0(2\b\b\u0002\u0010<\u001a\u00020%2\u001b\b\u0002\u0010=\u001a\u0015\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\"\u0018\u00010>\u00a2\u0006\u0002\b?2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020%J2\u0010C\u001a\u00020\u00032\u000e\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190(2\u0006\u0010D\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\b\u0010@\u001a\u0004\u0018\u00010AH\u0002J\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00190FJR\u0010E\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0H\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0H0G2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00030H2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00030H2\u0016\b\u0002\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010>J\u0016\u0010M\u001a\u00020\"2\u0006\u0010N\u001a\u00020\u00032\u0006\u0010O\u001a\u00020PJ2\u0010E\u001a\b\u0012\u0004\u0012\u00020I0H2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00030H2\u0016\b\u0002\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010>JH\u0010R\u001a\u00020\u00192\u000e\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190(2\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u0002082\u000e\u0010:\u001a\n\u0012\u0006\b\u0001\u0012\u00020;0(2\u0006\u0010B\u001a\u00020%2\u0006\u0010<\u001a\u00020%H\u0002J2\u0010S\u001a\u00020\u00192\u0006\u0010T\u001a\u00020P2\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u0002082\u0006\u0010B\u001a\u00020%2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0014J*\u0010U\u001a\u00020\"2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020X0W2\u0012\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030ZH\u0014J\"\u0010[\u001a\u00020\"2\u0006\u0010\\\u001a\u00020I2\b\u0010]\u001a\u0004\u0018\u00010^2\u0006\u0010_\u001a\u00020`H\u0014J\u0010\u0010a\u001a\u00020\"2\u0006\u0010b\u001a\u00020XH\u0014J\u0006\u0010c\u001a\u00020\"J\u0015\u0010d\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\beJ\u0010\u0010f\u001a\u00020P2\u0006\u00106\u001a\u00020\u0003H\u0016J\u000e\u0010g\u001a\u00020\u00032\u0006\u0010h\u001a\u00020\u0003J \u0010i\u001a\u0004\u0018\u00010\u00192\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u00032\u0006\u0010m\u001a\u00020nJ\"\u0010o\u001a\u0004\u0018\u00010\u00032\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u00032\u0006\u0010m\u001a\u00020nH\u0014J\u0006\u0010p\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00168\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020%8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006r"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl;", "Lcom/intellij/configurationStore/StateStorageManager;", "rootTagName", "", "macroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "controller", "Lcom/intellij/platform/settings/SettingsController;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/openapi/components/ComponentManager;Lcom/intellij/platform/settings/SettingsController;)V", "getMacroSubstitutor", "()Lcom/intellij/openapi/components/PathMacroSubstitutor;", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "virtualFileTracker", "Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "macros", "", "Lcom/intellij/configurationStore/Macro;", "storageLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "storages", "Ljava/util/HashMap;", "Lcom/intellij/openapi/components/StateStorage;", "Lkotlin/collections/HashMap;", "streamProvider", "Lcom/intellij/configurationStore/StreamProvider;", "getStreamProvider", "()Lcom/intellij/configurationStore/StreamProvider;", "compoundStreamProvider", "Lcom/intellij/configurationStore/CompoundStreamProvider;", "addStreamProvider", "", "provider", "first", "", "removeStreamProvider", "aClass", "Ljava/lang/Class;", "isUseVfsListener", "Lcom/intellij/util/ThreeState;", "isUseXmlProlog", "()Z", "setMacros", "list", "setMacros$intellij_platform_configurationStore_impl", "getStateStorage", "storageSpec", "Lcom/intellij/openapi/components/Storage;", "normalizeFileSpec", "fileSpec", "getOrCreateStorage", "collapsedPath", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "storageClass", "stateSplitter", "Lcom/intellij/openapi/components/StateSplitter;", "exclusive", "storageCustomizer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "storageCreator", "Lcom/intellij/configurationStore/StorageCreator;", "usePathMacroManager", "computeStorageKey", "normalizedCollapsedPath", "getCachedFileStorages", "", "Lkotlin/Pair;", "", "Lcom/intellij/configurationStore/FileBasedStorage;", "changed", "deleted", "pathNormalizer", "updatePath", "spec", "newPath", "Ljava/nio/file/Path;", "fileSpecs", "createStateStorage", "createFileBasedStorage", "file", "beforeElementSaved", "elements", "", "Lorg/jdom/Element;", "rootAttributes", "", "providerDataStateChanged", "storage", "writer", "Lcom/intellij/configurationStore/DataWriter;", "type", "Lcom/intellij/configurationStore/DataStateChanged;", "beforeElementLoaded", "element", "clearStorages", "clearVirtualFileTracker", "clearVirtualFileTracker$intellij_platform_configurationStore_impl", "expandMacro", "collapseMacro", "path", "getOldStorage", "component", "", "componentName", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getOldStorageSpec", "release", "TrackedFileStorage", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStateStorageManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateStorageManagerImpl.kt\ncom/intellij/configurationStore/StateStorageManagerImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,395:1\n42#2,3:396\n1#3:399\n382#4,7:400\n1227#5,2:407\n*S KotlinDebug\n*F\n+ 1 StateStorageManagerImpl.kt\ncom/intellij/configurationStore/StateStorageManagerImpl\n*L\n35#1:396,3\n115#1:400,7\n202#1:407,2\n*E\n"})
public class StateStorageManagerImpl
implements StateStorageManager {
    @NotNull
    private final String rootTagName;
    @Nullable
    private final PathMacroSubstitutor macroSubstitutor;
    @Nullable
    private final ComponentManager componentManager;
    @Nullable
    private final SettingsController controller;
    @Nullable
    private final StorageVirtualFileTracker virtualFileTracker;
    @JvmField
    @NotNull
    public volatile List<Macro> macros;
    @JvmField
    @NotNull
    protected final ReentrantReadWriteLock storageLock;
    @NotNull
    private final HashMap<String, StateStorage> storages;
    @NotNull
    private final CompoundStreamProvider compoundStreamProvider;
    @NotNull
    private ThreeState isUseVfsListener;

    public StateStorageManagerImpl(@NotNull String rootTagName, @Nullable PathMacroSubstitutor macroSubstitutor, @Nullable ComponentManager componentManager, @Nullable SettingsController controller) {
        StorageVirtualFileTracker storageVirtualFileTracker;
        Intrinsics.checkNotNullParameter((Object)rootTagName, (String)"rootTagName");
        this.rootTagName = rootTagName;
        this.macroSubstitutor = macroSubstitutor;
        this.componentManager = componentManager;
        this.controller = controller;
        if (this.componentManager == null) {
            storageVirtualFileTracker = null;
        } else {
            boolean $i$f$service = false;
            Class<StorageVirtualFileTracker> serviceClass$iv = StorageVirtualFileTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            storageVirtualFileTracker = (StorageVirtualFileTracker)object;
        }
        this.virtualFileTracker = storageVirtualFileTracker;
        List list = List.of();
        Intrinsics.checkNotNullExpressionValue(list, (String)"of(...)");
        this.macros = list;
        this.storageLock = new ReentrantReadWriteLock();
        this.storages = new HashMap();
        this.compoundStreamProvider = new CompoundStreamProvider();
        this.isUseVfsListener = this.componentManager == null ? ThreeState.NO : ThreeState.UNSURE;
    }

    public /* synthetic */ StateStorageManagerImpl(String string, PathMacroSubstitutor pathMacroSubstitutor, ComponentManager componentManager, SettingsController settingsController, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pathMacroSubstitutor = null;
        }
        this(string, pathMacroSubstitutor, componentManager, settingsController);
    }

    @Nullable
    public final PathMacroSubstitutor getMacroSubstitutor() {
        return this.macroSubstitutor;
    }

    @Nullable
    public final ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @NotNull
    public StreamProvider getStreamProvider() {
        return this.compoundStreamProvider;
    }

    public void addStreamProvider(@NotNull StreamProvider provider, boolean first) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.compoundStreamProvider.addStreamProvider(provider, first);
    }

    public void removeStreamProvider(@NotNull Class<? extends StreamProvider> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        this.compoundStreamProvider.removeStreamProvider(aClass);
    }

    protected boolean isUseXmlProlog() {
        return true;
    }

    @NotNull
    public final List<Macro> setMacros$intellij_platform_configurationStore_impl(@NotNull List<Macro> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        List<Macro> oldValue = this.macros;
        this.macros = list;
        return oldValue;
    }

    @NotNull
    public final StateStorage getStateStorage(@NotNull Storage storageSpec) {
        Intrinsics.checkNotNullParameter((Object)storageSpec, (String)"storageSpec");
        return StateStorageManagerImpl.getOrCreateStorage$default(this, ComponentInfoKt.getPath(storageSpec), storageSpec.roamingType(), storageSpec.storageClass(), storageSpec.stateSplitter(), storageSpec.exclusive(), null, storageSpec instanceof StorageCreator ? (StorageCreator)storageSpec : null, storageSpec.usePathMacroManager(), 32, null);
    }

    @NotNull
    protected String normalizeFileSpec(@NotNull String fileSpec) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        String string = FileUtilRt.toSystemIndependentName((String)fileSpec);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String path = string;
        return StringsKt.endsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) ? StringsKt.dropLast((String)path, (int)1) : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final StateStorage getOrCreateStorage(@NotNull String collapsedPath, @NotNull RoamingType roamingType, @NotNull Class<? extends StateStorage> storageClass, @NotNull Class<? extends StateSplitter> stateSplitter, boolean exclusive, @Nullable Function1<? super StateStorage, Unit> storageCustomizer, @Nullable StorageCreator storageCreator, boolean usePathMacroManager) {
        StateStorage storage;
        block14: {
            StateStorage stateStorage;
            Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            Intrinsics.checkNotNullParameter(storageClass, (String)"storageClass");
            Intrinsics.checkNotNullParameter(stateSplitter, (String)"stateSplitter");
            String normalizedCollapsedPath = this.normalizeFileSpec(collapsedPath);
            String key = this.computeStorageKey(storageClass, normalizedCollapsedPath, collapsedPath, storageCreator);
            ReentrantReadWriteLock.ReadLock readLock = this.storageLock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                StateStorage stateStorage2 = this.storages.get(key);
                stateStorage = stateStorage2;
            }
            finally {
                readLock.unlock();
            }
            if (stateStorage == null) {
                StateStorage stateStorage3;
                ReentrantReadWriteLock reentrantReadWriteLock = this.storageLock;
                readLock = reentrantReadWriteLock.readLock();
                int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    Object object;
                    void $this$getOrPut$iv;
                    boolean bl = false;
                    Map map2 = this.storages;
                    String key$iv = key;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        StateStorage storage2 = storageCreator == null ? this.createStateStorage(storageClass, normalizedCollapsedPath, roamingType, stateSplitter, usePathMacroManager, exclusive) : storageCreator.create((StateStorageManager)this);
                        Function1<? super StateStorage, Unit> function1 = storageCustomizer;
                        if (function1 != null) {
                            function1.invoke((Object)storage2);
                        }
                        StateStorage answer$iv = storage2;
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    stateStorage3 = (StateStorage)object;
                }
                finally {
                    for (int i = 0; i < n; ++i) {
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
                return stateStorage3;
            }
            storage = stateStorage;
            Function1<? super StateStorage, Unit> function1 = storageCustomizer;
            if (function1 == null) break block14;
            function1.invoke((Object)storage);
        }
        return storage;
    }

    public static /* synthetic */ StateStorage getOrCreateStorage$default(StateStorageManagerImpl stateStorageManagerImpl, String string, RoamingType roamingType, Class clazz, Class clazz2, boolean bl, Function1 function1, StorageCreator storageCreator, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getOrCreateStorage");
        }
        if ((n & 4) != 0) {
            clazz = StateStorage.class;
        }
        if ((n & 8) != 0) {
            clazz2 = StateSplitterEx.class;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        if ((n & 0x40) != 0) {
            storageCreator = null;
        }
        return stateStorageManagerImpl.getOrCreateStorage(string, roamingType, clazz, clazz2, bl, (Function1<? super StateStorage, Unit>)function1, storageCreator, bl2);
    }

    private final String computeStorageKey(Class<? extends StateStorage> storageClass, String normalizedCollapsedPath, String collapsedPath, StorageCreator storageCreator) {
        if (!Intrinsics.areEqual(storageClass, StateStorage.class)) {
            String string = storageClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        if (!(!(((CharSequence)normalizedCollapsedPath).length() == 0))) {
            boolean bl = false;
            String string = "Normalized path is empty, raw path '" + collapsedPath + "'";
            throw new IllegalStateException(string.toString());
        }
        Object object = storageCreator;
        if (object == null || (object = object.getKey()) == null) {
            object = normalizedCollapsedPath;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<StateStorage> getCachedFileStorages() {
        Set set;
        ReentrantReadWriteLock.ReadLock readLock = this.storageLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            Collection<StateStorage> collection = this.storages.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            set = CollectionsKt.toSet((Iterable)collection);
        }
        finally {
            readLock.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<Collection<FileBasedStorage>, Collection<FileBasedStorage>> getCachedFileStorages(@NotNull Collection<String> changed, @NotNull Collection<String> deleted, @Nullable Function1<? super String, String> pathNormalizer) {
        Pair pair;
        Intrinsics.checkNotNullParameter(changed, (String)"changed");
        Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
        ReentrantReadWriteLock.ReadLock readLock = this.storageLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            pair = new Pair(this.getCachedFileStorages(changed, pathNormalizer), this.getCachedFileStorages(deleted, pathNormalizer));
        }
        finally {
            readLock.unlock();
        }
        return pair;
    }

    public static /* synthetic */ Pair getCachedFileStorages$default(StateStorageManagerImpl stateStorageManagerImpl, Collection collection, Collection collection2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCachedFileStorages");
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return stateStorageManagerImpl.getCachedFileStorages(collection, collection2, (Function1<? super String, String>)function1);
    }

    public final void updatePath(@NotNull String spec, @NotNull Path newPath) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        FileBasedStorage fileBasedStorage = (FileBasedStorage)CollectionsKt.firstOrNull((Iterable)StateStorageManagerImpl.getCachedFileStorages$default(this, CollectionsKt.listOf((Object)spec), null, 2, null));
        if (fileBasedStorage == null) {
            return;
        }
        FileBasedStorage storage = fileBasedStorage;
        if (storage instanceof StorageVirtualFileTracker.TrackedStorage && this.virtualFileTracker != null) {
            this.virtualFileTracker.remove(PathsKt.getInvariantSeparatorsPathString((Path)storage.getFile()));
            this.virtualFileTracker.put(PathsKt.getInvariantSeparatorsPathString((Path)newPath), (StorageVirtualFileTracker.TrackedStorage)((Object)storage));
        }
        storage.setFile(null, newPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<FileBasedStorage> getCachedFileStorages(@NotNull Collection<String> fileSpecs, @Nullable Function1<? super String, String> pathNormalizer) {
        Intrinsics.checkNotNullParameter(fileSpecs, (String)"fileSpecs");
        if (fileSpecs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ReentrantReadWriteLock.ReadLock readLock = this.storageLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            List result = null;
            for (String fileSpec : fileSpecs) {
                String path;
                StateStorage storage;
                Object object = pathNormalizer;
                if (object == null || (object = (String)object.invoke((Object)fileSpec)) == null) {
                    object = fileSpec;
                }
                if (!((storage = this.storages.get(path = this.normalizeFileSpec((String)object))) instanceof FileBasedStorage)) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                result.add(storage);
            }
            List list = result;
            Collection collection = list != null ? (Collection)list : (Collection)CollectionsKt.emptyList();
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    public static /* synthetic */ Collection getCachedFileStorages$default(StateStorageManagerImpl stateStorageManagerImpl, Collection collection, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCachedFileStorages");
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        return stateStorageManagerImpl.getCachedFileStorages(collection, (Function1<? super String, String>)function1);
    }

    private final StateStorage createStateStorage(Class<? extends StateStorage> storageClass, String collapsedPath, RoamingType roamingType, Class<? extends StateSplitter> stateSplitter, boolean usePathMacroManager, boolean exclusive) {
        if (!Intrinsics.areEqual(storageClass, StateStorage.class)) {
            Object element$iv2;
            block9: {
                Constructor<?>[] constructorArray = storageClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getConstructors(...)");
                Object[] $this$first$iv = constructorArray;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Constructor it = (Constructor)element$iv2;
                    boolean bl = false;
                    if (!(it.getParameterCount() <= 3)) {
                        continue;
                    }
                    break block9;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Constructor constructor = (Constructor)element$iv2;
            constructor.setAccessible(true);
            if (constructor.getParameterCount() == 2) {
                Object[] $i$f$first = new Object[2];
                Intrinsics.checkNotNull((Object)this.componentManager);
                $i$f$first[1] = this;
                Object t = constructor.newInstance($i$f$first);
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.intellij.openapi.components.StateStorage");
                return (StateStorage)t;
            }
            Object[] $i$f$first = new Object[3];
            $i$f$first[0] = collapsedPath;
            Intrinsics.checkNotNull((Object)this.componentManager);
            $i$f$first[2] = this;
            Object t = constructor.newInstance($i$f$first);
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type com.intellij.openapi.components.StateStorage");
            return (StateStorage)t;
        }
        RoamingType effectiveRoamingType = ComponentInfoKt.getEffectiveRoamingType(roamingType, collapsedPath);
        if (this.isUseVfsListener == ThreeState.UNSURE) {
            this.isUseVfsListener = ThreeState.Companion.fromBoolean(!this.compoundStreamProvider.isApplicable(collapsedPath, effectiveRoamingType));
        }
        Path filePath = this.expandMacro(collapsedPath);
        if (!Intrinsics.areEqual(stateSplitter, StateSplitter.class) && !Intrinsics.areEqual(stateSplitter, StateSplitterEx.class)) {
            Object object = ReflectionUtil.newInstance(stateSplitter);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(...)");
            TrackedDirectoryStorage storage = new TrackedDirectoryStorage(this, filePath, (StateSplitter)object, this.macroSubstitutor, this.controller);
            StorageVirtualFileTracker storageVirtualFileTracker = this.virtualFileTracker;
            if (storageVirtualFileTracker != null) {
                storageVirtualFileTracker.put(PathsKt.getInvariantSeparatorsPathString((Path)filePath), storage);
            }
            return storage;
        }
        Application app = ApplicationManager.getApplication();
        if (!(app == null || app.isHeadlessEnvironment() || StringsKt.endsWith$default((CharSequence)collapsedPath, (char)'$', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)collapsedPath, (char)'.', (boolean)false, (int)2, null))) {
            throw new IllegalArgumentException("Extension is missing for storage file: " + collapsedPath);
        }
        StateStorage storage = this.createFileBasedStorage(filePath, collapsedPath, effectiveRoamingType, usePathMacroManager, exclusive ? null : this.rootTagName);
        if (this.isUseVfsListener == ThreeState.YES && storage instanceof StorageVirtualFileTracker.TrackedStorage && this.virtualFileTracker != null) {
            this.virtualFileTracker.put(PathsKt.getInvariantSeparatorsPathString((Path)filePath), (StorageVirtualFileTracker.TrackedStorage)storage);
        }
        return storage;
    }

    @NotNull
    protected StateStorage createFileBasedStorage(@NotNull Path file, @NotNull String collapsedPath, @NotNull RoamingType roamingType, boolean usePathMacroManager, @Nullable String rootTagName) {
        Object object;
        SettingsController it2;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        this.compoundStreamProvider.deleteIfObsolete(collapsedPath, roamingType);
        if (roamingType == RoamingType.DISABLED && this.controller != null && (object2 = this.controller.createStateStorage(collapsedPath, file)) != null) {
            Object it2 = object2;
            boolean bl = false;
            return (StateStorage)it2;
        }
        SettingsController settingsController = this.controller;
        if (settingsController != null) {
            SettingsController it3 = it2 = settingsController;
            boolean bl = false;
            object = it3.isPersistenceStateComponentProxy() ? it2 : null;
        } else {
            object = null;
        }
        SettingsController controller = object;
        PathMacroSubstitutor pathMacroSubstitutor = this.macroSubstitutor;
        it2 = pathMacroSubstitutor;
        RoamingType roamingType2 = roamingType;
        String string = rootTagName;
        String string2 = collapsedPath;
        Path path = file;
        StateStorageManagerImpl stateStorageManagerImpl = this;
        boolean bl = false;
        boolean bl2 = usePathMacroManager;
        SettingsController settingsController2 = controller;
        StreamProvider streamProvider = this.compoundStreamProvider;
        PathMacroSubstitutor pathMacroSubstitutor2 = bl2 ? pathMacroSubstitutor : null;
        RoamingType roamingType3 = roamingType2;
        String string3 = string;
        String string4 = string2;
        Path path2 = path;
        StateStorageManagerImpl stateStorageManagerImpl2 = stateStorageManagerImpl;
        return new TrackedFileStorage(stateStorageManagerImpl2, path2, string4, string3, roamingType3, pathMacroSubstitutor2, streamProvider, settingsController2);
    }

    protected void beforeElementSaved(@NotNull List<Element> elements, @NotNull Map<String, String> rootAttributes) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(rootAttributes, (String)"rootAttributes");
    }

    protected void providerDataStateChanged(@NotNull FileBasedStorage storage, @Nullable DataWriter writer, @NotNull DataStateChanged type) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    protected void beforeElementLoaded(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearStorages() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            try {
                if (this.virtualFileTracker != null) {
                    this.clearVirtualFileTracker$intellij_platform_configurationStore_impl(this.virtualFileTracker);
                }
            }
            finally {
                this.storages.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public void clearVirtualFileTracker$intellij_platform_configurationStore_impl(@NotNull StorageVirtualFileTracker virtualFileTracker) {
        Intrinsics.checkNotNullParameter((Object)virtualFileTracker, (String)"virtualFileTracker");
        for (String collapsedPath : this.storages.keySet()) {
            virtualFileTracker.remove(PathsKt.getInvariantSeparatorsPathString((Path)this.expandMacro(collapsedPath)));
        }
    }

    @NotNull
    public Path expandMacro(@NotNull String collapsedPath) {
        Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
        for (Macro macro : this.macros) {
            String key = macro.component1();
            Path value = macro.component2();
            if (Intrinsics.areEqual((Object)key, (Object)collapsedPath)) {
                return value;
            }
            if (collapsedPath.length() <= key.length() + 2 || collapsedPath.charAt(key.length()) != '/' || !StringsKt.startsWith$default((String)collapsedPath, (String)key, (boolean)false, (int)2, null)) continue;
            String string = collapsedPath.substring(key.length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Path path = value.resolve(string);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }
        throw new IllegalStateException("Cannot resolve " + collapsedPath + " in " + this.macros);
    }

    @NotNull
    public final String collapseMacro(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        for (Macro macro : this.macros) {
            String key = macro.component1();
            Path value = macro.component2();
            String result = StringsKt.replace$default((String)path, (String)PathsKt.getInvariantSeparatorsPathString((Path)value), (String)key, (boolean)false, (int)4, null);
            if (result == path) continue;
            return result;
        }
        return this.normalizeFileSpec(path);
    }

    @Nullable
    public final StateStorage getOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        String string = this.getOldStorageSpec(component, componentName, operation);
        if (string == null) {
            return null;
        }
        String oldStorageSpec = string;
        return StateStorageManagerImpl.getOrCreateStorage$default(this, oldStorageSpec, RoamingType.DEFAULT, null, null, false, null, null, true, 124, null);
    }

    @Nullable
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return null;
    }

    public final void release() {
        block1: {
            StorageVirtualFileTracker storageVirtualFileTracker = this.virtualFileTracker;
            if (storageVirtualFileTracker != null) {
                storageVirtualFileTracker.remove((Function1<? super StorageVirtualFileTracker.TrackedStorage, Boolean>)((Function1)arg_0 -> StateStorageManagerImpl.release$lambda$0(this, arg_0)));
            }
            SettingsController settingsController = this.controller;
            if (settingsController == null) break block1;
            settingsController.release();
        }
    }

    private static final boolean release$lambda$0(StateStorageManagerImpl this$0, StorageVirtualFileTracker.TrackedStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getStorageManager() == this$0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J*\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0!H\u0014J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001fH\u0014J\u001a\u0010$\u001a\u00020\u001c2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(H\u0014J$\u0010)\u001a\u00020*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0019H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001a\u00a8\u00060"}, d2={"Lcom/intellij/configurationStore/StateStorageManagerImpl$TrackedFileStorage;", "Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "file", "Ljava/nio/file/Path;", "fileSpec", "", "rootElementName", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "controller", "Lcom/intellij/platform/settings/SettingsController;", "<init>", "(Lcom/intellij/configurationStore/StateStorageManagerImpl;Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/configurationStore/StreamProvider;Lcom/intellij/platform/settings/SettingsController;)V", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getController", "()Lcom/intellij/platform/settings/SettingsController;", "isUseXmlProlog", "", "()Z", "beforeElementSaved", "", "elements", "", "Lorg/jdom/Element;", "rootAttributes", "", "beforeElementLoaded", "element", "providerDataStateChanged", "writer", "Lcom/intellij/configurationStore/DataWriter;", "type", "Lcom/intellij/configurationStore/DataStateChanged;", "getResolution", "Lcom/intellij/openapi/components/StateStorageChooserEx$Resolution;", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "isExternalSystemStorageEnabled", "intellij.platform.configurationStore.impl"})
    public static final class TrackedFileStorage
    extends FileBasedStorage
    implements StorageVirtualFileTracker.TrackedStorage {
        @NotNull
        private final StateStorageManagerImpl storageManager;
        @Nullable
        private final SettingsController controller;

        public TrackedFileStorage(@NotNull StateStorageManagerImpl storageManager2, @NotNull Path file, @NotNull String fileSpec, @Nullable String rootElementName, @NotNull RoamingType roamingType, @Nullable PathMacroSubstitutor pathMacroManager, @Nullable StreamProvider provider, @Nullable SettingsController controller) {
            Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
            super(file, fileSpec, rootElementName, pathMacroManager, roamingType, provider);
            this.storageManager = storageManager2;
            this.controller = controller;
        }

        @Override
        @NotNull
        public StateStorageManagerImpl getStorageManager() {
            return this.storageManager;
        }

        @Override
        @Nullable
        public SettingsController getController() {
            return this.controller;
        }

        @Override
        protected boolean isUseXmlProlog() {
            return this.rootElementName != null && this.getStorageManager().isUseXmlProlog() && !ComponentInfoKt.isSpecialStorage(this.fileSpec);
        }

        @Override
        protected void beforeElementSaved(@NotNull List<Element> elements, @NotNull Map<String, String> rootAttributes) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Intrinsics.checkNotNullParameter(rootAttributes, (String)"rootAttributes");
            if (this.rootElementName != null) {
                this.getStorageManager().beforeElementSaved(elements, rootAttributes);
            }
            super.beforeElementSaved(elements, rootAttributes);
        }

        @Override
        protected void beforeElementLoaded(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.getStorageManager().beforeElementLoaded(element);
            super.beforeElementLoaded(element);
        }

        @Override
        protected void providerDataStateChanged(@Nullable DataWriter writer, @NotNull DataStateChanged type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.getStorageManager().providerDataStateChanged(this, writer, type);
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public StateStorageChooserEx.Resolution getResolution(@NotNull PersistentStateComponent<?> component, @NotNull StateStorageOperation operation, boolean isExternalSystemStorageEnabled) {
            Intrinsics.checkNotNullParameter(component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            if (operation != StateStorageOperation.WRITE || !isExternalSystemStorageEnabled) ** GOTO lbl-1000
            v0 = component instanceof ProjectModelElement != false ? (ProjectModelElement)component : null;
            if ((v0 != null ? v0.getExternalSource() : null) != null) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            clearExtStorage = v1;
            return clearExtStorage != false ? StateStorageChooserEx.Resolution.CLEAR : StateStorageChooserEx.Resolution.DO;
        }
    }
}

