/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.DataWriterFilter;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.configurationStore.StringDataWriter;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfoRt;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BE\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J'\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0010\u00a2\u0006\u0002\b\u0017R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/configurationStore/XmlDataWriter;", "Lcom/intellij/configurationStore/StringDataWriter;", "rootElementName", "", "elements", "", "Lorg/jdom/Element;", "rootAttributes", "", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "storageFilePathForDebugPurposes", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/Map;Lcom/intellij/openapi/components/PathMacroManager;Ljava/lang/String;)V", "hasData", "", "filter", "Lcom/intellij/configurationStore/DataWriterFilter;", "writeTo", "", "writer", "Ljava/io/Writer;", "lineSeparator", "writeTo$intellij_platform_configurationStore_impl", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nXmlElementStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlElementStorage.kt\ncom/intellij/configurationStore/XmlDataWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,518:1\n1761#2,3:519\n*S KotlinDebug\n*F\n+ 1 XmlElementStorage.kt\ncom/intellij/configurationStore/XmlDataWriter\n*L\n369#1:519,3\n*E\n"})
public final class XmlDataWriter
extends StringDataWriter {
    @Nullable
    private final String rootElementName;
    @NotNull
    private final List<Element> elements;
    @NotNull
    private final Map<String, String> rootAttributes;
    @Nullable
    private final PathMacroManager macroManager;
    @NotNull
    private final String storageFilePathForDebugPurposes;

    public XmlDataWriter(@Nullable String rootElementName, @NotNull List<? extends Element> elements, @NotNull Map<String, String> rootAttributes, @Nullable PathMacroManager macroManager, @NotNull String storageFilePathForDebugPurposes) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(rootAttributes, (String)"rootAttributes");
        Intrinsics.checkNotNullParameter((Object)storageFilePathForDebugPurposes, (String)"storageFilePathForDebugPurposes");
        this.rootElementName = rootElementName;
        this.elements = elements;
        this.rootAttributes = rootAttributes;
        this.macroManager = macroManager;
        this.storageFilePathForDebugPurposes = storageFilePathForDebugPurposes;
    }

    @Override
    public boolean hasData(@NotNull DataWriterFilter filter2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            Iterable $this$any$iv = this.elements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Element it = (Element)element$iv;
                    boolean bl2 = false;
                    if (!filter2.hasData(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void writeTo$intellij_platform_configurationStore_impl(@NotNull Writer writer, @NotNull String lineSeparator, @Nullable DataWriterFilter filter2) {
        PathMacroFilter macroFilter;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        Object lineSeparatorWithIndent = lineSeparator;
        boolean hasRootElement = this.rootElementName != null;
        PathMacroManager pathMacroManager = this.macroManager;
        ReplacePathToMacroMap replacePathMap = pathMacroManager != null ? pathMacroManager.getReplacePathMap() : null;
        PathMacroManager pathMacroManager2 = this.macroManager;
        Object object = macroFilter = pathMacroManager2 != null ? pathMacroManager2.getMacroFilter() : null;
        if (hasRootElement) {
            lineSeparatorWithIndent = (String)lineSeparatorWithIndent + "  ";
            writer.append('<').append(this.rootElementName);
            for (Map.Entry<String, String> entry : this.rootAttributes.entrySet()) {
                writer.append(' ');
                writer.append(entry.getKey());
                writer.append('=');
                writer.append('\"');
                String value = entry.getValue();
                if (replacePathMap != null) {
                    String string = replacePathMap.substitute(value, SystemInfoRt.isFileSystemCaseSensitive);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substitute(...)");
                    value = string;
                }
                writer.append(JDOMUtil.escapeText((String)value, (boolean)false, (boolean)true));
                writer.append('\"');
            }
            if (this.elements.isEmpty()) {
                writer.append(" />");
                return;
            }
            writer.append('>');
        }
        DataWriterFilter dataWriterFilter = filter2;
        JbXmlOutputter xmlOutputter = new JbXmlOutputter((String)lineSeparatorWithIndent, (JDOMUtil.ElementOutputFilter)(dataWriterFilter != null ? dataWriterFilter.toElementFilter() : null), replacePathMap, macroFilter, false, this.storageFilePathForDebugPurposes, 16, null);
        for (Element element : this.elements) {
            if (hasRootElement) {
                writer.append((CharSequence)lineSeparatorWithIndent);
            }
            xmlOutputter.printElement(writer, element, 0);
        }
        if (this.rootElementName != null) {
            writer.append(lineSeparator);
            writer.append("</").append(this.rootElementName).append('>');
        }
    }
}

