/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0010\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/configurationStore/schemeManager/ApplicationSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "checkPath", "", "originalPath", "checkPath$intellij_platform_configurationStore_impl", "pathToFile", "Ljava/nio/file/Path;", "path", "pathToFile$intellij_platform_configurationStore_impl", "intellij.platform.configurationStore.impl"})
final class ApplicationSchemeManagerFactory
extends SchemeManagerFactoryBase {
    public ApplicationSchemeManagerFactory(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super((ComponentManager)ApplicationManager.getApplication(), coroutineScope, null);
    }

    @Override
    @NotNull
    public String checkPath$intellij_platform_configurationStore_impl(@NotNull String originalPath) {
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        String path = super.checkPath$intellij_platform_configurationStore_impl(originalPath);
        if (StringsKt.startsWith$default((String)path, (String)"$ROOT_CONFIG$", (boolean)false, (int)2, null)) {
            String string = path.substring(14);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            path = string;
            String message = "Path must not contains ROOT_CONFIG macro, corrected: " + path;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new AssertionError((Object)message);
            }
            ComponentStoreImplKt.LOG.warn(message);
        }
        return path;
    }

    @Override
    @NotNull
    public Path pathToFile$intellij_platform_configurationStore_impl(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        Path path2 = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager().expandMacro("$ROOT_CONFIG$").resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }
}

