/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialogKt;
import com.intellij.configurationStore.ComponentElementProperties;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.util.containers.CollectionFactory;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001cH\u0014J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020(H\u0014J\b\u0010*\u001a\u00020\nH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Lcom/intellij/configurationStore/ChooseComponentsToExportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "fileToComponents", "", "Lcom/intellij/configurationStore/FileSpec;", "", "Lcom/intellij/configurationStore/ExportableItem;", "isShowFilePath", "", "title", "", "description", "<init>", "(Ljava/util/Map;ZLjava/lang/String;Ljava/lang/String;)V", "chooser", "Lcom/intellij/ide/util/ElementsChooser;", "Lcom/intellij/configurationStore/ComponentElementProperties;", "pathPanel", "Lcom/intellij/ui/FieldPanel;", "exportableComponents", "", "getExportableComponents$intellij_platform_configurationStore_impl", "()Ljava/util/Set;", "exportFile", "Ljava/nio/file/Path;", "getExportFile$intellij_platform_configurationStore_impl", "()Ljava/nio/file/Path;", "browse", "", "updateControls", "createLeftSideActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "doOKAction", "getPreferredFocusedComponent", "Ljavax/swing/JTextField;", "createNorthPanel", "Ljavax/swing/JLabel;", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthPanel", "getDimensionServiceKey", "intellij.platform.configurationStore.impl"})
public final class ChooseComponentsToExportDialog
extends DialogWrapper {
    private final boolean isShowFilePath;
    @NotNull
    private final String description;
    @NotNull
    private final ElementsChooser<ComponentElementProperties> chooser;
    @NotNull
    private final FieldPanel pathPanel;

    public ChooseComponentsToExportDialog(@NotNull Map<FileSpec, ? extends List<ExportableItem>> fileToComponents, boolean isShowFilePath, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.Label @NotNull String description) {
        Intrinsics.checkNotNullParameter(fileToComponents, (String)"fileToComponents");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        super(false);
        this.isShowFilePath = isShowFilePath;
        this.description = description;
        this.pathPanel = new FieldPanel(ConfigurationStoreBundle.message("editbox.export.settings.to", new Object[0]), null, arg_0 -> ChooseComponentsToExportDialog.pathPanel$lambda$0(this, arg_0), null);
        LinkedHashMap componentToContainingListElement = new LinkedHashMap();
        for (List<ExportableItem> list : fileToComponents.values()) {
            for (ExportableItem item : list) {
                if (ChooseComponentsToExportDialogKt.access$addToExistingListElement(item, componentToContainingListElement, fileToComponents)) continue;
                ComponentElementProperties componentElementProperties = new ComponentElementProperties();
                componentElementProperties.getItems().add(item);
                ((Map)componentToContainingListElement).put(item, componentElementProperties);
            }
        }
        this.chooser = new ElementsChooser(true);
        this.chooser.setColorUnmarkedElements(false);
        Set markedElementNames = ChooseComponentsToExportDialogKt.access$getMarkedElementNames();
        Iterator iterator = new LinkedHashSet(componentToContainingListElement.values()).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ComponentElementProperties componentElementProperty = (ComponentElementProperties)iterator2.next();
            this.chooser.addElement((Object)componentElementProperty, markedElementNames.isEmpty() || markedElementNames.contains(componentElementProperty.getFileName()), (MultiStateElementsChooser.ElementProperties)componentElementProperty);
        }
        this.chooser.sort(Comparator.comparing(arg_0 -> ChooseComponentsToExportDialog._init_$lambda$1(ChooseComponentsToExportDialog::_init_$lambda$0, arg_0)));
        String string = PropertiesComponent.getInstance().getValue("export.settings.path", ChooseComponentsToExportDialogKt.access$getDEFAULT_PATH$p());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String string2 = string;
        this.pathPanel.setText(string2);
        this.pathPanel.setChangeListener(() -> ChooseComponentsToExportDialog._init_$lambda$2(this));
        this.updateControls();
        this.setTitle(title);
        this.init();
    }

    @NotNull
    public final Set<ExportableItem> getExportableComponents$intellij_platform_configurationStore_impl() {
        Set set = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createSmallMemoryFootprintSet(...)");
        Set components = set;
        for (ComponentElementProperties elementProperties : this.chooser.getMarkedElements()) {
            components.addAll((Collection)elementProperties.getItems());
        }
        return components;
    }

    @NotNull
    public final Path getExportFile$intellij_platform_configurationStore_impl() {
        Path path = Paths.get(this.pathPanel.getText(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    private final void browse() {
        FileChooserDescriptor fileChooserDescriptor;
        FileChooserDescriptor $this$browse_u24lambda_u240 = fileChooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        boolean bl = false;
        $this$browse_u24lambda_u240.setTitle(ConfigurationStoreBundle.message("title.export.file.location", new Object[0]));
        $this$browse_u24lambda_u240.setDescription(ConfigurationStoreBundle.message("prompt.choose.export.settings.file.path", new Object[0]));
        $this$browse_u24lambda_u240.setHideIgnored(false);
        ConfigImportHelper.setSettingsFilter((FileChooserDescriptor)$this$browse_u24lambda_u240);
        FileChooserDescriptor descriptor2 = fileChooserDescriptor;
        Intrinsics.checkNotNull((Object)descriptor2);
        ChooseComponentsToExportDialogKt.chooseSettingsFile(descriptor2, this.pathPanel.getText(), this.getWindow(), (Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> ChooseComponentsToExportDialog.browse$lambda$1(this, arg_0)));
    }

    private final void updateControls() {
        CharSequence charSequence = this.pathPanel.getText();
        this.setOKActionEnabled(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)));
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        String string = ConfigurationStoreBundle.message("export.components.list.action.select.all", new Object[0]);
        AbstractAction selectAll2 = new AbstractAction(this, string){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).setAllElementsMarked(true);
            }
        };
        String string2 = ConfigurationStoreBundle.message("export.components.list.action.select.none", new Object[0]);
        AbstractAction selectNone2 = new AbstractAction(this, string2){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).setAllElementsMarked(false);
            }
        };
        Action[] actionArray = ConfigurationStoreBundle.message("export.components.list.action.invert.selection", new Object[0]);
        AbstractAction invert2 = new AbstractAction(this, (String)actionArray){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).invertSelection();
            }
        };
        actionArray = new Action[]{selectAll2, selectNone2, invert2};
        return actionArray;
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue("export.settings.path", this.pathPanel.getText(), ChooseComponentsToExportDialogKt.access$getDEFAULT_PATH$p());
        StringBuilder builder = new StringBuilder();
        if (this.chooser.hasUnmarkedElements()) {
            List list = this.chooser.getElements(true);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getElements(...)");
            List marked = list;
            for (ComponentElementProperties element : marked) {
                builder.append(element.getFileName());
                builder.append("|");
            }
        }
        PropertiesComponent.getInstance().setValue("export.settings.marked", ((CharSequence)builder).length() == 0 ? null : builder.toString());
        super.doOKAction();
    }

    @Nullable
    public JTextField getPreferredFocusedComponent() {
        return this.pathPanel.getTextField();
    }

    @NotNull
    protected JLabel createNorthPanel() {
        return new JLabel(this.description);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.chooser;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent buttons = super.createSouthPanel();
        if (!this.isShowFilePath) {
            Intrinsics.checkNotNull((Object)buttons);
            return buttons;
        }
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)this.pathPanel);
        panel.add(buttons);
        return panel;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.actions.ChooseComponentsToExportDialog";
    }

    private static final void pathPanel$lambda$0(ChooseComponentsToExportDialog this$0, ActionEvent it) {
        this$0.browse();
    }

    private static final String _init_$lambda$0(ComponentElementProperties it) {
        return it.toString();
    }

    private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$2(ChooseComponentsToExportDialog this$0) {
        this$0.updateControls();
    }

    private static final Unit browse$lambda$1(ChooseComponentsToExportDialog this$0, VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isDirectory()) {
            object = file.getPath() + "/settings.zip";
        } else {
            String string = file.getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        }
        Object path = object;
        this$0.pathPanel.setText(FileUtil.toSystemDependentName((String)path));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ElementsChooser access$getChooser$p(ChooseComponentsToExportDialog $this) {
        return $this.chooser;
    }
}

