/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ComponentInfoImpl;
import com.intellij.configurationStore.ComponentWithModificationTrackerInfo;
import com.intellij.configurationStore.ComponentWithStateModificationTrackerInfo;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.ThreeState;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\"\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"path", "", "Lcom/intellij/openapi/components/Storage;", "getPath$annotations", "(Lcom/intellij/openapi/components/Storage;)V", "getPath", "(Lcom/intellij/openapi/components/Storage;)Ljava/lang/String;", "createComponentInfo", "Lcom/intellij/configurationStore/ComponentInfo;", "component", "", "stateSpec", "Lcom/intellij/openapi/components/State;", "serviceDescriptor", "Lcom/intellij/openapi/components/ServiceDescriptor;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "isUseSaveThreshold", "", "storage", "getEffectiveRoamingType", "Lcom/intellij/openapi/components/RoamingType;", "roamingType", "collapsedPath", "isSpecialOrNonRoamableStorage", "isSpecialStorage", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nComponentInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentInfo.kt\ncom/intellij/configurationStore/ComponentInfoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,144:1\n1#2:145\n13022#3,2:146\n*S KotlinDebug\n*F\n+ 1 ComponentInfo.kt\ncom/intellij/configurationStore/ComponentInfoKt\n*L\n43#1:146,2\n*E\n"})
public final class ComponentInfoKt {
    @NotNull
    public static final String getPath(@NotNull Storage $this$path) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        CharSequence charSequence2 = $this$path.value();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = $this$path.file();
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    public static /* synthetic */ void getPath$annotations(Storage storage) {
    }

    @NotNull
    public static final ComponentInfo createComponentInfo(@NotNull Object component, @Nullable State stateSpec, @Nullable ServiceDescriptor serviceDescriptor, @NotNull PluginId pluginId) {
        ComponentInfo result;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Object object = component;
        if (object instanceof PersistentStateComponentWithModificationTracker) {
            ServiceDescriptor serviceDescriptor2 = serviceDescriptor;
            v1 = new ComponentWithStateModificationTrackerInfo(pluginId, (PersistentStateComponentWithModificationTracker)component, stateSpec, serviceDescriptor2 != null ? serviceDescriptor2.configurationSchemaKey : null);
        } else if (object instanceof ModificationTracker) {
            ServiceDescriptor serviceDescriptor3 = serviceDescriptor;
            v1 = new ComponentWithModificationTrackerInfo(pluginId, (ModificationTracker)component, stateSpec, serviceDescriptor3 != null ? serviceDescriptor3.configurationSchemaKey : null);
        } else {
            v1 = result = (ComponentInfo)new ComponentInfoImpl(pluginId, component, stateSpec);
        }
        if (stateSpec != null && !(stateSpec.storages().length == 0)) {
            boolean bl;
            block7: {
                Storage[] $this$all$iv = stateSpec.storages();
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    Storage element$iv;
                    Storage it = element$iv = $this$all$iv[i];
                    boolean bl2 = false;
                    if (it.deprecated() || ComponentInfoKt.isUseSaveThreshold(it)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            if (bl) {
                result.lastSaved = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
            }
        }
        return result;
    }

    private static final boolean isUseSaveThreshold(Storage storage) {
        return storage.useSaveThreshold() != ThreeState.NO && ComponentInfoKt.getEffectiveRoamingType(storage.roamingType(), ComponentInfoKt.getPath(storage)) == RoamingType.DISABLED;
    }

    @NotNull
    public static final RoamingType getEffectiveRoamingType(@NotNull RoamingType roamingType, @NotNull String collapsedPath) {
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
        if (ComponentInfoKt.isSpecialOrNonRoamableStorage(collapsedPath)) {
            return RoamingType.DISABLED;
        }
        return roamingType;
    }

    public static final boolean isSpecialOrNonRoamableStorage(@NotNull String collapsedPath) {
        Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
        return Intrinsics.areEqual((Object)collapsedPath, (Object)"$WORKSPACE_FILE$") || Intrinsics.areEqual((Object)collapsedPath, (Object)"other.xml") || ComponentInfoKt.isSpecialStorage(collapsedPath);
    }

    public static final boolean isSpecialStorage(@NotNull String collapsedPath) {
        Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
        return Intrinsics.areEqual((Object)collapsedPath, (Object)"$CACHE_FILE$") || Intrinsics.areEqual((Object)collapsedPath, (Object)"$PRODUCT_WORKSPACE_FILE$");
    }
}

