/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ExternalStorageWithInternalPart;
import com.intellij.configurationStore.ProjectStorePathCustomizerKt;
import com.intellij.configurationStore.StorageImpl;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.UnknownMacroNotification;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.CoroutineSupport;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SerializablePersistentStateComponent;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\b\u0010\t\u001a\u00020\nH\u0001\u001a\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007H\u0001\u001a \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002\u001a$\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0080@\u00a2\u0006\u0002\u0010 \u001a\u001e\u0010!\u001a\u00020\u00052\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00112\u0006\u0010$\u001a\u00020#H\u0002\u001a.\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&\"\b\b\u0000\u0010(*\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H(0\u001dH\u0000\u001a!\u0010)\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020'0+H\u0002\u00a2\u0006\u0002\u0010,\"\u0010\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"8\u0010\r\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00110\u000eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "SAVE_MOD_LOG", "Lorg/jetbrains/annotations/NotNull;", "isUseLoadedStateAsExistingVmProperty", "", "NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT", "", "NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD", "restoreDefaultNotRoamableComponentSaveThreshold", "", "setRoamableComponentSaveThreshold", "thresholdInSeconds", "ignoredDeprecatedJDomExternalizableComponents", "", "", "kotlin.jvm.PlatformType", "", "getIgnoredDeprecatedJDomExternalizableComponents$annotations", "()V", "notifyUnknownMacros", "store", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "project", "Lcom/intellij/openapi/project/Project;", "componentName", "getStateForComponent", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "(Lcom/intellij/openapi/components/PersistentStateComponent;Lcom/intellij/openapi/components/State;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isStorageChanged", "changedStorages", "Lcom/intellij/openapi/components/StateStorage;", "storage", "getStorageSpecGenericImpl", "", "Lcom/intellij/openapi/components/Storage;", "T", "getWithPerOsStorages", "storages", "", "([Lcom/intellij/openapi/components/Storage;)Ljava/util/List;", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nComponentStoreImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentStoreImpl.kt\ncom/intellij/configurationStore/ComponentStoreImplKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,924:1\n30#2,2:925\n13#3:927\n*S KotlinDebug\n*F\n+ 1 ComponentStoreImpl.kt\ncom/intellij/configurationStore/ComponentStoreImplKt\n*L\n856#1:925,2\n51#1:927\n*E\n"})
public final class ComponentStoreImplKt {
    @JvmField
    @NotNull
    public static final Logger LOG;
    @NotNull
    private static final Logger SAVE_MOD_LOG;
    private static final boolean isUseLoadedStateAsExistingVmProperty;
    private static final int NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT;
    private static int NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD;
    private static final Set<String> ignoredDeprecatedJDomExternalizableComponents;

    @TestOnly
    public static final void restoreDefaultNotRoamableComponentSaveThreshold() {
        NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD = NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT;
    }

    @TestOnly
    public static final void setRoamableComponentSaveThreshold(int thresholdInSeconds) {
        NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD = thresholdInSeconds;
    }

    private static /* synthetic */ void getIgnoredDeprecatedJDomExternalizableComponents$annotations() {
    }

    private static final void notifyUnknownMacros(IComponentStore store, Project project, String componentName) {
        PathMacroSubstitutor pathMacroSubstitutor = store.getStorageManager().getMacroSubstitutor();
        TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor ? (TrackingPathMacroSubstitutor)pathMacroSubstitutor : null;
        if (trackingPathMacroSubstitutor == null) {
            return;
        }
        TrackingPathMacroSubstitutor substitutor = trackingPathMacroSubstitutor;
        Set immutableMacros = substitutor.getUnknownMacros(componentName);
        if (immutableMacros.isEmpty()) {
            return;
        }
        LinkedHashSet<String> macros = new LinkedHashSet<String>(immutableMacros);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<CoreUiCoroutineScopeHolder> serviceClass$iv = CoreUiCoroutineScopeHolder.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        BuildersKt.launch$default((CoroutineScope)((CoreUiCoroutineScopeHolder)object).coroutineScope, (CoroutineContext)CoroutinesKt.ui$default((Dispatchers)Dispatchers.INSTANCE, (CoroutineSupport.UiDispatcherKind)CoroutineSupport.UiDispatcherKind.RELAX, (boolean)false, (int)2, null), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, macros, componentName, substitutor, store, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ LinkedHashSet<String> $macros;
            final /* synthetic */ String $componentName;
            final /* synthetic */ TrackingPathMacroSubstitutor $substitutor;
            final /* synthetic */ IComponentStore $store;
            {
                this.$project = $project;
                this.$macros = $macros;
                this.$componentName = $componentName;
                this.$substitutor = $substitutor;
                this.$store = $store;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        List notified = null;
                        NotificationsManager manager = NotificationsManager.getNotificationsManager();
                        Notification[] notificationArray = manager.getNotificationsOfType(UnknownMacroNotification.class, this.$project);
                        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
                        for (UnknownMacroNotification notification : (UnknownMacroNotification[])notificationArray) {
                            if (notified == null) {
                                notified = new ArrayList<E>();
                            }
                            notified.addAll(notification.getMacros());
                        }
                        Collection collection = notified;
                        if (!(collection == null || collection.isEmpty())) {
                            this.$macros.removeAll(notified);
                        }
                        if (this.$macros.isEmpty()) {
                            return Unit.INSTANCE;
                        }
                        ComponentStoreImplKt.LOG.debug("Reporting unknown path macros " + this.$macros + " in component " + this.$componentName);
                        Set set = this.$macros;
                        Map<TrackingPathMacroSubstitutor, IComponentStore> map2 = Map.of(this.$substitutor, this.$store);
                        Intrinsics.checkNotNullExpressionValue(map2, (String)"of(...)");
                        StorageUtilKt.doNotify((Set)set, (Project)this.$project, map2);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Nullable
    public static final Object getStateForComponent(@NotNull PersistentStateComponent<?> component, @NotNull State stateSpec, @NotNull Continuation<Object> $completion) {
        if (!(component instanceof SerializablePersistentStateComponent)) {
            if (stateSpec.getStateRequiresEdt()) {
                return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(component, null){
                    int label;
                    final /* synthetic */ PersistentStateComponent<?> $component;
                    {
                        this.$component = $component;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                return this.$component.getState();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
            }
            return CoroutinesKt.readAction(() -> ComponentStoreImplKt.getStateForComponent$lambda$0(component), $completion);
        }
        return ((SerializablePersistentStateComponent)component).getState();
    }

    private static final boolean isStorageChanged(Set<? extends StateStorage> changedStorages, StateStorage storage) {
        return changedStorages.contains(storage) || storage instanceof ExternalStorageWithInternalPart && changedStorages.contains(((ExternalStorageWithInternalPart)storage).getInternalStorage());
    }

    @NotNull
    public static final <T> List<Storage> getStorageSpecGenericImpl(@NotNull State stateSpec, @NotNull PersistentStateComponent<T> component) {
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter(component, (String)"component");
        List<Storage> storages = ComponentStoreImplKt.getWithPerOsStorages(stateSpec.storages());
        if (storages.size() == 1 || component instanceof StateStorageChooserEx) {
            return storages;
        }
        if (storages.isEmpty()) {
            if (stateSpec.defaultStateAsResource()) {
                return CollectionsKt.emptyList();
            }
            throw new AssertionError((Object)("No storage specified for " + component));
        }
        return ProjectStorePathCustomizerKt.sortStoragesByDeprecated(storages);
    }

    private static final List<Storage> getWithPerOsStorages(Storage[] storages) {
        List result = new ArrayList();
        for (Storage storage : storages) {
            boolean bl;
            if (storage.roamingType() == RoamingType.PER_OS) {
                Storage storage2 = StorageImpl.copyWithNewValue(storage, StoreUtilKt.getOsDependentStorage((String)storage.value()));
                Intrinsics.checkNotNullExpressionValue((Object)storage2, (String)"copyWithNewValue(...)");
                result.add(storage2);
                Storage storage3 = StorageImpl.deprecatedCopy(storage);
                Intrinsics.checkNotNullExpressionValue((Object)storage3, (String)"deprecatedCopy(...)");
                bl = result.add(storage3);
                continue;
            }
            bl = result.add(storage);
        }
        return result;
    }

    private static final Object getStateForComponent$lambda$0(PersistentStateComponent $component) {
        return $component.getState();
    }

    public static final /* synthetic */ void access$notifyUnknownMacros(IComponentStore store, Project project, String componentName) {
        ComponentStoreImplKt.notifyUnknownMacros(store, project, componentName);
    }

    public static final /* synthetic */ Set access$getIgnoredDeprecatedJDomExternalizableComponents$p() {
        return ignoredDeprecatedJDomExternalizableComponents;
    }

    public static final /* synthetic */ Logger access$getSAVE_MOD_LOG$p() {
        return SAVE_MOD_LOG;
    }

    public static final /* synthetic */ int access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD$p() {
        return NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD;
    }

    public static final /* synthetic */ int access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT$p() {
        return NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT;
    }

    public static final /* synthetic */ boolean access$isStorageChanged(Set changedStorages, StateStorage storage) {
        return ComponentStoreImplKt.isStorageChanged(changedStorages, storage);
    }

    public static final /* synthetic */ boolean access$isUseLoadedStateAsExistingVmProperty$p() {
        return isUseLoadedStateAsExistingVmProperty;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ComponentStoreImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Logger logger2 = Logger.getInstance((String)"#configurationStore.save.skip");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        SAVE_MOD_LOG = logger2;
        isUseLoadedStateAsExistingVmProperty = Boolean.parseBoolean(System.getProperty("use.loaded.state.as.existing", "true"));
        NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD = NOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT = (int)TimeUnit.MINUTES.toSeconds(5L);
        ignoredDeprecatedJDomExternalizableComponents = Set.of("jetbrains.buildServer.codeInspection.InspectionPassRegistrar");
    }
}

