/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentInfoKt;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DefaultProjectElementNormalizerKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.ProjectStorePathCustomizerKt;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a \u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u001a<\u0010\u000f\u001a\u00020\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00112\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0013H\u0002\u001a^\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\t0\u00132!\u0010\u0019\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00070\u0013H\u0000\u001a\u001e\u0010\u001a\u001a\u00020\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002\u00a8\u0006\u001e"}, d2={"normalizeDefaultProjectElement", "", "defaultProject", "Lcom/intellij/openapi/project/Project;", "element", "Lorg/jdom/Element;", "projectConfigDir", "Ljava/nio/file/Path;", "getProfileName", "", "profile", "writeProfileSettings", "schemeDir", "componentName", "component", "convertProfiles", "profileIterator", "", "nameCallback", "Lkotlin/Function1;", "moveComponentConfiguration", "storagePathResolver", "Lkotlin/ParameterName;", "name", "storagePath", "fileResolver", "writeConfigFile", "elements", "", "file", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\ndefaultProjectElementNormalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 defaultProjectElementNormalizer.kt\ncom/intellij/configurationStore/DefaultProjectElementNormalizerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class DefaultProjectElementNormalizerKt {
    /*
     * Enabled aggressive block sorting
     */
    public static final void normalizeDefaultProjectElement(@NotNull Project defaultProject, @NotNull Element element, @NotNull Path projectConfigDir) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)defaultProject, (String)"defaultProject");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)projectConfigDir, (String)"projectConfigDir");
        Iterator iterator2 = iterator = element.getChildren("component").iterator();
        while (true) {
            block9: {
                block10: {
                    String componentName;
                    Element component;
                    block11: {
                        Path schemeDir;
                        if (!iterator2.hasNext()) {
                            DefaultProjectElementNormalizerKt.moveComponentConfiguration(defaultProject, element, (Function1<? super String, String>)((Function1)DefaultProjectElementNormalizerKt::normalizeDefaultProjectElement$lambda$1), (Function1<? super String, ? extends Path>)((Function1)arg_0 -> DefaultProjectElementNormalizerKt.normalizeDefaultProjectElement$lambda$2(projectConfigDir, arg_0)));
                            return;
                        }
                        component = (Element)iterator2.next();
                        componentName = component.getAttributeValue("name");
                        if (componentName == null) continue;
                        switch (componentName.hashCode()) {
                            case 932379142: {
                                if (componentName.equals("CopyrightManager")) break;
                                break block9;
                            }
                            case -1325606616: {
                                if (componentName.equals("ProjectModuleManager")) break block10;
                                break block9;
                            }
                            case -1720327213: {
                                if (componentName.equals("libraryTable")) break block11;
                                break block9;
                            }
                            case -334315511: {
                                if (componentName.equals("InspectionProjectProfileManager")) {
                                    iterator.remove();
                                    schemeDir = projectConfigDir.resolve("inspectionProfiles");
                                    Iterator iterator3 = component.getChildren("profile").iterator();
                                    Intrinsics.checkNotNull((Object)schemeDir);
                                    DefaultProjectElementNormalizerKt.convertProfiles(iterator3, componentName, schemeDir, (Function1<? super Element, String>)((Function1)normalizeDefaultProjectElement.1.INSTANCE));
                                    component.removeChild("version");
                                    Intrinsics.checkNotNull((Object)component);
                                    DefaultProjectElementNormalizerKt.writeProfileSettings(schemeDir, componentName, component);
                                }
                                break block9;
                            }
                        }
                        iterator.remove();
                        schemeDir = projectConfigDir.resolve("copyright");
                        Iterator iterator4 = component.getChildren("copyright").iterator();
                        Intrinsics.checkNotNull((Object)schemeDir);
                        DefaultProjectElementNormalizerKt.convertProfiles(iterator4, componentName, schemeDir, (Function1<? super Element, String>)((Function1)normalizeDefaultProjectElement.2.INSTANCE));
                        Intrinsics.checkNotNull((Object)component);
                        DefaultProjectElementNormalizerKt.writeProfileSettings(schemeDir, componentName, component);
                        continue;
                    }
                    iterator.remove();
                    Path libraryDir = projectConfigDir.resolve("libraries");
                    Iterator iterator5 = component.getChildren("library").iterator();
                    Intrinsics.checkNotNull((Object)libraryDir);
                    DefaultProjectElementNormalizerKt.convertProfiles(iterator5, componentName, libraryDir, (Function1<? super Element, String>)((Function1)DefaultProjectElementNormalizerKt::normalizeDefaultProjectElement$lambda$0));
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private static final String getProfileName(Element profile) {
        Object v1;
        block1: {
            List list = profile.getChildren("option");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                Element it = (Element)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAttributeValue("name"), (Object)"myName")) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        Element element = v1;
        return element != null ? element.getAttributeValue("value") : null;
    }

    private static final void writeProfileSettings(Path schemeDir, String componentName, Element component) {
        component.removeAttribute("name");
        if (JDOMUtil.isEmpty((Element)component)) {
            return;
        }
        Element wrapper = new Element("component").setAttribute("name", componentName);
        component.setName("settings");
        wrapper.addContent(component);
        JDOMUtil.write((Element)wrapper, (Path)schemeDir.resolve("profiles_settings.xml"));
    }

    private static final void convertProfiles(Iterator<? extends Element> profileIterator, String componentName, Path schemeDir, Function1<? super Element, String> nameCallback) {
        Iterator<? extends Element> iterator = profileIterator;
        while (iterator.hasNext()) {
            String schemeName;
            Element profile = iterator.next();
            if ((String)nameCallback.invoke((Object)profile) == null) continue;
            profileIterator.remove();
            Element wrapper = new Element("component").setAttribute("name", componentName);
            wrapper.addContent(profile);
            Path path = schemeDir.resolve(FileUtil.sanitizeFileName((String)schemeName, (boolean)true) + ".xml");
            Parent parent = (Parent)wrapper;
            Intrinsics.checkNotNull((Object)path);
            JDOMUtil.write((Parent)parent, (OutputStream)PathKt.outputStream((Path)path), (String)"\n");
        }
    }

    public static final void moveComponentConfiguration(@NotNull Project defaultProject, @NotNull Element element, @NotNull Function1<? super String, String> storagePathResolver, @NotNull Function1<? super String, ? extends Path> fileResolver) {
        Intrinsics.checkNotNullParameter((Object)defaultProject, (String)"defaultProject");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(storagePathResolver, (String)"storagePathResolver");
        Intrinsics.checkNotNullParameter(fileResolver, (String)"fileResolver");
        List componentElements = element.getChildren("component");
        if (componentElements.isEmpty()) {
            return;
        }
        HashMap storageNameToComponentNames = new HashMap();
        HashSet workspaceComponentNames = new HashSet(CollectionsKt.listOf((Object)"GradleLocalSettings"));
        HashSet ignoredComponentNames = new HashSet();
        storageNameToComponentNames.put("workspace.xml", workspaceComponentNames);
        ((ComponentManagerEx)defaultProject).processAllHolders((arg_0, arg_1, arg_2) -> DefaultProjectElementNormalizerKt.moveComponentConfiguration$lambda$2(workspaceComponentNames, ignoredComponentNames, storageNameToComponentNames, storagePathResolver, arg_0, arg_1, arg_2));
        HashMap<Object, List> storagePathToComponentStates = new HashMap<Object, List>();
        Iterator iterator = componentElements.iterator();
        Iterator<Object> iterator2 = iterator;
        block0: while (iterator2.hasNext()) {
            String name;
            Element entry = (Element)iterator2.next();
            iterator.remove();
            if (entry.getAttributeValue("name") == null || ignoredComponentNames.contains(name)) continue;
            for (Map.Entry entry2 : ((Map)storageNameToComponentNames).entrySet()) {
                String storageName = (String)entry2.getKey();
                Set componentNames = (Set)entry2.getValue();
                if (!componentNames.contains(name)) continue;
                Intrinsics.checkNotNull((Object)entry);
                storagePathToComponentStates.computeIfAbsent(fileResolver.invoke((Object)storageName), arg_0 -> DefaultProjectElementNormalizerKt.moveComponentConfiguration$lambda$4(DefaultProjectElementNormalizerKt::moveComponentConfiguration$lambda$3, arg_0)).add(entry);
                continue block0;
            }
            Intrinsics.checkNotNull((Object)entry);
            storagePathToComponentStates.computeIfAbsent(fileResolver.invoke((Object)"misc.xml"), arg_0 -> DefaultProjectElementNormalizerKt.moveComponentConfiguration$lambda$6(DefaultProjectElementNormalizerKt::moveComponentConfiguration$lambda$5, arg_0)).add(entry);
        }
        for (Map.Entry entry : ((Map)storagePathToComponentStates).entrySet()) {
            Path storageFile = (Path)entry.getKey();
            List componentStates = (List)entry.getValue();
            DefaultProjectElementNormalizerKt.writeConfigFile(componentStates, storageFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeConfigFile(List<? extends Element> elements, Path file) {
        if (elements.isEmpty()) {
            return;
        }
        Element wrapper = null;
        wrapper = new Element("project").setAttribute("version", "4");
        if (Files.exists(file, new LinkOption[0])) {
            try {
                wrapper = JDOMUtil.load((Path)file);
            }
            catch (Exception e) {
                ComponentStoreImplKt.LOG.warn((Throwable)e);
            }
        }
        for (Element throwable : elements) {
            wrapper.addContent(throwable);
        }
        Closeable closeable = PathKt.outputStream((Path)file);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            it.write(FileBasedStorageKt.XML_PROLOG);
            it.write(LineSeparator.LF.getSeparatorBytes());
            JDOMUtil.write((Parent)((Parent)wrapper), (OutputStream)it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, throwable);
        }
    }

    private static final String normalizeDefaultProjectElement$lambda$0(Element library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return library.getAttributeValue("name");
    }

    private static final String normalizeDefaultProjectElement$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Path normalizeDefaultProjectElement$lambda$2(Path $projectConfigDir, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Path path = $projectConfigDir.resolve(it);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final Set moveComponentConfiguration$processComponents$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final Set moveComponentConfiguration$processComponents$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final void moveComponentConfiguration$processComponents(HashSet<String> workspaceComponentNames, HashSet<String> ignoredComponentNames, HashMap<String, Set<String>> storageNameToComponentNames, Function1<? super String, String> $storagePathResolver, Class<?> aClass) {
        String storagePath;
        String string;
        State state = StoreUtilKt.getStateSpec(aClass);
        if (state == null) {
            return;
        }
        State stateAnnotation = state;
        if (((CharSequence)stateAnnotation.name()).length() == 0) {
            string = "misc.xml";
        } else {
            Storage storage = (Storage)CollectionsKt.firstOrNull((List)ProjectStorePathCustomizerKt.sortStoragesByDeprecated((List)ArraysKt.asList((Object[])stateAnnotation.storages())));
            if (storage == null) {
                return;
            }
            string = ComponentInfoKt.getPath(storage);
        }
        switch (storagePath = string) {
            case "$WORKSPACE_FILE$": {
                boolean bl = workspaceComponentNames.add(stateAnnotation.name());
                break;
            }
            case "$CACHE_FILE$": 
            case "$PRODUCT_WORKSPACE_FILE$": {
                boolean bl = ignoredComponentNames.add(stateAnnotation.name());
                break;
            }
            default: {
                boolean bl = storageNameToComponentNames.computeIfAbsent((String)$storagePathResolver.invoke((Object)storagePath), arg_0 -> DefaultProjectElementNormalizerKt.moveComponentConfiguration$processComponents$lambda$1(DefaultProjectElementNormalizerKt::moveComponentConfiguration$processComponents$lambda$0, arg_0)).add(stateAnnotation.name());
            }
        }
    }

    private static final Unit moveComponentConfiguration$lambda$2(HashSet $workspaceComponentNames, HashSet $ignoredComponentNames, HashMap $storageNameToComponentNames, Function1 $storagePathResolver, String string, Class componentClass, PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)componentClass, (String)"componentClass");
        DefaultProjectElementNormalizerKt.moveComponentConfiguration$processComponents($workspaceComponentNames, $ignoredComponentNames, $storageNameToComponentNames, (Function1<? super String, String>)$storagePathResolver, componentClass);
        return Unit.INSTANCE;
    }

    private static final List moveComponentConfiguration$lambda$3(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)new SmartList();
    }

    private static final List moveComponentConfiguration$lambda$4(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List moveComponentConfiguration$lambda$5(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)new SmartList();
    }

    private static final List moveComponentConfiguration$lambda$6(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getProfileName(Element profile) {
        return DefaultProjectElementNormalizerKt.getProfileName(profile);
    }
}

