/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.impl.stores.ComponentStorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.SafeStAXStreamBuilderKt;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\u001a<\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a0\u0010\u0002\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00182\u0006\u0010\u0010\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\"\u0010\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"XML_PROLOG", "", "writeFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cachedFile", "Ljava/nio/file/Path;", "requestor", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "virtualFile", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "lineSeparator", "Lcom/intellij/util/LineSeparator;", "prependXmlProlog", "", "", "file", "creationEvent", "Lcom/intellij/openapi/vfs/newvfs/events/VFileCreateEvent;", "dir", "updatingEvent", "Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "vFile", "loadDataAndDetectLineSeparator", "Lkotlin/Pair;", "Lorg/jdom/Element;", "detectLineSeparator", "chars", "", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nFileBasedStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileBasedStorage.kt\ncom/intellij/configurationStore/FileBasedStorageKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,369:1\n60#2,5:370\n60#2,5:378\n1786#3,3:375\n*S KotlinDebug\n*F\n+ 1 FileBasedStorage.kt\ncom/intellij/configurationStore/FileBasedStorageKt\n*L\n324#1:370,5\n281#1:378,5\n252#1:375,3\n*E\n"})
public final class FileBasedStorageKt {
    @JvmField
    @NotNull
    public static final byte[] XML_PROLOG;

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final VirtualFile writeFile(@Nullable Path cachedFile, @NotNull StorageManagerFileWriteRequestor requestor, @Nullable VirtualFile virtualFile, @NotNull DataWriter dataWriter, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)dataWriter, (String)"dataWriter");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        if (cachedFile == null) ** GOTO lbl-1000
        v0 = virtualFile;
        v1 = v0 != null ? v0.isValid() : false;
        if (v1) lbl-1000:
        // 2 sources

        {
            v2 = virtualFile;
            v3 = v2;
            Intrinsics.checkNotNull((Object)v2);
        } else {
            v3 = file = StorageUtilKt.getOrCreateVirtualFile((Path)cachedFile, (StorageManagerFileWriteRequestor)requestor);
        }
        if ((ComponentStoreImplKt.LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode()) && !VirtualFileUtil.isTooLarge((VirtualFile)file)) {
            content = dataWriter.toBufferExposingByteArray(lineSeparator);
            if (FileBasedStorageKt.writeFile$isEqualContent(file, lineSeparator, content, prependXmlProlog)) {
                v4 = content.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toByteArray(...)");
                var9_8 = v4;
                var10_9 = Charsets.UTF_8;
                contentString = new String(var9_8, var10_9);
                message = "Content equals, but it must be handled not at this level: file " + file.getName() + ", content:\n" + contentString;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    ComponentStoreImplKt.LOG.debug(message);
                } else {
                    ComponentStoreImplKt.LOG.warn(message);
                }
            } else if (StorageUtilKt.getDEBUG_LOG() != null && ApplicationManager.getApplication().isUnitTestMode()) {
                StorageUtilKt.setDEBUG_LOG((String)(file.getPath() + ":\n" + content + "\nOld Content:\n" + LoadTextUtil.loadText((VirtualFile)file)));
            }
        }
        FileBasedStorageKt.writeFile$doWrite(requestor, file, dataWriter, lineSeparator, prependXmlProlog);
        return file;
    }

    public static final void writeFile(@NotNull Path file, @NotNull StorageManagerFileWriteRequestor requestor, @NotNull DataWriter dataWriter, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)dataWriter, (String)"dataWriter");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Save " + file, t$iv);
        }
        try {
            dataWriter.writeTo(file, requestor, lineSeparator, prependXmlProlog);
        }
        catch (ReadOnlyModificationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot write " + file, e);
        }
    }

    @NotNull
    public static final VFileCreateEvent creationEvent(@NotNull Path file, @NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        FileAttributes fileAttributes = FileAttributes.fromNio((Path)file, (BasicFileAttributes)NioFiles.readAttributes((Path)file));
        Intrinsics.checkNotNullExpressionValue((Object)fileAttributes, (String)"fromNio(...)");
        FileAttributes attributes = fileAttributes;
        return new VFileCreateEvent((Object)StorageUtilKt.RELOADING_STORAGE_WRITE_REQUESTOR, dir, ((Object)file.getFileName()).toString(), attributes.isDirectory(), attributes, null, null);
    }

    @NotNull
    public static final VFileContentChangeEvent updatingEvent(@NotNull Path file, @NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        FileAttributes fileAttributes = FileAttributes.fromNio((Path)file, (BasicFileAttributes)NioFiles.readAttributes((Path)file));
        Intrinsics.checkNotNullExpressionValue((Object)fileAttributes, (String)"fromNio(...)");
        FileAttributes attributes = fileAttributes;
        return new VFileContentChangeEvent((Object)StorageUtilKt.RELOADING_STORAGE_WRITE_REQUESTOR, vFile, vFile.getModificationStamp(), -1L, vFile.getTimeStamp(), attributes.lastModified, vFile.getLength(), attributes.length);
    }

    @NotNull
    public static final Pair<Element, LineSeparator> loadDataAndDetectLineSeparator(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String text = ComponentStorageUtil.loadTextContent((Path)file);
        return TuplesKt.to((Object)SafeStAXStreamBuilderKt.buildNsUnawareJdom((Reader)new StringReader(text)), (Object)FileBasedStorageKt.detectLineSeparator(text));
    }

    private static final LineSeparator detectLineSeparator(CharSequence chars) {
        for (int i = 0; i < chars.length(); ++i) {
            char element = chars.charAt(i);
            if (element == '\r') {
                return LineSeparator.CRLF;
            }
            if (element != '\n') continue;
            return LineSeparator.LF;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit writeFile$doWrite$lambda$2(VirtualFile $file, StorageManagerFileWriteRequestor $requestor, boolean $prependXmlProlog, LineSeparator $lineSeparator, Object $dataWriterOrByteArray) {
        Closeable closeable = $file.getOutputStream((Object)$requestor);
        Throwable throwable = null;
        try {
            OutputStream output = (OutputStream)closeable;
            boolean bl = false;
            if ($prependXmlProlog) {
                output.write(XML_PROLOG);
                output.write($lineSeparator.getSeparatorBytes());
            }
            if ($dataWriterOrByteArray instanceof DataWriter) {
                DataWriter dataWriter = (DataWriter)$dataWriterOrByteArray;
                Intrinsics.checkNotNull((Object)output);
                DataWriter.writeTo$default(dataWriter, output, $lineSeparator, null, 4, null);
            } else {
                Intrinsics.checkNotNull((Object)$dataWriterOrByteArray, (String)"null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                ((BufferExposingByteArrayOutputStream)$dataWriterOrByteArray).writeTo(output);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final boolean writeFile$isEqualContent(VirtualFile file, LineSeparator lineSeparator, BufferExposingByteArrayOutputStream content, boolean prependXmlProlog) {
        int headerLength;
        int n = headerLength = !prependXmlProlog ? 0 : XML_PROLOG.length + lineSeparator.getSeparatorBytes().length;
        if ((int)file.getLength() == headerLength + content.size()) {
            byte[] byArray = file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            byte[] oldContent = byArray;
            if (!prependXmlProlog || ArrayUtil.startsWith((byte[])oldContent, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])oldContent, (int)XML_PROLOG.length, (byte[])lineSeparator.getSeparatorBytes())) {
                boolean bl;
                block5: {
                    Iterable $this$all$iv = (Iterable)RangesKt.until((int)headerLength, (int)oldContent.length);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator = $this$all$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl2 = false;
                            if (oldContent[it] == content.getInternalBuffer()[it - headerLength]) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
        }
        return false;
    }

    private static final void writeFile$doWrite(StorageManagerFileWriteRequestor requestor, VirtualFile file, Object dataWriterOrByteArray, LineSeparator lineSeparator, boolean prependXmlProlog) {
        Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Save " + file.getPresentableUrl(), t$iv);
        }
        if (!file.isWritable()) {
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream;
            if (dataWriterOrByteArray instanceof DataWriter) {
                bufferExposingByteArrayOutputStream = ((DataWriter)dataWriterOrByteArray).toBufferExposingByteArray(lineSeparator);
            } else {
                Intrinsics.checkNotNull((Object)dataWriterOrByteArray, (String)"null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)dataWriterOrByteArray;
            }
            BufferExposingByteArrayOutputStream byteArray = bufferExposingByteArrayOutputStream;
            throw new ReadOnlyModificationException(file, new SaveSession(requestor, file, byteArray, lineSeparator, prependXmlProlog){
                final /* synthetic */ StorageManagerFileWriteRequestor $requestor;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ BufferExposingByteArrayOutputStream $byteArray;
                final /* synthetic */ LineSeparator $lineSeparator;
                final /* synthetic */ boolean $prependXmlProlog;
                {
                    this.$requestor = $requestor;
                    this.$file = $file;
                    this.$byteArray = $byteArray;
                    this.$lineSeparator = $lineSeparator;
                    this.$prependXmlProlog = $prependXmlProlog;
                }

                public Object save(List<VFileEvent> events, Continuation<? super Unit> $completion) {
                    FileBasedStorageKt.access$writeFile$doWrite(this.$requestor, this.$file, this.$byteArray, this.$lineSeparator, this.$prependXmlProlog);
                    return Unit.INSTANCE;
                }
            });
        }
        StorageUtilKt.runAsWriteActionIfNeeded(() -> FileBasedStorageKt.writeFile$doWrite$lambda$2(file, requestor, prependXmlProlog, lineSeparator, dataWriterOrByteArray));
    }

    public static final /* synthetic */ void access$writeFile$doWrite(StorageManagerFileWriteRequestor requestor, VirtualFile file, Object dataWriterOrByteArray, LineSeparator lineSeparator, boolean prependXmlProlog) {
        FileBasedStorageKt.writeFile$doWrite(requestor, file, dataWriterOrByteArray, lineSeparator, prependXmlProlog);
    }

    static {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        XML_PROLOG = byArray;
    }
}

