/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreContentWriter;
import com.intellij.configurationStore.DirectJpsStorageContentWriter;
import com.intellij.configurationStore.JpsStorageContentWriter;
import com.intellij.configurationStore.ProjectStoreImpl;
import com.intellij.configurationStore.ProjectWithModulesSaveSessionProducerManager;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import com.intellij.platform.workspace.jps.serialization.impl.WritableJpsFileContent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J'\u0010\u0018\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J$\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00132\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00110\u001cH\u0016J\u000e\u0010\u001e\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/configurationStore/HalfDirectJpsStorageContentWriter;", "Lcom/intellij/configurationStore/JpsStorageContentWriter;", "session", "Lcom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager;", "store", "Lcom/intellij/configurationStore/ProjectStoreImpl;", "project", "Lcom/intellij/openapi/project/Project;", "moduleManager", "Lcom/intellij/openapi/module/ModuleManager;", "<init>", "(Lcom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager;Lcom/intellij/configurationStore/ProjectStoreImpl;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/ModuleManager;)V", "externalWriter", "Lcom/intellij/configurationStore/DirectJpsStorageContentWriter;", "internalWriter", "Lcom/intellij/configurationStore/ComponentStoreContentWriter;", "saveInternalFileModuleComponent", "", "filePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "componentName", "componentTag", "Lorg/jdom/Element;", "saveExternalFileModuleComponent", "saveFile", "fileUrl", "writer", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/jps/serialization/impl/WritableJpsFileContent;", "writeFilesToDisk", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.configurationStore.impl"})
final class HalfDirectJpsStorageContentWriter
extends JpsStorageContentWriter {
    @NotNull
    private final DirectJpsStorageContentWriter externalWriter;
    @NotNull
    private final ComponentStoreContentWriter internalWriter;

    public HalfDirectJpsStorageContentWriter(@NotNull ProjectWithModulesSaveSessionProducerManager session, @NotNull ProjectStoreImpl store, @NotNull Project project, @NotNull ModuleManager moduleManager) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleManager, (String)"moduleManager");
        super(session, store, project);
        this.externalWriter = new DirectJpsStorageContentWriter(session, store, project, moduleManager);
        this.internalWriter = new ComponentStoreContentWriter(session, store, project);
    }

    @Override
    public void saveInternalFileModuleComponent(@NotNull String filePath, @NotNull String componentName, @Nullable Element componentTag) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.internalWriter.saveComponent(filePath, componentName, componentTag);
    }

    @Override
    public void saveExternalFileModuleComponent(@NotNull String filePath, @NotNull String componentName, @Nullable Element componentTag) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.externalWriter.saveComponent(filePath, componentName, componentTag);
    }

    public void saveFile(@NotNull String fileUrl, @NotNull Function1<? super WritableJpsFileContent, Unit> writer) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        String filePath = JpsPathUtil.urlToPath((String)fileUrl);
        Intrinsics.checkNotNull((Object)filePath);
        if (JpsProjectSerializersImplKt.isExternalModuleFile((String)filePath)) {
            this.externalWriter.saveFile(fileUrl, writer);
        } else {
            super.saveFile(fileUrl, writer);
        }
    }

    @Override
    @Nullable
    public Object writeFilesToDisk(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.externalWriter.writeFilesToDisk($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

