/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.configurationStore.DirectoryBasedSaveSessionProducer;
import com.intellij.configurationStore.ProjectStoreBridgeKt;
import com.intellij.configurationStore.ProjectStoreImpl;
import com.intellij.configurationStore.ProjectWithModulesSaveSessionProducerManager;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import com.intellij.util.PathUtilRt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J'\u0010\u0011\u001a\u00020\u000b2\u000b\u0010\u0012\u001a\u00070\r\u00a2\u0006\u0002\b\u00132\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J'\u0010\u0014\u001a\u00020\u000b2\u000b\u0010\u0012\u001a\u00070\r\u00a2\u0006\u0002\b\u00132\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H&J\u000e\u0010\u0015\u001a\u00020\u000bH\u00a6@\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0017\u001a\u00020\u000b2\u000b\u0010\u0012\u001a\u00070\r\u00a2\u0006\u0002\b\u00132\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/configurationStore/JpsStorageContentWriter;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "session", "Lcom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager;", "store", "Lcom/intellij/configurationStore/ProjectStoreImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager;Lcom/intellij/configurationStore/ProjectStoreImpl;Lcom/intellij/openapi/project/Project;)V", "saveComponent", "", "fileUrl", "", "componentName", "componentTag", "Lorg/jdom/Element;", "saveInternalFileModuleComponent", "filePath", "Lcom/intellij/openapi/util/NlsSafe;", "saveExternalFileModuleComponent", "writeFilesToDisk", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveNonModuleComponent", "getReplacePathMacroMap", "Lcom/intellij/openapi/components/PathMacroMap;", "intellij.platform.configurationStore.impl"})
abstract class JpsStorageContentWriter
implements JpsFileContentWriter {
    @JvmField
    @NotNull
    public final ProjectWithModulesSaveSessionProducerManager session;
    @JvmField
    @NotNull
    public final ProjectStoreImpl store;
    @JvmField
    @NotNull
    public final Project project;

    public JpsStorageContentWriter(@NotNull ProjectWithModulesSaveSessionProducerManager session, @NotNull ProjectStoreImpl store, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.session = session;
        this.store = store;
        this.project = project;
    }

    public void saveComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable Element componentTag) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        String filePath = JpsPathUtil.urlToPath((String)fileUrl);
        if (FileUtilRt.extensionEquals((String)filePath, (String)"iml")) {
            Intrinsics.checkNotNull((Object)filePath);
            this.saveInternalFileModuleComponent(filePath, componentName, componentTag);
        } else {
            Intrinsics.checkNotNull((Object)filePath);
            if (JpsProjectSerializersImplKt.isExternalModuleFile((String)filePath)) {
                this.saveExternalFileModuleComponent(filePath, componentName, componentTag);
            } else {
                this.saveNonModuleComponent(filePath, componentName, componentTag);
            }
        }
    }

    public abstract void saveInternalFileModuleComponent(@NotNull String var1, @NotNull String var2, @Nullable Element var3);

    public abstract void saveExternalFileModuleComponent(@NotNull String var1, @NotNull String var2, @Nullable Element var3);

    @Nullable
    public abstract Object writeFilesToDisk(@NotNull Continuation<? super Unit> var1);

    private final void saveNonModuleComponent(String filePath, String componentName, Element componentTag) {
        block1: {
            SaveSessionProducer producer;
            block0: {
                StateStorageBase stateStorage = ProjectStoreBridgeKt.access$getProjectStateStorage(filePath, this.store, this.project);
                producer = this.session.getProducer(stateStorage);
                if (!(producer instanceof DirectoryBasedSaveSessionProducer)) break block0;
                DirectoryBasedSaveSessionProducer directoryBasedSaveSessionProducer = (DirectoryBasedSaveSessionProducer)producer;
                String string = PathUtilRt.getFileName((String)filePath);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                Object object = componentTag;
                directoryBasedSaveSessionProducer.setFileState(string, componentName, object != null && (object = object.getChildren()) != null ? (Element)CollectionsKt.first((List)object) : null);
                break block1;
            }
            SaveSessionProducer saveSessionProducer = producer;
            if (saveSessionProducer == null) break block1;
            saveSessionProducer.setState(null, componentName, PluginManagerCore.CORE_ID, (Object)componentTag);
        }
    }

    @NotNull
    public PathMacroMap getReplacePathMacroMap(@NotNull String fileUrl) {
        block3: {
            String filePath;
            block2: {
                Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
                filePath = JpsPathUtil.urlToPath((String)fileUrl);
                if (FileUtilRt.extensionEquals((String)filePath, (String)"iml")) break block2;
                Intrinsics.checkNotNull((Object)filePath);
                if (!JpsProjectSerializersImplKt.isExternalModuleFile((String)filePath)) break block3;
            }
            ReplacePathToMacroMap replacePathToMacroMap = new ModulePathMacroManager(PathMacros.getInstance(), () -> JpsStorageContentWriter.getReplacePathMacroMap$lambda$0(this), () -> JpsStorageContentWriter.getReplacePathMacroMap$lambda$1(filePath)).getReplacePathMap();
            Intrinsics.checkNotNullExpressionValue((Object)replacePathToMacroMap, (String)"getReplacePathMap(...)");
            return (PathMacroMap)replacePathToMacroMap;
        }
        ReplacePathToMacroMap replacePathToMacroMap = ProjectPathMacroManager.getInstance((ComponentManager)((ComponentManager)this.project)).getReplacePathMap();
        Intrinsics.checkNotNullExpressionValue((Object)replacePathToMacroMap, (String)"getReplacePathMap(...)");
        return (PathMacroMap)replacePathToMacroMap;
    }

    private static final String getReplacePathMacroMap$lambda$0(JpsStorageContentWriter this$0) {
        return this$0.project.getProjectFilePath();
    }

    private static final String getReplacePathMacroMap$lambda$1(String $filePath) {
        return $filePath;
    }
}

