/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.Macro;
import com.intellij.configurationStore.ModuleStateStorageManager;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.project.ProjectStoreOwner;
import com.intellij.util.messages.MessageBus;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleStore;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0006H\u0014J6\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001c\"\b\b\u0000\u0010\u001d*\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0014J\u001c\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0096@\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/intellij/configurationStore/ModuleStoreImpl;", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleStore;", "module", "Lcom/intellij/openapi/module/Module;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/components/PathMacroManager;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "collectVfsEventsDuringSave", "", "getCollectVfsEventsDuringSave", "()Z", "isReportStatisticAllowed", "stateSpec", "Lcom/intellij/openapi/components/State;", "storageSpec", "Lcom/intellij/openapi/components/Storage;", "getPathMacroManagerForDefaults", "getStorageSpecs", "", "T", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "reloadStates", "", "componentNames", "", "", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setPath", "path", "Ljava/nio/file/Path;", "isNew", "intellij.platform.configurationStore.impl"})
public final class ModuleStoreImpl
extends ComponentStoreImpl
implements ModuleStore {
    @NotNull
    private final PathMacroManager pathMacroManager;
    @NotNull
    private final Project project;
    @NotNull
    private final StateStorageManagerImpl storageManager;

    public ModuleStoreImpl(@NotNull Module module, @NotNull PathMacroManager pathMacroManager) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)pathMacroManager, (String)"pathMacroManager");
        this.pathMacroManager = pathMacroManager;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.storageManager = new ModuleStateStorageManager(new TrackingPathMacroSubstitutorImpl(this.pathMacroManager), module);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public StateStorageManagerImpl getStorageManager() {
        return this.storageManager;
    }

    @Override
    protected boolean getCollectVfsEventsDuringSave() {
        return true;
    }

    @Override
    protected boolean isReportStatisticAllowed(@NotNull State stateSpec, @NotNull Storage storageSpec) {
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)storageSpec, (String)"storageSpec");
        return false;
    }

    @Override
    @NotNull
    protected PathMacroManager getPathMacroManagerForDefaults() {
        return this.pathMacroManager;
    }

    @Override
    @NotNull
    protected <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Project project = this.getProject();
        Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.project.ProjectStoreOwner");
        return ((ProjectStoreOwner)project).getComponentStore().getStoreDescriptor().getModuleStorageSpecs(component, stateSpec, operation, (StateStorageManager)this.getStorageManager(), this.getProject());
    }

    @Override
    @Nullable
    public Object reloadStates(@NotNull Set<String> componentNames, @NotNull Continuation<? super Unit> $completion) {
        MessageBus messageBus = this.getProject().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        Object object = this.batchReloadStates$intellij_platform_configurationStore_impl(componentNames, messageBus, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void setPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.setPath(path, false);
    }

    public void setPath(@NotNull Path path, boolean isNew) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        StateStorageManagerImpl stateStorageManagerImpl = this.getStorageManager();
        List<Macro> list = List.of(new Macro("$MODULE_FILE$", path));
        Intrinsics.checkNotNullExpressionValue(list, (String)"of(...)");
        boolean isMacroAdded = stateStorageManagerImpl.setMacros$intellij_platform_configurationStore_impl(list).isEmpty();
        StateStorageManagerImpl.getOrCreateStorage$default(this.getStorageManager(), "$MODULE_FILE$", RoamingType.DEFAULT, null, null, false, arg_0 -> ModuleStoreImpl.setPath$lambda$0(isMacroAdded, path, isNew, this, arg_0), null, true, 92, null);
    }

    private static final Unit setPath$lambda$0(boolean $isMacroAdded, Path $path, boolean $isNew, ModuleStoreImpl this$0, StateStorage $this$getOrCreateStorage) {
        Intrinsics.checkNotNullParameter((Object)$this$getOrCreateStorage, (String)"$this$getOrCreateStorage");
        if (!($this$getOrCreateStorage instanceof FileBasedStorage)) {
            return Unit.INSTANCE;
        }
        ((FileBasedStorage)$this$getOrCreateStorage).setFile(null, $isMacroAdded ? null : $path);
        if ($isMacroAdded) {
            ((FileBasedStorage)$this$getOrCreateStorage).preloadStorageData($isNew);
        } else {
            this$0.getStorageManager().updatePath("$MODULE_FILE$", $path);
        }
        return Unit.INSTANCE;
    }
}

