/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ComponentStoreWithExtraComponents;
import com.intellij.configurationStore.DefaultProjectElementNormalizerKt;
import com.intellij.configurationStore.DefaultProjectStoreImpl;
import com.intellij.configurationStore.IprProjectStoreDescriptor;
import com.intellij.configurationStore.Macro;
import com.intellij.configurationStore.ProjectIdManager;
import com.intellij.configurationStore.ProjectSaveSessionProducerManagerKt;
import com.intellij.configurationStore.ProjectStateStorageManager;
import com.intellij.configurationStore.ProjectStoreDescriptor;
import com.intellij.configurationStore.ProjectStorePathManager;
import com.intellij.configurationStore.SaveResult;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionProducerManager;
import com.intellij.configurationStore.SaveSessionProducerManagerKt;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.util.io.Ksuid;
import com.intellij.util.messages.MessageBus;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u000202H\u0004J\u000e\u00103\u001a\u0002002\u0006\u00104\u001a\u00020*J\u0018\u00103\u001a\u0002002\u0006\u00105\u001a\u00020*2\b\u00106\u001a\u0004\u0018\u00010\u0004J\u001a\u00107\u001a\u0002002\u0006\u00108\u001a\u00020\u00042\b\u00109\u001a\u0004\u0018\u00010*H\u0002J6\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C\"\b\b\u0000\u0010E*\u00020F2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002HE0H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0004J\u000e\u0010M\u001a\u00020\n2\u0006\u00105\u001a\u00020NJ\u001c\u0010Q\u001a\u0002002\f\u0010R\u001a\b\u0012\u0004\u0012\u00020=0SH\u0086@\u00a2\u0006\u0002\u0010TJ \u0010U\u001a\u0002002\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\nH\u0080@\u00a2\u0006\u0004\bY\u0010ZJ6\u0010[\u001a\u0002002\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\n2\u0006\u0010_\u001a\u00020`H\u0090@\u00a2\u0006\u0004\ba\u0010bJ\u001d\u0010e\u001a\u0002002\u0006\u0010f\u001a\u00020`2\u0006\u0010g\u001a\u00020\nH\u0000\u00a2\u0006\u0002\bhJ\u0012\u0010i\u001a\u0004\u0018\u00010*2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u000b\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001e\u0010(\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u000bR\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010,R\u0011\u0010:\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010,R\u0011\u0010<\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0016\u0010@\u001a\u0004\u0018\u00010=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010?R\u0013\u0010O\u001a\u0004\u0018\u00010*8F\u00a2\u0006\u0006\u001a\u0004\bP\u0010,R\u0014\u0010c\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010\u000b\u00a8\u0006j"}, d2={"Lcom/intellij/configurationStore/ProjectStoreImpl;", "Lcom/intellij/configurationStore/ComponentStoreWithExtraComponents;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "isExternalStorageSupported", "", "()Z", "storeDescriptor", "Lcom/intellij/configurationStore/ProjectStoreDescriptor;", "getStoreDescriptor", "()Lcom/intellij/configurationStore/ProjectStoreDescriptor;", "setStoreDescriptor", "(Lcom/intellij/configurationStore/ProjectStoreDescriptor;)V", "serviceContainer", "Lcom/intellij/openapi/components/ComponentManagerEx;", "getServiceContainer", "()Lcom/intellij/openapi/components/ComponentManagerEx;", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "setLoadPolicy", "(Lcom/intellij/configurationStore/StateLoadPolicy;)V", "value", "isOptimiseTestLoadSpeed", "setOptimiseTestLoadSpeed", "(Z)V", "storageScheme", "Lcom/intellij/openapi/components/StorageScheme;", "getStorageScheme", "()Lcom/intellij/openapi/components/StorageScheme;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "isStoreInitialized", "projectFilePath", "Ljava/nio/file/Path;", "getProjectFilePath", "()Ljava/nio/file/Path;", "workspacePath", "getWorkspacePath", "clearStorages", "", "getPathMacroManagerForDefaults", "Lcom/intellij/openapi/components/PathMacroManager;", "setPath", "path", "file", "template", "loadProjectFromTemplate", "defaultProject", "iprFile", "projectBasePath", "getProjectBasePath", "locationHash", "", "getLocationHash", "()Ljava/lang/String;", "projectWorkspaceId", "getProjectWorkspaceId", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "isProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "directoryStorePath", "getDirectoryStorePath", "reloadStates", "componentNames", "", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doSave", "saveResult", "Lcom/intellij/configurationStore/SaveResult;", "forceSavingAllSettings", "doSave$intellij_platform_configurationStore_impl", "(Lcom/intellij/configurationStore/SaveResult;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveModules", "saveSessions", "", "Lcom/intellij/configurationStore/SaveSession;", "projectSessionManager", "Lcom/intellij/configurationStore/SaveSessionProducerManager;", "saveModules$intellij_platform_configurationStore_impl", "(Ljava/util/List;Lcom/intellij/configurationStore/SaveResult;ZLcom/intellij/configurationStore/SaveSessionProducerManager;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collectVfsEventsDuringSave", "getCollectVfsEventsDuringSave", "commitObsoleteComponents", "session", "isProjectLevel", "commitObsoleteComponents$intellij_platform_configurationStore_impl", "getMachineWorkspacePath", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProjectStoreImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStoreImpl.kt\ncom/intellij/configurationStore/ProjectStoreImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,346:1\n30#2,2:347\n30#2,2:349\n*S KotlinDebug\n*F\n+ 1 ProjectStoreImpl.kt\ncom/intellij/configurationStore/ProjectStoreImpl\n*L\n165#1:347,2\n225#1:349,2\n*E\n"})
public class ProjectStoreImpl
extends ComponentStoreWithExtraComponents
implements IProjectStore {
    @NotNull
    private final Project project;
    public ProjectStoreDescriptor storeDescriptor;
    @NotNull
    private StateLoadPolicy loadPolicy;
    @NotNull
    private final StateStorageManagerImpl storageManager;
    private volatile boolean isStoreInitialized;

    public ProjectStoreImpl(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean bl2 = bl = !this.project.isDefault();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.loadPolicy = StateLoadPolicy.LOAD;
        this.storageManager = new ProjectStateStorageManager(this.project, (Function0<Boolean>)((Function0)() -> ProjectStoreImpl.storageManager$lambda$0(this)));
    }

    @Override
    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public boolean isExternalStorageSupported() {
        return this.getStoreDescriptor().isExternalStorageSupported();
    }

    @NotNull
    public ProjectStoreDescriptor getStoreDescriptor() {
        ProjectStoreDescriptor projectStoreDescriptor = this.storeDescriptor;
        if (projectStoreDescriptor != null) {
            return projectStoreDescriptor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"storeDescriptor");
        return null;
    }

    public void setStoreDescriptor(@NotNull ProjectStoreDescriptor projectStoreDescriptor) {
        Intrinsics.checkNotNullParameter((Object)projectStoreDescriptor, (String)"<set-?>");
        this.storeDescriptor = projectStoreDescriptor;
    }

    @Override
    @NotNull
    protected ComponentManagerEx getServiceContainer() {
        Project project = this.project;
        Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
        return (ComponentManagerEx)project;
    }

    @Override
    @NotNull
    public final StateLoadPolicy getLoadPolicy() {
        return this.loadPolicy;
    }

    public final void setLoadPolicy(@NotNull StateLoadPolicy stateLoadPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)stateLoadPolicy), (String)"<set-?>");
        this.loadPolicy = stateLoadPolicy;
    }

    public boolean isOptimiseTestLoadSpeed() {
        return this.loadPolicy != StateLoadPolicy.LOAD;
    }

    public void setOptimiseTestLoadSpeed(boolean value) {
        this.loadPolicy = value ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    @NotNull
    public StorageScheme getStorageScheme() {
        return this.getStoreDescriptor().getDotIdea() == null ? StorageScheme.DEFAULT : StorageScheme.DIRECTORY_BASED;
    }

    @Override
    @NotNull
    public final StateStorageManagerImpl getStorageManager() {
        return this.storageManager;
    }

    public final boolean isStoreInitialized() {
        return this.isStoreInitialized;
    }

    @NotNull
    public Path getProjectFilePath() {
        return this.storageManager.expandMacro("$PROJECT_FILE$");
    }

    @NotNull
    public Path getWorkspacePath() {
        return this.storageManager.expandMacro("$WORKSPACE_FILE$");
    }

    public final void clearStorages() {
        this.storageManager.clearStorages();
    }

    @Override
    @NotNull
    protected final PathMacroManager getPathMacroManagerForDefaults() {
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.project));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        return pathMacroManager;
    }

    public final void setPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.setPath(path, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPath(@NotNull Path file, @Nullable Project template) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ComponentStoreImplKt.LOG.info("Project store initialization started for path: " + file + " and template: " + template);
        StateStorageManagerImpl storageManager2 = this.storageManager;
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        ArrayList<Object> macros = new ArrayList<Object>(5);
        Path iprFile = null;
        ProjectStoreDescriptor storeDescriptor = ProjectStorePathManager.Companion.getInstance().getStoreDescriptor(file);
        this.setStoreDescriptor(storeDescriptor);
        Path machineWorkspacePath = this.getMachineWorkspacePath(storeDescriptor);
        if (storeDescriptor instanceof IprProjectStoreDescriptor) {
            iprFile = file;
            macros.add(new Macro("$PROJECT_FILE$", file));
            Path userBaseDir = file.getParent();
            workspacePath = userBaseDir.resolve(StringsKt.removeSuffix((String)((Object)file.getFileName()).toString(), (CharSequence)".ipr") + ".iws");
            Path path = machineWorkspacePath;
            if (path == null) {
                path = workspacePath;
            }
            Path path2 = path;
            Intrinsics.checkNotNull((Object)path2);
            macros.add(new Macro("$WORKSPACE_FILE$", path2));
            if (isUnitTestMode) {
                Boolean componentStoreLoadingEnabled = (Boolean)this.project.getUserData(IProjectStore.COMPONENT_STORE_LOADING_ENABLED);
                Boolean bl = componentStoreLoadingEnabled;
                if (bl == null ? Files.notExists(file, new LinkOption[0]) : bl == false) {
                    this.loadPolicy = StateLoadPolicy.NOT_LOAD;
                }
                Intrinsics.checkNotNull((Object)workspacePath);
                macros.add(new Macro("$PRODUCT_WORKSPACE_FILE$", workspacePath));
            }
        } else {
            Map customMacros;
            iprFile = null;
            Path path = storeDescriptor.getDotIdea();
            Intrinsics.checkNotNull((Object)path);
            Path dotIdea = path;
            macros.add(new Macro("$PROJECT_CONFIG_DIR$", dotIdea));
            Path path2 = machineWorkspacePath;
            if (path2 == null) {
                path2 = dotIdea.resolve("workspace.xml");
            }
            workspacePath = path2;
            Intrinsics.checkNotNull((Object)workspacePath);
            macros.add(new Macro("$WORKSPACE_FILE$", workspacePath));
            Path path3 = dotIdea.resolve("misc.xml");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
            macros.add(new Macro("$PROJECT_FILE$", path3));
            if (isUnitTestMode) {
                this.setOptimiseTestLoadSpeed(Files.notExists(file, new LinkOption[0]));
                Path path4 = dotIdea.resolve("product-workspace.xml");
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
                macros.add(new Macro("$PRODUCT_WORKSPACE_FILE$", path4));
            }
            if (!(customMacros = storeDescriptor.customMacros()).isEmpty()) {
                macros.removeIf(arg_0 -> ProjectStoreImpl.setPath$lambda$1(arg_0 -> ProjectStoreImpl.setPath$lambda$0(customMacros, arg_0), arg_0));
                for (Map.Entry entry : customMacros.entrySet()) {
                    String key = (String)entry.getKey();
                    Path value = (Path)entry.getValue();
                    macros.add(new Macro(key, value));
                }
                Intrinsics.checkNotNull((Object)storageManager2, (String)"null cannot be cast to non-null type com.intellij.configurationStore.ProjectStateStorageManager");
                ((ProjectStateStorageManager)storageManager2).setCustomMacros(customMacros);
            }
        }
        Path presentableUrl = storeDescriptor.getDotIdea() == null ? file : storeDescriptor.getProjectIdentityFile();
        String cacheFileName = ProjectUtil.getProjectCacheFileName$default((String)PathsKt.getInvariantSeparatorsPathString((Path)presentableUrl), (String)"", (boolean)false, null, null, (int)28, null);
        Path path = ProjectUtil.getProjectsDataDir().resolve(cacheFileName).resolve("cache-state.xml");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        macros.add(new Macro("$CACHE_FILE$", path));
        storageManager2.setMacros$intellij_platform_configurationStore_impl((List<Macro>)macros);
        if (template != null) {
            this.loadProjectFromTemplate(template, iprFile);
        }
        ComponentManager componentManager = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Object serviceClass$iv = ProjectIdManager.class;
        Object object = componentManager.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, serviceClass$iv);
        }
        ProjectIdManager projectIdManager = (ProjectIdManager)object;
        String string = projectIdManager.getId();
        if (string == null) {
            String string2 = Ksuid.generate();
            projectIdManager.setId(string2);
        }
        if (!isUnitTestMode) {
            void var12_16;
            serviceClass$iv = Registry.Companion.is("rdct.persist.project.settings", false) ? PathManager.getOriginalConfigDir() : PathManager.getConfigDir();
            Intrinsics.checkNotNull((Object)serviceClass$iv);
            Object basePath = serviceClass$iv;
            Path productWorkspaceFile = basePath.resolve("workspace/" + (String)var12_16 + ".xml");
            Intrinsics.checkNotNull((Object)productWorkspaceFile);
            macros.add(new Macro("$PRODUCT_WORKSPACE_FILE$", productWorkspaceFile));
        }
        this.isStoreInitialized = true;
        ComponentStoreImplKt.LOG.info("Project store initialized with paths: " + macros);
    }

    private final void loadProjectFromTemplate(Project defaultProject, Path iprFile) {
        Object object;
        IComponentStore iComponentStore = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)defaultProject));
        Intrinsics.checkNotNull((Object)iComponentStore, (String)"null cannot be cast to non-null type com.intellij.configurationStore.DefaultProjectStoreImpl");
        Element element = ((DefaultProjectStoreImpl)iComponentStore).getStateCopy();
        if (element == null) {
            return;
        }
        Element element2 = element;
        ProjectStoreImpl projectStoreImpl = this;
        try {
            ProjectStoreImpl $this$loadProjectFromTemplate_u24lambda_u240 = projectStoreImpl;
            boolean bl = false;
            if (iprFile == null) {
                Path path = $this$loadProjectFromTemplate_u24lambda_u240.getStoreDescriptor().getDotIdea();
                Intrinsics.checkNotNull((Object)path);
                DefaultProjectElementNormalizerKt.normalizeDefaultProjectElement(defaultProject, element2, path);
            } else {
                DefaultProjectElementNormalizerKt.moveComponentConfiguration(defaultProject, element2, (Function1<? super String, String>)((Function1)ProjectStoreImpl::loadProjectFromTemplate$lambda$0$0), (Function1<? super String, ? extends Path>)((Function1)arg_0 -> ProjectStoreImpl.loadProjectFromTemplate$lambda$0$1($this$loadProjectFromTemplate_u24lambda_u240, iprFile, arg_0)));
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)ComponentStoreImplKt.LOG);
    }

    @NotNull
    public final Path getProjectBasePath() {
        return this.getStoreDescriptor().getHistoricalProjectBasePath();
    }

    @NotNull
    public final String getLocationHash() {
        String prefix = null;
        Path path = null;
        if (this.getStoreDescriptor().getDotIdea() == null) {
            path = this.getProjectFilePath();
            prefix = this.getStoreDescriptor().getProjectName();
        } else {
            path = this.getStoreDescriptor().getProjectIdentityFile();
            prefix = "";
        }
        return prefix + Integer.toHexString(PathsKt.getInvariantSeparatorsPathString((Path)path).hashCode());
    }

    @Nullable
    public String getProjectWorkspaceId() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ProjectIdManager> serviceClass$iv = ProjectIdManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((ProjectIdManager)object).getId();
    }

    @Override
    @NotNull
    protected final <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return this.getStoreDescriptor().getStorageSpecs(component, stateSpec, operation, (StateStorageManager)this.storageManager);
    }

    public final boolean isProjectFile(@NotNull VirtualFile file) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.isInLocalFileSystem()) break block4;
                CharSequence charSequence = file.getNameSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
                if (ProjectCoreUtil.INSTANCE.isProjectOrWorkspaceFile(file, charSequence)) break block5;
            }
            return false;
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String filePath = string;
        Path dotIdea = this.getStoreDescriptor().getDotIdea();
        if (dotIdea == null) {
            return Intrinsics.areEqual((Object)filePath, (Object)PathsKt.getInvariantSeparatorsPathString((Path)this.getStoreDescriptor().getPresentableUrl())) || Intrinsics.areEqual((Object)filePath, (Object)PathsKt.getInvariantSeparatorsPathString((Path)this.storageManager.expandMacro("$WORKSPACE_FILE$")));
        }
        return VfsUtilCore.isAncestorOrSelf((String)PathsKt.getInvariantSeparatorsPathString((Path)dotIdea), (VirtualFile)file);
    }

    @Nullable
    public final Path getDirectoryStorePath() {
        return this.getStoreDescriptor().getDotIdea();
    }

    @Override
    @Nullable
    public final Object reloadStates(@NotNull Set<String> componentNames, @NotNull Continuation<? super Unit> $completion) {
        MessageBus messageBus = this.project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        Object object = this.batchReloadStates$intellij_platform_configurationStore_impl(componentNames, messageBus, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public final Object doSave$intellij_platform_configurationStore_impl(@NotNull SaveResult saveResult, boolean forceSavingAllSettings, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(this, saveResult, forceSavingAllSettings, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ProjectStoreImpl this$0;
            final /* synthetic */ SaveResult $saveResult;
            final /* synthetic */ boolean $forceSavingAllSettings;
            {
                this.this$0 = $receiver;
                this.$saveResult = $saveResult;
                this.$forceSavingAllSettings = $forceSavingAllSettings;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$coroutineScope;
                        ResultKt.throwOnFailure((Object)$result);
                        BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$saveResult, this.$forceSavingAllSettings, null){
                            Object L$0;
                            Object L$1;
                            int label;
                            final /* synthetic */ ProjectStoreImpl this$0;
                            final /* synthetic */ SaveResult $saveResult;
                            final /* synthetic */ boolean $forceSavingAllSettings;
                            {
                                this.this$0 = $receiver;
                                this.$saveResult = $saveResult;
                                this.$forceSavingAllSettings = $forceSavingAllSettings;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        saveSessions = Collections.synchronizedList((List)new ArrayList<E>());
                                        projectSessionManager = this.this$0.createSaveSessionProducerManager$intellij_platform_configurationStore_impl();
                                        Intrinsics.checkNotNull((Object)saveSessions);
                                        this.L$0 = saveSessions;
                                        this.L$1 = projectSessionManager;
                                        this.label = 1;
                                        v0 = this.this$0.saveModules$intellij_platform_configurationStore_impl(saveSessions, this.$saveResult, this.$forceSavingAllSettings, projectSessionManager, (Continuation<? super Unit>)((Continuation)this));
                                        if (v0 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl20
                                    }
                                    case 1: {
                                        projectSessionManager = (SaveSessionProducerManager)this.L$1;
                                        saveSessions = (List)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl20:
                                        // 2 sources

                                        this.L$0 = saveSessions;
                                        this.L$1 = projectSessionManager;
                                        this.label = 2;
                                        v1 = this.this$0.saveSettingsAndCommitComponents$intellij_platform_configurationStore_impl(this.$saveResult, this.$forceSavingAllSettings, projectSessionManager, (Continuation<? super Unit>)((Continuation)this));
                                        if (v1 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl32
                                    }
                                    case 2: {
                                        projectSessionManager = (SaveSessionProducerManager)this.L$1;
                                        saveSessions = (List)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl32:
                                        // 2 sources

                                        Intrinsics.checkNotNull((Object)saveSessions);
                                        projectSessionManager.collectSaveSessions$intellij_platform_configurationStore_impl(saveSessions);
                                        if (!(((Collection)saveSessions).isEmpty() == false)) ** GOTO lbl59
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)saveSessions);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)projectSessionManager);
                                        this.label = 3;
                                        v2 = SaveSessionProducerManagerKt.saveSessions(saveSessions, this.$saveResult, true, (Continuation<? super Unit>)((Continuation)this));
                                        if (v2 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl47
                                    }
                                    case 3: {
                                        projectSessionManager = (SaveSessionProducerManager)this.L$1;
                                        saveSessions = (List)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl47:
                                        // 2 sources

                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)saveSessions);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)projectSessionManager);
                                        this.label = 4;
                                        v3 = ProjectSaveSessionProducerManagerKt.validateSaveResult(this.$saveResult, this.this$0.getProject(), (Continuation<? super Unit>)((Continuation)this));
                                        if (v3 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl59
                                    }
                                    case 4: {
                                        projectSessionManager = (SaveSessionProducerManager)this.L$1;
                                        saveSessions = (List)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v3 = $result;
lbl59:
                                        // 3 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        return BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ ProjectStoreImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.this$0.getStoreDescriptor().saveProjectName(this.this$0.getProject(), (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Job> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object saveModules$intellij_platform_configurationStore_impl(@NotNull List<SaveSession> saveSessions2, @NotNull SaveResult saveResult, boolean forceSavingAllSettings, @NotNull SaveSessionProducerManager projectSessionManager, @NotNull Continuation<? super Unit> $completion) {
        return ProjectStoreImpl.saveModules$suspendImpl(this, saveSessions2, saveResult, forceSavingAllSettings, projectSessionManager, $completion);
    }

    static /* synthetic */ Object saveModules$suspendImpl(ProjectStoreImpl $this, List<SaveSession> saveSessions2, SaveResult saveResult, boolean forceSavingAllSettings, SaveSessionProducerManager projectSessionManager, Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    protected final boolean getCollectVfsEventsDuringSave() {
        return true;
    }

    @Override
    public final void commitObsoleteComponents$intellij_platform_configurationStore_impl(@NotNull SaveSessionProducerManager session, boolean isProjectLevel) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (this.getStoreDescriptor().getDotIdea() != null) {
            super.commitObsoleteComponents$intellij_platform_configurationStore_impl(session, true);
        }
    }

    private final Path getMachineWorkspacePath(ProjectStoreDescriptor storeDescriptor) {
        Path projectPath = storeDescriptor.getHistoricalProjectBasePath();
        if (!Intrinsics.areEqual((Object)projectPath.getFileSystem(), (Object)FileSystems.getDefault())) {
            return null;
        }
        EelDescriptor descriptor2 = EelNioBridgeServiceKt.asEelPath((Path)projectPath).getDescriptor();
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(descriptor2.getClass()).getSimpleName(), (Object)"DockerEelDescriptor")) {
            return null;
        }
        int pathHash = FileUtilRt.pathHashCode((String)PathsKt.getInvariantSeparatorsPathString((Path)this.getProjectBasePath()));
        return PathManager.getOriginalConfigDir().resolve("workspace/" + FileUtil.sanitizeFileName((String)descriptor2.getName()) + "." + HexExtensionsKt.toHexString$default((int)pathHash, null, (int)1, null) + ".xml");
    }

    private static final boolean storageManager$lambda$0(ProjectStoreImpl this$0) {
        return this$0.getStoreDescriptor().isExternalStorageSupported();
    }

    private static final boolean setPath$lambda$0(Map $customMacros, Macro it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $customMacros.containsKey(it.key);
    }

    private static final boolean setPath$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String loadProjectFromTemplate$lambda$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "$PROJECT_FILE$";
    }

    private static final Path loadProjectFromTemplate$lambda$0$1(ProjectStoreImpl $this_runCatching, Path $iprFile, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)"workspace.xml") ? $this_runCatching.getWorkspacePath() : $iprFile;
    }
}

