/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateStorageBaseKt;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.platform.settings.SettingsController;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H&R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/configurationStore/SaveSessionProducerBase;", "Lcom/intellij/configurationStore/SaveSessionProducer;", "Lcom/intellij/openapi/vfs/SafeWriteRequestor;", "Lcom/intellij/openapi/vfs/LargeFileWriteRequestor;", "<init>", "()V", "controller", "Lcom/intellij/platform/settings/SettingsController;", "getController", "()Lcom/intellij/platform/settings/SettingsController;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "setState", "", "component", "", "componentName", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "state", "setSerializedState", "element", "Lorg/jdom/Element;", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
public abstract class SaveSessionProducerBase
implements SaveSessionProducer,
SafeWriteRequestor,
LargeFileWriteRequestor {
    @Nullable
    public abstract SettingsController getController();

    @Nullable
    public abstract RoamingType getRoamingType();

    public final void setState(@Nullable Object component, @NotNull String componentName, @NotNull PluginId pluginId, @Nullable Object state) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        if (state == null) {
            if (ClientId.Companion.isCurrentlyUnderLocalId()) {
                this.setSerializedState(componentName, null);
            }
            return;
        }
        Element element = null;
        try {
            element = StateStorageBaseKt.serializeState(state, componentName, pluginId, this.getController(), this.getRoamingType());
        }
        catch (WriteExternalException e) {
            ComponentStoreImplKt.LOG.debug((Throwable)e);
            return;
        }
        catch (Throwable e) {
            ComponentStoreImplKt.LOG.error("Unable to serialize " + componentName + " state", e);
            return;
        }
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            this.setSerializedState(componentName, element);
        }
    }

    public abstract void setSerializedState(@NotNull String var1, @Nullable Element var2);
}

