/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.schemeManager.SchemeFileTracker;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\n\u001a)\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bj\u0002`\u0011H\u0014J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/configurationStore/schemeManager/ProjectSchemeManagerFactory;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createFileChangeSubscriber", "Lkotlin/Function1;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "Lkotlin/ParameterName;", "name", "schemeManager", "", "Lcom/intellij/configurationStore/schemeManager/FileChangeSubscriber;", "pathToFile", "Ljava/nio/file/Path;", "path", "", "pathToFile$intellij_platform_configurationStore_impl", "intellij.platform.configurationStore.impl"})
public final class ProjectSchemeManagerFactory
extends SchemeManagerFactoryBase {
    @NotNull
    private final Project project;

    public ProjectSchemeManagerFactory(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super((ComponentManager)project, coroutineScope, null);
        this.project = project;
    }

    @NotNull
    protected Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    protected Function1<SchemeManagerImpl<?, ?>, Unit> createFileChangeSubscriber() {
        return arg_0 -> ProjectSchemeManagerFactory.createFileChangeSubscriber$lambda$0(this, arg_0);
    }

    @Override
    @NotNull
    public Path pathToFile$intellij_platform_configurationStore_impl(@NotNull String path) {
        Path path2;
        IProjectStore projectStore;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.getProject().isDefault()) {
            Path path3 = Path.of("__not_existent_path__", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
            return path3;
        }
        IComponentStore iComponentStore = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)this.getProject()));
        IProjectStore iProjectStore = projectStore = iComponentStore instanceof IProjectStore ? (IProjectStore)iComponentStore : null;
        Path projectFileDir = iProjectStore != null ? iProjectStore.getDirectoryStorePath() : null;
        Path path4 = projectFileDir;
        if (path4 != null) {
            Path path5 = path4.resolve(path);
            path2 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        } else {
            IProjectStore iProjectStore2 = projectStore;
            if (iProjectStore2 != null) {
                Path path6 = iProjectStore2.getProjectBasePath().resolve("." + path);
                path2 = path6;
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
            } else {
                String string = this.getProject().getBasePath();
                Intrinsics.checkNotNull((Object)string);
                String[] stringArray = new String[]{"." + path};
                Path path7 = Path.of(string, stringArray);
                path2 = path7;
                Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"of(...)");
            }
        }
        return path2;
    }

    private static final Unit createFileChangeSubscriber$lambda$0(ProjectSchemeManagerFactory this$0, SchemeManagerImpl schemeManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)schemeManager), (String)"schemeManager");
        if (!ApplicationManager.getApplication().isUnitTestMode() || Intrinsics.areEqual((Object)this$0.getProject().getUserData(Scheme_implKt.getLISTEN_SCHEME_VFS_CHANGES_IN_TEST_MODE()), (Object)true)) {
            SimpleMessageBusConnection simpleMessageBusConnection = this$0.getProject().getMessageBus().simpleConnect();
            Topic topic = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
            simpleMessageBusConnection.subscribe(topic, new SchemeFileTracker(schemeManager, this$0.getProject()));
        }
        return Unit.INSTANCE;
    }
}

