/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.schemeManager.SchemeChangeApplicatorKt;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.configurationStore.schemeManager.SchemeLoader;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.UpdateScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u00012\u00020\u0004B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\fJ<\u0010\u000e\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\f2\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00110\u0010H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeChangeApplicator;", "T", "Lcom/intellij/openapi/options/Scheme;", "M", "", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "<init>", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)V", "reload", "", "events", "", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "doReload", "lazySchemaLoader", "Lkotlin/Lazy;", "Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nSchemeChangeApplicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemeChangeApplicator.kt\ncom/intellij/configurationStore/schemeManager/SchemeChangeApplicator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n296#2,2:182\n*S KotlinDebug\n*F\n+ 1 SchemeChangeApplicator.kt\ncom/intellij/configurationStore/schemeManager/SchemeChangeApplicator\n*L\n62#1:182,2\n*E\n"})
public final class SchemeChangeApplicator<T extends Scheme, M extends T> {
    @NotNull
    private final SchemeManagerImpl<T, M> schemeManager;

    public SchemeChangeApplicator(@NotNull SchemeManagerImpl<T, M> schemeManager) {
        Intrinsics.checkNotNullParameter(schemeManager, (String)"schemeManager");
        this.schemeManager = schemeManager;
    }

    public final void reload(@NotNull Collection<? extends SchemeChangeEvent<T, M>> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Lazy lazySchemeLoader = LazyKt.lazy(() -> SchemeChangeApplicator.reload$lambda$0(this));
        this.doReload(events, lazySchemeLoader);
        if (lazySchemeLoader.isInitialized()) {
            ((SchemeLoader)lazySchemeLoader.getValue()).apply();
        }
    }

    private final void doReload(Collection<? extends SchemeChangeEvent<T, M>> events, Lazy<SchemeLoader<T, M>> lazySchemaLoader) {
        Object oldActiveScheme = this.schemeManager.getActiveScheme();
        Ref.ObjectRef newActiveScheme = new Ref.ObjectRef();
        SchemeProcessor processor = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
        for (SchemeChangeEvent<T, M> event : SchemeChangeApplicatorKt.sortSchemeChangeEvents(events)) {
            T newScheme;
            Scheme changedScheme;
            Object v0;
            String fileName;
            VirtualFile file;
            block4: {
                event.execute(lazySchemaLoader, this.schemeManager);
                if (!(event instanceof UpdateScheme) || !(file = ((UpdateScheme)event).getFile()).isValid()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
                Iterable $this$firstOrNull$iv = this.schemeManager.getSchemes$intellij_platform_configurationStore_impl();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Scheme it = (Scheme)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)SchemeChangeApplicatorKt.getSchemeFileName(this.schemeManager, it), (Object)fileName)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            if (SchemeChangeApplicatorKt.access$callSchemeContentChangedIfSupported(changedScheme = (Scheme)v0, fileName, file, this.schemeManager)) continue;
            if (changedScheme != null) {
                ((SchemeLoader)lazySchemaLoader.getValue()).removeUpdatedScheme(changedScheme);
                processor.onSchemeDeleted(changedScheme);
            }
            if (!SchemeChangeApplicator.doReload$isNewActiveScheme(newActiveScheme, oldActiveScheme, newScheme = SchemeChangeApplicatorKt.readSchemeFromFile(file, (SchemeLoader)lazySchemaLoader.getValue(), this.schemeManager), this, processor, changedScheme)) continue;
            newActiveScheme.element = newScheme;
        }
        if (newActiveScheme.element != null) {
            this.schemeManager.setActiveScheme$intellij_platform_configurationStore_impl((Scheme)newActiveScheme.element);
            processor.onCurrentSchemeSwitched(oldActiveScheme, (Scheme)newActiveScheme.element, false);
        }
    }

    private static final SchemeLoader reload$lambda$0(SchemeChangeApplicator this$0) {
        return SchemeManagerImpl.createSchemeLoader$intellij_platform_configurationStore_impl$default(this$0.schemeManager, false, 1, null);
    }

    private static final <T extends Scheme, M extends T> boolean doReload$isNewActiveScheme(Ref.ObjectRef<T> newActiveScheme, T oldActiveScheme, T newScheme, SchemeChangeApplicator<T, M> this$0, SchemeProcessor<T, ? super M> processor, M changedScheme) {
        if (newActiveScheme.element != null) {
            return false;
        }
        if (oldActiveScheme == null) {
            return newScheme != null && Intrinsics.areEqual((Object)this$0.schemeManager.getCurrentPendingSchemeName$intellij_platform_configurationStore_impl(), (Object)processor.getSchemeKey(newScheme));
        }
        return changedScheme == oldActiveScheme;
    }
}

