/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeContentChangedHandler;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.RemoveAllSchemes;
import com.intellij.configurationStore.schemeManager.RemoveScheme;
import com.intellij.configurationStore.schemeManager.SchemeAddOrUpdateEvent;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.configurationStore.schemeManager.SchemeDataHolderImpl;
import com.intellij.configurationStore.schemeManager.SchemeLoader;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.SchemeManagerUtilKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.dom.StaxFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a=\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u0002H\u00022\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00062\u0006\u0010\u0007\u001a\u0002H\u0002H\u0000\u00a2\u0006\u0002\u0010\b\u001aS\u0010\t\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u0002H\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\r2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0006H\u0000\u00a2\u0006\u0002\u0010\u000e\u001aH\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00110\u0010\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u0002H\u00022\u0018\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00110\u0010H\u0001\u001aO\u0010\u0013\u001a\u00020\u0014\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u0002H\u00022\b\u0010\u0015\u001a\u0004\u0018\u0001H\u00042\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0006H\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"getSchemeFileName", "", "T", "Lcom/intellij/openapi/options/Scheme;", "M", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "scheme", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;Lcom/intellij/openapi/options/Scheme;)Ljava/lang/String;", "readSchemeFromFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "schemeLoader", "Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/configurationStore/schemeManager/SchemeLoader;Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)Lcom/intellij/openapi/options/Scheme;", "sortSchemeChangeEvents", "", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "inputEvents", "callSchemeContentChangedIfSupported", "", "changedScheme", "fileName", "(Lcom/intellij/openapi/options/Scheme;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)Z", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nSchemeChangeApplicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemeChangeApplicator.kt\ncom/intellij/configurationStore/schemeManager/SchemeChangeApplicatorKt\n+ 2 schemeManagerUtil.kt\ncom/intellij/configurationStore/schemeManager/SchemeManagerUtilKt\n+ 3 schemeLoader.kt\ncom/intellij/configurationStore/schemeManager/SchemeLoaderKt\n*L\n1#1,181:1\n9#2,13:182\n9#2,2:195\n12#2,10:199\n218#3,2:197\n*S KotlinDebug\n*F\n+ 1 SchemeChangeApplicator.kt\ncom/intellij/configurationStore/schemeManager/SchemeChangeApplicatorKt\n*L\n28#1:182,13\n167#1:195,2\n167#1:199,10\n169#1:197,2\n*E\n"})
public final class SchemeChangeApplicatorKt {
    @NotNull
    public static final <T extends Scheme, M extends T> String getSchemeFileName(@NotNull SchemeManagerImpl<T, M> schemeManager, @NotNull T scheme) {
        Intrinsics.checkNotNullParameter(schemeManager, (String)"schemeManager");
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        return schemeManager.getFileName$intellij_platform_configurationStore_impl(scheme) + schemeManager.schemeExtension;
    }

    @Nullable
    public static final <T extends Scheme, M extends T> T readSchemeFromFile(@NotNull VirtualFile file, @NotNull SchemeLoader<T, M> schemeLoader, @NotNull SchemeManagerImpl<T, M> schemeManager) {
        M m;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(schemeLoader, (String)"schemeLoader");
        Intrinsics.checkNotNullParameter(schemeManager, (String)"schemeManager");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        if (file.isDirectory() || !schemeManager.canRead(fileName)) {
            return null;
        }
        boolean $i$f$catchAndLog = false;
        try {
            boolean bl = false;
            m = schemeLoader.loadScheme(fileName, null, file.contentsToByteArray());
        }
        catch (CancellationException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            if (e$iv instanceof ControlFlowException) {
                throw e$iv;
            }
            Logger logger = ComponentStoreImplKt.LOG;
            boolean bl = false;
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            logger.error("Cannot read scheme " + string2, e$iv);
            m = null;
        }
        return (T)m;
    }

    @VisibleForTesting
    @NotNull
    public static final <T extends Scheme, M extends T> Collection<SchemeChangeEvent<T, M>> sortSchemeChangeEvents(@NotNull Collection<? extends SchemeChangeEvent<T, M>> inputEvents) {
        Intrinsics.checkNotNullParameter(inputEvents, (String)"inputEvents");
        if (inputEvents.size() < 2) {
            return inputEvents;
        }
        boolean isThereSomeRemoveEvent = false;
        HashSet<String> existingAddOrUpdate = new HashSet<String>();
        HashSet<String> removedFileNames = new HashSet<String>();
        ArrayList<SchemeChangeEvent<T, M>> result = new ArrayList<SchemeChangeEvent<T, M>>(inputEvents);
        for (int i = result.size() - 1; -1 < i; --i) {
            Object object;
            SchemeChangeEvent<T, M> event = result.get(i);
            if (event instanceof RemoveAllSchemes) {
                for (int j = i - 1; -1 < j; --j) {
                    result.remove(j);
                }
                break;
            }
            if (event instanceof SchemeAddOrUpdateEvent) {
                String fileName;
                Intrinsics.checkNotNullExpressionValue((Object)((SchemeAddOrUpdateEvent)((Object)event)).getFile().getName(), (String)"getName(...)");
                Object object2 = removedFileNames.contains(fileName) ? result.remove(i) : Boolean.valueOf(existingAddOrUpdate.add(fileName));
                continue;
            }
            if (!(event instanceof RemoveScheme)) continue;
            if (existingAddOrUpdate.contains(((RemoveScheme)event).fileName)) {
                object = result.remove(i);
                continue;
            }
            isThereSomeRemoveEvent = true;
            object = removedFileNames.add(((RemoveScheme)event).fileName);
        }
        if (isThereSomeRemoveEvent) {
            CollectionsKt.sortWith((List)result, SchemeChangeApplicatorKt::sortSchemeChangeEvents$lambda$0);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends Scheme, M extends T> boolean callSchemeContentChangedIfSupported(M changedScheme, String fileName, VirtualFile file, SchemeManagerImpl<T, M> schemeManager) {
        Boolean bl;
        if (changedScheme == null || !(schemeManager.getProcessor$intellij_platform_configurationStore_impl() instanceof SchemeContentChangedHandler) || !(schemeManager.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor)) {
            return false;
        }
        ExternalInfo externalInfo = schemeManager.schemeListManager.getExternalInfo(changedScheme);
        if (externalInfo == null) {
            return false;
        }
        ExternalInfo externalInfo2 = externalInfo;
        boolean $i$f$catchAndLog = false;
        try {
            void parser;
            void bytes$iv;
            byte[] bytes;
            boolean bl2 = false;
            byte[] byArray = file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            byte[] byArray2 = bytes = byArray;
            boolean isOldSchemeNaming$iv = schemeManager.isOldSchemeNaming;
            boolean $i$f$lazyPreloadScheme = false;
            XMLStreamReader2 reader$iv = StaxFactory.createXmlStreamReader((byte[])bytes$iv);
            XMLStreamReader xMLStreamReader = (XMLStreamReader)reader$iv;
            String name = SchemeLoaderKt.access$readSchemeNameFromXml(isOldSchemeNaming$iv, (XMLStreamReader)reader$iv);
            boolean bl3 = false;
            Function<String, String> attributeProvider = arg_0 -> SchemeChangeApplicatorKt.callSchemeContentChangedIfSupported$lambda$1$0$0((XMLStreamReader)parser, arg_0);
            String string = name;
            if (string == null) {
                LazySchemeProcessor lazySchemeProcessor = (LazySchemeProcessor)schemeManager.getProcessor$intellij_platform_configurationStore_impl();
                String string2 = FileUtilRt.getNameWithoutExtension((String)fileName);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNameWithoutExtension(...)");
                string = lazySchemeProcessor.getSchemeKey(attributeProvider, string2);
                if (string == null) {
                    throw SchemeManagerUtilKt.nameIsMissed(bytes);
                }
            }
            String schemeName = string;
            SchemeDataHolderImpl dataHolder = new SchemeDataHolderImpl(schemeManager.getProcessor$intellij_platform_configurationStore_impl(), bytes, externalInfo2);
            SchemeProcessor schemeProcessor = schemeManager.getProcessor$intellij_platform_configurationStore_impl();
            Intrinsics.checkNotNull(schemeProcessor, (String)"null cannot be cast to non-null type com.intellij.configurationStore.SchemeContentChangedHandler<M of com.intellij.configurationStore.schemeManager.SchemeChangeApplicatorKt.callSchemeContentChangedIfSupported>");
            ((SchemeContentChangedHandler)schemeProcessor).schemeContentChanged(changedScheme, schemeName, (SchemeDataHolder)dataHolder);
            bl = true;
        }
        catch (CancellationException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            if (e$iv instanceof ControlFlowException) {
                throw e$iv;
            }
            Logger logger = ComponentStoreImplKt.LOG;
            boolean bl4 = false;
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            logger.error("Cannot read scheme " + string, e$iv);
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    private static final <T extends Scheme, M extends T> int sortSchemeChangeEvents$weight(SchemeChangeEvent<T, M> event) {
        return event instanceof SchemeAddOrUpdateEvent ? 1 : 0;
    }

    private static final int sortSchemeChangeEvents$lambda$0(SchemeChangeEvent o1, SchemeChangeEvent o2) {
        Intrinsics.checkNotNull((Object)o1);
        int n = SchemeChangeApplicatorKt.sortSchemeChangeEvents$weight(o1);
        Intrinsics.checkNotNull((Object)o2);
        return n - SchemeChangeApplicatorKt.sortSchemeChangeEvents$weight(o2);
    }

    private static final String callSchemeContentChangedIfSupported$lambda$1$0$0(XMLStreamReader $parser, String it) {
        return $parser.getAttributeValue(null, it);
    }

    public static final /* synthetic */ boolean access$callSchemeContentChangedIfSupported(Scheme changedScheme, String fileName, VirtualFile file, SchemeManagerImpl schemeManager) {
        return SchemeChangeApplicatorKt.callSchemeContentChangedIfSupported(changedScheme, fileName, file, schemeManager);
    }
}

