/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeCollection;
import com.intellij.configurationStore.schemeManager.SchemeListManagerKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0019\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\nJw\u0010\u001b\u001a\u00020\u00182i\u0010\u001c\u001ae\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0011\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u0010\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020 0\f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(!\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00180\u001dH\u0086\b\u00f8\u0001\u0000J\u0015\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00028\u0000\u00a2\u0006\u0002\u0010$J\u001b\u0010%\u001a\u00020\u00182\u0006\u0010#\u001a\u00028\u00002\u0006\u0010&\u001a\u00020'\u00a2\u0006\u0002\u0010(J9\u0010)\u001a\u00020\u00182\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+2\b\u0010,\u001a\u0004\u0018\u00018\u00002\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020'\u0018\u00010.\u00a2\u0006\u0002\u0010/J\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020\r012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u000001H\u0002R\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00062"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeListManager;", "T", "Lcom/intellij/openapi/options/Scheme;", "", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "<init>", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)V", "schemeListRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/configurationStore/schemeManager/SchemeCollection;", "readOnlyExternalizableSchemes", "", "", "getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl", "()Ljava/util/Map;", "schemes", "", "getSchemes", "()Ljava/util/List;", "data", "getData", "()Lcom/intellij/configurationStore/schemeManager/SchemeCollection;", "replaceSchemeList", "", "oldList", "newList", "mutate", "task", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "schemeToInfo", "getExternalInfo", "scheme", "(Lcom/intellij/openapi/options/Scheme;)Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "addScheme", "replaceExisting", "", "(Lcom/intellij/openapi/options/Scheme;Z)V", "setSchemes", "newSchemes", "", "newCurrentScheme", "removeCondition", "Lkotlin/Function1;", "(Ljava/util/List;Lcom/intellij/openapi/options/Scheme;Lkotlin/jvm/functions/Function1;)V", "collectExistingNames", "", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nSchemeListManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemeListManager.kt\ncom/intellij/configurationStore/schemeManager/SchemeListManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n873#2,2:178\n1661#2,3:180\n*S KotlinDebug\n*F\n+ 1 SchemeListManager.kt\ncom/intellij/configurationStore/schemeManager/SchemeListManager\n*L\n132#1:178,2\n168#1:180,3\n*E\n"})
public final class SchemeListManager<T extends Scheme> {
    @NotNull
    private final SchemeManagerImpl<T, ?> schemeManager;
    @NotNull
    private final AtomicReference<SchemeCollection<T>> schemeListRef;
    @NotNull
    private final Map<String, T> readOnlyExternalizableSchemes;

    public SchemeListManager(@NotNull SchemeManagerImpl<T, ?> schemeManager) {
        Intrinsics.checkNotNullParameter(schemeManager, (String)"schemeManager");
        this.schemeManager = schemeManager;
        this.schemeListRef = new AtomicReference<SchemeCollection>(SchemeListManagerKt.access$newSchemeCollection());
        this.readOnlyExternalizableSchemes = new ConcurrentHashMap();
    }

    @NotNull
    public final Map<String, T> getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl() {
        return this.readOnlyExternalizableSchemes;
    }

    @NotNull
    public final List<T> getSchemes() {
        return this.schemeListRef.get().list;
    }

    @NotNull
    public final SchemeCollection<T> getData() {
        SchemeCollection<T> schemeCollection = this.schemeListRef.get();
        Intrinsics.checkNotNullExpressionValue(schemeCollection, (String)"get(...)");
        return schemeCollection;
    }

    public final void replaceSchemeList(@NotNull SchemeCollection<T> oldList, @NotNull SchemeCollection<T> newList) {
        Intrinsics.checkNotNullParameter(oldList, (String)"oldList");
        Intrinsics.checkNotNullParameter(newList, (String)"newList");
        if (!this.schemeListRef.compareAndSet(oldList, newList)) {
            throw new IllegalStateException("Scheme list was modified");
        }
    }

    public final void mutate(@NotNull Function3<? super List<T>, ? super Map<T, ExternalInfo>, ? super Map<String, T>, Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        boolean $i$f$mutate = false;
        SchemeCollection old = (SchemeCollection)this.schemeListRef.get();
        ArrayList list = new ArrayList(old.list);
        IdentityHashMap schemeToInfo = new IdentityHashMap(old.schemeToInfo);
        task.invoke(list, schemeToInfo, this.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl());
        Intrinsics.checkNotNull((Object)old);
        List list2 = Collections.synchronizedList(list);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"synchronizedList(...)");
        Map map2 = Collections.synchronizedMap(schemeToInfo);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(...)");
        this.replaceSchemeList(old, new SchemeCollection(list2, map2));
    }

    @Nullable
    public final ExternalInfo getExternalInfo(@NotNull T scheme) {
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        return this.schemeListRef.get().schemeToInfo.get(scheme);
    }

    public final void addScheme(@NotNull T scheme, boolean replaceExisting) {
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        int toReplace = -1;
        List<T> schemes = this.getSchemes();
        SchemeProcessor processor = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
        Map schemeToInfo = this.schemeListRef.get().schemeToInfo;
        Iterator iterator = ((Iterable)schemes).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ExternalInfo oldInfo;
            int index = n++;
            Scheme existing = (Scheme)iterator.next();
            if (!Intrinsics.areEqual((Object)processor.getSchemeKey(existing), (Object)processor.getSchemeKey(scheme))) continue;
            toReplace = index;
            if (existing == scheme) break;
            if (!Intrinsics.areEqual(existing.getClass(), scheme.getClass())) {
                ComponentStoreImplKt.LOG.warn("'" + processor.getSchemeKey(scheme) + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
            }
            if (!replaceExisting || !processor.isExternalizable(existing) || (oldInfo = schemeToInfo.remove(existing)) == null || !processor.isExternalizable(scheme) || schemeToInfo.containsKey(scheme)) continue;
            schemeToInfo.put(scheme, oldInfo);
        }
        if (toReplace == -1) {
            schemes.add(scheme);
        } else if (replaceExisting || !processor.isExternalizable(scheme)) {
            if (schemes.get(toReplace) != scheme) {
                schemes.set(toReplace, scheme);
            }
        } else {
            ExternalizableScheme externalizableScheme = (ExternalizableScheme)scheme;
            String string = UniqueNameGenerator.generateUniqueName((String)scheme.getName(), this.collectExistingNames((Collection)schemes));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
            SchemeListManagerKt.access$renameScheme(externalizableScheme, string);
            schemes.add(scheme);
        }
        if (processor.isExternalizable(scheme) && !((Collection)this.schemeManager.filesToDelete).isEmpty()) {
            ExternalInfo externalInfo = schemeToInfo.get(scheme);
            if (externalInfo != null) {
                ExternalInfo it = externalInfo;
                boolean bl = false;
                this.schemeManager.filesToDelete.remove(it.getFileName());
            }
        }
        this.schemeManager.processPendingCurrentSchemeName$intellij_platform_configurationStore_impl(scheme);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSchemes(@NotNull List<? extends T> newSchemes, @Nullable T newCurrentScheme, @Nullable Function1<? super T, Boolean> removeCondition) {
        Object destination$iv;
        ConcurrentList concurrentList;
        Intrinsics.checkNotNullParameter(newSchemes, (String)"newSchemes");
        SchemeCollection<T> oldList = this.schemeListRef.get();
        if (ComponentStoreImplKt.LOG.isDebugEnabled()) {
            ComponentStoreImplKt.LOG.debug("setSchemes: old = " + oldList.list.size() + " schemes, " + this.collectExistingNames(oldList.list));
            ComponentStoreImplKt.LOG.debug("setSchemes: new = " + newSchemes.size() + " schemes, " + this.collectExistingNames((Collection)newSchemes));
        }
        if (removeCondition == null) {
            ConcurrentList concurrentList2 = ContainerUtil.createConcurrentList((Collection)newSchemes);
            Intrinsics.checkNotNull((Object)concurrentList2);
            concurrentList = concurrentList2;
        } else {
            void $this$filterTo$iv;
            ConcurrentList concurrentList3 = ContainerUtil.createConcurrentList();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentList3, (String)"createConcurrentList(...)");
            ConcurrentList list = concurrentList3;
            Iterable iterable = oldList.list;
            destination$iv = (Collection)list;
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                Scheme it = (Scheme)element$iv;
                boolean bl = false;
                if (!((Boolean)removeCondition.invoke((Object)it) == false)) continue;
                destination$iv.add(element$iv);
            }
            list.addAll((Collection)newSchemes);
            concurrentList = list;
        }
        ConcurrentList newSchemesMutable = concurrentList;
        destination$iv = ConcurrentCollectionFactory.createConcurrentIdentityMap();
        ConcurrentMap it = destination$iv;
        boolean bl = false;
        it.putAll(oldList.schemeToInfo);
        Object object = destination$iv;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"also(...)");
        Object newSchemeToInfo = object;
        this.schemeManager.retainExternalInfo$intellij_platform_configurationStore_impl(true, (Map)newSchemeToInfo, (List)newSchemesMutable);
        ConcurrentList concurrentList4 = ContainerUtil.createConcurrentList((Collection)((Collection)newSchemesMutable));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList4, (String)"createConcurrentList(...)");
        SchemeCollection newList = new SchemeCollection((List)concurrentList4, (Map)newSchemeToInfo);
        Intrinsics.checkNotNull(oldList);
        this.replaceSchemeList(oldList, newList);
        Object oldCurrentScheme = this.schemeManager.getActiveScheme();
        if (!Intrinsics.areEqual(oldCurrentScheme, newCurrentScheme)) {
            Scheme newScheme = null;
            if (newCurrentScheme != null) {
                this.schemeManager.setActiveScheme$intellij_platform_configurationStore_impl(newCurrentScheme);
                newScheme = (Scheme)newCurrentScheme;
            } else if (oldCurrentScheme != null && !newSchemesMutable.contains(oldCurrentScheme)) {
                newScheme = (Scheme)CollectionsKt.firstOrNull((List)((List)newSchemesMutable));
                this.schemeManager.setActiveScheme$intellij_platform_configurationStore_impl(newScheme);
            } else {
                newScheme = null;
            }
            if (!Intrinsics.areEqual(oldCurrentScheme, newScheme)) {
                this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().onCurrentSchemeSwitched(oldCurrentScheme, newScheme, false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> collectExistingNames(Collection<? extends T> schemes) {
        void var3_3;
        void $this$mapTo$iv;
        Iterable iterable = schemes;
        Collection destination$iv = new HashSet(schemes.size());
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Scheme scheme = (Scheme)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(this.schemeManager.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey((Scheme)it));
        }
        return var3_3;
    }
}

