/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeCollection;
import com.intellij.configurationStore.schemeManager.SchemeDataHolderImpl;
import com.intellij.configurationStore.schemeManager.SchemeListManagerKt;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.SchemeManagerUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.NonLazySchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u00012\u00020\u0004B?\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010#J\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%J\b\u0010&\u001a\u00020\u001dH\u0002J(\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bH\u0002J)\u0010+\u001a\u0004\u0018\u00018\u00012\u0006\u0010)\u001a\u00020\u000b2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0010\u00102\u001a\u0002032\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0013\u00104\u001a\u0002032\u0006\u00105\u001a\u00028\u0001\u00a2\u0006\u0002\u00106R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\f\u0012\n \u0018*\u0004\u0018\u00018\u00008\u0000\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00190\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "T", "Lcom/intellij/openapi/options/Scheme;", "MUTABLE_SCHEME", "", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "oldList", "Lcom/intellij/configurationStore/schemeManager/SchemeCollection;", "preScheduledFilesToDelete", "", "", "isDuringLoad", "", "<init>", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;Lcom/intellij/configurationStore/schemeManager/SchemeCollection;Ljava/util/Set;Z)V", "filesToDelete", "Ljava/util/HashSet;", "schemes", "", "newSchemesOffset", "", "schemeToInfo", "Ljava/util/IdentityHashMap;", "kotlin.jvm.PlatformType", "Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "isApplied", "Ljava/util/concurrent/atomic/AtomicBoolean;", "digest", "Lcom/dynatrace/hash4j/hashing/HashStream64;", "getInfoForExistingScheme", "existingScheme", "(Lcom/intellij/openapi/options/Scheme;)Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "isFromFileWithNewExtension", "fileNameWithoutExtension", "(Lcom/intellij/openapi/options/Scheme;Ljava/lang/String;)Z", "apply", "", "getHashStream", "checkExisting", "schemeKey", "fileName", "extension", "loadScheme", "input", "Ljava/io/InputStream;", "preloadedBytes", "", "(Ljava/lang/String;Ljava/io/InputStream;[B)Lcom/intellij/openapi/options/Scheme;", "isFileScheduledForDeleteInThisLoadSession", "retainProbablyScheduledForDeleteFile", "", "removeUpdatedScheme", "changedScheme", "(Lcom/intellij/openapi/options/Scheme;)V", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nschemeLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 schemeLoader.kt\ncom/intellij/configurationStore/schemeManager/SchemeLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 schemeLoader.kt\ncom/intellij/configurationStore/schemeManager/SchemeLoaderKt\n*L\n1#1,306:1\n60#2,5:307\n60#2,5:319\n363#3,7:312\n218#4,2:324\n*S KotlinDebug\n*F\n+ 1 schemeLoader.kt\ncom/intellij/configurationStore/schemeManager/SchemeLoader\n*L\n59#1:307,5\n126#1:319,5\n94#1:312,7\n162#1:324,2\n*E\n"})
public final class SchemeLoader<T extends Scheme, MUTABLE_SCHEME extends T> {
    @NotNull
    private final SchemeManagerImpl<T, MUTABLE_SCHEME> schemeManager;
    @NotNull
    private final SchemeCollection<T> oldList;
    @NotNull
    private final Set<String> preScheduledFilesToDelete;
    private final boolean isDuringLoad;
    @NotNull
    private final HashSet<String> filesToDelete;
    @NotNull
    private final List<T> schemes;
    private int newSchemesOffset;
    @NotNull
    private final IdentityHashMap<T, ExternalInfo> schemeToInfo;
    @NotNull
    private final AtomicBoolean isApplied;
    @Nullable
    private HashStream64 digest;

    public SchemeLoader(@NotNull SchemeManagerImpl<T, MUTABLE_SCHEME> schemeManager, @NotNull SchemeCollection<T> oldList, @NotNull Set<String> preScheduledFilesToDelete, boolean isDuringLoad) {
        Intrinsics.checkNotNullParameter(schemeManager, (String)"schemeManager");
        Intrinsics.checkNotNullParameter(oldList, (String)"oldList");
        Intrinsics.checkNotNullParameter(preScheduledFilesToDelete, (String)"preScheduledFilesToDelete");
        this.schemeManager = schemeManager;
        this.oldList = oldList;
        this.preScheduledFilesToDelete = preScheduledFilesToDelete;
        this.isDuringLoad = isDuringLoad;
        this.filesToDelete = new HashSet();
        this.schemes = CollectionsKt.toMutableList((Collection)this.oldList.list);
        this.newSchemesOffset = this.schemes.size();
        this.schemeToInfo = new IdentityHashMap(this.oldList.schemeToInfo);
        this.isApplied = new AtomicBoolean();
    }

    private final ExternalInfo getInfoForExistingScheme(T existingScheme) {
        ExternalInfo externalInfo = this.schemeToInfo.get(existingScheme);
        if (externalInfo == null) {
            externalInfo = this.schemeManager.schemeListManager.getExternalInfo(existingScheme);
        }
        return externalInfo;
    }

    private final boolean isFromFileWithNewExtension(T existingScheme, String fileNameWithoutExtension) {
        ExternalInfo externalInfo = this.getInfoForExistingScheme(existingScheme);
        return Intrinsics.areEqual((Object)(externalInfo != null ? externalInfo.fileNameWithoutExtension : null), (Object)fileNameWithoutExtension);
    }

    @NotNull
    public final List<T> apply() {
        ComponentStoreImplKt.LOG.assertTrue(this.isApplied.compareAndSet(false, true));
        if (!this.filesToDelete.isEmpty() || !this.preScheduledFilesToDelete.isEmpty()) {
            Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Schedule to delete: " + CollectionsKt.joinToString$default((Iterable)this.filesToDelete, null, null, null, (int)0, null, null, (int)63, null) + " (and preScheduledFilesToDelete: " + CollectionsKt.joinToString$default((Iterable)this.preScheduledFilesToDelete, null, null, null, (int)0, null, null, (int)63, null) + ")", t$iv);
            }
            CollectionsKt.addAll((Collection)this.schemeManager.filesToDelete, (Iterable)this.filesToDelete);
            CollectionsKt.addAll((Collection)this.schemeManager.filesToDelete, (Iterable)this.preScheduledFilesToDelete);
        }
        List<T> newSchemes = this.schemes.subList(this.newSchemesOffset, this.schemes.size());
        this.schemeManager.schemeListManager.replaceSchemeList(this.oldList, SchemeListManagerKt.toSchemeCollection(this.schemes, (Map)this.schemeToInfo));
        if (!this.isDuringLoad) {
            for (Scheme newScheme : newSchemes) {
                SchemeProcessor schemeProcessor = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
                Intrinsics.checkNotNull((Object)newScheme, (String)"null cannot be cast to non-null type MUTABLE_SCHEME of com.intellij.configurationStore.schemeManager.SchemeLoader");
                schemeProcessor.onSchemeAdded(newScheme);
            }
        }
        return newSchemes;
    }

    private final HashStream64 getHashStream() {
        HashStream64 result = this.digest;
        if (result == null) {
            HashStream64 hashStream64 = Hashing.komihash5_0().hashStream();
            Intrinsics.checkNotNull((Object)hashStream64);
            this.digest = result = hashStream64;
        } else {
            result.reset();
        }
        return result;
    }

    private final boolean checkExisting(String schemeKey, String fileName, String fileNameWithoutExtension, String extension) {
        ExternalInfo existingInfo;
        int n;
        int index$iv;
        int $i$f$indexOfFirst;
        SchemeProcessor processor;
        block10: {
            processor = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
            List<T> $this$indexOfFirst$iv = this.schemes;
            $i$f$indexOfFirst = 0;
            index$iv = 0;
            for (T item$iv : $this$indexOfFirst$iv) {
                Scheme it = (Scheme)item$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)processor.getSchemeKey(it), (Object)schemeKey)) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = -1;
        }
        int existingSchemeIndex = n;
        Scheme scheme = existingSchemeIndex == -1 ? null : (Scheme)this.schemes.get(existingSchemeIndex);
        if (scheme == null) {
            return true;
        }
        Scheme existingScheme = scheme;
        if (this.schemeManager.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().get(processor.getSchemeKey(existingScheme)) == existingScheme) {
            this.schemes.remove(existingSchemeIndex);
            if (existingSchemeIndex < this.newSchemesOffset) {
                $i$f$indexOfFirst = this.newSchemesOffset;
                this.newSchemesOffset = $i$f$indexOfFirst + -1;
            }
            return true;
        }
        if (processor.isExternalizable(existingScheme) && (existingInfo = this.getInfoForExistingScheme(existingScheme)) != null && !Intrinsics.areEqual((Object)this.schemeManager.schemeExtension, (Object)existingInfo.fileExtension)) {
            this.schemeToInfo.remove(existingScheme);
            existingInfo.scheduleDelete((Set<String>)this.filesToDelete, "from file with old extension");
            this.schemes.remove(existingSchemeIndex);
            if (existingSchemeIndex < this.newSchemesOffset) {
                index$iv = this.newSchemesOffset;
                this.newSchemesOffset = index$iv + -1;
            }
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.schemeManager.schemeExtension, (Object)extension) && this.isFromFileWithNewExtension(existingScheme, fileNameWithoutExtension)) {
            Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Schedule to delete: " + fileName + " (reason: extension mismatch)", t$iv);
            }
            this.filesToDelete.add(fileName);
        } else {
            ComponentStoreImplKt.LOG.warn("Scheme file \"" + fileName + "\" is not loaded because defines duplicated name \"" + schemeKey + "\"");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MUTABLE_SCHEME loadScheme(@NotNull String fileName, @Nullable InputStream input, @Nullable byte[] preloadedBytes) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String extension = this.schemeManager.getFileExtension$intellij_platform_configurationStore_impl(fileName, false);
        if (this.isFileScheduledForDeleteInThisLoadSession(fileName)) {
            ComponentStoreImplKt.LOG.warn("Scheme file \"" + fileName + "\" is not loaded because marked to delete");
            return null;
        }
        SchemeProcessor processor = this.schemeManager.getProcessor$intellij_platform_configurationStore_impl();
        String string = fileName.substring(0, fileName.length() - extension.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String fileNameWithoutExtension = string;
        Scheme scheme = null;
        if (processor instanceof LazySchemeProcessor) {
            void parser;
            void bytes$iv;
            byte[] byArray = preloadedBytes;
            if (preloadedBytes == null) {
                InputStream inputStream = input;
                Intrinsics.checkNotNull((Object)inputStream);
                byArray = inputStream.readAllBytes();
            }
            byte[] bytes = byArray;
            Intrinsics.checkNotNull((Object)bytes);
            byte[] byArray2 = bytes;
            boolean isOldSchemeNaming$iv = this.schemeManager.isOldSchemeNaming;
            boolean $i$f$lazyPreloadScheme = false;
            XMLStreamReader2 reader$iv = StaxFactory.createXmlStreamReader((byte[])bytes$iv);
            XMLStreamReader xMLStreamReader = (XMLStreamReader)reader$iv;
            String name = SchemeLoaderKt.access$readSchemeNameFromXml(isOldSchemeNaming$iv, (XMLStreamReader)reader$iv);
            boolean bl = false;
            Function1 attributeProvider = arg_0 -> SchemeLoader.loadScheme$lambda$0$0((XMLStreamReader)parser, arg_0);
            String string2 = name;
            if (string2 == null && (string2 = ((LazySchemeProcessor)processor).getSchemeKey(arg_0 -> SchemeLoader.loadScheme$lambda$0$1(attributeProvider, arg_0), fileNameWithoutExtension)) == null) {
                throw SchemeManagerUtilKt.nameIsMissed(bytes);
            }
            String schemeKey = string2;
            if (!this.checkExisting(schemeKey, fileName, fileNameWithoutExtension, extension)) {
                return null;
            }
            ExternalInfo externalInfo = SchemeLoader.loadScheme$createInfo(fileNameWithoutExtension, extension, this, schemeKey, null);
            SchemeDataHolderImpl dataHolder = new SchemeDataHolderImpl(processor, bytes, externalInfo);
            Scheme newScheme = LazySchemeProcessor.createScheme$default((LazySchemeProcessor)((LazySchemeProcessor)processor), (SchemeDataHolder)dataHolder, (String)schemeKey, (Function1)attributeProvider, (boolean)false, (int)8, null);
            this.schemeToInfo.put(newScheme, externalInfo);
            this.retainProbablyScheduledForDeleteFile(fileName);
            scheme = newScheme;
        } else {
            Element element = preloadedBytes == null ? JDOMUtil.load((InputStream)input) : JDOMUtil.load((byte[])preloadedBytes);
            Intrinsics.checkNotNull(processor, (String)"null cannot be cast to non-null type com.intellij.openapi.options.NonLazySchemeProcessor<T of com.intellij.configurationStore.schemeManager.SchemeLoader, MUTABLE_SCHEME of com.intellij.configurationStore.schemeManager.SchemeLoader>");
            NonLazySchemeProcessor nonLazySchemeProcessor = (NonLazySchemeProcessor)processor;
            Intrinsics.checkNotNull((Object)element);
            Scheme scheme2 = nonLazySchemeProcessor.readScheme(element, this.isDuringLoad);
            if (scheme2 == null) {
                return null;
            }
            Scheme loadedScheme = scheme2;
            String schemeKey = ((NonLazySchemeProcessor)processor).getSchemeKey(loadedScheme);
            if (!this.checkExisting(schemeKey, fileName, fileNameWithoutExtension, extension)) {
                return null;
            }
            this.schemeToInfo.put(loadedScheme, SchemeLoader.loadScheme$createInfo(fileNameWithoutExtension, extension, this, schemeKey, element));
            this.retainProbablyScheduledForDeleteFile(fileName);
            scheme = loadedScheme;
        }
        Scheme scheme3 = scheme;
        Intrinsics.checkNotNull((Object)scheme3);
        this.schemes.add(scheme3);
        return (MUTABLE_SCHEME)scheme;
    }

    private final boolean isFileScheduledForDeleteInThisLoadSession(String fileName) {
        return this.filesToDelete.contains(fileName);
    }

    private final void retainProbablyScheduledForDeleteFile(String fileName) {
        this.filesToDelete.remove(fileName);
        this.preScheduledFilesToDelete.remove(fileName);
    }

    public final void removeUpdatedScheme(@NotNull MUTABLE_SCHEME changedScheme) {
        Intrinsics.checkNotNullParameter(changedScheme, (String)"changedScheme");
        int index = ContainerUtil.indexOfIdentity(this.schemes, changedScheme);
        if (ComponentStoreImplKt.LOG.assertTrue(index >= 0)) {
            this.schemes.remove(index);
            this.schemeToInfo.remove(changedScheme);
        }
    }

    private static final String loadScheme$lambda$0$0(XMLStreamReader $parser, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $parser.getEventType() == 1 ? $parser.getAttributeValue(null, it) : null;
    }

    private static final String loadScheme$lambda$0$1(Function1 $tmp0, String p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (String)$tmp0.invoke((Object)p0);
    }

    private static final <T extends Scheme, MUTABLE_SCHEME extends T> ExternalInfo loadScheme$createInfo(String fileNameWithoutExtension, String extension, SchemeLoader<T, MUTABLE_SCHEME> this$0, String schemeKey, Element element) {
        ExternalInfo info = new ExternalInfo(fileNameWithoutExtension, extension);
        if (element != null) {
            HashStream64 hashStream = super.getHashStream();
            Scheme_implKt.hashElement((Element)element, (HashStream64)hashStream);
            info.setDigest(hashStream.getAsLong());
        }
        info.setSchemeKey(schemeKey);
        return info;
    }
}

