/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DirectoryBasedSaveSessionProducer;
import com.intellij.configurationStore.DirectoryBasedStorageKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.SaveSessionProducerBase;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.configurationStore.XmlDataWriter;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.settings.SettingsController;
import com.intellij.util.LineSeparator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001/B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u001e\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100 H\u0096@\u00a2\u0006\u0002\u0010!J,\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u00022\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u0015H\u0002J\u0017\u0010*\u001a\u00020\u001e2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0015H\u0000\u00a2\u0006\u0002\b+J\n\u0010,\u001a\u0004\u0018\u00010-H\u0016J\n\u0010.\u001a\u00020\u0010H\u0096\u0080\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage;", "Lcom/intellij/configurationStore/StateStorageBase;", "Lcom/intellij/configurationStore/StateMap;", "dir", "Ljava/nio/file/Path;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "controller", "Lcom/intellij/platform/settings/SettingsController;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/openapi/components/StateSplitter;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/platform/settings/SettingsController;)V", "getController", "()Lcom/intellij/platform/settings/SettingsController;", "componentName", "", "nameToLineSeparatorMap", "", "Lcom/intellij/util/LineSeparator;", "cachedVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "loadData", "getLineSeparator", "name", "analyzeExternalChangesAndUpdateIfNeeded", "", "componentNames", "", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSerializedState", "Lorg/jdom/Element;", "storageData", "component", "", "archive", "", "getVirtualFile", "setVirtualDir", "setVirtualDir$intellij_platform_configurationStore_impl", "createSaveSessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "toString", "DirectorySaveSessionProducer", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDirectoryBasedStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryBasedStorage.kt\ncom/intellij/configurationStore/DirectoryBasedStorage\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,330:1\n37#2,2:331\n*S KotlinDebug\n*F\n+ 1 DirectoryBasedStorage.kt\ncom/intellij/configurationStore/DirectoryBasedStorage\n*L\n81#1:331,2\n*E\n"})
public class DirectoryBasedStorage
extends StateStorageBase<StateMap> {
    @NotNull
    private final Path dir;
    @NotNull
    private final StateSplitter splitter;
    @Nullable
    private final PathMacroSubstitutor pathMacroSubstitutor;
    @Nullable
    private final SettingsController controller;
    @Nullable
    private String componentName;
    @NotNull
    private volatile Map<String, ? extends LineSeparator> nameToLineSeparatorMap;
    @Nullable
    private volatile VirtualFile cachedVirtualFile;

    public DirectoryBasedStorage(@NotNull Path dir, @NotNull StateSplitter splitter, @Nullable PathMacroSubstitutor pathMacroSubstitutor, @Nullable SettingsController controller) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)splitter, (String)"splitter");
        this.dir = dir;
        this.splitter = splitter;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
        this.controller = controller;
        Map map2 = Map.of();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"of(...)");
        this.nameToLineSeparatorMap = map2;
    }

    public /* synthetic */ DirectoryBasedStorage(Path path, StateSplitter stateSplitter, PathMacroSubstitutor pathMacroSubstitutor, SettingsController settingsController, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pathMacroSubstitutor = null;
        }
        if ((n & 8) != 0) {
            settingsController = null;
        }
        this(path, stateSplitter, pathMacroSubstitutor, settingsController);
    }

    @Override
    @Nullable
    public SettingsController getController() {
        return this.controller;
    }

    @Override
    @Nullable
    public RoamingType getRoamingType() {
        return null;
    }

    @Override
    @NotNull
    public StateMap loadData() {
        Map separatorMap;
        Pair pair = DirectoryBasedStorageKt.access$loadComponentsAndDetectLineSeparator(this.dir, this.pathMacroSubstitutor);
        Map elementMap = (Map)pair.component1();
        this.nameToLineSeparatorMap = separatorMap = (Map)pair.component2();
        return StateMap.Companion.fromMap(elementMap);
    }

    private final LineSeparator getLineSeparator(String name) {
        LineSeparator lineSeparator = this.nameToLineSeparatorMap.get(name);
        if (lineSeparator == null) {
            LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
            lineSeparator = lineSeparator2;
            Intrinsics.checkNotNullExpressionValue((Object)lineSeparator2, (String)"getSystemLineSeparator(...)");
        }
        return lineSeparator;
    }

    @Nullable
    public Object analyzeExternalChangesAndUpdateIfNeeded(@NotNull Set<? super String> componentNames, @NotNull Continuation<? super Unit> $completion) {
        return DirectoryBasedStorage.analyzeExternalChangesAndUpdateIfNeeded$suspendImpl(this, componentNames, $completion);
    }

    static /* synthetic */ Object analyzeExternalChangesAndUpdateIfNeeded$suspendImpl(DirectoryBasedStorage $this, Set<? super String> componentNames, Continuation<? super Unit> $completion) {
        block0: {
            StateMap newData = $this.loadData();
            $this.storageDataRef.set(newData);
            String string = $this.componentName;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Boxing.boxBoolean((boolean)componentNames.add(it));
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkNotNullParameter((Object)storageData, (String)"storageData");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.componentName = componentName;
        if (storageData.isEmpty()) {
            return null;
        }
        Element state = new Element("component").setAttribute("name", componentName);
        if (this.splitter instanceof StateSplitterEx) {
            for (String fileName : storageData.keys()) {
                Element subState;
                if (storageData.getState(fileName, archive) == null) {
                    return null;
                }
                ((StateSplitterEx)this.splitter).mergeStateInto(state, subState.clone());
            }
        } else {
            ArrayList<Element> subElements = new ArrayList<Element>();
            for (String fileName : storageData.keys()) {
                Element subState;
                if (storageData.getState(fileName, archive) == null) {
                    return null;
                }
                subElements.add(subState.clone());
            }
            if (!((Collection)subElements).isEmpty()) {
                Collection $this$toTypedArray$iv = subElements;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                this.splitter.mergeStatesInto(state, thisCollection$iv.toArray(new Element[0]));
            }
        }
        return state;
    }

    private final VirtualFile getVirtualFile() {
        VirtualFile result = this.cachedVirtualFile;
        if (result == null) {
            this.cachedVirtualFile = result = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(this.dir);
        }
        return result;
    }

    public final void setVirtualDir$intellij_platform_configurationStore_impl(@Nullable VirtualFile dir) {
        this.cachedVirtualFile = dir;
    }

    @Nullable
    public SaveSessionProducer createSaveSessionProducer() {
        return this.checkIsSavingDisabled() ? null : (SaveSessionProducer)new DirectorySaveSessionProducer(this, (StateMap)this.getStorageData());
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(dir=" + this.dir + ", componentName=" + this.componentName + ")";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\"\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\fH\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\f2\u0006\u0010#\u001a\u00020\u001eH\u0002J\n\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010%\u001a\u00020\u001b2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'H\u0096@\u00a2\u0006\u0002\u0010)J \u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u00072\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'H\u0002J\u0018\u0010,\u001a\u00020\u001b2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/configurationStore/DirectoryBasedStorage$DirectorySaveSessionProducer;", "Lcom/intellij/configurationStore/SaveSessionProducerBase;", "Lcom/intellij/configurationStore/SaveSession;", "Lcom/intellij/configurationStore/DirectoryBasedSaveSessionProducer;", "storage", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "<init>", "(Lcom/intellij/configurationStore/DirectoryBasedStorage;Lcom/intellij/configurationStore/StateMap;)V", "copiedStorageData", "", "", "", "controller", "Lcom/intellij/platform/settings/SettingsController;", "getController", "()Lcom/intellij/platform/settings/SettingsController;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "dirtyFileNames", "Ljava/util/HashSet;", "isSomeFileRemoved", "", "setSerializedState", "", "componentName", "element", "Lorg/jdom/Element;", "setFileState", "fileName", "removeFileData", "doSetState", "subState", "createSaveSession", "save", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveStates", "states", "deleteFiles", "intellij.platform.configurationStore.impl"})
    @SourceDebugExtension(value={"SMAP\nDirectoryBasedStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryBasedStorage.kt\ncom/intellij/configurationStore/DirectoryBasedStorage$DirectorySaveSessionProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1#2:331\n*E\n"})
    private static final class DirectorySaveSessionProducer
    extends SaveSessionProducerBase
    implements SaveSession,
    DirectoryBasedSaveSessionProducer {
        @NotNull
        private final DirectoryBasedStorage storage;
        @NotNull
        private final StateMap originalStates;
        @Nullable
        private Map<String, Object> copiedStorageData;
        @NotNull
        private final HashSet<String> dirtyFileNames;
        private boolean isSomeFileRemoved;

        public DirectorySaveSessionProducer(@NotNull DirectoryBasedStorage storage, @NotNull StateMap originalStates) {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            Intrinsics.checkNotNullParameter((Object)originalStates, (String)"originalStates");
            this.storage = storage;
            this.originalStates = originalStates;
            this.dirtyFileNames = new HashSet();
        }

        @Override
        @Nullable
        public SettingsController getController() {
            return null;
        }

        @Override
        @Nullable
        public RoamingType getRoamingType() {
            return null;
        }

        @Override
        public void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            List stateAndFileNameList;
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            this.storage.componentName = componentName;
            List list = stateAndFileNameList = element == null || element.isEmpty() ? Collections.emptyList() : this.storage.splitter.splitState(element);
            if (stateAndFileNameList.isEmpty()) {
                if (this.copiedStorageData != null) {
                    Map<String, Object> map2 = this.copiedStorageData;
                    Intrinsics.checkNotNull(map2);
                    map2.clear();
                } else if (!this.originalStates.isEmpty()) {
                    this.copiedStorageData = new HashMap();
                }
                return;
            }
            HashSet<Object> existingFiles = new HashSet<Object>(stateAndFileNameList.size());
            for (com.intellij.openapi.util.Pair pair : stateAndFileNameList) {
                Object object = pair.second;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                String string = (String)object;
                Object object2 = pair.first;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first");
                this.doSetState(string, (Element)object2);
                existingFiles.add(pair.second);
            }
            for (String key : this.originalStates.keys()) {
                if (existingFiles.contains(key)) continue;
                this.removeFileData(key);
            }
        }

        @Override
        public void setFileState(@NotNull String fileName, @NotNull String componentName, @Nullable Element element) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            this.storage.componentName = componentName;
            if (element == null) {
                this.removeFileData(fileName);
            } else {
                this.doSetState(fileName, element);
            }
        }

        private final void removeFileData(String fileName) {
            if (this.copiedStorageData == null) {
                this.copiedStorageData = this.originalStates.toMutableMap();
            }
            this.isSomeFileRemoved = true;
            Map<String, Object> map2 = this.copiedStorageData;
            Intrinsics.checkNotNull(map2);
            map2.remove(fileName);
        }

        private final void doSetState(String fileName, Element subState) {
            if (this.copiedStorageData == null) {
                this.copiedStorageData = StateMapKt.setStateAndCloneIfNeeded(fileName, subState, this.originalStates, null);
                if (this.copiedStorageData != null) {
                    this.dirtyFileNames.add(fileName);
                }
            } else {
                Map<String, Object> map2 = this.copiedStorageData;
                Intrinsics.checkNotNull(map2);
                if (StateMapKt.updateState(map2, fileName, subState, null)) {
                    this.dirtyFileNames.add(fileName);
                }
            }
        }

        @Nullable
        public SaveSession createSaveSession() {
            return this.storage.checkIsSavingDisabled() || this.copiedStorageData == null ? null : (SaveSession)this;
        }

        @Nullable
        public Object save(@Nullable List<VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
            Map<String, Object> map2 = this.copiedStorageData;
            Intrinsics.checkNotNull(map2);
            StateMap stateMap = StateMap.Companion.fromMap(map2);
            Map<String, Object> map3 = this.copiedStorageData;
            Intrinsics.checkNotNull(map3);
            if (map3.isEmpty()) {
                VirtualFile dir = this.storage.getVirtualFile();
                if (dir != null && dir.exists()) {
                    NioFiles.deleteRecursively((Path)this.storage.dir);
                    List<VFileEvent> list = events;
                    if (list != null) {
                        Boxing.boxBoolean((boolean)list.add((VFileEvent)new VFileDeleteEvent((Object)this, dir)));
                    }
                }
            } else {
                if (!((Collection)this.dirtyFileNames).isEmpty()) {
                    this.saveStates(stateMap, events);
                }
                if (this.isSomeFileRemoved) {
                    this.deleteFiles(events);
                }
            }
            this.storage.storageDataRef.set(stateMap);
            return Unit.INSTANCE;
        }

        private final void saveStates(StateMap states, List<VFileEvent> events) {
            String[] stringArray = this.storage.pathMacroSubstitutor;
            TrackingPathMacroSubstitutorImpl trackingPathMacroSubstitutorImpl = stringArray instanceof TrackingPathMacroSubstitutorImpl ? (TrackingPathMacroSubstitutorImpl)stringArray : null;
            PathMacroManager macroManager = trackingPathMacroSubstitutorImpl != null ? trackingPathMacroSubstitutorImpl.getMacroManager$intellij_platform_configurationStore_impl() : null;
            NioFiles.createDirectories((Path)this.storage.dir);
            VirtualFile dir = this.storage.getVirtualFile();
            for (String fileName : states.keys()) {
                Element element;
                if (!this.dirtyFileNames.contains(fileName) || StateMap.getElement$default(states, fileName, null, 2, null) == null) continue;
                String string = this.storage.componentName;
                Intrinsics.checkNotNull((Object)string);
                Map rootAttributes = MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)string));
                String debugString = ((Object)this.storage.dir).toString();
                XmlDataWriter dataWriter = new XmlDataWriter("component", CollectionsKt.listOf((Object)element), rootAttributes, macroManager, debugString);
                try {
                    Path file = this.storage.dir.resolve(fileName);
                    Intrinsics.checkNotNull((Object)file);
                    FileBasedStorageKt.writeFile(file, (StorageManagerFileWriteRequestor)this, dataWriter, this.storage.getLineSeparator(fileName), false);
                    if (events == null) continue;
                    VirtualFile virtualFile = dir;
                    VirtualFile vFile = virtualFile != null ? virtualFile.findChild(fileName) : null;
                    if (vFile != null) {
                        events.add((VFileEvent)FileBasedStorageKt.updatingEvent(file, vFile));
                        continue;
                    }
                    if (dir == null) continue;
                    events.add((VFileEvent)FileBasedStorageKt.creationEvent(file, dir));
                }
                catch (IOException e) {
                    ComponentStoreImplKt.LOG.error((Throwable)e);
                }
            }
        }

        private final void deleteFiles(List<VFileEvent> events) {
            Map<String, Object> map2 = this.copiedStorageData;
            Intrinsics.checkNotNull(map2);
            Map<String, Object> copiedStorageData = map2;
            VirtualFile dir = this.storage.getVirtualFile();
            for (Path file : NioFiles.list((Path)this.storage.dir)) {
                String fileName = ((Object)file.getFileName()).toString();
                if (!StringsKt.endsWith$default((String)fileName, (String)".xml", (boolean)false, (int)2, null) || copiedStorageData.containsKey(fileName)) continue;
                Files.deleteIfExists(file);
                if (events == null) continue;
                VirtualFile virtualFile = dir;
                if (virtualFile == null || (virtualFile = virtualFile.findChild(fileName)) == null) continue;
                VirtualFile it = virtualFile;
                boolean bl = false;
                events.add((VFileEvent)new VFileDeleteEvent((Object)this, it));
            }
        }
    }
}

