/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.configurationStore.ComponentInfoKt;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.configurationStore.LocalExportableItem;
import com.intellij.configurationStore.ProjectStorePathCustomizerKt;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.Compressor;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\u001a>\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a@\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u000b\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00132\b\b\u0002\u0010\u0016\u001a\u00020\u0013H\u0007\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0018H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0018H\u0002\u001a&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0013H\u0002\u001a\u0012\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010!\u001a\u00020\nH\u0002\u001a\u0017\u0010\"\u001a\t\u0018\u00010\u0018\u00a2\u0006\u0002\b#2\u0006\u0010$\u001a\u00020%H\u0002\u001a\b\u0010&\u001a\u00020\fH\u0002\u001a(\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0013H\u0000\u001a&\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020%2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002\u001a\"\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00182\b\b\u0001\u00103\u001a\u00020\u0018H\u0002\u001a<\u00104\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u00110\b2\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110\b2\u0006\u0010\u000b\u001a\u00020\u0014H\u0007\u001a\u001a\u00106\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0014H\u0002\u001a\u001a\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001a\u0010:\u001a\u00020\u00132\b\u0010;\u001a\u0004\u0018\u00010\u00182\u0006\u0010<\u001a\u000208H\u0002\u001a \u0010=\u001a\u00020\u00012\u0006\u00109\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010>\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006?"}, d2={"exportSettings", "", "exportableItems", "", "Lcom/intellij/configurationStore/ExportableItem;", "out", "Ljava/io/OutputStream;", "exportableThirdPartyFiles", "", "Lcom/intellij/configurationStore/FileSpec;", "Ljava/nio/file/Path;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "exportInstalledPlugins", "zip", "Lcom/intellij/util/io/Compressor;", "getExportableComponentsMap", "", "isComputePresentableNames", "", "Lcom/intellij/configurationStore/StateStorageManager;", "withDeprecated", "withExportable", "stringify", "", "value", "name", "looksLikeDirectory", "storage", "Lcom/intellij/openapi/components/Storage;", "fileSpec", "getRelativePaths", "getRelativePathOrNull", "fullPath", "getAdditionalExportFile", "Lorg/jetbrains/annotations/NotNull;", "stateAnnotation", "Lcom/intellij/openapi/components/State;", "getAppStorageManager", "isStorageExportable", "simpleName", "getComponentPresentableName", "state", "aClass", "Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "messageOrDefault", "classLoader", "Ljava/lang/ClassLoader;", "bundleName", "defaultName", "getExportableItemsFromLocalStorage", "Lcom/intellij/configurationStore/LocalExportableItem;", "getLocalPath", "loadFileContent", "", "item", "isComponentDefined", "componentName", "bytes", "exportDirectory", "checkIfDirectoryExists", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nExportSettingsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportSettingsAction.kt\ncom/intellij/configurationStore/ExportSettingsActionKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,475:1\n1915#2,2:476\n1586#2:478\n1661#2,3:479\n1642#2,10:483\n1915#2:493\n1586#2:494\n1661#2,3:495\n1916#2:499\n1652#2:500\n1#3:482\n1#3:498\n3938#4:501\n4474#4,2:502\n*S KotlinDebug\n*F\n+ 1 ExportSettingsAction.kt\ncom/intellij/configurationStore/ExportSettingsActionKt\n*L\n213#1:476,2\n289#1:478\n289#1:479,3\n388#1:483,10\n388#1:493\n390#1:494\n390#1:495,3\n388#1:499\n388#1:500\n388#1:498\n224#1:501\n224#1:502,2\n*E\n"})
public final class ExportSettingsActionKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static final void exportSettings(@NotNull Set<ExportableItem> exportableItems, @NotNull OutputStream out, @NotNull Map<FileSpec, ? extends Path> exportableThirdPartyFiles, @NotNull StateStorageManagerImpl storageManager2) {
        Intrinsics.checkNotNullParameter(exportableItems, (String)"exportableItems");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter(exportableThirdPartyFiles, (String)"exportableThirdPartyFiles");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        HashSet filter2 = new HashSet();
        Closeable closeable = (Closeable)new Compressor.Zip(out).filter((arg_0, arg_1) -> ExportSettingsActionKt.exportSettings$lambda$1((arg_0, arg_1) -> ExportSettingsActionKt.exportSettings$lambda$0(filter2, arg_0, arg_1), arg_0, arg_1));
        Throwable throwable = null;
        try {
            Compressor zip = (Compressor)closeable;
            boolean bl = false;
            for (ExportableItem entry : exportableItems) {
                if (entry.fileSpec.isDirectory) {
                    Intrinsics.checkNotNull((Object)zip);
                    ExportSettingsActionKt.exportDirectory(entry, zip, storageManager2);
                    continue;
                }
                byte[] content = ExportSettingsActionKt.loadFileContent(entry, storageManager2);
                if (content == null) continue;
                zip.addFile(entry.fileSpec.relativePath, content);
            }
            for (Map.Entry entry : exportableThirdPartyFiles.entrySet()) {
                FileSpec fileSpec = (FileSpec)entry.getKey();
                Path path = (Path)entry.getValue();
                ComponentStoreImplKt.LOG.assertTrue(!fileSpec.isDirectory, (Object)"fileSpec should not be directory");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                ComponentStoreImplKt.LOG.assertTrue(Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)), (Object)"path should be file");
                zip.addFile(fileSpec.relativePath, Files.readAllBytes(path));
            }
            Intrinsics.checkNotNull((Object)zip);
            ExportSettingsActionKt.exportInstalledPlugins(zip);
            zip.addFile("IntelliJ IDEA Global Settings", ArrayUtil.EMPTY_BYTE_ARRAY);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void exportSettings$default(Set set, OutputStream outputStream, Map map2, StateStorageManagerImpl stateStorageManagerImpl, int n, Object object) {
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            stateStorageManagerImpl = ExportSettingsActionKt.getAppStorageManager();
        }
        ExportSettingsActionKt.exportSettings(set, outputStream, map2, stateStorageManagerImpl);
    }

    @ApiStatus.Internal
    public static final void exportInstalledPlugins(@NotNull Compressor zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        String pluginIds = SequencesKt.joinToString$default((Sequence)SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)PluginManagerCore.getLoadedPlugins()), ExportSettingsActionKt::exportInstalledPlugins$lambda$0), (CharSequence)"\n", null, null, (int)0, null, ExportSettingsActionKt::exportInstalledPlugins$lambda$1, (int)30, null);
        if (((CharSequence)pluginIds).length() > 0) {
            String string = pluginIds;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            zip.addFile("installed.txt", byArray);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static final Map<FileSpec, List<ExportableItem>> getExportableComponentsMap(boolean isComputePresentableNames, @NotNull StateStorageManager storageManager2, boolean withDeprecated, boolean withExportable) {
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        LinkedHashMap result = new LinkedHashMap();
        Function1 processor = arg_0 -> ExportSettingsActionKt.getExportableComponentsMap$lambda$0(result, arg_0);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
        ComponentManagerEx app = (ComponentManagerEx)application;
        if (withExportable) {
            List list = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadServicesFromBeans(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                processor.invoke(element$iv);
            }
        }
        app.processAllImplementationClasses((arg_0, arg_1) -> ExportSettingsActionKt.getExportableComponentsMap$lambda$1(withDeprecated, isComputePresentableNames, withExportable, storageManager2, result, arg_0, arg_1));
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        Intrinsics.checkNotNull((Object)schemeManagerFactory, (String)"null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1<? super SchemeManagerImpl<Scheme, Scheme>, Unit>)((Function1)arg_0 -> ExportSettingsActionKt.getExportableComponentsMap$lambda$2(result, arg_0)));
        return result;
    }

    public static /* synthetic */ Map getExportableComponentsMap$default(boolean bl, StateStorageManager stateStorageManager, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            stateStorageManager = ExportSettingsActionKt.getAppStorageManager();
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        return ExportSettingsActionKt.getExportableComponentsMap(bl, stateStorageManager, bl2, bl3);
    }

    private static final String stringify(boolean value, String name) {
        return value ? name : "not " + name;
    }

    private static final boolean looksLikeDirectory(Storage storage) {
        return !Intrinsics.areEqual((Object)storage.stateSplitter(), StateSplitterEx.class);
    }

    private static final boolean looksLikeDirectory(String fileSpec) {
        return !StringsKt.endsWith$default((String)fileSpec, (String)".xml", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getRelativePaths(Storage storage, StateStorageManager storageManager2, boolean withDeprecated) {
        void $this$mapTo$iv$iv;
        String storagePath = ComponentInfoKt.getPath(storage);
        List relativePaths = new ArrayList();
        if (storage.roamingType() == RoamingType.PER_OS) {
            ((Collection)relativePaths).add(StoreUtilKt.getOsDependentStorage((String)storagePath));
            if (withDeprecated) {
                ((Collection)relativePaths).add(storagePath);
            }
        } else {
            ((Collection)relativePaths).add(storagePath);
        }
        Iterable $this$map$iv = relativePaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path expandedPath = storageManager2.expandMacro((String)it);
            String string2 = ExportSettingsActionKt.getRelativePathOrNull(expandedPath);
            if (string2 == null) {
                string2 = ((Object)expandedPath).toString();
            }
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    private static final String getRelativePathOrNull(Path fullPath) {
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        Path configPath = path;
        if (fullPath.startsWith(configPath)) {
            Path path2 = configPath.relativize(fullPath);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"relativize(...)");
            return PathsKt.getInvariantSeparatorsPathString((Path)path2);
        }
        return null;
    }

    private static final String getAdditionalExportFile(State stateAnnotation) {
        String string;
        String it = string = stateAnnotation.additionalExportDirectory();
        boolean bl = false;
        return ((CharSequence)it).length() > 0 ? string : null;
    }

    private static final StateStorageManagerImpl getAppStorageManager() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        StateStorageManager stateStorageManager = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        Intrinsics.checkNotNull((Object)stateStorageManager, (String)"null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        return (StateStorageManagerImpl)stateStorageManager;
    }

    public static final boolean isStorageExportable(@NotNull String simpleName, @NotNull State stateAnnotation, @NotNull Storage storage, boolean withExportable) {
        Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
        Intrinsics.checkNotNullParameter((Object)stateAnnotation, (String)"stateAnnotation");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (ComponentInfoKt.isSpecialOrNonRoamableStorage(ComponentInfoKt.getPath(storage))) {
            ComponentStoreImplKt.LOG.debug("Storage for class " + simpleName + " is special (non-roamable, not exportable): " + storage);
            return false;
        }
        boolean isRoamable = ComponentInfoKt.getEffectiveRoamingType(storage.roamingType(), ComponentInfoKt.getPath(storage)).isRoamable() && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((Class)storage.storageClass()), (Object)Reflection.getOrCreateKotlinClass(StateStorage.class)) && ((CharSequence)ComponentInfoKt.getPath(storage)).length() > 0;
        boolean isExportable = storage.exportable() || stateAnnotation.exportable();
        ComponentStoreImplKt.LOG.debug("Storage for class " + simpleName + " is " + ExportSettingsActionKt.stringify(isRoamable, "roamable") + ", " + ExportSettingsActionKt.stringify(isExportable, "exportable") + ": " + storage);
        return isRoamable || withExportable && isExportable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getComponentPresentableName(State state, Class<?> aClass, PluginDescriptor pluginDescriptor) {
        String message;
        Object classLoader;
        Object object;
        Class presentableName = state.presentableName();
        if (!Intrinsics.areEqual((Object)presentableName, State.NameGetter.class)) {
            try {
                String string = ((State.NameGetter)ReflectionUtil.newInstance((Class)presentableName)).get();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                return string;
            }
            catch (Exception e) {
                ComponentStoreImplKt.LOG.error((Throwable)e);
            }
        }
        String defaultName = state.name();
        String resourceBundleName = null;
        if (pluginDescriptor != null && !Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)pluginDescriptor.getPluginId())) {
            resourceBundleName = pluginDescriptor.getResourceBundleBaseName();
            if (resourceBundleName == null) {
                if (!Intrinsics.areEqual((Object)pluginDescriptor.getVendor(), (Object)"JetBrains")) return ExportSettingsActionKt.getComponentPresentableName$trimDefaultName(defaultName);
                resourceBundleName = "messages.OptionsBundle";
            }
        } else {
            resourceBundleName = "messages.OptionsBundle";
        }
        if ((object = pluginDescriptor) == null || (object = object.getPluginClassLoader()) == null) {
            object = aClass.getClassLoader();
        }
        if ((classLoader = object) == null || (message = ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, resourceBundleName, defaultName)) == defaultName) return ExportSettingsActionKt.getComponentPresentableName$trimDefaultName(defaultName);
        return message;
    }

    private static final String messageOrDefault(ClassLoader classLoader, String bundleName, @Nls String defaultName) {
        try {
            String string = AbstractBundle.Companion.messageOrDefault(DynamicBundle.getResourceBundle((ClassLoader)classLoader, (String)bundleName), "exportable." + defaultName + ".presentable.name", defaultName, new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        catch (MissingResourceException e) {
            ComponentStoreImplKt.LOG.warn("Missing bundle " + bundleName + " at " + classLoader + ": " + e.getMessage());
            return defaultName;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final Map<Path, List<LocalExportableItem>> getExportableItemsFromLocalStorage(@NotNull Map<FileSpec, ? extends List<ExportableItem>> exportableItems, @NotNull StateStorageManager storageManager2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(exportableItems, (String)"exportableItems");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        Iterable $this$mapNotNull$iv = exportableItems.entrySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            FileSpec fileSpec = (FileSpec)entry.getKey();
            List items = (List)entry.getValue();
            if (ExportSettingsActionKt.getLocalPath(fileSpec, storageManager2) != null) {
                Path path;
                void $this$mapTo$iv$iv;
                boolean bl3 = false;
                Iterable $this$map$iv = items;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ExportableItem exportableItem = (ExportableItem)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(new LocalExportableItem(path, it.presentableName, it.roamingType));
                }
                List localItems = (List)destination$iv$iv2;
                pair = TuplesKt.to((Object)path, (Object)localItems);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final Path getLocalPath(FileSpec fileSpec, StateStorageManager storageManager2) {
        Path path;
        Path it = path = storageManager2.expandMacro("$ROOT_CONFIG$").resolve(fileSpec.relativePath);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
    }

    private static final byte[] loadFileContent(ExportableItem item, StateStorageManagerImpl storageManager2) {
        Path path;
        boolean handledByProvider;
        Ref.ObjectRef content = new Ref.ObjectRef();
        Ref.BooleanRef errorDuringLoadingFromProvider = new Ref.BooleanRef();
        boolean skipProvider = !item.roamingType.isRoamable();
        boolean bl = handledByProvider = !skipProvider && storageManager2.getStreamProvider().read(item.fileSpec.rawFileSpec, item.roamingType, arg_0 -> ExportSettingsActionKt.loadFileContent$lambda$0(content, errorDuringLoadingFromProvider, arg_0));
        if ((!handledByProvider || errorDuringLoadingFromProvider.element) && (path = ExportSettingsActionKt.getLocalPath(item.fileSpec, storageManager2)) != null) {
            byte[] bytes = Files.readAllBytes(path);
            String string = item.componentName;
            Intrinsics.checkNotNull((Object)bytes);
            if (ExportSettingsActionKt.isComponentDefined(string, bytes)) {
                content.element = bytes;
            }
        }
        return (byte[])content.element;
    }

    private static final boolean isComponentDefined(String componentName, byte[] bytes) {
        return componentName == null || StringsKt.contains$default((CharSequence)StringsKt.decodeToString((byte[])bytes), (CharSequence)("<component name=\"" + componentName + "\""), (boolean)false, (int)2, null);
    }

    private static final void exportDirectory(ExportableItem item, Compressor zip, StateStorageManagerImpl storageManager2) {
        Path localPath;
        Ref.BooleanRef error = new Ref.BooleanRef();
        boolean success = storageManager2.getStreamProvider().processChildren(item.fileSpec.relativePath, item.roamingType, ExportSettingsActionKt::exportDirectory$lambda$0, (arg_0, arg_1, arg_2) -> ExportSettingsActionKt.exportDirectory$lambda$1(item, zip, error, arg_0, arg_1, arg_2));
        if ((!success || error.element) && (localPath = ExportSettingsActionKt.getLocalPath(item.fileSpec, storageManager2)) != null) {
            zip.addDirectory(item.fileSpec.relativePath, localPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkIfDirectoryExists(ExportableItem item, StateStorageManagerImpl storageManager2) {
        Ref.BooleanRef exists = new Ref.BooleanRef();
        boolean handledByProvider = storageManager2.getStreamProvider().processChildren(item.fileSpec.relativePath, item.roamingType, ExportSettingsActionKt::checkIfDirectoryExists$lambda$0, (arg_0, arg_1, arg_2) -> ExportSettingsActionKt.checkIfDirectoryExists$lambda$1(exists, arg_0, arg_1, arg_2));
        if (handledByProvider) {
            return exists.element;
        }
        Path localPath = ExportSettingsActionKt.getLocalPath(item.fileSpec, storageManager2);
        if (localPath == null) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(localPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    private static final boolean exportSettings$lambda$0(HashSet $filter, String entryName, Path path) {
        return $filter.add(entryName);
    }

    private static final boolean exportSettings$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final boolean exportInstalledPlugins$lambda$0(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isBundled();
    }

    private static final CharSequence exportInstalledPlugins$lambda$1(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPluginId().getIdString();
    }

    private static final Unit getExportableComponentsMap$lambda$0(LinkedHashMap $result, ExportableComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        File[] fileArray = component.getExportFiles();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"getExportFiles(...)");
        for (File file : fileArray) {
            Path path = file.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            String path2 = ExportSettingsActionKt.getRelativePathOrNull(path);
            if (path2 == null) continue;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            FileSpec fileSpec = new FileSpec(path2, path2, ExportSettingsActionKt.looksLikeDirectory(string));
            String string2 = component.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
            ExportableItem item = new ExportableItem(fileSpec, string2, null, null, 12, null);
            UtilKt.putValue((Map)$result, (Object)fileSpec, (Object)item);
        }
        return Unit.INSTANCE;
    }

    private static final Unit getExportableComponentsMap$lambda$1(boolean $withDeprecated, boolean $isComputePresentableNames, boolean $withExportable, StateStorageManager $storageManager, LinkedHashMap $result, Class aClass, PluginDescriptor pluginDescriptor) {
        String additionalExportFile;
        List storages;
        Intrinsics.checkNotNullParameter((Object)aClass, (String)"aClass");
        State stateAnnotation = StoreUtilKt.getStateSpec((Class)aClass);
        if (stateAnnotation == null || ((CharSequence)stateAnnotation.name()).length() == 0 || ExportableComponent.class.isAssignableFrom(aClass)) {
            return Unit.INSTANCE;
        }
        if (!$withDeprecated) {
            Iterator $this$filterTo$iv$iv;
            Storage[] $this$filter$iv = stateAnnotation.storages();
            boolean $i$f$filter = false;
            Storage[] storageArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Iterator element$iv$iv;
                Iterator it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(!it.deprecated())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v0 = (List)destination$iv$iv;
        } else {
            v0 = storages = ProjectStorePathCustomizerKt.sortStoragesByDeprecated((List)ArraysKt.asList((Object[])stateAnnotation.storages()));
        }
        if (storages.isEmpty()) {
            return Unit.INSTANCE;
        }
        String presentableName = $isComputePresentableNames ? ExportSettingsActionKt.getComponentPresentableName(stateAnnotation, aClass, pluginDescriptor) : "";
        boolean thereIsExportableStorage = false;
        for (Storage storage : storages) {
            String string = aClass.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            boolean exportable = ExportSettingsActionKt.isStorageExportable(string, stateAnnotation, storage, $withExportable);
            if (!exportable) continue;
            thereIsExportableStorage = true;
            List<String> paths = ExportSettingsActionKt.getRelativePaths(storage, $storageManager, $withDeprecated);
            for (String path : paths) {
                FileSpec fileSpec = new FileSpec(path, ComponentInfoKt.getPath(storage), ExportSettingsActionKt.looksLikeDirectory(storage));
                UtilKt.putValue((Map)$result, (Object)fileSpec, (Object)new ExportableItem(fileSpec, presentableName, stateAnnotation.name(), storage.roamingType()));
            }
        }
        if (thereIsExportableStorage && (additionalExportFile = ExportSettingsActionKt.getAdditionalExportFile(stateAnnotation)) != null) {
            FileSpec additionalFileSpec = new FileSpec(additionalExportFile, additionalExportFile, true);
            UtilKt.putValue((Map)$result, (Object)additionalFileSpec, (Object)new ExportableItem(additionalFileSpec, presentableName + " (schemes)", null, null, 12, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit getExportableComponentsMap$lambda$2(LinkedHashMap $result, SchemeManagerImpl it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        if (it.getRoamingType().isRoamable()) {
            FileSpec fileSpec;
            Character c = StringsKt.getOrNull((CharSequence)it.getFileSpec(), (int)0);
            char c2 = '$';
            if (!(c != null && c.charValue() == c2 || $result.containsKey(fileSpec = new FileSpec(it.getFileSpec(), it.getFileSpec(), true)))) {
                Map map2 = $result;
                String string = it.getPresentableName();
                if (string == null) {
                    string = "";
                }
                UtilKt.putValue((Map)map2, (Object)fileSpec, (Object)new ExportableItem(fileSpec, string, null, it.getRoamingType()));
            }
        }
        return Unit.INSTANCE;
    }

    private static final String getComponentPresentableName$trimDefaultName(String defaultName) {
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)defaultName, (CharSequence)".Settings"), (CharSequence)".Settings");
    }

    private static final Unit loadFileContent$lambda$0(Ref.ObjectRef $content, Ref.BooleanRef $errorDuringLoadingFromProvider, InputStream inputStream) {
        block2: {
            InputStream inputStream2 = inputStream;
            if (inputStream2 == null) break block2;
            InputStream it = inputStream2;
            boolean bl = false;
            try {
                $content.element = FileUtil.loadBytes((InputStream)inputStream);
            }
            catch (Exception e) {
                ComponentStoreImplKt.LOG.warn((Throwable)e);
                $errorDuringLoadingFromProvider.element = true;
            }
        }
        return Unit.INSTANCE;
    }

    private static final boolean exportDirectory$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean exportDirectory$lambda$1(ExportableItem $item, Compressor $zip, Ref.BooleanRef $error, String name, InputStream inputStream, boolean bl) {
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            String fileName = $item.fileSpec.relativePath + "/" + name;
            $zip.addFile(fileName, inputStream);
            bl2 = true;
        }
        catch (Exception e) {
            ComponentStoreImplKt.LOG.warn((Throwable)e);
            $error.element = true;
            bl2 = false;
        }
        return bl2;
    }

    private static final boolean checkIfDirectoryExists$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean checkIfDirectoryExists$lambda$1(Ref.BooleanRef $exists, String string, InputStream inputStream, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"<unused var>");
        $exists.element = true;
        return false;
    }

    public static final /* synthetic */ boolean access$checkIfDirectoryExists(ExportableItem item, StateStorageManagerImpl storageManager2) {
        return ExportSettingsActionKt.checkIfDirectoryExists(item, storageManager2);
    }

    public static final /* synthetic */ StateStorageManagerImpl access$getAppStorageManager() {
        return ExportSettingsActionKt.getAppStorageManager();
    }

    public static final /* synthetic */ byte[] access$loadFileContent(ExportableItem item, StateStorageManagerImpl storageManager2) {
        return ExportSettingsActionKt.loadFileContent(item, storageManager2);
    }

    public static final /* synthetic */ boolean access$isComponentDefined(String componentName, byte[] bytes) {
        return ExportSettingsActionKt.isComponentDefined(componentName, bytes);
    }
}

