/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.ProjectStoreBridgeKt;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.SaveSessionProducerManager;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.HashingStrategy;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\nJ \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\nJ\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager;", "Lcom/intellij/configurationStore/SaveSessionProducerManager;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "internalModuleComponents", "Ljava/util/concurrent/ConcurrentMap;", "", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jdom/Element;", "externalModuleComponents", "setModuleComponentState", "", "imlFilePath", "componentName", "componentTag", "setExternalModuleComponentState", "moduleFileName", "commitComponents", "moduleStore", "Lcom/intellij/configurationStore/ComponentStoreImpl;", "moduleSaveSessionManager", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nProjectStoreBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStoreBridge.kt\ncom/intellij/configurationStore/ProjectWithModulesSaveSessionProducerManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,483:1\n1#2:484\n*E\n"})
final class ProjectWithModulesSaveSessionProducerManager
extends SaveSessionProducerManager {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<String, ConcurrentHashMap<String, Element>> internalModuleComponents;
    @NotNull
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Element>> externalModuleComponents;

    public ProjectWithModulesSaveSessionProducerManager(@NotNull Project project) {
        ConcurrentMap concurrentMap;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            ConcurrentMap concurrentMap2 = ConcurrentCollectionFactory.createConcurrentMap();
            Intrinsics.checkNotNull((Object)concurrentMap2);
            concurrentMap = concurrentMap2;
        } else {
            ConcurrentMap concurrentMap3 = ConcurrentCollectionFactory.createConcurrentMap((HashingStrategy)HashingStrategy.caseInsensitive());
            Intrinsics.checkNotNull((Object)concurrentMap3);
            concurrentMap = concurrentMap3;
        }
        this.internalModuleComponents = concurrentMap;
        this.externalModuleComponents = new ConcurrentHashMap();
    }

    public final void setModuleComponentState(@NotNull String imlFilePath, @NotNull String componentName, @Nullable Element componentTag) {
        Intrinsics.checkNotNullParameter((Object)imlFilePath, (String)"imlFilePath");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        ConcurrentHashMap componentToElement = this.internalModuleComponents.computeIfAbsent(imlFilePath, arg_0 -> ProjectWithModulesSaveSessionProducerManager.setModuleComponentState$lambda$1(ProjectWithModulesSaveSessionProducerManager::setModuleComponentState$lambda$0, arg_0));
        Element element = componentTag;
        if (element == null) {
            element = ProjectStoreBridgeKt.access$getNULL_ELEMENT$p();
        }
        componentToElement.put(componentName, element);
    }

    public final void setExternalModuleComponentState(@NotNull String moduleFileName, @NotNull String componentName, @Nullable Element componentTag) {
        Intrinsics.checkNotNullParameter((Object)moduleFileName, (String)"moduleFileName");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        ConcurrentHashMap concurrentHashMap = this.externalModuleComponents.computeIfAbsent(moduleFileName, arg_0 -> ProjectWithModulesSaveSessionProducerManager.setExternalModuleComponentState$lambda$1(ProjectWithModulesSaveSessionProducerManager::setExternalModuleComponentState$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentHashMap, (String)"computeIfAbsent(...)");
        ConcurrentHashMap componentToElement = concurrentHashMap;
        Element element = componentTag;
        if (element == null) {
            element = ProjectStoreBridgeKt.access$getNULL_ELEMENT$p();
        }
        componentToElement.put(componentName, element);
    }

    public final void commitComponents(@NotNull ComponentStoreImpl moduleStore, @NotNull SaveSessionProducerManager moduleSaveSessionManager) {
        block1: {
            Storage storage;
            Intrinsics.checkNotNullParameter((Object)moduleStore, (String)"moduleStore");
            Intrinsics.checkNotNullParameter((Object)moduleSaveSessionManager, (String)"moduleSaveSessionManager");
            Path moduleFilePath = moduleStore.getStorageManager().expandMacro("$MODULE_FILE$");
            ConcurrentHashMap internalComponents = (ConcurrentHashMap)this.internalModuleComponents.get(PathsKt.getInvariantSeparatorsPathString((Path)moduleFilePath));
            if (internalComponents != null) {
                FileStorageAnnotation fileStorageAnnotation = FileStorageAnnotation.MODULE_FILE_STORAGE_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fileStorageAnnotation, (String)"MODULE_FILE_STORAGE_ANNOTATION");
                ProjectWithModulesSaveSessionProducerManager.commitComponents$commitToStorage(moduleStore, moduleSaveSessionManager, (Storage)fileStorageAnnotation, internalComponents);
            }
            String string = FileUtilRt.getNameWithoutExtension((String)((Object)moduleFilePath.getFileName()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            String moduleFileName = string;
            ConcurrentHashMap<String, Element> externalComponents = this.externalModuleComponents.get(moduleFileName);
            if (externalComponents == null || (storage = (Storage)StreamProviderFactory.EP_NAME.computeSafeIfAny((AreaInstance)this.project, ProjectWithModulesSaveSessionProducerManager::commitComponents$lambda$0)) == null) break block1;
            Storage it = storage;
            boolean bl = false;
            ProjectWithModulesSaveSessionProducerManager.commitComponents$commitToStorage(moduleStore, moduleSaveSessionManager, it, (Map<String, ? extends Element>)externalComponents);
        }
    }

    private static final ConcurrentHashMap setModuleComponentState$lambda$0(String it) {
        return new ConcurrentHashMap();
    }

    private static final ConcurrentHashMap setModuleComponentState$lambda$1(Function1 $tmp0, Object p0) {
        return (ConcurrentHashMap)$tmp0.invoke(p0);
    }

    private static final ConcurrentHashMap setExternalModuleComponentState$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ConcurrentHashMap();
    }

    private static final ConcurrentHashMap setExternalModuleComponentState$lambda$1(Function1 $tmp0, Object p0) {
        return (ConcurrentHashMap)$tmp0.invoke(p0);
    }

    private static final void commitComponents$commitToStorage(ComponentStoreImpl $moduleStore, SaveSessionProducerManager $moduleSaveSessionManager, Storage storageSpec, Map<String, ? extends Element> componentToElement) {
        StateStorage storage = $moduleStore.getStorageManager().getStateStorage(storageSpec);
        SaveSessionProducer saveSessionProducer = $moduleSaveSessionManager.getProducer(storage);
        if (saveSessionProducer == null) {
            return;
        }
        SaveSessionProducer producer = saveSessionProducer;
        for (Map.Entry<String, ? extends Element> entry : componentToElement.entrySet()) {
            String componentName = entry.getKey();
            Element componentTag = entry.getValue();
            producer.setState(null, componentName, PluginManagerCore.CORE_ID, (Object)(componentTag == ProjectStoreBridgeKt.access$getNULL_ELEMENT$p() ? null : componentTag));
        }
    }

    private static final Storage commitComponents$lambda$0(StreamProviderFactory it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StreamProviderFactory.getOrCreateStorageSpec$default((StreamProviderFactory)it, (String)"$MODULE_FILE$", null, (int)2, null);
    }
}

