/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StateStorageBaseKt;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.platform.settings.SettingsController;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005JQ\u0010\u0015\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u0001H\u00012\u0006\u0010\u001e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001fJ\u000b\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J1\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00028\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010&J\u0015\u0010 \u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u0007H\u0004\u00a2\u0006\u0002\u0010'J\r\u0010(\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010!J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020*J\b\u0010,\u001a\u00020\u0007H\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u0004\u0018\u00010\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/intellij/configurationStore/StateStorageBase;", "T", "", "Lcom/intellij/openapi/components/StateStorage;", "<init>", "()V", "isSavingDisabled", "", "storageDataRef", "Ljava/util/concurrent/atomic/AtomicReference;", "saveStorageDataOnReload", "getSaveStorageDataOnReload", "()Z", "controller", "Lcom/intellij/platform/settings/SettingsController;", "getController", "()Lcom/intellij/platform/settings/SettingsController;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "getState", "component", "componentName", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "stateClass", "Ljava/lang/Class;", "mergeInto", "reload", "(Ljava/lang/Object;Ljava/lang/String;Lcom/intellij/openapi/extensions/PluginId;Ljava/lang/Class;Ljava/lang/Object;Z)Ljava/lang/Object;", "getStorageData", "()Ljava/lang/Object;", "getSerializedState", "Lorg/jdom/Element;", "storageData", "archive", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Z)Lorg/jdom/Element;", "(Z)Ljava/lang/Object;", "loadData", "disableSaving", "", "enableSaving", "checkIsSavingDisabled", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStateStorageBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateStorageBase.kt\ncom/intellij/configurationStore/StateStorageBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,517:1\n60#2,5:518\n60#2,5:523\n60#2,5:528\n*S KotlinDebug\n*F\n+ 1 StateStorageBase.kt\ncom/intellij/configurationStore/StateStorageBase\n*L\n99#1:518,5\n104#1:523,5\n110#1:528,5\n*E\n"})
public abstract class StateStorageBase<T>
implements StateStorage {
    private boolean isSavingDisabled;
    @JvmField
    @NotNull
    protected final AtomicReference<T> storageDataRef = new AtomicReference();

    protected boolean getSaveStorageDataOnReload() {
        return true;
    }

    @Nullable
    public abstract SettingsController getController();

    @Nullable
    public abstract RoamingType getRoamingType();

    @Nullable
    public final <T> T getState(@Nullable Object component, @NotNull String componentName, @NotNull PluginId pluginId, @NotNull Class<T> stateClass, @Nullable T mergeInto, boolean reload2) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter(stateClass, (String)"stateClass");
        Element stateElement = this.getSerializedState(this.getStorageData(reload2), component, componentName, false);
        return StateStorageBaseKt.deserializeStateWithController(stateElement, stateClass, mergeInto, this.getController(), componentName, pluginId, this.getRoamingType());
    }

    @NotNull
    public final T getStorageData() {
        return this.getStorageData(false);
    }

    @Nullable
    public abstract Element getSerializedState(@NotNull T var1, @Nullable Object var2, @NotNull String var3, boolean var4);

    @NotNull
    protected final T getStorageData(boolean reload2) {
        T currentStorageData = this.storageDataRef.get();
        if (currentStorageData != null && !reload2) {
            return currentStorageData;
        }
        T newStorageData = this.loadData();
        if (reload2 && !this.getSaveStorageDataOnReload()) {
            if (this.storageDataRef.compareAndSet(currentStorageData, null)) {
                return newStorageData;
            }
            return this.getStorageData(true);
        }
        if (this.storageDataRef.compareAndSet(currentStorageData, newStorageData)) {
            return newStorageData;
        }
        return this.getStorageData(false);
    }

    @NotNull
    protected abstract T loadData();

    public final void disableSaving() {
        Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Disable saving: " + this, t$iv);
        }
        this.isSavingDisabled = true;
    }

    public final void enableSaving() {
        Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Enable saving: " + this, t$iv);
        }
        this.isSavingDisabled = false;
    }

    protected final boolean checkIsSavingDisabled() {
        if (this.isSavingDisabled) {
            Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Saving disabled: " + this, t$iv);
            }
            return true;
        }
        return false;
    }
}

