/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.configurationStore.Scheme_implKt;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.schemeManager.ErrorCollector;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.SchemeCollection;
import com.intellij.configurationStore.schemeManager.SchemeDataHolderImpl;
import com.intellij.configurationStore.schemeManager.SchemeListManager;
import com.intellij.configurationStore.schemeManager.SchemeLoader;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.SchemeManagerUtilKt;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.TempUIThemeLookAndFeelInfo;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ApplicationKt;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0011\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u00052\u00020\u0006B\u00c9\u0001\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\n\u0012'\b\u0002\u0010\u0014\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\n0\u0015j\u0002`\u0018\u00123\b\u0002\u0010\u0019\u001a-\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0000\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0015j\u0004\u0018\u0001`\u001c\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\u0004\b!\u0010\"J\b\u0010L\u001a\u00020\u001bH\u0002J\u001c\u0010M\u001a\u00020\u001b2\u0012\u0010N\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000P0OH\u0016J+\u0010Q\u001a\u0004\u0018\u00018\u00002\u0006\u0010R\u001a\u00020\n2\b\u0010S\u001a\u0004\u0018\u00010T2\b\u0010U\u001a\u0004\u0018\u00010VH\u0016\u00a2\u0006\u0002\u0010WJ&\u0010X\u001a\u0004\u0018\u00010Y2\b\u0010U\u001a\u0004\u0018\u00010V2\b\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010R\u001a\u00020\nH\u0002J#\u0010Z\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010[2\b\b\u0002\u0010\\\u001a\u00020+H\u0000\u00a2\u0006\u0002\b]J\u001d\u0010^\u001a\u00020\n2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020+H\u0000\u00a2\u0006\u0002\bbJ\u000e\u0010c\u001a\b\u0012\u0004\u0012\u00028\u00000DH\u0016J\b\u0010d\u001a\u00020\u001bH\u0016J\r\u0010e\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\bfJ\u0019\u0010g\u001a\u0004\u0018\u00010\n2\u0006\u0010h\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\bi\u0010jJ\u000e\u0010k\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020`J\b\u0010l\u001a\u00020\u001bH\u0016J\u001e\u0010m\u001a\u00020\u001b2\u0006\u0010n\u001a\u00020+2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020\u001b0pH\u0002J\u001e\u0010q\u001a\u00020\u001b2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020s02H\u0080@\u00a2\u0006\u0004\bt\u0010uJ\b\u0010v\u001a\u00020\u001eH\u0016J\u001e\u0010w\u001a\u00020\u001b2\u0006\u0010x\u001a\u00020y2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020s02H\u0002J9\u0010z\u001a\u00020\u001b2\u0006\u0010h\u001a\u00028\u00012\u0006\u0010{\u001a\u00020|2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0>2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020s02H\u0002\u00a2\u0006\u0002\u0010}J9\u0010~\u001a\u00020+2\t\u0010\u007f\u001a\u0005\u0018\u00010\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0006\u0010h\u001a\u00028\u00012\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0>H\u0002\u00a2\u0006\u0003\u0010\u0083\u0001J\u0017\u0010\u0084\u0001\u001a\u00020+2\u0006\u0010h\u001a\u00028\u0000H\u0002\u00a2\u0006\u0003\u0010\u0085\u0001J-\u0010\u0086\u0001\u001a\u00020\u001b2\u0006\u0010x\u001a\u00020y2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0>2\f\u0010r\u001a\b\u0012\u0004\u0012\u00020s02H\u0002J\u0011\u0010\u0087\u0001\u001a\u0004\u0018\u000106H\u0000\u00a2\u0006\u0003\b\u0088\u0001J;\u0010\u0089\u0001\u001a\u00020\u001b2\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000H2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00018\u00002\u0010\u0010\u008c\u0001\u001a\u000b\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u008d\u0001H\u0016\u00a2\u0006\u0003\u0010\u008e\u0001J>\u0010\u008f\u0001\u001a\u00020\u001b2\u0007\u0010\u0090\u0001\u001a\u00020+2\u0015\u0010\u0091\u0001\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0005\u0012\u00030\u0080\u00010\u0092\u00012\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000HH\u0000\u00a2\u0006\u0003\b\u0093\u0001J \u0010\u0094\u0001\u001a\u00020\u001b2\u0006\u0010h\u001a\u00028\u00002\u0007\u0010\u0095\u0001\u001a\u00020+H\u0016\u00a2\u0006\u0003\u0010\u0096\u0001J\u001a\u0010\u0097\u0001\u001a\u0004\u0018\u00018\u00002\u0007\u0010\u0098\u0001\u001a\u00020\nH\u0016\u00a2\u0006\u0003\u0010\u0099\u0001J\u0019\u0010\u009a\u0001\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\nH\u0016\u00a2\u0006\u0003\u0010\u0099\u0001J\u0017\u0010\u009a\u0001\u001a\u00020+2\u0006\u0010h\u001a\u00028\u0000H\u0016\u00a2\u0006\u0003\u0010\u0085\u0001J\u001e\u0010\u009a\u0001\u001a\u00020+2\u0006\u0010h\u001a\u00028\u00002\u0007\u0010\u0090\u0001\u001a\u00020+\u00a2\u0006\u0003\u0010\u009b\u0001J\u0017\u0010\u009c\u0001\u001a\u00020+2\u0006\u0010h\u001a\u00028\u0000H\u0016\u00a2\u0006\u0003\u0010\u0085\u0001J\u000b\u0010\u009d\u0001\u001a\u00020\nH\u0096\u0080\u0004J\t\u0010\u009e\u0001\u001a\u00020\u001bH\u0007J2\u0010\u009f\u0001\u001a\u0004\u0018\u00018\u00002\u0007\u0010\u0090\u0001\u001a\u00020+2\u0013\u0010\u00a0\u0001\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020+0\u0015H\u0000\u00a2\u0006\u0006\b\u00a1\u0001\u0010\u00a2\u0001R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010$R-\u0010\u0014\u001a!\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\n0\u0015j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\u0019\u001a-\u0012\u001b\u0012\u0019\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0000\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0015j\u0004\u0018\u0001`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020+8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00028\u0000008\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00028\u0000028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001c\u00105\u001a\u0004\u0018\u000106X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0010\u0010;\u001a\u00020\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\n0>8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010?\u001a\u00020@8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u001a\u0010C\u001a\b\u0012\u0004\u0012\u00020\n0D8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00028\u00000H8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u00104R\u0014\u0010J\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010K\u00a8\u0006\u00a3\u0001"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "T", "Lcom/intellij/openapi/options/Scheme;", "MUTABLE_SCHEME", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerBase;", "Lcom/intellij/openapi/vfs/SafeWriteRequestor;", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "fileSpec", "", "processor", "Lcom/intellij/openapi/options/SchemeProcessor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "ioDirectory", "Ljava/nio/file/Path;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "presentableName", "schemeNameToFileName", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lcom/intellij/configurationStore/SchemeNameToFileName;", "fileChangeSubscriber", "schemeManager", "", "Lcom/intellij/configurationStore/schemeManager/FileChangeSubscriber;", "settingsCategory", "Lcom/intellij/openapi/components/SettingsCategory;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/options/SchemeProcessor;Lcom/intellij/configurationStore/StreamProvider;Ljava/nio/file/Path;Lcom/intellij/openapi/components/RoamingType;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/intellij/openapi/components/SettingsCategory;Lkotlinx/coroutines/CoroutineScope;)V", "getFileSpec", "()Ljava/lang/String;", "getIoDirectory$intellij_platform_configurationStore_impl", "()Ljava/nio/file/Path;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "getPresentableName", "isUpdateVfs", "", "isOldSchemeNaming", "isLoadingSchemes", "Ljava/util/concurrent/atomic/AtomicBoolean;", "schemeListManager", "Lcom/intellij/configurationStore/schemeManager/SchemeListManager;", "schemes", "", "getSchemes$intellij_platform_configurationStore_impl", "()Ljava/util/List;", "cachedVirtualDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCachedVirtualDirectory$intellij_platform_configurationStore_impl", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setCachedVirtualDirectory$intellij_platform_configurationStore_impl", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "schemeExtension", "updateExtension", "filesToDelete", "", "rootDirectory", "Ljava/io/File;", "getRootDirectory", "()Ljava/io/File;", "allSchemeNames", "", "getAllSchemeNames", "()Ljava/util/Collection;", "allSchemes", "", "getAllSchemes", "isEmpty", "()Z", "refreshVirtualDirectory", "loadBundledSchemes", "providers", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/options/SchemeManager$LoadBundleSchemeRequest;", "loadBundledScheme", "resourceName", "requestor", "", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "(Ljava/lang/String;Ljava/lang/Object;Lcom/intellij/openapi/extensions/PluginDescriptor;)Lcom/intellij/openapi/options/Scheme;", "loadBytes", "", "createSchemeLoader", "Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "isDuringLoad", "createSchemeLoader$intellij_platform_configurationStore_impl", "getFileExtension", "fileName", "", "isAllowAny", "getFileExtension$intellij_platform_configurationStore_impl", "loadSchemes", "reload", "removeExternalizableSchemesFromRuntimeState", "removeExternalizableSchemesFromRuntimeState$intellij_platform_configurationStore_impl", "getFileName", "scheme", "getFileName$intellij_platform_configurationStore_impl", "(Lcom/intellij/openapi/options/Scheme;)Ljava/lang/String;", "canRead", "save", "wrapWithIndicator", "forceIndicator", "run", "Lkotlin/Function0;", "saveImpl", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "saveImpl$intellij_platform_configurationStore_impl", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSettingsCategory", "removeDirectoryIfEmpty", "errorCollector", "Lcom/intellij/configurationStore/schemeManager/ErrorCollector;", "saveScheme", "nameGenerator", "Lcom/intellij/util/text/UniqueNameGenerator;", "(Lcom/intellij/openapi/options/Scheme;Lcom/intellij/util/text/UniqueNameGenerator;Ljava/util/Set;Ljava/util/List;)V", "isEqualToBundledScheme", "externalInfo", "Lcom/intellij/configurationStore/schemeManager/ExternalInfo;", "newDigest", "", "(Lcom/intellij/configurationStore/schemeManager/ExternalInfo;JLcom/intellij/openapi/options/Scheme;Ljava/util/Set;)Z", "isRenamed", "(Lcom/intellij/openapi/options/Scheme;)Z", "deleteFiles", "getVirtualDirectory", "getVirtualDirectory$intellij_platform_configurationStore_impl", "setSchemes", "newSchemes", "newCurrentScheme", "removeCondition", "Ljava/util/function/Predicate;", "(Ljava/util/List;Lcom/intellij/openapi/options/Scheme;Ljava/util/function/Predicate;)V", "retainExternalInfo", "isScheduleToDelete", "schemeToInfo", "", "retainExternalInfo$intellij_platform_configurationStore_impl", "addScheme", "replaceExisting", "(Lcom/intellij/openapi/options/Scheme;Z)V", "findSchemeByName", "schemeName", "(Ljava/lang/String;)Lcom/intellij/openapi/options/Scheme;", "removeScheme", "(Lcom/intellij/openapi/options/Scheme;Z)Z", "isMetadataEditable", "toString", "forceSaving", "removeFirstScheme", "condition", "removeFirstScheme$intellij_platform_configurationStore_impl", "(ZLkotlin/jvm/functions/Function1;)Lcom/intellij/openapi/options/Scheme;", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSchemeManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemeManagerImpl.kt\ncom/intellij/configurationStore/schemeManager/SchemeManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SchemeListManager.kt\ncom/intellij/configurationStore/schemeManager/SchemeListManager\n+ 4 schemeLoader.kt\ncom/intellij/configurationStore/schemeManager/SchemeLoaderKt\n+ 5 path.kt\ncom/intellij/util/io/PathKt\n+ 6 schemeManagerUtil.kt\ncom/intellij/configurationStore/schemeManager/SchemeManagerUtilKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,733:1\n1586#2:734\n1661#2,3:735\n296#2,2:792\n1915#2,2:794\n58#3,7:738\n218#4,2:745\n162#5,2:747\n165#5,3:762\n162#5,6:775\n9#6,13:749\n9#6,13:796\n60#7,5:765\n60#7,5:770\n60#7,5:782\n60#7,5:787\n1#8:781\n*S KotlinDebug\n*F\n+ 1 SchemeManagerImpl.kt\ncom/intellij/configurationStore/schemeManager/SchemeManagerImpl\n*L\n115#1:734\n115#1:735,3\n677#1:792,2\n695#1:794,2\n135#1:738,7\n165#1:745,2\n266#1:747,2\n266#1:762,3\n417#1:775,6\n268#1:749,13\n256#1:796,13\n317#1:765,5\n321#1:770,5\n600#1:782,5\n614#1:787,5\n*E\n"})
public final class SchemeManagerImpl<T extends Scheme, MUTABLE_SCHEME extends T>
extends SchemeManagerBase<T, MUTABLE_SCHEME>
implements SafeWriteRequestor,
StorageManagerFileWriteRequestor {
    @Nullable
    private final Project project;
    @NotNull
    private final String fileSpec;
    @Nullable
    private final StreamProvider provider;
    @NotNull
    private final Path ioDirectory;
    @NotNull
    private final RoamingType roamingType;
    @Nullable
    private final String presentableName;
    @NotNull
    private final Function1<String, String> schemeNameToFileName;
    @Nullable
    private final Function1<SchemeManagerImpl<?, ?>, Unit> fileChangeSubscriber;
    @NotNull
    private final SettingsCategory settingsCategory;
    private final boolean isUpdateVfs;
    @JvmField
    public final boolean isOldSchemeNaming;
    @NotNull
    private final AtomicBoolean isLoadingSchemes;
    @JvmField
    @NotNull
    public final SchemeListManager<T> schemeListManager;
    @Nullable
    private volatile VirtualFile cachedVirtualDirectory;
    @JvmField
    @NotNull
    public final String schemeExtension;
    private final boolean updateExtension;
    @JvmField
    @NotNull
    public final Set<String> filesToDelete;

    public SchemeManagerImpl(@Nullable Project project, @NotNull String fileSpec, @NotNull SchemeProcessor<T, ? super MUTABLE_SCHEME> processor, @Nullable StreamProvider provider, @NotNull Path ioDirectory, @NotNull RoamingType roamingType, @Nullable String presentableName, @NotNull Function1<? super String, String> schemeNameToFileName, @Nullable Function1<? super SchemeManagerImpl<?, ?>, Unit> fileChangeSubscriber, @NotNull SettingsCategory settingsCategory, @Nullable CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)ioDirectory, (String)"ioDirectory");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        Intrinsics.checkNotNullParameter(schemeNameToFileName, (String)"schemeNameToFileName");
        Intrinsics.checkNotNullParameter((Object)settingsCategory, (String)"settingsCategory");
        super(processor);
        this.project = project;
        this.fileSpec = fileSpec;
        this.provider = provider;
        this.ioDirectory = ioDirectory;
        this.roamingType = roamingType;
        this.presentableName = presentableName;
        this.schemeNameToFileName = schemeNameToFileName;
        this.fileChangeSubscriber = fileChangeSubscriber;
        this.settingsCategory = settingsCategory;
        this.isUpdateVfs = this.fileChangeSubscriber != null;
        this.isOldSchemeNaming = Intrinsics.areEqual(this.schemeNameToFileName, (Object)Scheme_implKt.getOLD_NAME_CONVERTER());
        this.isLoadingSchemes = new AtomicBoolean();
        this.schemeListManager = new SchemeListManager(this);
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.filesToDelete = set;
        if (processor instanceof SchemeExtensionProvider) {
            this.schemeExtension = ((SchemeExtensionProvider)processor).getSchemeExtension();
            this.updateExtension = true;
        } else {
            this.schemeExtension = ".xml";
            this.updateExtension = false;
        }
        if (this.isUpdateVfs) {
            CoroutineScope coroutineScope2 = coroutineScope;
            Intrinsics.checkNotNull((Object)coroutineScope2);
            BuildersKt.launch$default((CoroutineScope)coroutineScope2, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ SchemeManagerImpl<T, MUTABLE_SCHEME> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object $result) {
                    CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Object object;
                            void $this$launch;
                            ResultKt.throwOnFailure((Object)$result);
                            void var3_3 = $this$launch;
                            SchemeManagerImpl schemeManagerImpl = this.this$0;
                            try {
                                void $this$invokeSuspend_u24lambda_u240 = var3_3;
                                boolean bl = false;
                                schemeManagerImpl.refreshVirtualDirectory();
                                object = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable throwable) {
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            LoggerKt.getOrLogException((Object)object, (Logger)ComponentStoreImplKt.LOG);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public /* synthetic */ SchemeManagerImpl(Project project, String string, SchemeProcessor schemeProcessor, StreamProvider streamProvider, Path path, RoamingType roamingType, String string2, Function1 function1, Function1 function12, SettingsCategory settingsCategory, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x40) != 0) {
            string2 = null;
        }
        if ((n & 0x80) != 0) {
            function1 = Scheme_implKt.getCURRENT_NAME_CONVERTER();
        }
        if ((n & 0x100) != 0) {
            function12 = null;
        }
        if ((n & 0x200) != 0) {
            settingsCategory = SettingsCategory.OTHER;
        }
        if ((n & 0x400) != 0) {
            coroutineScope = null;
        }
        this(project, string, schemeProcessor, streamProvider, path, roamingType, string2, (Function1<? super String, String>)function1, function12, settingsCategory, coroutineScope);
    }

    @NotNull
    public final String getFileSpec() {
        return this.fileSpec;
    }

    @NotNull
    public final Path getIoDirectory$intellij_platform_configurationStore_impl() {
        return this.ioDirectory;
    }

    @NotNull
    public final RoamingType getRoamingType() {
        return this.roamingType;
    }

    @Nullable
    public final String getPresentableName() {
        return this.presentableName;
    }

    @NotNull
    public final List<T> getSchemes$intellij_platform_configurationStore_impl() {
        return this.schemeListManager.getSchemes();
    }

    @Nullable
    public final VirtualFile getCachedVirtualDirectory$intellij_platform_configurationStore_impl() {
        return this.cachedVirtualDirectory;
    }

    public final void setCachedVirtualDirectory$intellij_platform_configurationStore_impl(@Nullable VirtualFile virtualFile) {
        this.cachedVirtualDirectory = virtualFile;
    }

    @NotNull
    public File getRootDirectory() {
        File file = this.ioDirectory.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<String> getAllSchemeNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSchemes$intellij_platform_configurationStore_impl();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Scheme scheme = (Scheme)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey((Scheme)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<T> getAllSchemes() {
        List<T> list = Collections.unmodifiableList(this.getSchemes$intellij_platform_configurationStore_impl());
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    public boolean isEmpty() {
        return this.getSchemes$intellij_platform_configurationStore_impl().isEmpty();
    }

    private final void refreshVirtualDirectory() {
        VirtualFile directory;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(this.ioDirectory);
        if (virtualFile == null) {
            return;
        }
        this.cachedVirtualDirectory = directory = virtualFile;
        directory.getChildren();
        NewVirtualFile newVirtualFile = directory instanceof NewVirtualFile ? (NewVirtualFile)directory : null;
        if (newVirtualFile != null) {
            newVirtualFile.markDirty();
        }
        directory.refresh(true, false);
    }

    /*
     * WARNING - void declaration
     */
    public void loadBundledSchemes(@NotNull Sequence<? extends SchemeManager.LoadBundleSchemeRequest<T>> providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
        Intrinsics.checkNotNull(schemeProcessor, (String)"null cannot be cast to non-null type com.intellij.configurationStore.LazySchemeProcessor<T of com.intellij.configurationStore.schemeManager.SchemeManagerImpl, MUTABLE_SCHEME of com.intellij.configurationStore.schemeManager.SchemeManagerImpl>");
        LazySchemeProcessor cfr_ignored_0 = (LazySchemeProcessor)schemeProcessor;
        SchemeListManager this_$iv = this.schemeListManager;
        boolean $i$f$mutate = false;
        SchemeCollection old$iv = (SchemeCollection)SchemeListManager.access$getSchemeListRef$p(this_$iv).get();
        ArrayList list$iv = new ArrayList(old$iv.list);
        IdentityHashMap schemeToInfo$iv = new IdentityHashMap(old$iv.schemeToInfo);
        Map<String, T> map2 = this_$iv.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl();
        Map map3 = schemeToInfo$iv;
        List schemes = list$iv;
        boolean bl = false;
        for (SchemeManager.LoadBundleSchemeRequest provider : providers) {
            try {
                void readOnlyExternalizableSchemes;
                void schemeToInfo;
                String schemeKey = provider.getSchemeKey();
                String fileNameWithoutExtension = (String)this.schemeNameToFileName.invoke((Object)schemeKey);
                ExternalInfo externalInfo = new ExternalInfo(fileNameWithoutExtension, fileNameWithoutExtension + ".xml");
                externalInfo.setSchemeKey(schemeKey);
                Scheme scheme = (Scheme)provider.createScheme();
                ExternalInfo oldInfo = schemeToInfo.put(scheme, externalInfo);
                ComponentStoreImplKt.LOG.assertTrue(oldInfo == null);
                Scheme oldScheme = readOnlyExternalizableSchemes.put(schemeKey, scheme);
                if (oldScheme != null) {
                    ComponentStoreImplKt.LOG.debug("Duplicated scheme " + schemeKey + " - old: " + oldScheme + ", new " + scheme);
                }
                schemes.add(scheme);
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                ComponentStoreImplKt.LOG.error((Throwable)new PluginException(e, provider.getPluginId()));
            }
        }
        Intrinsics.checkNotNull((Object)old$iv);
        List list = Collections.synchronizedList(list$iv);
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        Map map4 = Collections.synchronizedMap(schemeToInfo$iv);
        Intrinsics.checkNotNullExpressionValue(map4, (String)"synchronizedMap(...)");
        this_$iv.replaceSchemeList(old$iv, new SchemeCollection(list, map4));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public T loadBundledScheme(@NotNull String resourceName, @Nullable Object requestor, @Nullable PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        try {
            void parser;
            void bytes$iv;
            byte[] bytes;
            byte[] byArray = this.loadBytes(pluginDescriptor, requestor, resourceName);
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = bytes = byArray;
            boolean isOldSchemeNaming$iv = this.isOldSchemeNaming;
            boolean $i$f$lazyPreloadScheme = false;
            XMLStreamReader2 reader$iv = StaxFactory.createXmlStreamReader((byte[])bytes$iv);
            XMLStreamReader xMLStreamReader = (XMLStreamReader)reader$iv;
            String name = SchemeLoaderKt.access$readSchemeNameFromXml(isOldSchemeNaming$iv, (XMLStreamReader)reader$iv);
            boolean bl = false;
            Function1 attributeProvider = arg_0 -> SchemeManagerImpl.loadBundledScheme$lambda$0$0((XMLStreamReader)parser, arg_0);
            String string = PathUtilRt.getFileName((String)resourceName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String fileName = string;
            String extension = this.getFileExtension$intellij_platform_configurationStore_impl(fileName, true);
            String string2 = fileName.substring(0, fileName.length() - extension.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            ExternalInfo externalInfo = new ExternalInfo(string2, extension);
            String string3 = name;
            if (string3 == null) {
                SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
                Intrinsics.checkNotNull(schemeProcessor, (String)"null cannot be cast to non-null type com.intellij.configurationStore.LazySchemeProcessor<T of com.intellij.configurationStore.schemeManager.SchemeManagerImpl, MUTABLE_SCHEME of com.intellij.configurationStore.schemeManager.SchemeManagerImpl>");
                string3 = ((LazySchemeProcessor)schemeProcessor).getSchemeKey(arg_0 -> SchemeManagerImpl.loadBundledScheme$lambda$0$1(attributeProvider, arg_0), externalInfo.fileNameWithoutExtension);
                if (string3 == null) {
                    throw SchemeManagerUtilKt.nameIsMissed(bytes);
                }
            }
            String schemeKey = string3;
            externalInfo.setSchemeKey(schemeKey);
            SchemeDataHolderImpl dataHolder = new SchemeDataHolderImpl(this.getProcessor$intellij_platform_configurationStore_impl(), bytes, externalInfo);
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            Intrinsics.checkNotNull(schemeProcessor, (String)"null cannot be cast to non-null type com.intellij.configurationStore.LazySchemeProcessor<T of com.intellij.configurationStore.schemeManager.SchemeManagerImpl, MUTABLE_SCHEME of com.intellij.configurationStore.schemeManager.SchemeManagerImpl>");
            Scheme scheme = ((LazySchemeProcessor)schemeProcessor).createScheme((SchemeDataHolder)dataHolder, schemeKey, attributeProvider, true);
            ExternalInfo oldInfo = this.schemeListManager.getData().putSchemeInfo(scheme, externalInfo);
            ComponentStoreImplKt.LOG.assertTrue(oldInfo == null);
            Scheme oldScheme = this.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().put(schemeKey, scheme);
            if (oldScheme != null) {
                ComponentStoreImplKt.LOG.warn("Duplicated scheme " + schemeKey + " - old: " + oldScheme + ", new " + scheme);
            }
            this.getSchemes$intellij_platform_configurationStore_impl().add(scheme);
            return (T)scheme;
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            ComponentStoreImplKt.LOG.error("Cannot read scheme from " + resourceName, e);
            return null;
        }
    }

    private final byte[] loadBytes(PluginDescriptor pluginDescriptor, Object requestor, String resourceName) {
        byte[] bytes = null;
        if (pluginDescriptor == null) {
            Object object = requestor;
            if (object instanceof TempUIThemeLookAndFeelInfo) {
                bytes = Files.readAllBytes(Path.of(resourceName, new String[0]));
            } else if (object instanceof UITheme) {
                bytes = ResourceUtil.getResourceAsBytes((String)StringsKt.removePrefix((String)resourceName, (CharSequence)"/"), (ClassLoader)((UITheme)requestor).getProviderClassLoader());
                if (bytes == null) {
                    ComponentStoreImplKt.LOG.error("Cannot find " + resourceName + " in " + ((UITheme)requestor).getProviderClassLoader());
                    return null;
                }
            } else {
                ClassLoader classLoader;
                ClassLoader classLoader2 = requestor instanceof ClassLoader ? (ClassLoader)requestor : null;
                if (classLoader2 == null) {
                    Object object2 = requestor;
                    Intrinsics.checkNotNull((Object)object2);
                    classLoader2 = classLoader = object2.getClass().getClassLoader();
                }
                if ((bytes = ResourceUtil.getResourceAsBytes((String)StringsKt.removePrefix((String)resourceName, (CharSequence)"/"), (ClassLoader)classLoader)) == null) {
                    ComponentStoreImplKt.LOG.error("Cannot read scheme from " + resourceName);
                    return null;
                }
            }
        } else {
            ClassLoader classLoader = pluginDescriptor.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            ClassLoader classLoader3 = classLoader;
            bytes = ResourceUtil.getResourceAsBytes((String)StringsKt.removePrefix((String)resourceName, (CharSequence)"/"), (ClassLoader)classLoader3);
            if (bytes == null) {
                ComponentStoreImplKt.LOG.error("Cannot found scheme " + resourceName + " in " + classLoader3);
                return null;
            }
        }
        return bytes;
    }

    @NotNull
    public final SchemeLoader<T, MUTABLE_SCHEME> createSchemeLoader$intellij_platform_configurationStore_impl(boolean isDuringLoad) {
        HashSet filesToDelete = new HashSet(this.filesToDelete);
        this.filesToDelete.removeAll(filesToDelete);
        return new SchemeLoader(this, this.schemeListManager.getData(), filesToDelete, isDuringLoad);
    }

    public static /* synthetic */ SchemeLoader createSchemeLoader$intellij_platform_configurationStore_impl$default(SchemeManagerImpl schemeManagerImpl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return schemeManagerImpl.createSchemeLoader$intellij_platform_configurationStore_impl(bl);
    }

    @NotNull
    public final String getFileExtension$intellij_platform_configurationStore_impl(@NotNull CharSequence fileName, boolean isAllowAny) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (StringsKt.endsWith((CharSequence)fileName, (CharSequence)this.schemeExtension, (boolean)true)) {
            string = this.schemeExtension;
        } else if (StringsKt.endsWith((CharSequence)fileName, (CharSequence)".xml", (boolean)true)) {
            string = ".xml";
        } else if (isAllowAny) {
            String string2 = PathUtilRt.getFileExtension((String)((Object)fileName).toString());
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            throw new IllegalStateException("Scheme file extension " + fileName + " is unknown, must be filtered out");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<T> loadSchemes() {
        if (!this.isLoadingSchemes.compareAndSet(false, true)) {
            throw new IllegalStateException("loadSchemes is already called");
        }
        try {
            Scheme newScheme;
            boolean isLoadOnlyFromProvider;
            SchemeLoader<T, MUTABLE_SCHEME> schemeLoader = this.createSchemeLoader$intellij_platform_configurationStore_impl(true);
            boolean bl = isLoadOnlyFromProvider = this.provider != null && this.provider.processChildren(this.fileSpec, this.roamingType, arg_0 -> SchemeManagerImpl.loadSchemes$lambda$0(this, arg_0), (arg_0, arg_1, arg_2) -> SchemeManagerImpl.loadSchemes$lambda$1(this, schemeLoader, arg_0, arg_1, arg_2));
            if (!isLoadOnlyFromProvider) {
                Closeable closeable;
                Path $this$directoryStreamIfExists$iv = this.ioDirectory;
                boolean $i$f$directoryStreamIfExists = false;
                try {
                    Unit unit;
                    closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
                    Throwable throwable = null;
                    try {
                        DirectoryStream directoryStream = (DirectoryStream)closeable;
                        boolean bl2 = false;
                        Iterator iterator = directoryStream.iterator();
                        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                        Iterator iterator2 = iterator;
                        while (iterator2.hasNext()) {
                            Path file = (Path)iterator2.next();
                            boolean $i$f$catchAndLog = false;
                            try {
                                boolean bl3 = false;
                                String fileName = ((Object)file.getFileName()).toString();
                                if (!this.canRead(fileName)) continue;
                                try {
                                    Intrinsics.checkNotNull((Object)file);
                                    byte[] byArray = Files.readAllBytes(file);
                                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                                    schemeLoader.loadScheme(fileName, null, byArray);
                                }
                                catch (FileSystemException e) {
                                    Intrinsics.checkNotNull((Object)file);
                                    LinkOption[] linkOptionArray = new LinkOption[]{};
                                    if (Files.isDirectory(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                                    throw e;
                                }
                            }
                            catch (CancellationException e$iv) {
                                throw e$iv;
                            }
                            catch (Throwable e$iv) {
                                if (e$iv instanceof ControlFlowException) {
                                    throw e$iv;
                                }
                                Logger logger = ComponentStoreImplKt.LOG;
                                boolean bl4 = false;
                                logger.error("Cannot read scheme " + ((Object)file).toString(), e$iv);
                            }
                        }
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    closeable = unit;
                }
                catch (NoSuchFileException noSuchFileException) {
                    closeable = null;
                }
            }
            List<T> newSchemes = schemeLoader.apply();
            Object object = newSchemes.iterator();
            while (object.hasNext() && !this.processPendingCurrentSchemeName$intellij_platform_configurationStore_impl(newScheme = (Scheme)object.next())) {
            }
            Function1<SchemeManagerImpl<?, ?>, Unit> function1 = this.fileChangeSubscriber;
            if (function1 != null) {
                function1.invoke((Object)this);
            }
            object = newSchemes;
            return object;
        }
        finally {
            this.isLoadingSchemes.set(false);
        }
    }

    public void reload() {
        this.getProcessor$intellij_platform_configurationStore_impl().beforeReloaded((SchemeManager)this);
        this.removeExternalizableSchemesFromRuntimeState$intellij_platform_configurationStore_impl();
        this.getProcessor$intellij_platform_configurationStore_impl().reloaded((SchemeManager)this, this.loadSchemes());
    }

    public final void removeExternalizableSchemesFromRuntimeState$intellij_platform_configurationStore_impl() {
        Iterator iterator;
        SchemeCollection<T> list = this.schemeListManager.getData();
        Iterator iterator2 = iterator = list.list.iterator();
        while (iterator2.hasNext()) {
            Scheme scheme = (Scheme)iterator2.next();
            SerializableScheme serializableScheme = scheme instanceof SerializableScheme ? (SerializableScheme)scheme : null;
            if (serializableScheme == null || (serializableScheme = serializableScheme.getSchemeState()) == null) {
                serializableScheme = this.getProcessor$intellij_platform_configurationStore_impl().getState(scheme);
            }
            if (serializableScheme == SchemeState.NON_PERSISTENT) continue;
            Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("removeExternalizableSchemesFromRuntimeState: remove scheme '" + scheme + "'@" + System.identityHashCode(scheme), t$iv);
            }
            if (this.getActiveScheme() != null) {
                Object it;
                boolean bl = false;
                if (scheme == it) {
                    this.setCurrentPendingSchemeName$intellij_platform_configurationStore_impl(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it));
                    Logger $this$debug_u24default$iv2 = ComponentStoreImplKt.LOG;
                    Throwable t$iv2 = null;
                    boolean $i$f$debug2 = false;
                    if ($this$debug_u24default$iv2.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv2;
                        boolean bl2 = false;
                        logger.debug("removeExternalizableSchemesFromRuntimeState: set currentPendingSchemeName to " + this.getCurrentPendingSchemeName$intellij_platform_configurationStore_impl(), t$iv2);
                    }
                    this.setActiveScheme$intellij_platform_configurationStore_impl(null);
                }
            }
            iterator.remove();
            this.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().remove(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme));
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            Intrinsics.checkNotNull((Object)scheme, (String)"null cannot be cast to non-null type MUTABLE_SCHEME of com.intellij.configurationStore.schemeManager.SchemeManagerImpl");
            schemeProcessor.onSchemeDeleted(scheme);
        }
        this.retainExternalInfo$intellij_platform_configurationStore_impl(false, list.schemeToInfo, list.list);
    }

    @Nullable
    public final String getFileName$intellij_platform_configurationStore_impl(@NotNull T scheme) {
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        ExternalInfo externalInfo = this.schemeListManager.getExternalInfo(scheme);
        return externalInfo != null ? externalInfo.fileNameWithoutExtension : null;
    }

    public final boolean canRead(@NotNull CharSequence name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (this.updateExtension && StringsKt.endsWith((CharSequence)name, (CharSequence)".xml", (boolean)true) || StringsKt.endsWith((CharSequence)name, (CharSequence)this.schemeExtension, (boolean)true)) && (!(this.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor) || ((LazySchemeProcessor)this.getProcessor$intellij_platform_configurationStore_impl()).isSchemeFile(name));
    }

    public void save() {
        List events = this.isUpdateVfs ? (List)new ArrayList() : Collections.emptyList();
        this.wrapWithIndicator(ApplicationKt.getApplication().isUnitTestMode(), (Function0<Unit>)((Function0)() -> SchemeManagerImpl.save$lambda$0(this, events)));
        Intrinsics.checkNotNull((Object)events);
        if (!((Collection)events).isEmpty()) {
            RefreshQueue.Companion.getInstance().processEvents(false, events);
        }
    }

    private final void wrapWithIndicator(boolean forceIndicator, Function0<Unit> run) {
        if (forceIndicator) {
            ProgressManager.getInstance().runProcess(() -> SchemeManagerImpl.wrapWithIndicator$lambda$0(run), (ProgressIndicator)new EmptyProgressIndicator());
        } else {
            run.invoke();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object saveImpl$intellij_platform_configurationStore_impl(@NotNull List<VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof saveImpl.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ SchemeManagerImpl<T, MUTABLE_SCHEME> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveImpl$intellij_platform_configurationStore_impl(null, (Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.isLoadingSchemes.get()) {
                    ComponentStoreImplKt.LOG.warn("Skip save - schemes are loading");
                }
                hasSchemes = 0;
                nameGenerator = new UniqueNameGenerator();
                changedSchemes = new SmartList();
                errorCollector = new ErrorCollector();
                for (Scheme scheme : this.getSchemes$intellij_platform_configurationStore_impl()) {
                    v0 = scheme instanceof SerializableScheme != false ? (SerializableScheme)scheme : null;
                    if (v0 == null || (v0 = v0.getSchemeState()) == null) {
                        v0 = this.getProcessor$intellij_platform_configurationStore_impl().getState(scheme);
                    }
                    if ((state = v0) == SchemeState.NON_PERSISTENT) continue;
                    hasSchemes = 1;
                    if (state != SchemeState.UNCHANGED) {
                        Intrinsics.checkNotNull((Object)scheme, (String)"null cannot be cast to non-null type MUTABLE_SCHEME of com.intellij.configurationStore.schemeManager.SchemeManagerImpl");
                        changedSchemes.add((Object)scheme);
                    }
                    if ((fileName = this.getFileName$intellij_platform_configurationStore_impl(scheme)) == null || this.isRenamed(scheme)) continue;
                    nameGenerator.addExistingName(fileName);
                }
                filesToDelete = new HashSet<String>((Collection)this.filesToDelete);
                $continuation.L$0 = events;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)nameGenerator);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)changedSchemes);
                $continuation.L$3 = errorCollector;
                $continuation.L$4 = filesToDelete;
                $continuation.I$0 = hasSchemes;
                $continuation.label = 1;
                v1 = FileUtilKt.writeWithEnsureWritable((Project)this.project, (Collection)((Collection)changedSchemes), (Function2)((Function2)new Function2<MUTABLE_SCHEME, Continuation<? super Unit>, Object>(this, nameGenerator, filesToDelete, (List<VFileEvent>)events, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ SchemeManagerImpl<T, MUTABLE_SCHEME> this$0;
                    final /* synthetic */ UniqueNameGenerator $nameGenerator;
                    final /* synthetic */ HashSet<String> $filesToDelete;
                    final /* synthetic */ List<VFileEvent> $events;
                    {
                        this.this$0 = $receiver;
                        this.$nameGenerator = $nameGenerator;
                        this.$filesToDelete = $filesToDelete;
                        this.$events = $events;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        Scheme scheme = (Scheme)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void scheme2;
                                ResultKt.throwOnFailure((Object)$result);
                                SchemeManagerImpl.access$saveScheme(this.this$0, (Scheme)scheme2, this.$nameGenerator, this.$filesToDelete, this.$events);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(MUTABLE_SCHEME p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Function2)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, saveImpl$lambda$0(com.intellij.configurationStore.schemeManager.ErrorCollector com.intellij.configurationStore.schemeManager.SchemeManagerImpl com.intellij.openapi.options.Scheme java.lang.Throwable ), (Lcom/intellij/openapi/options/Scheme;Ljava/lang/Throwable;)Lkotlin/Unit;)((ErrorCollector)errorCollector, (SchemeManagerImpl)this), (Continuation)$continuation);
                if (v1 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl52
            }
            case 1: {
                hasSchemes = $continuation.I$0;
                filesToDelete = (HashSet<String>)$continuation.L$4;
                errorCollector = (ErrorCollector)$continuation.L$3;
                changedSchemes = (SmartList)$continuation.L$2;
                nameGenerator = (UniqueNameGenerator)$continuation.L$1;
                events = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl52:
                // 2 sources

                if (((Collection)filesToDelete).isEmpty() == false) {
                    this.schemeListManager.getData().schemeToInfo.values().removeIf((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, saveImpl$lambda$2(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, saveImpl$lambda$1(java.util.HashSet com.intellij.configurationStore.schemeManager.ExternalInfo ), (Lcom/intellij/configurationStore/schemeManager/ExternalInfo;)Ljava/lang/Boolean;)(filesToDelete)));
                    this.filesToDelete.removeAll((Collection)filesToDelete);
                    this.deleteFiles(errorCollector, (Set<String>)filesToDelete, events);
                    if (!(hasSchemes != 0 || this.provider != null && this.provider.isApplicable(this.fileSpec, this.roamingType))) {
                        this.removeDirectoryIfEmpty(errorCollector, events);
                    }
                }
                v2 = errorCollector.getError();
                if (v2 != null) {
                    it = v2;
                    $i$a$-let-SchemeManagerImpl$saveImpl$5 = false;
                    throw it;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public SettingsCategory getSettingsCategory() {
        return this.settingsCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDirectoryIfEmpty(ErrorCollector errorCollector, List<VFileEvent> events) {
        Path $this$directoryStreamIfExists$iv = this.ioDirectory;
        boolean $i$f$directoryStreamIfExists = false;
        try {
            Unit unit;
            Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
            Throwable throwable = null;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = it.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Path file = (Path)iterator2.next();
                    Intrinsics.checkNotNull((Object)file);
                    if (Files.isHidden(file)) continue;
                    ComponentStoreImplKt.LOG.info("Directory " + this.ioDirectory.getFileName() + " is not deleted: at least one file " + file.getFileName() + " exists");
                    return;
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = unit;
        }
        catch (NoSuchFileException noSuchFileException) {
            Object var5_7 = null;
        }
        ComponentStoreImplKt.LOG.info("Remove scheme directory " + this.ioDirectory.getFileName());
        try {
            NioFiles.deleteRecursively((Path)this.ioDirectory);
        }
        catch (Throwable e) {
            errorCollector.addError(e);
        }
        if (this.isUpdateVfs) {
            VirtualFile dir = this.getVirtualDirectory$intellij_platform_configurationStore_impl();
            this.cachedVirtualDirectory = null;
            if (dir != null) {
                ((Collection)events).add(new VFileDeleteEvent((Object)this, dir));
            }
        }
    }

    private final void saveScheme(MUTABLE_SCHEME scheme, UniqueNameGenerator nameGenerator, Set<String> filesToDelete, List<VFileEvent> events) {
        boolean renamed;
        Element element;
        ExternalInfo externalInfo;
        ExternalInfo externalInfo2 = externalInfo = this.schemeListManager.getExternalInfo(scheme);
        String currentFileNameWithoutExtension = externalInfo2 != null ? externalInfo2.fileNameWithoutExtension : null;
        Parent parent = this.getProcessor$intellij_platform_configurationStore_impl().writeScheme(scheme);
        if (parent != null) {
            Parent it = parent;
            boolean bl = false;
            v2 = it instanceof Element ? (Element)it : null;
            if (v2 == null) {
                v2 = ((Document)it).detachRootElement();
            }
        } else {
            v2 = element = null;
        }
        if (element == null || element.isEmpty()) {
            ExternalInfo externalInfo3 = externalInfo;
            if (externalInfo3 != null) {
                externalInfo3.scheduleDelete(filesToDelete, "empty");
            }
            return;
        }
        String fileNameWithoutExtension = currentFileNameWithoutExtension;
        if (fileNameWithoutExtension == null || this.isRenamed(scheme)) {
            fileNameWithoutExtension = nameGenerator.generateUniqueName((String)this.schemeNameToFileName.invoke((Object)this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme)));
            if (ComponentStoreImplKt.LOG.isDebugEnabled()) {
                List<T> allSchemes = this.schemeListManager.getSchemes();
                ComponentStoreImplKt.LOG.debug(StringsKt.trimMargin$default((String)("\n          |Generate scheme file name '" + fileNameWithoutExtension + "' for '" + scheme + "'@" + System.identityHashCode(scheme) + "\n          | currentFileNameWithoutExtension=" + currentFileNameWithoutExtension + "\n          | externalInfo=" + externalInfo + "\n          | " + allSchemes.size() + " schemes:\n          | " + CollectionsKt.joinToString$default((Iterable)allSchemes, (CharSequence)"\n ", null, null, (int)0, null, arg_0 -> SchemeManagerImpl.saveScheme$lambda$1(this, arg_0), (int)30, null) + "\n          |"), null, (int)1, null));
            }
        }
        String fileName = fileNameWithoutExtension + this.schemeExtension;
        filesToDelete.remove(fileName);
        long newDigest = Scheme_implKt.hashElement((Element)element);
        if (externalInfo != null && currentFileNameWithoutExtension == fileNameWithoutExtension && externalInfo.isDigestEquals(newDigest)) {
            return;
        }
        if (this.isEqualToBundledScheme(externalInfo, newDigest, scheme, filesToDelete)) {
            return;
        }
        if (this.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor && ((LazySchemeProcessor)this.getProcessor$intellij_platform_configurationStore_impl()).isSchemeDefault(scheme, newDigest)) {
            ExternalInfo externalInfo4 = externalInfo;
            if (externalInfo4 != null) {
                externalInfo4.scheduleDelete(filesToDelete, "equals to default");
            }
            return;
        }
        BufferExposingByteArrayOutputStream byteOut = JdomKt.toBufferExposingByteArray$default((Element)element, null, (int)1, null);
        String providerPath = null;
        if (this.provider != null && this.provider.getEnabled()) {
            providerPath = this.fileSpec + "/" + fileName;
            if (!this.provider.isApplicable(providerPath, this.roamingType)) {
                providerPath = null;
            }
        } else {
            providerPath = null;
        }
        boolean bl = renamed = externalInfo != null && fileNameWithoutExtension != currentFileNameWithoutExtension && currentFileNameWithoutExtension != null && nameGenerator.isUnique(currentFileNameWithoutExtension);
        if (providerPath == null) {
            if (renamed) {
                externalInfo.scheduleDelete(filesToDelete, "renamed");
            }
            VirtualFile dir = this.isUpdateVfs ? this.getVirtualDirectory$intellij_platform_configurationStore_impl() : null;
            Path ioFile = this.ioDirectory.resolve(fileName);
            Intrinsics.checkNotNull((Object)ioFile);
            byte[] byArray = byteOut.getInternalBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInternalBuffer(...)");
            PathKt.write((Path)ioFile, (byte[])byArray, (int)0, (int)byteOut.size());
            if (this.isUpdateVfs) {
                if (dir == null) {
                    this.cachedVirtualDirectory = dir = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(this.ioDirectory);
                }
                if (dir != null) {
                    VirtualFile file = dir.findChild(fileName);
                    if (file != null) {
                        ((Collection)events).add(FileBasedStorageKt.updatingEvent(ioFile, file));
                    } else {
                        ((Collection)events).add(FileBasedStorageKt.creationEvent(ioFile, dir));
                    }
                }
            }
        } else {
            if (renamed) {
                externalInfo.scheduleDelete(filesToDelete, "renamed");
            }
            StreamProvider streamProvider = this.provider;
            Intrinsics.checkNotNull((Object)streamProvider);
            byte[] byArray = byteOut.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            streamProvider.write(providerPath, byArray, this.roamingType);
        }
        if (externalInfo == null) {
            externalInfo = new ExternalInfo(fileNameWithoutExtension, this.schemeExtension);
            this.schemeListManager.getData().schemeToInfo.put(scheme, externalInfo);
        } else {
            externalInfo.setFileNameWithoutExtension(fileNameWithoutExtension, this.schemeExtension);
        }
        externalInfo.setDigest(newDigest);
        externalInfo.setSchemeKey(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme));
    }

    private final boolean isEqualToBundledScheme(ExternalInfo externalInfo, long newDigest, MUTABLE_SCHEME scheme, Set<String> filesToDelete) {
        Scheme bundledScheme = (Scheme)this.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().get(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme));
        if (bundledScheme == null) {
            SchemeProcessor schemeProcessor = this.getProcessor$intellij_platform_configurationStore_impl();
            LazySchemeProcessor lazySchemeProcessor = schemeProcessor instanceof LazySchemeProcessor ? (LazySchemeProcessor)schemeProcessor : null;
            boolean bl = lazySchemeProcessor != null ? lazySchemeProcessor.isSchemeEqualToBundled(scheme) : false;
            if (bl) {
                ExternalInfo externalInfo2 = externalInfo;
                if (externalInfo2 != null) {
                    externalInfo2.scheduleDelete(filesToDelete, "equals to bundled");
                }
                return true;
            }
            return false;
        }
        ExternalInfo externalInfo3 = this.schemeListManager.getExternalInfo(bundledScheme);
        if (externalInfo3 == null) {
            return false;
        }
        ExternalInfo bundledExternalInfo = externalInfo3;
        if (bundledExternalInfo.getDigest() == null) {
            Element element = SchemeManagerImpl.isEqualToBundledScheme$serializeIfPossible(this, bundledScheme);
            if (element != null) {
                Element it = element;
                boolean bl = false;
                bundledExternalInfo.setDigest(Scheme_implKt.hashElement((Element)it));
            } else {
                return false;
            }
        }
        if (bundledExternalInfo.isDigestEquals(newDigest)) {
            ExternalInfo externalInfo4 = externalInfo;
            if (externalInfo4 != null) {
                externalInfo4.scheduleDelete(filesToDelete, "equals to bundled");
            }
            return true;
        }
        return false;
    }

    private final boolean isRenamed(T scheme) {
        ExternalInfo info = this.schemeListManager.getExternalInfo(scheme);
        return info != null && !Intrinsics.areEqual((Object)this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme), (Object)info.getSchemeKey());
    }

    private final void deleteFiles(ErrorCollector errorCollector, Set<String> filesToDelete, List<VFileEvent> events) {
        VirtualFile dir;
        Logger logger;
        if (this.provider != null) {
            VirtualFile[] iterator;
            VirtualFile[] virtualFileArray = iterator = filesToDelete.iterator();
            while (virtualFileArray.hasNext()) {
                String name = virtualFileArray.next();
                try {
                    String spec = this.fileSpec + "/" + name;
                    if (!this.provider.delete(spec, this.roamingType)) continue;
                    Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug(spec + " deleted from provider " + this.provider, t$iv);
                    }
                    iterator.remove();
                }
                catch (Throwable e) {
                    errorCollector.addError(e);
                }
            }
        }
        if (filesToDelete.isEmpty()) {
            return;
        }
        Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Delete scheme files: " + CollectionsKt.joinToString$default((Iterable)filesToDelete, null, null, null, (int)0, null, null, (int)63, null), t$iv);
        }
        for (String name : filesToDelete) {
            try {
                NioFiles.deleteRecursively((Path)this.ioDirectory.resolve(name));
            }
            catch (Throwable e) {
                errorCollector.addError(e);
            }
        }
        if (this.isUpdateVfs && (dir = this.getVirtualDirectory$intellij_platform_configurationStore_impl()) != null) {
            VirtualFile[] virtualFileArray = dir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            for (VirtualFile file : virtualFileArray) {
                if (!file.isValid() || !filesToDelete.contains(file.getName())) continue;
                ((Collection)events).add(new VFileDeleteEvent((Object)this, file));
            }
        }
    }

    @Nullable
    public final VirtualFile getVirtualDirectory$intellij_platform_configurationStore_impl() {
        VirtualFile result = this.cachedVirtualDirectory;
        if (result == null) {
            this.cachedVirtualDirectory = result = LocalFileSystem.getInstance().findFileByNioFile(this.ioDirectory);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public void setSchemes(@NotNull List<? extends T> newSchemes, @Nullable T newCurrentScheme, @Nullable Predicate<T> removeCondition) {
        KFunction kFunction;
        Intrinsics.checkNotNullParameter(newSchemes, (String)"newSchemes");
        SchemeListManager<T> schemeListManager = this.schemeListManager;
        List<T> list = newSchemes;
        T t = newCurrentScheme;
        Predicate<T> predicate = removeCondition;
        if (predicate != null) {
            void it;
            Predicate<T> predicate2 = predicate;
            T t2 = t;
            List<T> list2 = list;
            SchemeListManager<T> schemeListManager2 = schemeListManager;
            boolean bl = false;
            KFunction kFunction2 = (KFunction)new Function1<T, Boolean>(it){

                public final Boolean invoke(T p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return ((Predicate)this.receiver).test(p0);
                }
            };
            schemeListManager = schemeListManager2;
            list = list2;
            t = t2;
            kFunction = kFunction2;
        } else {
            kFunction = null;
        }
        schemeListManager.setSchemes(list, t, (Function1)kFunction);
    }

    public final void retainExternalInfo$intellij_platform_configurationStore_impl(boolean isScheduleToDelete, @NotNull Map<T, ExternalInfo> schemeToInfo, @NotNull List<? extends T> newSchemes) {
        Iterator<Map.Entry<T, ExternalInfo>> iterator;
        Intrinsics.checkNotNullParameter(schemeToInfo, (String)"schemeToInfo");
        Intrinsics.checkNotNullParameter(newSchemes, (String)"newSchemes");
        if (schemeToInfo.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<T, ExternalInfo>> iterator2 = iterator = schemeToInfo.entrySet().iterator();
        block0: while (iterator2.hasNext()) {
            Map.Entry<T, ExternalInfo> entry = iterator2.next();
            Scheme scheme = (Scheme)entry.getKey();
            ExternalInfo info = entry.getValue();
            if (this.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().get(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme)) == scheme) continue;
            for (Scheme newScheme : newSchemes) {
                if (scheme != newScheme) continue;
                this.filesToDelete.remove(info.getFileName());
                continue block0;
            }
            iterator.remove();
            if (!isScheduleToDelete) continue;
            info.scheduleDelete(this.filesToDelete, "requested to delete");
        }
    }

    public void addScheme(@NotNull T scheme, boolean replaceExisting) {
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        this.schemeListManager.addScheme(scheme, replaceExisting);
    }

    @Nullable
    public T findSchemeByName(@NotNull String schemeName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)schemeName, (String)"schemeName");
            Iterable $this$firstOrNull$iv = this.getSchemes$intellij_platform_configurationStore_impl();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Scheme it = (Scheme)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it), (Object)schemeName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (T)((Scheme)v0);
    }

    @Nullable
    public T removeScheme(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.removeFirstScheme$intellij_platform_configurationStore_impl(true, arg_0 -> SchemeManagerImpl.removeScheme$lambda$0(this, name, arg_0));
    }

    public boolean removeScheme(@NotNull T scheme) {
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        return this.removeScheme(scheme, true);
    }

    public final boolean removeScheme(@NotNull T scheme, boolean isScheduleToDelete) {
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        return this.removeFirstScheme$intellij_platform_configurationStore_impl(isScheduleToDelete, arg_0 -> SchemeManagerImpl.removeScheme$lambda$1(scheme, arg_0)) != null;
    }

    public boolean isMetadataEditable(@NotNull T scheme) {
        Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
        return !this.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().containsKey(this.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme));
    }

    @NotNull
    public String toString() {
        return this.fileSpec;
    }

    @TestOnly
    public final void forceSaving() {
        Iterable $this$forEach$iv = this.schemeListManager.getData().schemeToInfo.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExternalInfo it = (ExternalInfo)element$iv;
            boolean bl = false;
            it.setDigest(null);
        }
    }

    @Nullable
    public final T removeFirstScheme$intellij_platform_configurationStore_impl(boolean isScheduleToDelete, @NotNull Function1<? super T, Boolean> condition) {
        Iterator<T> iterator;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Iterator<T> iterator2 = iterator = this.getSchemes$intellij_platform_configurationStore_impl().iterator();
        while (iterator2.hasNext()) {
            Scheme scheme = (Scheme)iterator2.next();
            if (!((Boolean)condition.invoke((Object)scheme)).booleanValue()) continue;
            if (this.getActiveScheme() == scheme) {
                this.setActiveScheme$intellij_platform_configurationStore_impl(null);
            }
            iterator.remove();
            if (isScheduleToDelete && this.getProcessor$intellij_platform_configurationStore_impl().isExternalizable(scheme)) {
                ExternalInfo externalInfo = this.schemeListManager.getData().schemeToInfo.remove(scheme);
                if (externalInfo != null) {
                    externalInfo.scheduleDelete(this.filesToDelete, "requested to delete (removeFirstScheme)");
                }
            }
            return (T)scheme;
        }
        return null;
    }

    private static final String loadBundledScheme$lambda$0$0(XMLStreamReader $parser, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $parser.getAttributeValue(null, it);
    }

    private static final String loadBundledScheme$lambda$0$1(Function1 $tmp0, String p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return (String)$tmp0.invoke((Object)p0);
    }

    private static final boolean loadSchemes$lambda$0(SchemeManagerImpl this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.canRead(it);
    }

    private static final boolean loadSchemes$lambda$1(SchemeManagerImpl this$0, SchemeLoader $schemeLoader, String name, InputStream input, boolean readOnly) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean $i$f$catchAndLog = false;
        try {
            boolean bl = false;
            Object scheme = $schemeLoader.loadScheme(name, input, null);
            if (readOnly && scheme != null) {
                this$0.schemeListManager.getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().put(this$0.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(scheme), scheme);
            }
        }
        catch (CancellationException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            if (e$iv instanceof ControlFlowException) {
                throw e$iv;
            }
            Logger logger = ComponentStoreImplKt.LOG;
            boolean bl = false;
            logger.error("Cannot read scheme " + (this$0.provider.getClass().getName() + ": " + name), e$iv);
        }
        return true;
    }

    private static final Unit save$lambda$0(SchemeManagerImpl this$0, List $events) {
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, (List<VFileEvent>)$events, null){
            int label;
            final /* synthetic */ SchemeManagerImpl<T, MUTABLE_SCHEME> this$0;
            final /* synthetic */ List<VFileEvent> $events;
            {
                this.this$0 = $receiver;
                this.$events = $events;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        List<VFileEvent> list = this.$events;
                        Intrinsics.checkNotNull(list);
                        this.label = 1;
                        Object object2 = this.this$0.saveImpl$intellij_platform_configurationStore_impl(list, (Continuation<Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final void wrapWithIndicator$lambda$0(Function0 $run) {
        $run.invoke();
    }

    private static final Unit saveImpl$lambda$0(ErrorCollector $errorCollector, SchemeManagerImpl this$0, Scheme scheme, Throwable e) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $errorCollector.addError(new RuntimeException("Cannot save scheme " + this$0.fileSpec + "/" + scheme, e));
        return Unit.INSTANCE;
    }

    private static final boolean saveImpl$lambda$1(HashSet $filesToDelete, ExternalInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $filesToDelete.contains(it.getFileName());
    }

    private static final boolean saveImpl$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence saveScheme$lambda$1(SchemeManagerImpl this$0, Scheme it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ExternalInfo externalInfo = this$0.schemeListManager.getExternalInfo(it);
        return it.getName() + "@" + System.identityHashCode(it) + " -> " + (externalInfo != null ? externalInfo.fileNameWithoutExtension : null);
    }

    private static final <T extends Scheme, MUTABLE_SCHEME extends T> Element isEqualToBundledScheme$serializeIfPossible(SchemeManagerImpl<T, MUTABLE_SCHEME> this$0, T scheme) {
        Object object;
        Object object2 = scheme instanceof Scheme ? scheme : null;
        if (object2 == null) {
            return null;
        }
        T bundledAsMutable = object2;
        SchemeManagerImpl<T, MUTABLE_SCHEME> schemeManagerImpl = this$0;
        try {
            SchemeManagerImpl<T, MUTABLE_SCHEME> $this$isEqualToBundledScheme_u24serializeIfPossible_u24lambda_u240 = schemeManagerImpl;
            boolean bl = false;
            Parent parent = $this$isEqualToBundledScheme_u24serializeIfPossible_u24lambda_u240.getProcessor$intellij_platform_configurationStore_impl().writeScheme(bundledAsMutable);
            Intrinsics.checkNotNull((Object)parent, (String)"null cannot be cast to non-null type org.jdom.Element");
            object = Result.constructor-impl((Object)((Element)parent));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (Element)LoggerKt.getOrLogException((Object)object, (Logger)ComponentStoreImplKt.LOG);
    }

    private static final boolean removeScheme$lambda$0(SchemeManagerImpl this$0, String $name, Scheme it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)this$0.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(it), (Object)$name);
    }

    private static final boolean removeScheme$lambda$1(Scheme $scheme, Scheme it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it == $scheme;
    }

    public static final /* synthetic */ void access$saveScheme(SchemeManagerImpl $this, Scheme scheme, UniqueNameGenerator nameGenerator, Set filesToDelete, List events) {
        $this.saveScheme(scheme, nameGenerator, filesToDelete, events);
    }
}

