/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialog;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007H\u0014J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J4\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/ExportSettingsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getExportableComponents", "", "Lcom/intellij/configurationStore/FileSpec;", "", "Lcom/intellij/configurationStore/ExportableItem;", "exportSettings", "", "saveFile", "Ljava/nio/file/Path;", "markedComponents", "", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "filterExisting", "exportableComponents", "exists", "", "item", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExportSettingsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportSettingsAction.kt\ncom/intellij/configurationStore/ExportSettingsAction\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,475:1\n139#2,10:476\n221#2:486\n222#2:491\n149#2:492\n777#3:487\n873#3,2:488\n1#4:490\n*S KotlinDebug\n*F\n+ 1 ExportSettingsAction.kt\ncom/intellij/configurationStore/ExportSettingsAction\n*L\n105#1:476,10\n105#1:486\n105#1:491\n105#1:492\n106#1:487\n106#1:488,2\n105#1:490\n*E\n"})
public class ExportSettingsAction
extends AnAction
implements ActionRemoteBehaviorSpecification.Frontend,
DumbAware {
    @NotNull
    protected Map<FileSpec, List<ExportableItem>> getExportableComponents() {
        return this.filterExisting(ExportSettingsActionKt.getExportableComponentsMap$default(true, null, false, false, 14, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportSettings(@NotNull Path saveFile, @NotNull Set<ExportableItem> markedComponents) {
        Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
        Intrinsics.checkNotNullParameter(markedComponents, (String)"markedComponents");
        Closeable closeable = PathKt.outputStream((Path)saveFile);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            ExportSettingsActionKt.exportSettings$default(markedComponents, it, null, null, 12, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ApplicationManager.getApplication().saveSettings();
        Map<FileSpec, List<ExportableItem>> map2 = this.getExportableComponents();
        String string = ConfigurationStoreBundle.message("title.select.components.to.export", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = ConfigurationStoreBundle.message("prompt.please.check.all.components.to.export", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        ChooseComponentsToExportDialog dialog = new ChooseComponentsToExportDialog(map2, true, string, string2);
        if (!dialog.showAndGet()) {
            return;
        }
        Set<ExportableItem> markedComponents = dialog.getExportableComponents$intellij_platform_configurationStore_impl();
        if (markedComponents.isEmpty()) {
            return;
        }
        Path saveFile = dialog.getExportFile$intellij_platform_configurationStore_impl();
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(saveFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                String string3 = IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                Object[] objectArray = new Object[]{((Object)saveFile).toString()};
                String string4 = ConfigurationStoreBundle.message("prompt.overwrite.settings.file", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                String string5 = IdeBundle.message((String)"action.overwrite", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                if (MessageUtil.showOkCancelDialog$default((String)string3, (String)string4, (String)string5, null, (Icon)Messages.getWarningIcon(), null, null, (int)104, null) != 0) {
                    return;
                }
            }
            this.exportSettings(saveFile, markedComponents);
            String string6 = ConfigurationStoreBundle.message("title.export.successful", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            String string7 = ConfigurationStoreBundle.message("message.settings.exported.successfully", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
            String string8 = RevealFileAction.getActionName(null);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getActionName(...)");
            String string9 = IdeBundle.message((String)"action.close", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
            if (MessageUtil.showOkCancelDialog$default((String)string6, (String)string7, (String)string8, (String)string9, (Icon)Messages.getInformationIcon(), null, (Project)AnAction.getEventProject((AnActionEvent)e), (int)32, null) == 0) {
                RevealFileAction.openFile((File)saveFile.toFile());
            }
        }
        catch (IOException e2) {
            Object[] objectArray = new Object[]{e2.toString()};
            Messages.showErrorDialog((String)ConfigurationStoreBundle.message("error.writing.settings", objectArray), (String)IdeBundle.message((String)"title.error.writing.file", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<FileSpec, List<ExportableItem>> filterExisting(Map<FileSpec, ? extends List<ExportableItem>> exportableComponents) {
        void $this$mapNotNullTo$iv$iv;
        Map<FileSpec, ? extends List<ExportableItem>> $this$mapNotNull$iv = exportableComponents;
        boolean $i$f$mapNotNull = false;
        Map<FileSpec, ? extends List<ExportableItem>> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            void $this$filterTo$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            FileSpec fileSpec = (FileSpec)entry.getKey();
            List items = (List)entry.getValue();
            Iterable $this$filter$iv = items;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                ExportableItem it = (ExportableItem)element$iv$iv2;
                boolean bl3 = false;
                if (!this.exists(it)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List existingItems = (List)destination$iv$iv2;
            if ((existingItems.isEmpty() ? null : TuplesKt.to((Object)fileSpec, (Object)existingItems)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final boolean exists(ExportableItem item) {
        if (item.fileSpec.isDirectory) {
            return ExportSettingsActionKt.access$checkIfDirectoryExists(item, ExportSettingsActionKt.access$getAppStorageManager());
        }
        byte[] content = ExportSettingsActionKt.access$loadFileContent(item, ExportSettingsActionKt.access$getAppStorageManager());
        return content != null && ExportSettingsActionKt.access$isComponentDefined(item.componentName, content);
    }
}

