/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.Macro;
import com.intellij.configurationStore.RenameableStateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StorageVirtualFileTracker;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.project.ProjectStoreOwner;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0015\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J\u001a\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 H\u0014J*\u0010!\u001a\u00020\u00142\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0%H\u0014J2\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'2\b\u0010/\u001a\u0004\u0018\u00010\nH\u0014R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010(\u00a8\u00060"}, d2={"Lcom/intellij/configurationStore/ModuleStateStorageManager;", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "Lcom/intellij/configurationStore/RenameableStateStorageManager;", "macroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/module/Module;)V", "getOldStorageSpec", "", "component", "", "componentName", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "expandMacro", "Ljava/nio/file/Path;", "collapsedPath", "rename", "", "newName", "clearVirtualFileTracker", "virtualFileTracker", "Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "clearVirtualFileTracker$intellij_platform_configurationStore_impl", "pathRenamed", "newPath", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "beforeElementLoaded", "element", "Lorg/jdom/Element;", "beforeElementSaved", "elements", "", "rootAttributes", "", "isExternalSystemStorageEnabled", "", "()Z", "createFileBasedStorage", "Lcom/intellij/openapi/components/StateStorage;", "file", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "usePathMacroManager", "rootTagName", "intellij.platform.configurationStore.impl"})
final class ModuleStateStorageManager
extends StateStorageManagerImpl
implements RenameableStateStorageManager {
    public ModuleStateStorageManager(@NotNull TrackingPathMacroSubstitutor macroSubstitutor, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)macroSubstitutor, (String)"macroSubstitutor");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super("module", (PathMacroSubstitutor)macroSubstitutor, (ComponentManager)module, null);
    }

    @Override
    @NotNull
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return "$MODULE_FILE$";
    }

    @Override
    @NotNull
    public Path expandMacro(@NotNull String collapsedPath) {
        Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
        if (!Intrinsics.areEqual((Object)collapsedPath, (Object)"$MODULE_FILE$")) {
            throw new IllegalStateException("Cannot resolve " + collapsedPath + " in " + this.macros);
        }
        return ((Macro)this.macros.get((int)0)).value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        ReentrantReadWriteLock reentrantReadWriteLock = this.storageLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            StateStorage stateStorage = StateStorageManagerImpl.getOrCreateStorage$default(this, "$MODULE_FILE$", RoamingType.DEFAULT, null, null, false, null, null, true, 124, null);
            Intrinsics.checkNotNull((Object)stateStorage, (String)"null cannot be cast to non-null type com.intellij.configurationStore.FileBasedStorage");
            FileBasedStorage storage = (FileBasedStorage)stateStorage;
            VirtualFile file = storage.getVirtualFile();
            try {
                if (file != null) {
                    file.rename((Object)storage, newName);
                } else if (!Intrinsics.areEqual((Object)((Object)storage.getFile().getFileName()).toString(), (Object)newName)) {
                    Path newFile = storage.getFile().getParent().resolve(newName);
                    storage.setFile(null, newFile);
                    Intrinsics.checkNotNull((Object)newFile);
                    this.pathRenamed(newFile, null);
                }
            }
            catch (IOException e) {
                ComponentStoreImplKt.LOG.debug((Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Override
    public void clearVirtualFileTracker$intellij_platform_configurationStore_impl(@NotNull StorageVirtualFileTracker virtualFileTracker) {
        Intrinsics.checkNotNullParameter((Object)virtualFileTracker, (String)"virtualFileTracker");
        virtualFileTracker.remove(PathsKt.getInvariantSeparatorsPathString((Path)this.expandMacro("$MODULE_FILE$")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pathRenamed(@NotNull Path newPath, @Nullable VFileEvent event) {
        Object requestor;
        VFileEvent vFileEvent;
        Intrinsics.checkNotNullParameter((Object)newPath, (String)"newPath");
        try {
            List<Macro> list = List.of(new Macro("$MODULE_FILE$", newPath));
            Intrinsics.checkNotNullExpressionValue(list, (String)"of(...)");
            this.setMacros$intellij_platform_configurationStore_impl(list);
            vFileEvent = event;
        }
        catch (Throwable throwable) {
            Object requestor2;
            VFileEvent vFileEvent2 = event;
            Object object = requestor2 = vFileEvent2 != null ? vFileEvent2.getRequestor() : null;
            if (requestor2 == null || !(requestor2 instanceof StateStorage)) {
                ComponentManager componentManager = this.getComponentManager();
                Intrinsics.checkNotNull((Object)componentManager, (String)"null cannot be cast to non-null type com.intellij.openapi.module.impl.ModuleEx");
                ModuleEx module = (ModuleEx)componentManager;
                module.rename(StringsKt.removeSuffix((String)((Object)newPath.getFileName()).toString(), (CharSequence)".iml"), false);
            }
            throw throwable;
        }
        Object object = requestor = vFileEvent != null ? vFileEvent.getRequestor() : null;
        if (requestor == null || !(requestor instanceof StateStorage)) {
            ComponentManager componentManager = this.getComponentManager();
            Intrinsics.checkNotNull((Object)componentManager, (String)"null cannot be cast to non-null type com.intellij.openapi.module.impl.ModuleEx");
            ModuleEx module = (ModuleEx)componentManager;
            module.rename(StringsKt.removeSuffix((String)((Object)newPath.getFileName()).toString(), (CharSequence)".iml"), false);
        }
    }

    @Override
    protected void beforeElementLoaded(@NotNull Element element) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Element optionElement = new Element("component").setAttribute("name", "DeprecatedModuleOptionManager");
        Iterator iterator2 = iterator = element.getAttributes().iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            if (Intrinsics.areEqual((Object)attribute.getName(), (Object)"version")) continue;
            iterator.remove();
            optionElement.addContent(new Element("option").setAttribute("key", attribute.getName()).setAttribute("value", attribute.getValue()));
        }
        element.addContent(optionElement);
    }

    @Override
    protected void beforeElementSaved(@NotNull List<Element> elements, @NotNull Map<String, String> rootAttributes) {
        Iterator<Element> componentIterator;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(rootAttributes, (String)"rootAttributes");
        Iterator<Element> iterator = componentIterator = elements.iterator();
        while (iterator.hasNext()) {
            Element component = iterator.next();
            if (!Intrinsics.areEqual((Object)component.getAttributeValue("name"), (Object)"DeprecatedModuleOptionManager")) continue;
            componentIterator.remove();
            for (Element option : component.getChildren("option")) {
                String string = option.getAttributeValue("key");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                String string2 = option.getAttributeValue("value");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
                rootAttributes.put(string, string2);
            }
        }
        rootAttributes.put("version", "4");
    }

    public boolean isExternalSystemStorageEnabled() {
        Module module = (Module)this.getComponentManager();
        if (module == null || (module = module.getProject()) == null) {
            return false;
        }
        Module project = module;
        if (!(project instanceof ProjectStoreOwner)) {
            return false;
        }
        return ((ProjectStoreOwner)project).getComponentStore().getStoreDescriptor().isExternalStorageSupported() && ProjectUtilCore.isExternalStorageEnabled((Project)project);
    }

    @Override
    @NotNull
    protected StateStorage createFileBasedStorage(@NotNull Path file, @NotNull String collapsedPath, @NotNull RoamingType roamingType, boolean usePathMacroManager, @Nullable String rootTagName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
        Intrinsics.checkNotNullParameter((Object)roamingType, (String)"roamingType");
        StreamProvider provider = roamingType == RoamingType.DISABLED ? null : this.getStreamProvider();
        return new StateStorageManagerImpl.TrackedFileStorage(this, file, collapsedPath, rootTagName, roamingType, this.getMacroSubstitutor(), provider, null, null);
    }
}

