/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DotIdeaProjectStoreDescriptor;
import com.intellij.configurationStore.IprProjectStoreDescriptor;
import com.intellij.configurationStore.NestedProjectStorePathManagerKt;
import com.intellij.configurationStore.ProjectStoreDescriptor;
import com.intellij.configurationStore.ProjectStorePathCustomizer;
import com.intellij.configurationStore.ProjectStorePathManager;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/configurationStore/NestedProjectStorePathManager;", "Lcom/intellij/configurationStore/ProjectStorePathManager;", "<init>", "()V", "getStoreDescriptor", "Lcom/intellij/configurationStore/ProjectStoreDescriptor;", "projectRoot", "Ljava/nio/file/Path;", "getStoreDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.configurationStore.impl"})
public final class NestedProjectStorePathManager
implements ProjectStorePathManager {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ProjectStoreDescriptor getStoreDescriptor(@NotNull Path projectRoot) {
        ProjectStoreDescriptor projectStoreDescriptor;
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        ArrayList<ProjectStoreDescriptor> suitableDescriptors = new ArrayList<ProjectStoreDescriptor>();
        for (LazyExtension descriptor2 : NestedProjectStorePathManagerKt.access$getEP_NAME$p().filterableLazySequence()) {
            PluginId pluginId;
            Intrinsics.checkNotNullExpressionValue((Object)descriptor2.getPluginDescriptor().getPluginId(), (String)"getPluginId(...)");
            if (!descriptor2.getPluginDescriptor().isBundled() && !Intrinsics.areEqual((Object)pluginId.getIdString(), (Object)"org.jetbrains.bazel")) {
                ComponentStoreImplKt.LOG.warn((Throwable)new PluginException("ProjectStorePathCustomizer from '" + descriptor2.getPluginDescriptor() + "' is not allowed (not in a whitelist)", pluginId));
                continue;
            }
            ProjectStorePathCustomizer projectStorePathCustomizer = (ProjectStorePathCustomizer)descriptor2.getInstance();
            Object object = projectStorePathCustomizer != null ? projectStorePathCustomizer.getStoreDirectoryPath(projectRoot) : null;
            if (object == null) continue;
            suitableDescriptors.add((ProjectStoreDescriptor)object);
        }
        if (!((Collection)suitableDescriptors).isEmpty()) {
            if (suitableDescriptors.size() == 1) return (ProjectStoreDescriptor)CollectionsKt.single((List)suitableDescriptors);
            boolean bl = false;
            String string = "More than one suitable ProjectStorePathCustomizer found: " + CollectionsKt.joinToString$default((Iterable)suitableDescriptors, null, null, null, (int)0, null, null, (int)63, null) + ". We cannot determine which one is suitable for " + projectRoot;
            throw new IllegalArgumentException(string.toString());
        }
        if (StringsKt.endsWith$default((String)((Object)projectRoot).toString(), (String)".ipr", (boolean)false, (int)2, null)) {
            Path path = projectRoot.getParent();
            if (path == null) {
                Iterable<Path> iterable = projectRoot.getFileSystem().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                path = (Path)CollectionsKt.first(iterable);
            }
            Path userBaseDir = path;
            Intrinsics.checkNotNull((Object)userBaseDir);
            return new IprProjectStoreDescriptor(userBaseDir, projectRoot);
        }
        if (Files.isRegularFile(projectRoot, new LinkOption[0])) {
            Path path = projectRoot.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            Path path2 = projectRoot.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
            projectStoreDescriptor = new DotIdeaProjectStoreDescriptor(path, path2);
            return projectStoreDescriptor;
        }
        if (Files.isDirectory(projectRoot, new LinkOption[0]) && Boolean.parseBoolean(System.getProperty("store.basedir.parent.detection", "true"))) {
            Object object = projectRoot.getFileName();
            boolean bl = object != null && (object = object.toString()) != null ? StringsKt.startsWith$default((String)object, (String)".idea.", (boolean)false, (int)2, null) : false;
            if (bl) {
                Path path = projectRoot.getParent().getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                projectStoreDescriptor = new DotIdeaProjectStoreDescriptor(projectRoot, path);
                return projectStoreDescriptor;
            }
        }
        projectStoreDescriptor = new DotIdeaProjectStoreDescriptor(projectRoot, projectRoot);
        return projectStoreDescriptor;
    }

    @Nullable
    public VirtualFile getStoreDirectory(@NotNull VirtualFile projectRoot) {
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        return projectRoot.isDirectory() ? projectRoot.findChild(".idea") : null;
    }
}

