/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.configurationStore.StoreReloadManagerImpl;
import com.intellij.configurationStore.schemeManager.AddScheme;
import com.intellij.configurationStore.schemeManager.RemoveAllSchemes;
import com.intellij.configurationStore.schemeManager.RemoveScheme;
import com.intellij.configurationStore.schemeManager.SchemeChangeApplicator;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.UpdateScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u00012\u00020\u0004B#\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J*\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001b0\u001aH\u0002J*\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001b0\u001aH\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/configurationStore/schemeManager/SchemeFileTracker;", "T", "Lcom/intellij/openapi/options/Scheme;", "M", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;Lcom/intellij/openapi/project/Project;)V", "applicator", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeApplicator;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "isMyFileWithoutParentCheck", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isMyDirectory", "parent", "handleDirectoryDeleted", "list", "", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "handleDirectoryCreated", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileCreateEvent;", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nSchemeFileTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemeFileTracker.kt\ncom/intellij/configurationStore/schemeManager/SchemeFileTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,158:1\n60#2,5:159\n60#2,5:164\n60#2,5:169\n60#2,5:174\n60#2,5:179\n*S KotlinDebug\n*F\n+ 1 SchemeFileTracker.kt\ncom/intellij/configurationStore/schemeManager/SchemeFileTracker\n*L\n38#1:159,5\n49#1:164,5\n62#1:169,5\n89#1:174,5\n106#1:179,5\n*E\n"})
public final class SchemeFileTracker<T extends Scheme, M extends T>
implements BulkFileListener {
    @NotNull
    private final SchemeManagerImpl<T, M> schemeManager;
    @NotNull
    private final Project project;
    @NotNull
    private final SchemeChangeApplicator<T, M> applicator;

    public SchemeFileTracker(@NotNull SchemeManagerImpl<T, M> schemeManager, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(schemeManager, (String)"schemeManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.schemeManager = schemeManager;
        this.project = project;
        this.applicator = new SchemeChangeApplicator<T, M>(this.schemeManager);
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        ArrayList<Object> list = new ArrayList<Object>();
        for (VFileEvent vFileEvent : events) {
            boolean bl;
            Logger logger;
            boolean $i$f$debug;
            Throwable t$iv;
            Logger $this$debug_u24default$iv;
            VirtualFile file;
            if (vFileEvent.getRequestor() instanceof SchemeManagerImpl || Intrinsics.areEqual((Object)vFileEvent.getRequestor(), (Object)StorageUtilKt.RELOADING_STORAGE_WRITE_REQUESTOR)) continue;
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileContentChangeEvent) {
                Intrinsics.checkNotNullExpressionValue((Object)((VFileContentChangeEvent)vFileEvent).getFile(), (String)"getFile(...)");
                if (!this.isMyFileWithoutParentCheck(file) || file.getParent() == null) continue;
                VirtualFile virtualFile = file.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
                if (!this.isMyDirectory(virtualFile)) continue;
                $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    bl = false;
                    logger.debug("CHANGED " + file.getPath(), t$iv);
                }
                list.add(new UpdateScheme(file));
                continue;
            }
            if (vFileEvent2 instanceof VFileCreateEvent) {
                if (((VFileCreateEvent)vFileEvent).isDirectory()) {
                    this.handleDirectoryCreated((VFileCreateEvent)vFileEvent, (List)list);
                    continue;
                }
                String string = ((VFileCreateEvent)vFileEvent).getChildName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChildName(...)");
                if (!this.schemeManager.canRead(string)) continue;
                VirtualFile virtualFile = ((VFileCreateEvent)vFileEvent).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
                if (!this.isMyDirectory(virtualFile)) continue;
                VirtualFile virtualFile2 = ((VFileCreateEvent)vFileEvent).getFile();
                $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    bl = false;
                    logger.debug("CREATED " + ((VFileCreateEvent)vFileEvent).getPath() + " (virtualFile: " + (virtualFile2 == null ? "not " : "") + "found)", t$iv);
                }
                if (virtualFile2 == null) continue;
                list.add(new AddScheme(virtualFile2));
                continue;
            }
            if (!(vFileEvent2 instanceof VFileDeleteEvent)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((VFileDeleteEvent)vFileEvent).getFile(), (String)"getFile(...)");
            if (file.isDirectory()) {
                this.handleDirectoryDeleted(file, (List)list);
                continue;
            }
            if (!this.isMyFileWithoutParentCheck(file)) continue;
            VirtualFile virtualFile = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            if (!this.isMyDirectory(virtualFile)) continue;
            $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                bl = false;
                logger.debug("DELETED " + file.getPath(), t$iv);
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            list.add(new RemoveScheme(string));
        }
        if (!((Collection)list).isEmpty()) {
            StoreReloadManager storeReloadManager = StoreReloadManager.Companion.getInstance(this.project);
            Intrinsics.checkNotNull((Object)storeReloadManager, (String)"null cannot be cast to non-null type com.intellij.configurationStore.StoreReloadManagerImpl");
            ((StoreReloadManagerImpl)storeReloadManager).registerChangedSchemes$intellij_platform_configurationStore_impl((List)list, this.applicator);
        }
    }

    private final boolean isMyFileWithoutParentCheck(VirtualFile file) {
        CharSequence charSequence = file.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        return this.schemeManager.canRead(charSequence);
    }

    private final boolean isMyDirectory(VirtualFile parent) {
        VirtualFile virtualDirectory = this.schemeManager.getCachedVirtualDirectory$intellij_platform_configurationStore_impl();
        return virtualDirectory == null ? Intrinsics.areEqual((Object)PathsKt.getInvariantSeparatorsPathString((Path)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl()), (Object)parent.getPath()) : Intrinsics.areEqual((Object)virtualDirectory, (Object)parent);
    }

    private final void handleDirectoryDeleted(VirtualFile file, List<SchemeChangeEvent<T, M>> list) {
        if (!StringUtil.equals((CharSequence)file.getNameSequence(), (CharSequence)((Object)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl().getFileName()).toString())) {
            return;
        }
        Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("DIR DELETED " + file.getPath(), t$iv);
        }
        if (Intrinsics.areEqual((Object)file, (Object)this.schemeManager.getVirtualDirectory$intellij_platform_configurationStore_impl())) {
            list.add(new RemoveAllSchemes());
        }
    }

    private final void handleDirectoryCreated(VFileCreateEvent event, List<SchemeChangeEvent<T, M>> list) {
        if (!Intrinsics.areEqual((Object)event.getChildName(), (Object)((Object)this.schemeManager.getIoDirectory$intellij_platform_configurationStore_impl().getFileName()).toString())) {
            return;
        }
        VirtualFile dir = this.schemeManager.getVirtualDirectory$intellij_platform_configurationStore_impl();
        VirtualFile virtualFile = event.getFile();
        if (!Intrinsics.areEqual((Object)virtualFile, (Object)dir)) {
            return;
        }
        Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            VirtualFile virtualFile2 = virtualFile;
            logger.debug("DIR CREATED " + (virtualFile2 != null ? virtualFile2.getPath() : null), t$iv);
        }
        VirtualFile virtualFile3 = dir;
        Intrinsics.checkNotNull((Object)virtualFile3);
        VirtualFile[] virtualFileArray = virtualFile3.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        for (VirtualFile file : virtualFileArray) {
            Intrinsics.checkNotNull((Object)file);
            if (!this.isMyFileWithoutParentCheck(file)) continue;
            list.add(new AddScheme(file));
        }
    }
}

